/******************************
 Configuration parser
 (c) 1999 Jeremy Wise
 GnomeICU
*******************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>

/*** Local function declarations ***/
static void str2col( GdkColor *color, const gchar *str );
int sort_compare( CONTACT_PTR c1, CONTACT_PTR c2 );

/*** Global functions ***/
void Read_RC_File( void )
{
	char *value, *true_value;
	char *temp_uin;
	char *temp_nick;
	int first = TRUE;

	/* To be used in the new config section */
	void *iter;
	char *iterKey = NULL;
	char *iterData = NULL;

	CONTACT_PTR contactdata;

	gchar *version;

#ifdef TRACE_FUNCTION
	g_print( "Read_RC_File\n" );
#endif

	gnome_config_push_prefix( configfilename );

	/* User info */
	if( our_info->uin == 0 ) /* in case it was set in newsignup.c */
	  our_info->uin = gnome_config_get_int( "User/UIN=0" );

	/* Version */
	version = gnome_config_get_string( "User/Version=" );
	if( strcmp( version, VERSION ) )
	{
		/* Do this if they've upgraded */
	}

	g_free( version );

	if( !passwd ) /* ... */
		passwd = gnome_config_private_get_string( "User/Password=" );

	if( !strcmp( passwd, "" ) )
	{
		passwd = gnome_config_get_string( "User/Password=" );
		if( strcmp( passwd, "" ) )
			gnome_config_clean_key( "User/Password" );
	}
	
	our_info->nick = gnome_config_get_string( "User/Nickname=User" );

	preset_status = atoi( gnome_config_get_string( "User/Status=0" ) );

	g_free( Away_Message );
	Away_Message = gnome_config_get_string( "User/AwayMessage=User is currently away.  Please leave a message and have a great day!" );

	g_free( our_info->first );
	our_info->first = gnome_config_get_string( "User/First" );
	
	g_free( our_info->last );
	our_info->last = gnome_config_get_string( "User/Last" );

	our_info->sex = gnome_config_get_int( "User/Sex=0" );

	our_info->age = gnome_config_get_int( "User/Age=0" );

	our_info->auth = gnome_config_get_int( "User/Auth=1" );

	our_info->birth_year = gnome_config_get_int( "User/Birth_Year=0" );

	our_info->birth_month = gnome_config_get_int( "User/Birth_Month=1" );

	our_info->birth_day = gnome_config_get_int( "User/Birth_Day=1" );

	g_free( our_info->email );
	our_info->email = gnome_config_get_string( "User/Email" );

	g_free( our_info->email2 );
	our_info->email2 = gnome_config_get_string( "User/Email2" );

	g_free( our_info->email3 );
	our_info->email3 = gnome_config_get_string( "User/Email3" );

	g_free( our_info->phone );
	our_info->phone = gnome_config_get_string( "User/Phone" );

	g_free( our_info->fax );
	our_info->fax = gnome_config_get_string( "User/Fax" );

	g_free( our_info->cellular );
	our_info->cellular = gnome_config_get_string( "User/Cellular" );

	g_free( our_info->street );
	our_info->street = gnome_config_get_string( "User/Street" );

	g_free( our_info->city );
	our_info->city = gnome_config_get_string( "User/City" );

	g_free( our_info->state );
	our_info->state = gnome_config_get_string( "User/State" );

	our_info->zip = gnome_config_get_int( "User/Zip=0" );

	our_info->country = gnome_config_get_int( "User/Country=1" );

	our_info->zip = gnome_config_get_int( "User/Zip=0" );

	our_info->c_status = gnome_config_get_int( "User/C_Status=-500" );

	our_info->hide_email = gnome_config_get_int( "User/Hide_Email=0 " );

	g_free(our_info->homepage);
	our_info->homepage = gnome_config_get_string( "User/Homepage" );

	g_free(our_info->about);
	our_info->about = gnome_config_get_string( "User/About" );

	/* Server info */
	g_free( server );
	server = gnome_config_get_string( "Server/Server=icq.mirabilis.com" );

	remote_port = gnome_config_get_int( "Server/Port=4000" );

	min_tcp_port = gnome_config_get_int( "Server/MinTCPPort=4000" );
	max_tcp_port = gnome_config_get_int( "Server/MaxTCPPort=4100" );

	/* Window info */
	sscanf( gnome_config_get_string( "Window/Size=160x330" ), "%dx%d", &WindowWidth, &WindowHeight);

	WindowWidth = (WindowWidth > 500) ? 500 : WindowWidth;
	WindowHeight = (WindowHeight > 1200) ? 1200 : WindowHeight;

	/* Auto Hide */
	autohide_time = gnome_config_get_int( "AutoHide/AutoHideTime=30" );

	g_free(WindowTitle);

	WindowTitle = gnome_config_get_string( "Window/Title=GnomeICU" );

	/* Toggles */
	toggles->sound = gnome_config_get_bool( "Toggles/Sound=true" );
	toggles->beep = gnome_config_get_bool( "Toggles/Beep=false" );
	toggles->packet_udp = gnome_config_get_bool( "Toggles/PacketDumpUDP=false" );
	toggles->packet_tcp = gnome_config_get_bool( "Toggles/PacketDumpTCP=false" );
	toggles->force = gnome_config_get_bool( "Toggles/Force=false" );
	toggles->autohide = gnome_config_get_bool( "Toggles/AutoHide=false" );
	toggles->webpresence = gnome_config_get_bool( "Toggles/WebPresence=false" );
	toggles->show_window = gnome_config_get_bool( "Toggles/ShowWindow=false" );
	toggles->full_reply = gnome_config_get_bool( "Toggles/FullReply=true" );

	/* Auto Hide */
	autohide_time = gnome_config_get_int( "AutoHide/AutoHideTime=60" );

	/* Chat font */
	g_free(ChatFontString);
	ChatFontString = gnome_config_get_string( "Color/ChatFont=-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );

	if( ChatFontString == NULL || !strcmp( ChatFontString, "" ) )
		ChatFontString = g_strdup( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );

	/* Color section */
	str2col(&color_online, gnome_config_get_string( "Color/Online=#000000009a69009a" ) );
	color_online_set = TRUE;
	str2col(&color_offline, gnome_config_get_string( "Color/Offline=#75d675d675d67575" ) );
	color_offline_set = TRUE;
	str2col(&color_away, gnome_config_get_string( "Color/Away=#0000820700008200" ) );
	color_away_set = TRUE;
	str2col(&color_na, gnome_config_get_string( "Color/NotAvailable=#0000820700008200" ) );
	color_na_set = TRUE;
	str2col(&color_ffc, gnome_config_get_string( "Color/FreeForChat=#0000000075300075" ) );
	color_ffc_set = TRUE;
	str2col(&color_occ, gnome_config_get_string( "Color/Occupied=#0000000075300075" ) );
	color_occ_set = TRUE;
	str2col(&color_dnd, gnome_config_get_string( "Color/DoNotDisturb=#0000000075300075" ) );
	color_dnd_set = TRUE;
	str2col(&color_inv, gnome_config_get_string( "Color/Invisible=#9a692ed2810c2e81" ) );
	color_inv_set = TRUE;

	/* New Contacts section */
	if( gnome_config_has_section( "NewContacts" ) )
	{
		iter = gnome_config_init_iterator( "NewContacts" );
		while( 1 )
		{
			iter = gnome_config_iterator_next( iter, &iterKey, &iterData );
			if( iter == NULL )
				break;
			if( atoi( iterKey ) == 0 )
				continue;
			contactdata = g_new0( Contact_Member, 1 );
			if( strstr( iterData, "Snot" ) ) /* Online Notification */
				contactdata->online_notify = TRUE;
			else
				contactdata->online_notify = FALSE;

			if( strstr( iterData, "Sign" ) ) /* Ignore List */
				contactdata->ignore_list = TRUE;
			else
				contactdata->ignore_list = FALSE;

			if( strstr( iterData, "Sinv" ) ) /* Invisible List */
				contactdata->invis_list = TRUE;
			else if( strstr( iterData, "Svis" ) ) /* Visible List */
				contactdata->vis_list = TRUE;
			else
			{
				contactdata->invis_list = FALSE;
				contactdata->vis_list = FALSE;
			}
		
			contactdata->uin = atoi( iterKey );

			if( iterData[ 0 ] == ',' )
				sprintf( contactdata->nick, "%s", iterKey );
			else
			{
				if( strchr( iterData, ',' ) != NULL )
					strncpy( contactdata->nick, iterData,
					         ( strchr( iterData, ',' ) - iterData ) );
				else
					strncpy( contactdata->nick, iterData,
					         sizeof( contactdata->nick ) );
			}

			contactdata->oneline_in = NULL;
			contactdata->oneline_out = NULL;
			contactdata->sok = 0;
			contactdata->chat_away = 0;
			contactdata->chat_window = NULL;
			contactdata->chat_sok = 0;
			contactdata->chat_seq = 0;
			contactdata->chat_active = FALSE;
			contactdata->chat_active2 = FALSE;
			contactdata->chat_port = 0;
			contactdata->chat_history = NULL;
			contactdata->chat_bg_red =
			contactdata->chat_bg_green =
			contactdata->chat_bg_blue = 0;
			contactdata->chat_fg_red =
			contactdata->chat_fg_green =
			contactdata->chat_fg_blue = 255;
			contactdata->tcp_gdk_input = 0;
			contactdata->chat_gdk_input = 0;
			contactdata->pdata = NULL;
			contactdata->file_name = NULL;
			contactdata->file_short_name = NULL;
			contactdata->file_fd = 0;
			contactdata->file_offset = 0;
			contactdata->file_sending = FALSE;
			contactdata->stored_messages = NULL;
			contactdata->status = STATUS_OFFLINE;
			contactdata->true_status = STATUS_OFFLINE;
			contactdata->last_time = -1L;
			contactdata->current_ip = -1L;
			contactdata->gdk_input_tag = 0;
			contactdata->file_info = NULL;
			contactdata->show_again = TRUE;
			contactdata->chat_reason = NULL;
			contactdata->info = g_new0( USER_INFO_STRUCT, 1 );
			contactdata->inlist = TRUE;

			Contacts = g_slist_insert_sorted( Contacts, contactdata, (GCompareFunc)sort_compare );
		}
	}

	/* Contacts section */
	else
	{
		value = gnome_config_get_string( "Contacts/Contacts=4664755,GnomeICU Author" );

		true_value = value;

		while( ( temp_uin = strtok( ( first ? value : NULL ), "," ) ) != NULL )
		{
			first = FALSE;
			temp_nick = strtok( NULL, "," );

			contactdata = g_new0( Contact_Member, 1 );

			if( temp_uin[ 0 ] == '*' )
			{
				contactdata->invis_list = TRUE;
				contactdata->uin = atoi( &temp_uin[ 1 ] );
			}
			else if( temp_uin[ 0 ] == '~' )
			{
				contactdata->vis_list = TRUE;
				contactdata->uin = atoi( &temp_uin[ 1 ] );
			}
			else
			{
				contactdata->invis_list = FALSE;
				contactdata->vis_list = FALSE;
				contactdata->uin = atoi( temp_uin );
			}
			contactdata->oneline_in = NULL;
			contactdata->oneline_out = NULL;
			contactdata->sok = 0;
			contactdata->chat_away = 0;
			contactdata->chat_window = NULL;
			contactdata->chat_sok = 0;
			contactdata->chat_seq = 0;
			contactdata->chat_active = FALSE;
			contactdata->chat_active2 = FALSE;
			contactdata->chat_port = 0;
			contactdata->chat_history = NULL;
			contactdata->chat_bg_red =
			contactdata->chat_bg_green =
			contactdata->chat_bg_blue = 0;
			contactdata->chat_fg_red =
			contactdata->chat_fg_green =
			contactdata->chat_fg_blue = 255;
			contactdata->tcp_gdk_input = 0;
			contactdata->chat_gdk_input = 0;
			contactdata->pdata = NULL;
			contactdata->file_name = NULL;
			contactdata->file_short_name = NULL;
			contactdata->file_fd = 0;
			contactdata->file_offset = 0;
			contactdata->file_sending = FALSE;
			contactdata->message = NULL;
			contactdata->messages = 0;
			contactdata->status = STATUS_OFFLINE;
			contactdata->true_status = STATUS_OFFLINE;
			contactdata->last_time = -1L;
			contactdata->current_ip = -1L;
			contactdata->gdk_input_tag = 0;
			contactdata->file_info = NULL;
			contactdata->show_again = TRUE;
			contactdata->chat_reason = NULL;
			contactdata->info = g_new0( USER_INFO_STRUCT, 1 );

			if( temp_nick )
			{
				strncpy( contactdata->nick, temp_nick, sizeof(contactdata->nick)-1);
				contactdata->nick[ sizeof( contactdata->nick ) - 1 ] = 0;
			}
			else
				contactdata->nick[ 0 ] = 0;

			Contacts = g_slist_append( Contacts, contactdata );
		}

		g_free( true_value );
	}

	gnome_config_pop_prefix();

	have_read_config = TRUE;

	return;
}

void Initialize_RC_File( void )
{
	gchar *path = NULL;
#ifdef TRACE_FUNCTION
	g_print( "Initialize_RC_File\n" );
#endif

	path = g_strdup_printf("%s/.icq", getenv( "HOME" ) );
	if(mkdir(path, 0700))
	    switch(errno)
	      {
	      case EEXIST: break;
	      default: g_warning(PACKAGE "mkdir:%s:%s", path, g_strerror(errno) );
	      }
	g_free(path);

	path = g_strdup_printf("%s/.icq/history", getenv( "HOME" ) );
	if(mkdir(path, 0700))
	    switch(errno)
	      {
	      case EEXIST: break;
	      default: g_warning(PACKAGE "mkdir:%s:%s", path, g_strerror(errno) );
	      }
	g_free(path);

	NewUserSignup();

	return;
}

/*
 *	Config File Save
 *
 * Jeremy Wise (jwise@pathwaynet.com) 02/27/1999
 *
 */

void Save_RC( void )
{
	char uin_str[64];
	char *contactKey, *contactStr;

	GSList *contact;

	gnome_config_push_prefix( configfilename );

#ifdef TRACE_FUNCTION
	g_print( "Save_RC\n" );
#endif

	/* User info */
	gnome_config_set_string( "User/Version", VERSION );
	gnome_config_set_int( "User/UIN", our_info->uin );
	gnome_config_private_set_string( "User/Password", passwd );
	gnome_config_set_int( "User/Status", ( Current_Status != STATUS_OFFLINE ? Current_Status : STATUS_ONLINE ) );
	gnome_config_set_string( "User/Nickname", our_info->nick );
	gnome_config_set_string( "User/First", our_info->first );
	gnome_config_set_string( "User/Last", our_info->last );
	gnome_config_set_int( "User/Sex", our_info->sex );
	gnome_config_set_int( "User/Age", our_info->age );
	gnome_config_set_int( "User/Auth", our_info->auth );
	gnome_config_set_int( "User/Birth_Year", our_info->birth_year );
	gnome_config_set_int( "User/Birth_Month", our_info->birth_month );
	gnome_config_set_int( "User/Birth_Day", our_info->birth_day );
	gnome_config_set_string( "User/Email", our_info->email );
	gnome_config_set_string( "User/Email2", our_info->email2 );
	gnome_config_set_string( "User/Email3", our_info->email3 );
	gnome_config_set_string( "User/Phone", our_info->phone );
	gnome_config_set_string( "User/Fax", our_info->fax );
	gnome_config_set_string( "User/Cellular", our_info->cellular );
	gnome_config_set_string( "User/Street", our_info->street );
	gnome_config_set_string( "User/City", our_info->city );
	gnome_config_set_string( "User/State", our_info->state );
	gnome_config_set_int( "User/Zip", our_info->zip );
	gnome_config_set_int( "User/Country", our_info->country );
	gnome_config_set_int( "User/C_Status", our_info->c_status );
	gnome_config_set_string( "User/Homepage", our_info->homepage );
	gnome_config_set_string( "User/About", our_info->about );
	gnome_config_set_int( "User/Hide_Email", our_info->hide_email );
	gnome_config_set_string( "User/AwayMessage", Away_Message );

	/* Server info */
	gnome_config_set_string( "Server/Server", server );
	gnome_config_set_int( "Server/Port", remote_port );
	gnome_config_set_int( "Server/MinTCPPort", min_tcp_port );
	gnome_config_set_int( "Server/MaxTCPPort", max_tcp_port );

	/* Window info */
	sprintf( uin_str, "%dx%d", WindowWidth, WindowHeight );
	gnome_config_set_string( "Window/Size", uin_str );
	gnome_config_set_string( "Window/Title", WindowTitle );

	/* Toggles */
	gnome_config_set_bool( "Toggles/Sound", toggles->sound );
	gnome_config_set_bool( "Toggles/Beep", toggles->beep );
	gnome_config_set_bool( "Toggles/PacketDumpUDP", toggles->packet_udp );
	gnome_config_set_bool( "Toggles/PacketDumpTCP", toggles->packet_tcp );
	gnome_config_set_bool( "Toggles/Force", toggles->force );
	gnome_config_set_bool( "Toggles/AutoHide", toggles->autohide );
	gnome_config_set_bool( "Toggles/WebPresence", toggles->webpresence );
	gnome_config_clean_key( "Toggles/Headers" );
	gnome_config_set_bool( "Toggles/ShowWindow", toggles->show_window );
	gnome_config_set_bool( "Toggles/FullReply", toggles->full_reply );

	/* AutoHide */
	gnome_config_set_int( "AutoHide/AutoHideTime", autohide_time );

	/* Color Section */
	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_online.red & 0xffff,
	         color_online.green & 0xffff,
	         color_online.blue & 0xffff,
	         (unsigned int)color_online.pixel & 0xffff );
	gnome_config_set_string( "Color/Online", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_offline.red & 0xffff,
	         color_offline.green & 0xffff,
	         color_offline.blue & 0xffff,
	         (unsigned int)color_offline.pixel & 0xffff );
	gnome_config_set_string( "Color/Offline", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_away.red & 0xffff,
	         color_away.green & 0xffff,
	         color_away.blue & 0xffff,
	         (unsigned int)color_away.pixel & 0xffff );
	gnome_config_set_string( "Color/Away", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_na.red & 0xffff,
	         color_na.green & 0xffff,
	         color_na.blue & 0xffff,
	         (unsigned int)color_na.pixel & 0xffff );
	gnome_config_set_string( "Color/NotAvailable", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_ffc.red & 0xffff,
	         color_ffc.green & 0xffff,
	         color_ffc.blue & 0xffff,
	         (unsigned int)color_ffc.pixel & 0xffff);
	gnome_config_set_string( "Color/FreeForChat", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_occ.red & 0xffff,
	         color_occ.green & 0xffff,
	         color_occ.blue & 0xffff,
	         (unsigned int)color_occ.pixel & 0xffff );
	gnome_config_set_string( "Color/Occupied", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_dnd.red & 0xffff,
	         color_dnd.green & 0xffff,
	         color_dnd.blue & 0xffff,
	         (unsigned int)color_dnd.pixel & 0xffff );
	gnome_config_set_string( "Color/DoNotDisturb", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_inv.red & 0xffff,
	         color_inv.green & 0xffff,
	         color_inv.blue & 0xffff,
	         (unsigned int)color_inv.pixel & 0xffff );
	gnome_config_set_string( "Color/Invisible", uin_str );

	/* Chat font */
	gnome_config_set_string( "Color/ChatFont", ChatFontString );

	/* New Contact Section */
	gnome_config_clean_section( "NewContacts" );

	contact = Contacts;

	while( contact != NULL )
	{
		contactKey = g_strdup_printf( "NewContacts/%u",
					      ( (CONTACT_PTR)( (CONTACT_PTR)contact->data ) )->uin );

		contactStr = g_strdup_printf( "%s%s%s%s%s%s",

	/* Start with the nickname */
					      ((CONTACT_PTR)((CONTACT_PTR)contact->data))->nick,

	/* If we append ANYTHING, we need a comma here */
					      ( ((CONTACT_PTR)contact->data)->invis_list ||
		                 ((CONTACT_PTR)contact->data)->vis_list ||
		                 ((CONTACT_PTR)contact->data)->ignore_list ||
		                 ((CONTACT_PTR)contact->data)->online_notify ? "," : "" ),

	/* If they're on the invisible list, we append an Sinv */
		               ( ((CONTACT_PTR)contact->data)->invis_list ? "Sinv" : "" ),

	/* If they're on the visible list, we append Svis here */
		               ( ((CONTACT_PTR)contact->data)->vis_list ? "Svis" : "" ),

	/* If they're on the notify list, we append Snot here */
		               ( ((CONTACT_PTR)contact->data)->online_notify ? "Snot" : "" ),
		
	/* If they're on the ignore list, we append Sign here */
		               ( ((CONTACT_PTR)contact->data)->ignore_list ? "Sign" : "" ) );

		if( ((CONTACT_PTR)contact->data)->inlist == TRUE )
			gnome_config_set_string( contactKey, contactStr );
		g_free( contactKey );
		g_free( contactStr );
		contact = contact->next;
	}

	gnome_config_set_int( "Existence/exists", 1 );

	gnome_config_sync();

	gnome_config_pop_prefix();

	return;
}

/*** Local functions ***/
void str2col(GdkColor *color, const gchar *str) {
    guint r, g, b;
    guint pix;

    sscanf(str, "#%04x%04x%04x%04x", &r, &g, &b, &pix);
    color->red = r;
    color->green = g;
    color->blue = b;
    color->pixel = pix;
}

int sort_compare( CONTACT_PTR c1, CONTACT_PTR c2 )
{
	return strcmp( c1->nick, c2->nick );
}
