/***********************************
 Update contact list in main window
 (c) 1999 Jeremy Wise
 GnomeICU
************************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

typedef struct
{
	GSList *contact;
	char *str[2];
} ContactListMember;

void remove_from_list( GSList **list, GSList *contact );

GSList *OnlineList = NULL;
GSList *OfflineList = NULL;

int Show_Quick_Status( void )
{
	return Show_Quick_Status_lower( FALSE, NULL );
}

int Show_Quick_Status_lower( int forced_update, GSList *passed_contact )
{
	char statusbuf_editable[2][32];
	char *statusbuf[2];
	
	static GtkStyle *style = NULL;
	
	#define PlayOnline 1
	#define PlayOffline 2
	int play_sound = FALSE;
	
	int row = 0;
	static int preshown = FALSE;
	int message_clear;
	GSList *contact, *mem;

	GtkWidget *sellist;

	gboolean shown_online = FALSE, shown_offline = FALSE;

	gboolean not_is_vis = FALSE;
	static gboolean not_was_vis = FALSE;

	ContactListMember *Individual = NULL;

	gint highlighted_on;
	gint highlighted_off;
	gint highlighted_not;

	gboolean on_changed = FALSE;
	gboolean off_changed = FALSE;
	gboolean not_changed = FALSE;

#ifdef TRACE_FUNCTION
	g_print( "Show_Quick_Status\n" );
#endif

	if( passed_contact != NULL )
	{
		remove_from_list( &OnlineList, passed_contact );
		remove_from_list( &OfflineList, passed_contact );
	}

	if( forced_update | UPDATE_NOTLIST )
		not_changed = TRUE;
	if( forced_update | UPDATE_ONLINE )
		on_changed = TRUE;
	if( forced_update | UPDATE_OFFLINE )
		off_changed = TRUE;

/*	if( !enable_online_events && preshown )
		return FALSE;*/

	statusbuf[0] = statusbuf_editable[0];
	statusbuf[1] = statusbuf_editable[1];
	
	gtk_clist_freeze( GTK_CLIST( MainData->lb_userwin_online ) );
	gtk_clist_freeze( GTK_CLIST( MainData->lb_userwin_offline ) );
	gtk_clist_freeze( GTK_CLIST( MainData->lb_userwin_notinlist ) );
	
	if( style == NULL )
	{
		gtk_widget_ensure_style( MainData->lb_userwin_online );
		gtk_widget_ensure_style( MainData->lb_userwin_offline );
		gtk_widget_ensure_style( MainData->lb_userwin_notinlist );
		style = gtk_style_copy( MainData->lb_userwin_online->style );
		
		gdk_font_unref( style->font );
		style->font = gdk_font_load( _("-adobe-helvetica-bold-r-*-*-*-140-*-*-*-*-*-*"));
	}
	
	play_sound = FALSE;
	
	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->inlist == FALSE )
			not_is_vis = TRUE;
		contact = contact->next;
	}

	if( not_is_vis && !not_was_vis )
	{
		not_was_vis = not_is_vis;
		gtk_container_add( GTK_CONTAINER( MainData->notebook ), MainData->not_contents );
		gtk_widget_show( MainData->head_notinlist );
		gtk_notebook_set_tab_label( GTK_NOTEBOOK( MainData->notebook ), gtk_notebook_get_nth_page( GTK_NOTEBOOK( MainData->notebook ), 2 ), MainData->head_notinlist );
	}
	else if( not_was_vis && !not_is_vis )
	{
		not_was_vis = not_is_vis;
		gtk_widget_hide( MainData->head_notinlist );
		gtk_notebook_remove_page( GTK_NOTEBOOK( MainData->notebook ), 2 );
	}

	contact = Contacts;

	while( contact != NULL )
	{
		if( ( S_DWORD )((CONTACT_PTR)contact->data)->uin <= 0 )
		{
			contact = contact->next;
			continue;
		}
		
		if( ((CONTACT_PTR)contact->data)->status == STATUS_OCCUPIED_MAC )
			((CONTACT_PTR)contact->data)->status = STATUS_OCCUPIED;
		if( ((CONTACT_PTR)contact->data)->status == STATUS_NA_99A )
			((CONTACT_PTR)contact->data)->status = STATUS_NA;

		message_clear = FALSE;
		if( ((CONTACT_PTR)contact->data)->status != STATUS_OFFLINE )
		{
			if( ((CONTACT_PTR)contact->data)->icon_p == icon_message_pixmap || g_slist_length( ((CONTACT_PTR)contact->data)->stored_messages ) == 0 )
			{
				((CONTACT_PTR)contact->data)->icon_p = GetIcon_p( ((CONTACT_PTR)contact->data)->status );
				((CONTACT_PTR)contact->data)->icon_b = GetIcon_b( ((CONTACT_PTR)contact->data)->status );
			}
			
			if( ( ((CONTACT_PTR)contact->data)->last_status != ((CONTACT_PTR)contact->data)->status ) ||
			    ( ((CONTACT_PTR)contact->data)->icon_p == icon_message_pixmap ) ||
			    ((CONTACT_PTR)contact->data)->need_update )
			{
				((CONTACT_PTR)contact->data)->need_update = FALSE;
				if( ((CONTACT_PTR)contact->data)->last_status == STATUS_OFFLINE )
				{
					Individual = g_new0( ContactListMember, 1 );
					Individual->contact = contact;
					OnlineList = g_slist_append( OnlineList, Individual );
					remove_from_list( &OfflineList, contact );
					if( ((CONTACT_PTR)contact->data)->ignore_list == FALSE )
						play_sound = PlayOnline;
					if( ((CONTACT_PTR)contact->data)->inlist )
						on_changed = TRUE;
					else
						not_changed = TRUE;
				}
				if( ((CONTACT_PTR)contact->data)->inlist == FALSE )
					sellist = MainData->lb_userwin_notinlist;
				else
					sellist = MainData->lb_userwin_online;

				if( ((CONTACT_PTR)contact->data)->ignore_list == FALSE )
					gtk_clist_set_pixmap( GTK_CLIST( sellist ),
					                      ((CONTACT_PTR)contact->data)->lb_index, 0,
					                      ((CONTACT_PTR)contact->data)->icon_p,
					                      ((CONTACT_PTR)contact->data)->icon_b );

				if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_ONLINE )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          ((CONTACT_PTR)contact->data)->lb_index, &color_online );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_FREE_CHAT )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          ((CONTACT_PTR)contact->data)->lb_index, &color_ffc );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_AWAY )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          ((CONTACT_PTR)contact->data)->lb_index, &color_away );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_NA )
				{
				gtk_clist_set_foreground( GTK_CLIST( sellist ),
				                          ((CONTACT_PTR)contact->data)->lb_index, &color_na );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_OCCUPIED )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          ((CONTACT_PTR)contact->data)->lb_index, &color_occ );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_DND )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          ((CONTACT_PTR)contact->data)->lb_index, &color_dnd );
				}
				if( ( ((CONTACT_PTR)contact->data)->true_status & 0x0100 ) == STATUS_INVISIBLE )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          ((CONTACT_PTR)contact->data)->lb_index, &color_inv );
				}
			}
			((CONTACT_PTR)contact->data)->last_status = ((CONTACT_PTR)contact->data)->status;
		}
		else
		{
			if( ((CONTACT_PTR)contact->data)->icon_p == icon_message_pixmap || g_slist_length( ((CONTACT_PTR)contact->data)->stored_messages ) == 0 )
			{
				((CONTACT_PTR)contact->data)->icon_p = GetIcon_p( ((CONTACT_PTR)contact->data)->status );
				((CONTACT_PTR)contact->data)->icon_b = GetIcon_b( ((CONTACT_PTR)contact->data)->status );
			}
			
			if( !preshown )
			{
				Individual = g_new0( ContactListMember, 1 );
				Individual->contact = contact;
				OfflineList = g_slist_append( OfflineList, Individual );
				((CONTACT_PTR)contact->data)->last_status = ((CONTACT_PTR)contact->data)->status;
				if( ((CONTACT_PTR)contact->data)->inlist )
					off_changed = TRUE;
				else
					not_changed = TRUE;
				contact = contact->next;
				continue;
			}

			if( ((CONTACT_PTR)contact->data)->last_status != ((CONTACT_PTR)contact->data)->status ||
			    ((CONTACT_PTR)contact->data)->need_update )
			{
				((CONTACT_PTR)contact->data)->need_update = FALSE;
				if( ((CONTACT_PTR)contact->data)->last_status != STATUS_OFFLINE )
				{
					Individual = g_new0( ContactListMember, 1 );
					Individual->contact = contact;
					OfflineList = g_slist_prepend( OfflineList, Individual );
					remove_from_list( &OnlineList, contact );
					if( ((CONTACT_PTR)contact->data)->ignore_list == FALSE )
						play_sound = PlayOffline;
					((CONTACT_PTR)contact->data)->last_status = ((CONTACT_PTR)contact->data)->status;
					if( ((CONTACT_PTR)contact->data)->inlist )
						off_changed = TRUE;
					else
						not_changed = TRUE;
					contact = contact->next;
					continue;
				}

				Individual = g_new0( ContactListMember, 1 );
				Individual->contact = contact;
				remove_from_list( &OfflineList, contact );
				OfflineList = g_slist_prepend( OfflineList, Individual );
				if( ((CONTACT_PTR)contact->data)->inlist )
					off_changed = TRUE;
				else
					not_changed = TRUE;
			}
			((CONTACT_PTR)contact->data)->last_status = ((CONTACT_PTR)contact->data)->status;
		}
		contact = contact->next;
	}

	if( !preshown )
		preshown = TRUE;

	if( !on_changed && !off_changed && !not_changed )
	{
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_online ) );
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_offline ) );
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_notinlist ) );
		return play_sound;
	}

	highlighted_on = GTK_CLIST( MainData->lb_userwin_online )->focus_row;
	highlighted_off = GTK_CLIST( MainData->lb_userwin_offline )->focus_row;
	highlighted_not = GTK_CLIST( MainData->lb_userwin_notinlist )->focus_row;

	if( on_changed )
		gtk_clist_clear( GTK_CLIST( MainData->lb_userwin_online ) );
	if( off_changed )
		gtk_clist_clear( GTK_CLIST( MainData->lb_userwin_offline ) );
	if( not_changed )
		gtk_clist_clear( GTK_CLIST( MainData->lb_userwin_notinlist ) );

	if( on_changed | not_changed )
	{
		mem = OnlineList;

		while( mem != NULL )
		{
			if( ((ContactListMember*)mem->data)->contact == NULL )
			{
				mem = mem->next;
				continue;
			}
			else
			{
			if( !on_changed && ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->inlist )
			{
				mem = mem->next;
				continue;
			}
			if( !not_changed && ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->inlist == FALSE )
			{
				mem = mem->next;
				continue;
			}
				if( ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->ignore_list == TRUE )
				{
					mem = mem->next;
					continue;
				}
				statusbuf[0] = g_strdup( "" );
				statusbuf[1] = g_strdup( ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->nick );
				shown_online = TRUE;
			}
			if( ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->inlist == TRUE )
				sellist = MainData->lb_userwin_online;
			else
				sellist = MainData->lb_userwin_notinlist;
	
			row = gtk_clist_append( GTK_CLIST( sellist ),
			                        statusbuf );
	
			if( ((ContactListMember*)mem->data)->contact != NULL )
			{
				contact = ((GSList*)((ContactListMember*)mem->data)->contact);
				gtk_clist_set_row_data( GTK_CLIST( sellist ),
  					                     row,
  					                     GINT_TO_POINTER( ((CONTACT_PTR)contact->data)->uin ) );
				((CONTACT_PTR)contact->data)->lb_index = row;

				if( ((CONTACT_PTR)contact->data)->ignore_list == FALSE )
					gtk_clist_set_pixmap( GTK_CLIST( sellist ),
					                      row, 0, ((CONTACT_PTR)contact->data)->icon_p, ((CONTACT_PTR)contact->data)->icon_b );

				if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_ONLINE )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          row, &color_online );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_FREE_CHAT )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          row, &color_ffc );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_AWAY )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          row, &color_away );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_NA )
				{
				gtk_clist_set_foreground( GTK_CLIST( sellist ),
				                          row, &color_na );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_OCCUPIED )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          row, &color_occ );
				}
				else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_DND )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          row, &color_dnd );
				}
				if( ( ((CONTACT_PTR)contact->data)->true_status & 0x0100 ) == STATUS_INVISIBLE )
				{
					gtk_clist_set_foreground( GTK_CLIST( sellist ),
					                          row, &color_inv );
				}
			}
			else
		      gtk_clist_set_row_style( GTK_CLIST( sellist ), row, style );

			mem = mem->next;
		}
	}

	if( off_changed | not_changed )
	{
		mem = OfflineList;

		while( mem != NULL )
		{
			if( !off_changed && ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->inlist )
			{
				mem = mem->next;
				continue;
			}
			if( !not_changed && ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->inlist == FALSE )
			{
				mem = mem->next;
				continue;
			}
			if( ((ContactListMember*)mem->data)->contact == NULL )
			{
				mem = mem->next;
				continue;
			}
			else
			{
				if( ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->ignore_list == TRUE )
				{
					mem = mem->next;
					continue;
				}
				statusbuf[0] = g_strdup( "" );
				statusbuf[1] = g_strdup( ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->nick );
				shown_offline = TRUE;
			}
			if( ((CONTACT_PTR)((GSList*)((ContactListMember*)mem->data)->contact)->data)->inlist == FALSE )
				sellist = MainData->lb_userwin_notinlist;
			else
				sellist = MainData->lb_userwin_offline;

			row = gtk_clist_append( GTK_CLIST( sellist ),
			                        statusbuf );

			if( ((ContactListMember*)mem->data)->contact != NULL )
			{
				contact = ((GSList*)((ContactListMember*)mem->data)->contact);
				gtk_clist_set_row_data( GTK_CLIST( sellist ),
  					                     row,
  					                     GINT_TO_POINTER( ((CONTACT_PTR)contact->data)->uin ) );
				((CONTACT_PTR)contact->data)->lb_index = row;

				if( ((CONTACT_PTR)contact->data)->ignore_list == FALSE )
					gtk_clist_set_pixmap( GTK_CLIST( sellist ),
					                      row, 0, ((CONTACT_PTR)contact->data)->icon_p, ((CONTACT_PTR)contact->data)->icon_b );

				gtk_clist_set_foreground( GTK_CLIST( sellist ),
				                          row, &color_offline );
			}
			else
		      gtk_clist_set_row_style( GTK_CLIST( sellist ), row, style );

			mem = mem->next;
		}
	}

	if( play_sound == PlayOnline )
		gnomeicu_event( EV_USERON );
	if( play_sound == PlayOffline )
		gnomeicu_event( EV_USEROFF );

	if( on_changed )
		gtk_clist_select_row( GTK_CLIST( MainData->lb_userwin_online ), highlighted_on, 0 );
	if( off_changed )
		gtk_clist_select_row( GTK_CLIST( MainData->lb_userwin_offline ), highlighted_off, 0 );
	if( not_changed )
		gtk_clist_select_row( GTK_CLIST( MainData->lb_userwin_notinlist ), highlighted_not, 0 );

	if( on_changed )
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_online ) );
	if( off_changed )
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_offline ) );
	if( not_changed )
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_notinlist ) );

	return play_sound;
}

void remove_from_list( GSList **list, GSList *contact )
{
	GSList *mem;

	mem = *list;
	while( mem != NULL )
	{
		if( contact == ((ContactListMember*)mem->data)->contact )
		{
			*list = g_slist_remove( *list, mem->data );
			break;
		}
		mem = mem->next;
	}
}
