/*
 *  Copyright (C) 1999 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include "gtm_applet.h"
#include "dialogs.h"

/* Structure that keeps the widgets containing the current properties */
typedef struct 
{
    GtkWidget *pbox;                            /* GNOME Property Box */
    GtkWidget *def_download_dir;                /* Entry */
    GtkWidget *addnew_changes_def_dl_dir;       /* Toggle button */
    GtkWidget *confirm_dnd_url;                 /* Toggle button */
} PropDialogData;


static void
apply_prop_download (PropDialogData *prop)
{
    /* Default download directory */
    gtm_applet_prop.def_download_dir = 
        g_strdup (gtk_entry_get_text (GTK_ENTRY (
            prop->def_download_dir)));
}

static void
apply_prop_confirmations (PropDialogData *prop)
{
    /* New changes default download dir */
    gtm_applet_prop.addnew_changes_def_dl_dir =
        gtk_toggle_button_get_active (
            GTK_TOGGLE_BUTTON (prop->addnew_changes_def_dl_dir));

    /* Confirm drag-n-drop URL */
    gtm_applet_prop.confirm_dnd_url =
        gtk_toggle_button_get_active (
            GTK_TOGGLE_BUTTON (prop->confirm_dnd_url));
}

static void
apply_prop (GtkWidget *widget, gint page_num, PropDialogData *prop)
{
    /* If it's not an absolute and we don't use that */
    if (page_num == -1)
        return;

    /* This function is called for each page changed so we need to apply props
     * for each page individually */
    switch (page_num) {
        case 0: /* Download */
            apply_prop_download (prop);
            break;
            
        case 1: /* Confirmations */
            apply_prop_confirmations (prop);
            break;
    }    
}

static void
destroy_propbox (GtkWidget *widget, PropDialogData **prop)
{
    gtk_widget_destroy ((*prop)->pbox);
    g_free (*prop);
    *prop = NULL;
}

static void
prop_modified_cb (GtkWidget *widget, PropDialogData *prop)
{
    /* Tell to property box that data changed */
    gnome_property_box_changed (GNOME_PROPERTY_BOX (prop->pbox));
}


static GtkWidget *
create_download_page (PropDialogData *prop)
{
    GtkWidget *vbox, *hbox, *label;
    GtkWidget *def_download_dir;

    /* Create vbox for page lines */
    vbox = gtk_vbox_new (FALSE, GNOME_PAD_SMALL);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
    
    /* Default download directory */
    hbox = gtk_hbox_new (FALSE, GNOME_PAD_SMALL);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    label = gtk_label_new (_ ("Default download dir:"));
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    def_download_dir =
        gnome_file_entry_new ("DefDownloadDir", 
                              _("GTM Applet - Def Download Dir"));
    prop->def_download_dir = gnome_file_entry_gtk_entry (
        GNOME_FILE_ENTRY (def_download_dir));
    gnome_file_entry_set_directory (GNOME_FILE_ENTRY (def_download_dir), 1);
    gtk_box_pack_start (GTK_BOX (hbox), def_download_dir, TRUE, TRUE, 0);

    /* Set current properties */
    gtk_entry_set_text (GTK_ENTRY (prop->def_download_dir), 
                        gtm_applet_prop.def_download_dir);

    /* Connect the signal that acknowledges the change on the widget to 
     * function that turns on the OK and APPLY buttons */
    gtk_signal_connect (GTK_OBJECT (prop->def_download_dir), "changed",
                        GTK_SIGNAL_FUNC (prop_modified_cb),
                        (gpointer) prop);

    return vbox;
}

static GtkWidget *
create_confirmations_page (PropDialogData *prop)
{
    GtkWidget *vbox;

    /* Create vbox for page lines */
    vbox = gtk_vbox_new (FALSE, GNOME_PAD_SMALL);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);

    /* New changes default download dir */
    prop->addnew_changes_def_dl_dir = 
        gtk_check_button_new_with_label (_ (
            "Dialog new or dialog add changes default download dir"));
    gtk_box_pack_start (GTK_BOX (vbox), prop->addnew_changes_def_dl_dir, FALSE,
                        FALSE, 0);

    /* Confirm drag-n-drop URL */
    prop->confirm_dnd_url = 
        gtk_check_button_new_with_label (_ (
            "Confirm drag and drop URL"));
    gtk_box_pack_start (GTK_BOX (vbox), prop->confirm_dnd_url, FALSE,
                        FALSE, 0);

    /* Set current properties */
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (
        prop->addnew_changes_def_dl_dir),
                                  gtm_applet_prop.addnew_changes_def_dl_dir);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (
        prop->confirm_dnd_url), gtm_applet_prop.confirm_dnd_url);

    /* Connect the signal that acknowledges the change on the widget to 
     * function that turns on the OK and APPLY buttons */
    gtk_signal_connect (GTK_OBJECT (prop->addnew_changes_def_dl_dir),
                        "toggled", GTK_SIGNAL_FUNC (prop_modified_cb),
                        (gpointer) prop);
    gtk_signal_connect (GTK_OBJECT (prop->confirm_dnd_url), "toggled",
                        GTK_SIGNAL_FUNC (prop_modified_cb),
                        (gpointer) prop);

    return vbox;
}

/* Function to create and run the properties diaload box */
void
dialog_prop (void)
{
    GtkWidget *label;
    static PropDialogData *prop_dialog_data;

    /* Only one properties dialog box is allowed */
    if (prop_dialog_data != NULL) {
        gdk_window_raise (GTK_WIDGET (
            GNOME_DIALOG (prop_dialog_data->pbox))->window);
        return;
    }

    /* Create the gnome property box and set the common signals */
    prop_dialog_data = g_new (PropDialogData, 1);
    prop_dialog_data->pbox = gnome_property_box_new ();
    gtk_window_set_title (GTK_WINDOW (prop_dialog_data->pbox),
                          _ ("GTM Applet - Properties"));
    gtk_signal_connect (GTK_OBJECT (prop_dialog_data->pbox), "destroy",
                        GTK_SIGNAL_FUNC (destroy_propbox), 
                        (gpointer) &prop_dialog_data);
    gtk_signal_connect (GTK_OBJECT (prop_dialog_data->pbox), "apply",
                        GTK_SIGNAL_FUNC (apply_prop), 
                        (gpointer) prop_dialog_data);

    /* Create the notebook pages */
    label = gtk_label_new (_ ("Download"));
    gtk_notebook_append_page (
        GTK_NOTEBOOK (GNOME_PROPERTY_BOX (prop_dialog_data->pbox)->notebook), 
        create_download_page (prop_dialog_data), label);
    label = gtk_label_new (_ ("Confirmations"));
    gtk_notebook_append_page (
        GTK_NOTEBOOK (GNOME_PROPERTY_BOX (prop_dialog_data->pbox)->notebook), 
        create_confirmations_page (prop_dialog_data), label);

    /* We are ready to show it all */
    gtk_widget_show_all (prop_dialog_data->pbox);
}
