/*
 *  Copyright (C) 1999 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <applet-widget.h>
#include "Gtm.h"
#include "dialogs.h"
#include "gtm_applet.h"
#include "tray_empty.xpm"
#include "tray_full.xpm"

/* Pixmaps used on the application */
static GdkPixmap *i_open;
static GdkPixmap *i_open_mask;
static GdkPixmap *i_closed;
static GdkPixmap *i_closed_mask;


/* Used to keep current drag state */
static gboolean have_drag;


/* The types of stuff we accept on dnd */
enum {
    TARGET_URL,
    TARGET_NETSCAPE_URL
};


/* The applet properties */
Properties gtm_applet_prop;


/* Open gtm */
void
gtm_open (void)
{
    goad_server_activate_with_repo_id (NULL, "IDL:gtm/download:1.0", 0,
				       NULL);
}


/* Add a new URL to gtm */
gboolean
gtm_add_url (gchar *url, gchar *dir, gboolean disable_proxy,
             gboolean disable_auto_dl)
{
    CORBA_Environment ev;
    GTM_Download gtm_download_client;
    gboolean result;

    result = FALSE;
    gtm_download_client = 
        goad_server_activate_with_repo_id (NULL,
                                           "IDL:gtm/download:1.0", 0,
                                           NULL);

    if (gtm_download_client != NULL) {
        CORBA_exception_init (&ev);
        result = GTM_Download_add_url (gtm_download_client, url, dir,
                                       disable_proxy, disable_auto_dl, &ev);
        if (ev._major != CORBA_NO_EXCEPTION) {
            g_print ("Exception thrown: %s\n",
                     CORBA_exception_id (&ev));
            CORBA_exception_free (&ev);
        }
    }

    return result;
}


/* Properties manipulation functions */
static void
property_load (gchar *path)
{
    gboolean def;

    gnome_config_push_prefix (path);
    gtm_applet_prop.def_download_dir = 
	gnome_config_get_string_with_default ("gtm_applet/def_download_dir",
                                              &def);
    if (def)
        gtm_applet_prop.def_download_dir = gnome_util_user_home ();
    gtm_applet_prop.addnew_changes_def_dl_dir = 
        gnome_config_get_bool ("gtm_applet/addnew_changes_def_dl_dir=FALSE");
    gtm_applet_prop.confirm_dnd_url =
        gnome_config_get_bool ("gtm_applet/confirm_dnd_url=FALSE");
    gnome_config_pop_prefix ();
}

static void
property_save (gchar *path)
{
    gnome_config_push_prefix (path);
    gnome_config_set_string ("gtm_applet/def_download_dir", 
                             gtm_applet_prop.def_download_dir);
    gnome_config_set_bool ("gtm_applet/addnew_changes_def_dl_dir",
                           gtm_applet_prop.addnew_changes_def_dl_dir);
    gnome_config_set_bool ("gtm_applet/confirm_dnd_url",
                           gtm_applet_prop.confirm_dnd_url);
    gnome_config_pop_prefix ();
}


/* Save applet session */
static gint 
applet_save_session (GtkWidget *widget, char *privcfgpath, char *globcfgpath)
{
    property_save (privcfgpath);

    return FALSE;
}


/* Command open gtm */
static void
cmd_gtm_open (AppletWidget *widget, gpointer data)
{
    gtm_open ();
}


/* Command new URL */
static void
cmd_new_url (AppletWidget *widget, gpointer data)
{
    dialog_new ();
}


/* Command properties */
static void
cmd_properties (AppletWidget *widget, gpointer data)
{
    dialog_prop ();
}


/* Command about */
static void
cmd_about (AppletWidget *widget, gpointer data)
{
    dialog_about ();
}


/* Drag 'n drop stuff */
static void  
drag_leave_cb (GtkWidget *widget, GdkDragContext *context, guint time)
{
    have_drag = FALSE;
    gtk_pixmap_set (GTK_PIXMAP (widget), i_closed, i_closed_mask);
}

static gboolean
drag_motion_cb (GtkWidget *widget, GdkDragContext *context, gint x, gint y,
                guint time)
{
    if (!have_drag) {
        have_drag = TRUE;
        gtk_pixmap_set (GTK_PIXMAP (widget), i_open, i_open_mask);
    }

    gdk_drag_status (context, context->suggested_action, time);
    return TRUE;
}

static void
drag_data_received_cb (GtkWidget *widget, GdkDragContext *context,
                       gint x, gint y, GtkSelectionData *selection_data,
                       guint info, guint time)
{
    if ((selection_data->length >= 0) && (selection_data->format == 8)) {
        switch (info) {
            case TARGET_URL:
            case TARGET_NETSCAPE_URL:
                dialog_add (selection_data->data);
                break;
        }
        gtk_drag_finish (context, TRUE, FALSE, time);
        return;
    }  
    gtk_drag_finish (context, FALSE, FALSE, time);
}


/* Applet click event */
static gint
applet_clicked_cb (GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    if (event != NULL && event->button == 1
        && event->type == GDK_BUTTON_PRESS) {
        dialog_new ();
        return TRUE;
    }

    return FALSE;
}


/* Main program */
int 
main (int argc, char *argv[])
{
    GtkWidget *applet, *pixmap, *eventbox;
    static GtkTargetEntry target_table[] = {
        { "text/uri-list", 0, TARGET_URL },
        { "text/plain", 0, TARGET_URL },
        { "x-url/http", 0, TARGET_NETSCAPE_URL },
        { "x-url/ftp", 0, TARGET_NETSCAPE_URL },
        { "_NETSCAPE_URL", 0, TARGET_NETSCAPE_URL }
    };

    /* Initialize the i18n stuff */
    bindtextdomain (PACKAGE, GNOMELOCALEDIR);
    textdomain (PACKAGE);
   
    /* Initialize the applet */
    applet_widget_init ("gtm_applet", VERSION, argc, argv, NULL, 0, NULL);
    applet = applet_widget_new ("gtm_applet");
    if (!applet)
	g_error ("Can't create applet!\n");
    gtk_widget_set_events (applet, GDK_BUTTON_PRESS_MASK);
    gtk_widget_realize (applet);
    property_load (APPLET_WIDGET (applet)->privcfgpath);

    /* Load pixmaps */
    i_open = gdk_pixmap_colormap_create_from_xpm_d (
        NULL,
        gtk_widget_get_colormap (applet),
        &i_open_mask, NULL, tray_full_xpm);
    i_closed = gdk_pixmap_colormap_create_from_xpm_d (
        NULL,
        gtk_widget_get_colormap (applet),
        &i_closed_mask, NULL, tray_empty_xpm);
                                               
    /* Create widget eventbox with a pixmap for to new URL */
    eventbox = gtk_event_box_new ();
    pixmap = gtk_pixmap_new (i_closed, i_closed_mask);
    gtk_container_add (GTK_CONTAINER (eventbox), pixmap);
    gtk_widget_show (pixmap);
    gtk_signal_connect (GTK_OBJECT (eventbox), "button_press_event", 
			GTK_SIGNAL_FUNC (applet_clicked_cb), NULL);
    applet_widget_set_widget_tooltip (
        APPLET_WIDGET(applet), eventbox, 
        _ ("Click for new URL or Drop URL from netscape, gmc, gftp..."));
    gtk_widget_show (eventbox);

    /* Set the drag 'n drop stuff */
    gtk_drag_dest_set (pixmap, GTK_DEST_DEFAULT_MOTION 
		       | GTK_DEST_DEFAULT_DROP,
                       target_table, 
                       sizeof (target_table) / sizeof (target_table[0]),
                       GDK_ACTION_COPY);
    gtk_signal_connect (GTK_OBJECT (pixmap), "drag_leave",
                        GTK_SIGNAL_FUNC (drag_leave_cb), NULL);
    gtk_signal_connect (GTK_OBJECT (pixmap), "drag_motion",
                        GTK_SIGNAL_FUNC (drag_motion_cb), NULL);
    gtk_signal_connect (GTK_OBJECT (pixmap), "drag_data_received",
                        GTK_SIGNAL_FUNC(drag_data_received_cb), NULL);

    /* Add the eventbox to the applet and show the applet */
    applet_widget_add (APPLET_WIDGET (applet), eventbox);
    gtk_widget_show (applet);

    /* Session management stuff */
    gtk_signal_connect (GTK_OBJECT (applet),"save_session",
			GTK_SIGNAL_FUNC (applet_save_session), NULL);

    /* Add the menu items */
    applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					   "properties",
					   GNOME_STOCK_MENU_PROP,
					   _ ("Properties..."),
					   cmd_properties, 
					   NULL);
    applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					   "about",
					   GNOME_STOCK_MENU_ABOUT,
					   _ ("About..."),
					   cmd_about,
					   NULL);
    applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					   "new",
					   GNOME_STOCK_MENU_NEW,
					   _ ("New URL"),
					   cmd_new_url, 
					   NULL);
    applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					   "gtm",
					   GNOME_STOCK_PIXMAP_EXEC,
					   _ ("Open GTM"),
					   cmd_gtm_open, 
					   NULL);

    applet_widget_gtk_main();
    return 0;
}

