/*
 dialog-window.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static void sig_save_ok(GtkWidget *dialog)
{
    proplist_t wprop;
    gchar *name, *x, *y, *width, *height;
    gint xsize, ysize, xpos, ypos;
    GString *str;

    name = gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(dialog), "chanentry")));
    x = gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(dialog), "posxentry")));
    y = gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(dialog), "posyentry")));
    width = gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(dialog), "sizexentry")));
    height = gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(dialog), "sizeyentry")));

    if (sscanf(x, "%d", &xpos) != 1) xpos = -1;
    if (sscanf(y, "%d", &ypos) != 1) ypos = -1;
    if (sscanf(width, "%d", &xsize) != 1) xsize = -1;
    if (sscanf(height, "%d", &ysize) != 1) ysize = -1;

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(dialog), "defaultbut"))))
    {
        /* default window */
        name = "default";
    }

    if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(dialog), "sizebut"))))
    {
        /* don't save window size */
        xsize = ysize = -1;
    }

    if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(dialog), "posbut"))))
    {
        /* don't save window position */
        xpos = ypos = -1;
    }

    str = g_string_new(NULL);

    /* save position */
    wprop = config_section(&cprop, "windows");
    g_string_sprintf(str, "%s_xpos", name);
    if (xpos != -1) config_set_int(wprop, str->str, xpos);
    g_string_sprintf(str, "%s_ypos", name);
    if (ypos != -1) config_set_int(wprop, str->str, ypos);

    /* save size */
    g_string_sprintf(str, "%s_xsize", name);
    if (xsize != -1) config_set_int(wprop, str->str, xsize);
    g_string_sprintf(str, "%s_ysize", name);
    if (ysize != -1) config_set_int(wprop, str->str, ysize);

    g_string_free(str, TRUE);

    PLSave(cprop, TRUE);
    gtk_widget_destroy(dialog);
}

static void sig_toggle_button(GtkToggleButton *button, GtkWidget *widget)
{
    gtk_widget_set_sensitive(widget, gtk_toggle_button_get_active(button));
}

static void sig_toggle_name(GtkToggleButton *button, GtkWidget *widget)
{
    gtk_widget_set_sensitive(widget, !gtk_toggle_button_get_active(button));
}

void dialog_window_save(GtkWidget *widget, MAIN_WINDOW_REC *window)
{
    CHANNEL_REC *channel;
    GtkWidget *dialog, *hbox, *hbox2, *entry, *button;
    gchar *str, *name;
    gint x, y;

    dialog = gnome_dialog_new(PACKAGE, GNOME_STOCK_BUTTON_OK,
                              GNOME_STOCK_BUTTON_CANCEL, NULL);
    gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, TRUE, FALSE);
    gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                       GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

    /* window size */
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, FALSE, FALSE, 0);

    button = gtk_check_button_new_with_label(_("Save size"));
    gtk_object_set_data(GTK_OBJECT(dialog), "sizebut", button);
    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);

    hbox2 = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(hbox), hbox2, TRUE, TRUE, 0);

    str = g_strdup_printf("%d", window->window->allocation.width);
    entry = gui_create_labelentry(hbox2, _("Width"), str, TRUE);
    gtk_object_set_data(GTK_OBJECT(dialog), "sizexentry", entry);
    gtk_widget_set_usize(entry, 50, -1);
    g_free(str);

    str = g_strdup_printf("%d", window->window->allocation.height);
    entry = gui_create_labelentry(hbox2, _("Height"), str, TRUE);
    gtk_object_set_data(GTK_OBJECT(dialog), "sizeyentry", entry);
    gtk_widget_set_usize(entry, 50, -1);
    g_free(str);

    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(sig_toggle_button), hbox2);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);

    /* window position */
    gdk_window_get_origin(window->window->window, &x, &y);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, FALSE, FALSE, 0);

    button = gtk_check_button_new_with_label(_("Save position"));
    gtk_object_set_data(GTK_OBJECT(dialog), "posbut", button);
    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);

    hbox2 = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(hbox), hbox2, TRUE, TRUE, 0);

    str = g_strdup_printf("%d", x);
    entry = gui_create_labelentry(hbox2, _("X"), str, TRUE);
    gtk_object_set_data(GTK_OBJECT(dialog), "posxentry", entry);
    gtk_widget_set_usize(entry, 50, -1);
    g_free(str);

    str = g_strdup_printf("%d", y);
    entry = gui_create_labelentry(hbox2, _("Y"), str, TRUE);
    gtk_object_set_data(GTK_OBJECT(dialog), "posyentry", entry);
    gtk_widget_set_usize(entry, 50, -1);
    g_free(str);

    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(sig_toggle_button), hbox2);
    gtk_widget_set_sensitive(hbox2, FALSE);

    /* window name */
    channel = window->active->active;
    name = gui_channel_get_name(channel);
    if (name == NULL) name = "default";

    button = gtk_check_button_new_with_label(_("Default window"));
    gtk_object_set_data(GTK_OBJECT(dialog), "defaultbut", button);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), button, FALSE, FALSE, 0);

    entry = gui_create_labelentry(GNOME_DIALOG(dialog)->vbox, _("Name"), name, FALSE);
    gtk_object_set_data(GTK_OBJECT(dialog), "chanentry", entry);

    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(sig_toggle_name), entry);
    if (strcmp(name, "default") == 0)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);

    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 0, sig_save_ok, GTK_OBJECT(dialog));
    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 1, GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));

    gtk_widget_show_all(dialog);
}

void dialog_window_init(void)
{
}

void dialog_window_deinit(void)
{
}
