/*
 ircbase.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

gint irssi_gui;

void irc_base_init(void)
{
    net_init();
    network_nonblock_init();
    signals_init();

    servers_init();
    servers_idle_init();
    servers_reconnect_init();
    servers_redirect_init();
    channels_init();
    channels_query_init();
    channels_setup_init();

    bans_init();
    ctcp_init();
    commands_init();
    irc_init();
    lag_init();
    modes_init();
    rawlog_init();
    netsplit_init();
    nicklist_init();
}

void irc_base_deinit(void)
{
    nicklist_deinit();
    netsplit_deinit();
    rawlog_deinit();
    modes_deinit();
    lag_deinit();
    irc_deinit();
    commands_deinit();
    ctcp_deinit();
    bans_deinit();

    channels_setup_deinit();
    channels_query_deinit();
    channels_deinit();
    servers_redirect_deinit();
    servers_reconnect_deinit();
    servers_idle_deinit();
    servers_deinit();

    signals_deinit();
    network_nonblock_deinit();
    net_deinit();
}
