#!/usr/bin/perl -w
#
# 14all.cgi
#
# create html pages and graphics with rrdtool for mrtg + rrdtool
#
# (c) 1999 Rainer.Bawidamann@informatik.uni-ulm.de
#
# use freely, but: NO WARRANTY - USE AT YOUR OWN RISK!
#
# RCS History
#
# $Log: 14all.cgi,v $
# Revision 0.9  1999/10/26 14:57:53  rb1
# * changed options parsing
# * the graphics show now the same time interval as mrtg
# * design changes: "last updated..." (thx Matija Grabnar),
#   unknaszero (with rrdtool 1.0.8), GRID color is now black
# * allow multiple config files (thx David Frasch)
# * added binmode calls for NT (untested) (thx Hoorelbeke Rik)
#
# Revision 0.8  1999/09/27 08:03:13  rb1
# * set defaults for optional settings
# * use MAX rra for GPRINT...MAX when withpeak is set
#
# Revision 0.7  1999/09/23 13:09:31  rb1
# * removed manual midnight line for daily graph
#
# Revision 0.6  1999/09/23 12:23:35  rb1
# * don't do a lower-case on global options
# * icondir can be without a final /
# * print a helpful error message when called with wrong parameters
#   (this is a workaround, script should be more tolerante)
# * added kilo option
# * corrected withpeak option to work with perminute... and better legend
# * check workdir option
#
# Revision 0.5  1999/09/23 12:20:34  rb1
# * put under RCS control
#
#
# pre-RCS History
#
# 1999-08-19
#	* v0.1
#	* first release
# 1999-08-25
#	* v0.2
#	* recognizes more options: perhour, perminute, integer
#	* integrates fully in mrtg (-> 2.8.7) with "useRRDTool: Yes"-switch
# 1999-08-27
#	* v0.3
#	* added: "options[...]: bits"
#	* mrtg/rrd-patch runs without installed rrdtools perl module
# 1999-08-30
#	* v0.4
#	* added: "interval: ..."
#	* changed graphics a bit (idea from Alex van den Bogaerdt)
#	* v0.4.1
#	* added support for pseudo targets "^" and "$"
#	* added: "AddHead[...]: ..."
#	* added support for multiple config files (get cfgfile name from script name)

my $rcsid = '$Id: 14all.cgi,v 0.9 1999/10/26 14:57:53 rb1 RelC2 $';
my $version = join(' ', (split(/ /,$rcsid))[1,2]);
$version =~ s',v''; #'

use strict;
use CGI;

sub print_error(@);
sub read_mrtg_config();

my ($q, %targets, @sorted, %config, $cfgfile, $cfgfiledir, %options);
my ($cgidir, @author, @style);

### where the mrtg.cfg file is
# anywhere in the filespace
#$cfgfile = '/home/mrtg/mrtg.cfg';
# relative to the script
#$cfgfile = 'mrtg.cfg';
# use this so 14all.cgi gets the cfgfile name from the script name 
# (14all.cgi -> 14all.cfg)
$cfgfile = '';

# if you want to store your config files in a different place than your cgis:
$cfgfiledir = '';

### cusotmize the html pages
@author = ( -author => 'Rainer.Bawidamann@informatik.uni-ulm.de');
# one possibility to enable stylesheets (second is to use "AddHead[_]:..." in mrtg.cfg)
#@style = ( -style => { -src => 'general.css' });
###

# initialize CGI
$q = new CGI;
$q->import_names('CGI');

# look for the config file
my $meurl = $q->url();
if (defined $CGI::cfg) {
	if (-r $CGI::cfg) {
		$cfgfile = $CGI::cfg;
	} else {
		print_error("Cannot find the given config file: \<tt>$CGI::cfg\</tt>");
	}
} elsif (!$cfgfile) {
	$meurl =~ m|/([^/]*)\.cgi$|;
	$cfgfile = $1 . '.cfg';
	$cfgfile = "$cfgfiledir/$cfgfile" unless -r $cfgfile;
}

# read the config file
read_mrtg_config();
# fix some settings
#   make sure icondir ends with /
$config{icondir} .= '/' if $config{icondir} !~ m|/$|;
#   does the configured workdir exist?
#   (if no workdir is given we can use the actual dir)
if ($config{workdir} && ! -d $config{workdir}) {
	print_error($q->p("Cannot access the configured working directory, please check if the line"),
		$q->p($q->tt("Workdir: $config{workdir}")),
		$q->p("(in ",$q->tt($cfgfile),") is typed correctly."),
		$q->p("Remember: this is a path into the global filesystem, not a web server path"));
	exit 0;
}

my @headeropts = ( @author, @style, -bgcolor => $config{background} );

# the footer we print on every page
my $footer = <<"EOT";
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
  <TR>
    <TD WIDTH=63><A ALT="MRTG"
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-l.gif"></A></TD>
    <TD WIDTH=25><A ALT=""
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-m.gif"></A></TD>
    <TD WIDTH=388><A ALT=""
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-r.gif"></A></TD>
  </TR>
</TABLE>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
  <TR VALIGN=top>
  <TD WIDTH=88 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>Version 2.8.x-rrd</FONT></TD>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>
  <A HREF="http://ee-staff.ethz.ch/~oetiker/">Tobias Oetiker</A>
  <A HREF="mailto:oetiker\@ee.ethz.ch">&lt;oetiker\@ee.ethz.ch&gt;</A> and
  <A HREF="http://www.bungi.com">Dave&nbsp;Rand</A>&nbsp;
  <A HREF="mailto:dlr\@bungi.com">&lt;dlr\@bungi.com&gt;</A>
  <TR VALIGN=top>
  <TD WIDTH=88 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>$version</FONT></TD>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>
  <A HREF="http://www.uni-ulm.de/~rbawidam/">Rainer&nbsp;Bawidamann</A>&nbsp;
  <A HREF="mailto:rb1\@informatik.uni-ulm.de">&lt;rb1\@informatik.uni-ulm.de&gt;</A></FONT>
  </TD>
</TR>
</TABLE>
EOT
$footer .= $q->end_html;

### the main switch
# the modes:
# if parameter "dir" is given show a list of the targets in this "directory"
# elsif parameter "png" is given show a graphic for the target given w/ parameter "log"
# elsif parameter "log" is given show the page for this target
# else show a list of directories and of targets w/o directory
# parameter "cfg" can hold the name of the config file to use
if (defined $CGI::dir) {
	# show a list of targets in the given directory
	my @addhead;
	if ($targets{_}{addhead}) {
		@addhead = ( -head => "$targets{_}{addhead}" );
	}
	print $q->header(-expires => "+300s"), $q->start_html(
		-title => "MRTG/RRD - Group $CGI::dir",
		@headeropts,
		@addhead,
		-expires => '+10m');
	print $q->h1("Available Targets"),"\n\<table>\n";
	my $cfgstr = (defined $CGI::cfg ? "&cfg=$CGI::cfg" : '');
	foreach my $tar (@sorted) {
		next if $tar =~ m/^[\$\^\_]$/; # _ is not a real target
		next if $targets{$tar}{directory} ne $CGI::dir;
		print '<tr><td>',$q->a({href => "$meurl?log=$tar$cfgstr"},
			"$targets{$tar}{title}"),'<td>',
			$q->a({href => "$meurl?log=$tar$cfgstr"},
			$q->img({src => "$meurl?log=$tar&png=daily&small=1$cfgstr", alt => "daily-graph"})),
			"\n";
	}
	print '</table>', $footer;
} elsif (defined $CGI::png) {
	# send a graphic, create it if necessary
	print_error("CGI call error") if (!defined $CGI::log);	
	my $workdir = "$config{workdir}/$targets{$CGI::log}{directory}/";
	my $rrd = "$workdir$CGI::log.rrd";
	my $suffix = (defined $CGI::small ? '.s.png' : '.png');
	my $pngfile = "$workdir$CGI::log-$CGI::png$suffix";
	if (!-w $workdir) {
		$pngfile = "/tmp/$CGI::log-$CGI::png$suffix";
	}
	# reload the graphics after this time:
	my %expire = qw/daily +300s weekly +1800s monthly +2h yearly +1d/;
	# the start times of the diagram; the end time is 'now'
	# (-2000m is 'show the last 2000 minutes' [default size 400 columns, 5 min/value])
	my %start = qw/daily -2000m weekly -12000m monthly -800h yearly -400d/;
	
	require 'RRDs.pm'; # load RRDs.pm only when needed
	# build the rrd command line: set the starttime and the graphics format (PNG)
	my @args = ($pngfile, '-s', $start{$CGI::png}, '-a', 'PNG');
	# if it's not a small picture set the legends
	my ($l1,$l2,$l3,$l4,$li,$lo) = ('','','','','','');
	if (!defined $CGI::small) {
		if ($targets{$CGI::log}{ylegend}) {
			push @args, '-v', $targets{$CGI::log}{ylegend}; }
		if ($targets{$CGI::log}{xsize}) {
			push @args, '-w', $targets{$CGI::log}{xsize}; }
		if ($targets{$CGI::log}{ysize}) {
			push @args, '-h', $targets{$CGI::log}{ysize}; }
		if ($targets{$CGI::log}{legend1}) {
			$l1 = ":".$targets{$CGI::log}{legend1}."\\l"; }
		if ($targets{$CGI::log}{legend2}) {
			$l2 = ":".$targets{$CGI::log}{legend2}."\\l"; }
		if ($targets{$CGI::log}{legend3} ne '--CALC--') {
			$l3 = ":".$targets{$CGI::log}{legend3}."\\l";
		} else {
			$l3 = ":Maximal 5 Minute ".$targets{$CGI::log}{legend1}."\\l";
		}
		if ($targets{$CGI::log}{legend4} ne '--CALC--') {
			$l4 = ":".$targets{$CGI::log}{legend4}."\\l";
		} else {
			$l4 = ":Maximal 5 Minute ".$targets{$CGI::log}{legend2}."\\l";
		}
		if ($targets{$CGI::log}{legendi}) {
			$li = $targets{$CGI::log}{legendi}; }
		else {	$li = "In: "; }
		$li =~ s':'\\:'; # ' quote :
		if ($targets{$CGI::log}{legendo}) {
			$lo = $targets{$CGI::log}{legendo}; }
		else {	$lo = "Out:"; }
		$lo =~ s':'\\:'; # ' quote :
		if ($options{$CGI::log}{integer}) {
			$li = $li . ' %9.0lf';
			$lo = $lo . ' %9.0lf';
		} else {
			$li = $li . ' %8.3lf';
			$lo = $lo . ' %8.3lf';
		}
		if ($targets{$CGI::log}{kmg}) {
			$li = $li . ' %s';
			$lo = $lo . ' %s';
			if ($targets{$CGI::log}{kilo}) {
				push @args, '-b', $targets{$CGI::log}{kilo};
			}
		}
	} else {
		push @args, '-w',250,'-h',100;
	}
	push @args,'--alt-y-grid','--lazy','-c','MGRID#ee0000','-c','GRID#000000';
	my $factor = 1; # should we scale the values?
	if ($options{$CGI::log}{perminute}) {
		$factor = 60; # perminute -> 60x
	} elsif ($options{$CGI::log}{perhour}) {
		$factor = 3600; # perhour -> 3600x
	}
	if ($options{$CGI::log}{bits}) {
		$factor *= 8; # bits instead of bytes -> 8x
	}
	# now build the graph calculation commands
	my ($ds0, $ds1) = ('in', 'out');
	push @args, "DEF:$ds0=$rrd:ds0:AVERAGE", "DEF:$ds1=$rrd:ds1:AVERAGE";
	### if you have rrdtool-1.0.8 (or a beta of it) uncomment the next lines
	# my $unkn_val = ($options{$CGI::log}{unknaszero} ? 0 : 'PREV');
	# push @args, "CDEF:uin=$ds0,UN,$unkn_val,$ds0,IF",
	#	"CDEF:uout=$ds1,UN,$unkn_val,$ds1,IF";
	# ($ds0, $ds1) = ('uin', 'uout');
	if ($factor > 1) {
		# scale the values. we need a CDEF for this
		push @args, "CDEF:fin=$ds0,$factor,*","CDEF:fout=$ds1,$factor,*";
		($ds0, $ds1) = ('fin', 'fout');
	}
	# the commands to draw the values
	push @args, "AREA:$ds0#00cc00$l1", "LINE1:$ds1#0000ff$l2";
	my ($mx0, $mx1) = ($ds0, $ds1);
	# the commands for the peaks
	if (!defined $CGI::small && (substr($CGI::png,0,1) =~ /[$targets{$CGI::log}{withpeak} ]/)) {
		push @args, "DEF:min=$rrd:ds0:MAX", "DEF:mout=$rrd:ds1:MAX";
		($mx0, $mx1) = ('min', 'mout');
		### only with rrdtool-1.0.8
		# push @args, "CDEF:umin=$mx0,UN,$unkn_val,$mx0,IF",
		# 	"CDEF:umout=$mx1,UN,$unkn_val,$mx1,IF";
		# ($ds0, $ds1) = ('umin', 'umout');
		if ($factor > 1) {
			# scale the values. we need a CDEF for this
			push @args, "CDEF:fmin=$mx0,$factor,*","CDEF:fmout=$mx1,$factor,*";
			($mx0, $mx1) = ('fmin', 'fmout');
		}
		push @args, "LINE1:$mx0#006600$l3", "LINE1:$mx1#ff00ff$l4";
	}
	# print the legends
	push @args, "GPRINT:$mx1:MAX:Max $lo",
		"GPRINT:$ds1:AVERAGE:Average $lo",
		"GPRINT:$ds1:LAST:Current $lo\\l",
		"GPRINT:$mx0:MAX:Max $li",
		"GPRINT:$ds0:AVERAGE:Average $li",
		"GPRINT:$ds0:LAST:Current $li\\l" if (!defined $CGI::small);
	# fire up rrdtool
	RRDs::graph(@args);
	my $e = RRDs::error();
	print_error("Cannot create graph: $e") if $e;
	# no error, try to send the file
	open(PNG, "<$pngfile") || print_error("Cannot read graph file (with @args)");
	# ok, send it as image/png
	print $q->header(-type => "image/png", -expires => "$expire{$CGI::png}");
	# NT needs this:
	binmode(PNG); binmode(STDOUT);
	my $buf;
	while(read PNG,$buf,4096) {
		print STDOUT $buf;
	}
	close PNG;
} elsif (defined $CGI::log) {
	# show the graphics for one target
	print_error ("Target $CGI::log unknown") if (!exists $targets{$CGI::log});
	my $title;
	# user defined title?
	if ($targets{$CGI::log}{title}) {
		$title = $targets{$CGI::log}{title};
	} else {
		$title = "MRTG/RRD - Target $CGI::log";
	}
	my @addhead;
	if ($targets{$CGI::log}{addhead}) {
		@addhead = ( -head => "$targets{$CGI::log}{addhead}" );
	}
	print $q->header(-expires => "+300s"), $q->start_html(
		-title => $title,
		@headeropts,
		@addhead);
	# user defined header line? (should exist as mrtg requires it)
	if (exists $targets{$CGI::log}{pagetop}) {
		print $targets{$CGI::log}{pagetop},"\n";
	} else {
		print $q->h1("Target $targets{$CGI::log}{title}"),"\n";
	}
	require 'RRDs.pm';
	my $lasttime = RRDs::last("$config{workdir}/$targets{$CGI::log}{directory}/${CGI::log}.rrd");
	print $q->hr,
		"The statistics were last updated: ",$q->b(scalar(localtime($lasttime))),
		$q->hr;
	my $sup = $targets{$CGI::log}{suppress};
	my $url = "$meurl?log=$CGI::log";
	$url .= "&cfg=$CGI::cfg" if defined $CGI::cfg;
	$url .= "&png";
	# the header lines and tags for the graphics
	if ($sup !~ /d/) {
		print $q->h2("'Daily' graph (5 Minute Average)"),"\n",
			$q->img({src => "$url=daily", alt => "daily-graph"}),
			"\n";
	}
	if ($sup !~ /w/) {
		print $q->h2("'Weekly' graph (30 Minute Average)"),"\n",
			$q->img({src => "$url=weekly", alt => "weekly-graph"}),
			"\n";
	}
	if ($sup !~ /m/) {
		print $q->h2("'Monthly' graph (2 Hour Average)"),"\n",
			$q->img({src => "$url=monthly", alt => "monthly-graph"}),
			"\n";
	}
	if ($sup !~ /y/) {
		print $q->h2("'Yearly' graph (1 Day Average)"),"\n",
			$q->img({src => "$url=yearly", alt => "yearly-graph"}),
			"\n";
	}
	print $footer;
} else {
	# no parameter - show a list of directories and targets without "Directory[...]" (aka root-targets)
	my @addhead;
	if ($targets{_}{addhead}) {
		@addhead = ( -head => "$targets{_}{addhead}" );
	}
	print $q->header(-expires => "+300"), $q->start_html(
	-title => "MRTG/RRD $version",
	@headeropts,
	@addhead,
	-expires => '+1d'); # this page changes whenever directories are added/deleted in mrtg.cfg
	my (@dirs, %dirs, @logs);
	# get the list of directories and "root"-targets
	foreach my $tar (@sorted) {
		next if $tar =~ m/^[_\$\^]$/; # pseudo targets
		if ($targets{$tar}{directory}) {
			next if exists $dirs{$targets{$tar}{directory}};
			$dirs{$targets{$tar}{directory}} = $tar;
			push @dirs, $targets{$tar}{directory};
		} else {
			push @logs, $tar;
		}
	}
	my $cfgstr = (defined $CGI::cfg ? "&cfg=$CGI::cfg" : '');
	print $q->h1("Available Targets"),"\n";
	if ($#dirs > -1) {
		print $q->h2("Directories"),"\<ul>\n";
		foreach my $tar (@dirs) {
			print $q->li($q->a({href => "$meurl?dir=$tar$cfgstr"},
				"Group $tar")),"\n";
		}
		print '</ul><hr>';
	}
	if ($#logs > -1) {
		print $q->h2("Targets"),"\n\<table>\n";
		foreach my $tar (@logs) {
			next if $tar =~ m/^[\$\^_]$/;
			next if $targets{$tar}{directory} ne $CGI::dir;
			print '<tr><td>',
				$q->a({href => "$meurl?log=$tar$cfgstr"},"$targets{$tar}{title}"),
				'<td>',
				$q->img({src => "$meurl?log=$tar&png=daily&small=1$cfgstr",alt => "daily-graph"}),
				"\n";
		}
		print '</table>';
	}
	print $footer;
}
exit 0;

sub build_value($$) {
	my ($opt, $cval) = @_;
	my $val = ($targets{'^'}{$opt} ? $targets{'^'}{$opt}.' ' : '')
		. $cval
		. ($targets{'$'}{$opt} ? ' '.$targets{'$'}{$opt} : '');
	return $val;
}

# read the mrtg.cfg file
sub read_mrtg_config()
{
	my ($opt, $tar, $val);
	my $line = '';
	my @lines;
	open(CFG, "<$cfgfile") || print_error("Cannot open config file");
	while(<CFG>) {
		chomp;		# remove newline
		s/\s+$//g;	# remove trailing space
		s/\s/ /g;	# collapse white space to one space
		next if /^ *\#/;# ignore comment lines
		next if /^ *$/;	# ignore empty lins
		if (/^ +(.*)$/) {	# continuation lines
			$lines[$#lines] .= " ".$1;
		} else {
			push @lines, $_;
		}
	}
	close CFG;
	# set some defaults
	my %defaults = (
		directory => '',
		suppress => '',
		interval => 5,
		xsize => 400,
		ysize => 100,
		withpeak => '',
		ylegend => 'Bytes per Second',
		legend1 => 'Incoming Traffic in Bytes per Second',
		legend2 => 'Outgoing Traffic in Bytes per Second',
		legend3 => '--CALC--',
		legend4 => '--CALC--',
		legendi => 'In: ',
		legendo => 'Out:',
		kmg => ',k,M,G,T,P',
		kilo => 1000
		);
	%config = (
		writeexpires => 'No',
		background => '#ffffff',
		interval => 5,
		icondir => ''
		);
	%{$options{_}} = ();
	%{$targets{_}} = %defaults;
	%{$targets{'$'}} = (); # prepend and append 'targets' are empty by default
	%{$targets{'^'}} = ();
	foreach (@lines) {
		if (/^([\d\w]+)\[(\S*)\] *: *(.*)$/) {
			# a target config line
			($tar, $opt, $val) = (lc($2), lc($1), $3);
			$val = '' if !defined $val; # get around undef values
			if (!exists $targets{$tar}) {
				# first occurance of a target, copy defaults
				# (don't need to check for '_' as this exists in any case)
				push @sorted, $tar;
				foreach my $k (keys %{$targets{_}}) {
					$targets{$tar}{$k} = build_value($k, $targets{_}{$k});
				}
				%{$options{$tar}} = %{$options{_}};
				# set a default title if none given
				# (shouldn't happen as mrtg requires a title)
				$targets{$tar}{'title'} = $tar;
			}
			if ($tar eq '_' && $val eq '') {
				# a line "Command[_]:", resets default
				if ($defaults{$opt}) {
					# there is a default for this, set it
					$targets{'_'}{$opt} = $defaults{$opt};
				} else {
					# no default, delete from _
					delete $targets{'_'}{$opt};
				}
			} elsif ($opt eq 'options') {
				# "Options[...]: " - add values to a set of options
				# not sure aboout this: mrtg allows only one "Options" line,
				# so the defaults should probably be replaced not merged
				$val = lc($val);
				map {$options{$tar}{$_} = 1} ($val =~ m/([a-z]+)/g);
			} elsif ($tar eq '$' || $tar eq '^') {
				$targets{$tar}{$opt} = $val;
			} else {
				# "Command[...]: ..."
				$targets{$tar}{$opt} = build_value($opt, $val);
			}
			next;
		} elsif (/^([\d\w]+) *: *(\S*)$/) {
			# global option
			($tar, $opt, $val) = (undef, lc($1), $2);
			$config{$opt} = $val;
			next;
		}
		$_ =~ s/</&gt;/g;
		print STDERR scalar(localtime())," MRTG/RRD 14all.cgi: unknown field in mrtg.conf '$_'\n";
	}
	# we need to replace '&nbsp;' in the legends as we print them via rrdtool
	foreach $tar (keys %targets) {
		foreach $opt (qw/legend1 legend2 legend3 legend4 legend5 legendi legendo ylegend shortlegend/) {
			$targets{$tar}{$opt} =~ s'&nbsp;' ' # '
				if exists $targets{$tar}{$opt};
		}
	}
}

sub print_error(@)
{
	print $q->header, $q->start_html(
		-title => 'MRTG/RRD index.cgi - Skript error',
		@author,
		-bgcolor => "#ffffff"),
		$q->h1('Skript Error'),
		@_, $q->end_html;
	exit 0;
}
