/*
 *  ncp.h
 *
 *  Copyright (C) 1995 by Volker Lendecke
 *  Modified for sparc by J.F. Chadima
 *
 */

#ifndef _LINUX_NCP_H
#define _LINUX_NCP_H

#include <ncp/kernel/types.h>

#define NCP_PTYPE                (0x11)
#define NCP_PORT                 (0x0451)

#define NCP_ALLOC_SLOT_REQUEST   (0x1111)
#define NCP_REQUEST              (0x2222)
#define NCP_DEALLOC_SLOT_REQUEST (0x5555)

struct ncp_request_header {
	u_int16_t type __attribute__((packed));
	u_int8_t  sequence __attribute__((packed));
	u_int8_t  conn_low __attribute__((packed));
	u_int8_t  task __attribute__((packed));
	u_int8_t  conn_high __attribute__((packed));
	u_int8_t  function __attribute__((packed));
	u_int8_t  data[0] __attribute__((packed));
};

#define NCP_REPLY                (0x3333)
#define NCP_POSITIVE_ACK         (0x9999)

struct ncp_reply_header {
	u_int16_t type __attribute__((packed));
	u_int8_t sequence __attribute__((packed));
	u_int8_t conn_low __attribute__((packed));
	u_int8_t task __attribute__((packed));
	u_int8_t conn_high __attribute__((packed));
	u_int8_t completion_code __attribute__((packed));
	u_int8_t connection_state __attribute__((packed));
	u_int8_t data[0] __attribute__((packed));
};

#define NCP_VOLNAME_LEN (16)
#define NCP_NUMBER_OF_VOLUMES (64)
struct ncp_volume_info {
	u_int32_t total_blocks;
	u_int32_t free_blocks;
	u_int32_t purgeable_blocks;
	u_int32_t not_yet_purgeable_blocks;
	u_int32_t total_dir_entries;
	u_int32_t available_dir_entries;
	u_int8_t sectors_per_block;
	char volume_name[NCP_VOLNAME_LEN + 1];
};

/* these define the attribute byte as seen by NCP */
/* FIXME: Create counterparts "as seen by host" i.e. aRONLY always 0x1 */
#define aRONLY     (ntohl(0x01000000))
#define aHIDDEN    (ntohl(0x02000000))
#define aSYSTEM    (ntohl(0x04000000))
#define aEXECUTE   (ntohl(0x08000000))
#define aDIR       (ntohl(0x10000000))
#define aARCH      (ntohl(0x20000000))

#define AR_READ      (ntohs(0x0100))
#define AR_WRITE     (ntohs(0x0200))
#define AR_EXCLUSIVE (ntohs(0x2000))

#define NCP_FILE_ID_LEN 6

/* Defines for Name Spaces */
#define NW_NS_DOS     0
#define NW_NS_MAC     1
#define NW_NS_NFS     2
#define NW_NS_FTAM    3
#define NW_NS_OS2     4

#define	RIM_NAME		0x00000001
#define	RIM_SPACE_ALLOCATED	0x00000002
#define RIM_ATTRIBUTES		0x00000004
#define RIM_DATA_SIZE		0x00000008
#define RIM_TOTAL_SIZE		0x00000010
#define RIM_EXT_ATTR_INFO	0x00000020
#define RIM_ARCHIVE		0x00000040
#define RIM_MODIFY		0x00000080
#define RIM_CREATION		0x00000100
#define RIM_OWNING_NAMESPACE	0x00000200
#define RIM_DIRECTORY		0x00000400
#define RIM_RIGHTS		0x00000800
#define RIM_ALL			0x00000FFF
#define RIM_REFERENCE_ID	0x00001000
#define RIM_NS_ATTRIBUTES	0x00002000
#define RIM_DATASTREAM_SIZES	0x00004000
#define RIM_DATASTREAM_LOGICALS	0x00008000
#define RIM_UPDATE_TIME		0x00010000
#define RIM_DOS_NAME		0x00020000
#define RIM_FLUSH_TIME		0x00040000
#define RIM_PARENT_BASE_ID	0x00080000
#define RIM_MAC_FINDER_INFO	0x00100000
#define RIM_SIBLING_COUNT	0x00200000
#define RIM_EFFECTIVE_RIGHTS	0x00400000
#define RIM_MAC_TIMES		0x00800000
#define RIM_LAST_ACCESS_TIME	0x01000000
#define RIM_NSS_LARGE_SIZES	0x40000000
#define RIM_COMPRESSED_INFO	0x80000000U

/* open/create modes */
#define OC_MODE_OPEN		0x01
#define OC_MODE_TRUNCATE	0x02
#define OC_MODE_REPLACE 	0x02
#define OC_MODE_CREATE		0x08
#define OC_MODE_READONLY_OK	0x40
#define OC_MODE_CALLBACK	0x80

/* open/create results */
#define OC_ACTION_NONE		0x00
#define OC_ACTION_OPEN		0x01
#define OC_ACTION_CREATE	0x02
#define OC_ACTION_TRUNCATE	0x04
#define OC_ACTION_REPLACE	0x04
#define OC_ACTION_COMPRESSED	0x08
#define OC_ACTION_READONLY	0x80

/* access rights attributes */
#ifndef AR_READ_ONLY
#define AR_READ_ONLY	   0x0001
#define AR_WRITE_ONLY	   0x0002
#define AR_DENY_READ	   0x0004
#define AR_DENY_WRITE	   0x0008
#define AR_COMPATIBILITY   0x0010
#define AR_WRITE_THROUGH   0x0040
#define AR_OPEN_COMPRESSED 0x0100
#endif

struct nw_info_struct {
	u_int32_t spaceAlloc __attribute__((packed));
	u_int32_t attributes __attribute__((packed));
	u_int16_t flags __attribute__((packed));
	u_int32_t dataStreamSize __attribute__((packed));
	u_int32_t totalStreamSize __attribute__((packed));
	u_int16_t numberOfStreams __attribute__((packed));
	u_int16_t creationTime __attribute__((packed));
	u_int16_t creationDate __attribute__((packed));
	u_int32_t creatorID __attribute__((packed));
	u_int16_t modifyTime __attribute__((packed));
	u_int16_t modifyDate __attribute__((packed));
	u_int32_t modifierID __attribute__((packed));
	u_int16_t lastAccessDate __attribute__((packed));
	u_int16_t archiveTime __attribute__((packed));
	u_int16_t archiveDate __attribute__((packed));
	u_int32_t archiverID __attribute__((packed));
	u_int16_t inheritedRightsMask __attribute__((packed));
	u_int32_t dirEntNum __attribute__((packed));
	u_int32_t DosDirNum __attribute__((packed));
	u_int32_t volNumber __attribute__((packed));
	u_int32_t EADataSize __attribute__((packed));
	u_int32_t EAKeyCount __attribute__((packed));
	u_int32_t EAKeySize __attribute__((packed));
	u_int32_t NSCreator __attribute__((packed));
	u_int8_t nameLen __attribute__((packed));
	u_int8_t entryName[256] __attribute__((packed));
};

/* modify mask - use with MODIFY_DOS_INFO structure */
#define DM_ATTRIBUTES		  (0x00000002L)
#define DM_CREATE_DATE		  (0x00000004L)
#define DM_CREATE_TIME		  (0x00000008L)
#define DM_CREATOR_ID		  (0x00000010L)
#define DM_ARCHIVE_DATE 	  (0x00000020L)
#define DM_ARCHIVE_TIME 	  (0x00000040L)
#define DM_ARCHIVER_ID		  (0x00000080L)
#define DM_MODIFY_DATE		  (0x00000100L)
#define DM_MODIFY_TIME		  (0x00000200L)
#define DM_MODIFIER_ID		  (0x00000400L)
#define DM_LAST_ACCESS_DATE	  (0x00000800L)
#define DM_INHERITED_RIGHTS_MASK  (0x00001000L)
#define DM_MAXIMUM_SPACE	  (0x00002000L)

struct nw_modify_dos_info {
	u_int32_t attributes __attribute__((packed));
	u_int16_t creationDate __attribute__((packed));
	u_int16_t creationTime __attribute__((packed));
	u_int32_t creatorID __attribute__((packed));
	u_int16_t modifyDate __attribute__((packed));
	u_int16_t modifyTime __attribute__((packed));
	u_int32_t modifierID __attribute__((packed));
	u_int16_t archiveDate __attribute__((packed));
	u_int16_t archiveTime __attribute__((packed));
	u_int32_t archiverID __attribute__((packed));
	u_int16_t lastAccessDate __attribute__((packed));
	u_int16_t inheritanceGrantMask __attribute__((packed));
	u_int16_t inheritanceRevokeMask __attribute__((packed));
	u_int32_t maximumSpace __attribute__((packed));
};

struct nw_file_info {
	struct nw_info_struct i;
	int opened;
	int access;
	u_int32_t server_file_handle __attribute__((packed));
	u_int8_t open_create_action __attribute__((packed));
	u_int8_t file_handle[6] __attribute__((packed));
};

struct nw_search_sequence {
	u_int8_t volNumber __attribute__((packed));
	u_int32_t dirBase __attribute__((packed));
	u_int32_t sequence __attribute__((packed));
};

#endif				/* _LINUX_NCP_H */
