#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>

/*
 * Simple substitute snprintf().  Ignores the size param and works like the
 * old unsafe sprintf().
 */
int 
snprintf(char *string1, 
         size_t size, 
         const char *format,
         ...)

{
  int result;
  va_list varlist;

  va_start(varlist, format);

  result = vsprintf(string1, format, varlist);

  va_end(varlist);

  return result;
}
