/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 *  			  Centro SERRA, University of Pisa
 *  			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef NTOP_H
#define NTOP_H

#if defined(linux) || defined(__linux__)


/* 
   This allows to hide the (minimal) differences between
   linux and BSD 
*/
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif /* _BSD_SOURCE */
#undef HAVE_SCHED_H /* Linux doesn't seem to really like it */
#endif /* linux */

#ifdef WIN32
#include "ntop_win32.h"
#define HAVE_GDBM_H
#define strncasecmp(a, b, c) strnicmp(a, b, c)
#endif

/* Libwrap support courtesy of 
   Georg Schwarz
   <schwarz@itp4.physik.TU-Berlin.DE> */
#ifdef HAVE_LIBWRAP
#include <tcpd.h>
#include <syslog.h>
#ifdef NEED_SYS_SYSLOG_H
#include <sys/syslog.h>
#endif /* NEED_SYS_SYSLOG_H */
#ifndef SYSLOG_FACILITY
#define SYSLOG_FACILITY LOG_DAEMON /* default value, if not specified otherwise */
#endif

#ifndef DAEMONNAME
#define DAEMONNAME "ntop" /* for /etc/hosts.allow, /etc/hosts.deny */
#endif  /* DAEMONNAME */

#endif /* HAVE_LIBWRAP */

#ifdef HPUX
#include <dl.h>
/*-----------------------Export from linux----------------------------------------*/
#define HFIXEDSZ      12              /* #/bytes of fixed data in header */
#define INT32SZ       4               /* for systems without 32-bit ints */
#define INT16SZ       2               /* for systems without 16-bit ints */
#define INADDRSZ      4               /* IPv4 T_A */
#define IN6ADDRSZ     16              /* IPv6 T_AAAA */
/*------------------------------------------------------------------------------*/
#endif
 

#include <errno.h>

#if defined(HAVE_NCURSES_H) || defined(HAVE_CURSES_H)
#define HAVE_CURSES
#endif

#ifdef HAVE_CURSES
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#ifdef HAVE_CURSES_H
#include <curses.h>
#endif
#endif

#ifndef A_NORMAL
#define A_NORMAL        000000000000L
#endif

#ifndef A_REVERSE
#define A_REVERSE       000040000000L
#endif
#endif

#include <ctype.h>
#include <sys/types.h>
#ifndef WIN32
#include <sys/param.h>
#include <unistd.h>
#endif
#ifndef WIN32
#include <sys/socket.h>
#endif
#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif

#ifdef HAVE_SYS_FCNTL_H
#include <sys/fcntl.h>
#endif
#ifndef WIN32
#include <sys/wait.h>
#endif

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifndef WIN32
#include <net/if.h>
#include <arpa/nameser.h>
#endif
#include <time.h>
#ifndef WIN32
#include <sys/time.h>
#include <sys/times.h>
#include <sys/ioctl.h>
#include <netinet/in.h>

#ifdef HAVE_NETINET_IF_ETHER_H
#include <netinet/if_ether.h>
#else
#ifdef SLACKWARE
#undef ETHER_HEADER_HAS_EA
struct	ether_header {
	u_char	ether_dhost[6];
	u_char	ether_shost[6];
	u_short	ether_type;
};
#endif /* SLACKWARE */
#endif /* HAVE_IF_ETHER_H */


#include <netinet/in_systm.h>
#endif


#ifndef WIN32
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netdb.h> 
#include <sys/file.h>
#include <sys/stat.h>
#include <signal.h>
RETSIGTYPE (*setsignal(int, RETSIGTYPE (*)(int)))(int);
#endif

#if __STDC__
#include <stdarg.h>
#else
#ifndef WIN32
#include <varargs.h>
#endif
#endif

#ifndef WIN32
#include <unistd.h>
#endif

#ifdef OSF1
#include "if.h"
#endif


#ifdef HAVE_GDBM_H
#include <gdbm.h>
#ifdef WIN32
#include <gdbmerrno.h>
extern const char *gdbm_strerror (int);
#endif
#endif


#include <stdio.h>

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif

/* #ifdef below courtesy of 
 * "David Masterson" <David.Masterson@kla-tencor.com> 
 */
#ifdef HAVE_NET_BPF_H
#include <net/bpf.h>
#endif
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_NET_ETHERNET_H
#include <net/ethernet.h> 
#endif
#ifdef HAVE_ETHERTYPE_H
#include <ethertype.h>
#else
#ifndef ETHERTYPE_IP
#define ETHERTYPE_IP		0x0800
#endif
#ifndef ETHERTYPE_NS
#define ETHERTYPE_NS		0x0600
#endif
#ifndef	ETHERTYPE_SPRITE
#define	ETHERTYPE_SPRITE	0x0500
#endif
#ifndef ETHERTYPE_TRAIL
#define ETHERTYPE_TRAIL		0x1000
#endif
#ifndef	ETHERTYPE_MOPDL
#define	ETHERTYPE_MOPDL		0x6001
#endif
#ifndef	ETHERTYPE_MOPRC
#define	ETHERTYPE_MOPRC		0x6002
#endif
#ifndef	ETHERTYPE_DN
#define	ETHERTYPE_DN		0x6003
#endif
#ifndef	ETHERTYPE_ARP
#define	ETHERTYPE_ARP		0x0806
#endif
#ifndef	ETHERTYPE_LAT
#define	ETHERTYPE_LAT		0x6004
#endif
#ifndef ETHERTYPE_SCA
#define ETHERTYPE_SCA		0x6007
#endif
#ifndef ETHERTYPE_REVARP
#define ETHERTYPE_REVARP	0x8035
#endif
#ifndef	ETHERTYPE_LANBRIDGE
#define	ETHERTYPE_LANBRIDGE	0x8038
#endif
#ifndef	ETHERTYPE_DECDNS
#define	ETHERTYPE_DECDNS	0x803c
#endif
#ifndef	ETHERTYPE_DECDTS
#define	ETHERTYPE_DECDTS	0x803e
#endif
#ifndef	ETHERTYPE_VEXP
#define	ETHERTYPE_VEXP		0x805b
#endif
#ifndef	ETHERTYPE_VPROD
#define	ETHERTYPE_VPROD		0x805c
#endif
#ifndef ETHERTYPE_ATALK
#define ETHERTYPE_ATALK		0x809b
#endif
#ifndef ETHERTYPE_AARP
#define ETHERTYPE_AARP		0x80f3
#endif
#ifndef	ETHERTYPE_LOOPBACK
#define	ETHERTYPE_LOOPBACK	0x9000
#endif

#endif

#ifndef ETHERMTU
#define ETHERMTU  1500
#endif

#include <setjmp.h>

#include "interface.h"

#define ALARM_TIME                3
#define MIN_ALARM_TIME            1
#define THROUGHPUT_REFRESH_TIME   30
#define REFRESH_TIME              120
#define MIN_REFRESH_TIME          15

#ifdef MULTITHREADED
#ifndef WIN32
#ifdef HAVE_SYS_SCHED_H
#include <sys/sched.h>
#endif
#ifdef HAVE_SCHED_H
#include <sched.h>
#endif


/* Switched pthread with semaphore.
   Courtesy of 
   Wayne Roberts <wroberts1@cx983858-b.orng1.occa.home.com>
*/
#include <pthread.h>

#ifdef HAVE_SEMAPHORE_H
#include <semaphore.h>
#else
#undef USE_SEMAPHORES
#endif

typedef struct conditionalVariable {
  pthread_mutex_t mutex;
  pthread_cond_t  condvar;
  int predicate;
} ConditionalVariable;
#endif /* WIN32 */

typedef struct packetInformation {
  struct pcap_pkthdr h;
  u_char p[2*DEFAULT_SNAPLEN+1];
} PacketInformation;


#ifndef _UTIL_C_
extern int createThread(pthread_t *threadId,
		  void *(*__start_routine) (void *));
extern void killThread(pthread_t *threadId);
extern int createMutex(pthread_mutex_t *mutexId);
extern void deleteMutex(pthread_mutex_t *mutexId);
extern int accessMutex(pthread_mutex_t *mutexId);
extern int releaseMutex(pthread_mutex_t *mutexId);
extern int createCondvar(ConditionalVariable *condvarId);
extern void deleteCondvar(ConditionalVariable *condvarId);
extern int waitCondvar(ConditionalVariable *condvarId);
extern int signalCondvar(ConditionalVariable *condvarId);

#ifdef HAVE_SEMAPHORE_H
extern int createSem(sem_t *semId, int initialValue);
extern void waitSem(sem_t *semId);
extern int incrementSem(sem_t *semId);
extern int decrementSem(sem_t *semId);
extern int deleteSem(sem_t *semId);
#endif

#endif /* _UTIL_C_ */
#define THREAD_MODE "MT"

#else /* MULTITHREADED */

#define THREAD_MODE "ST"

/*
  Comment out the line below if asynchronous
  numeric -> symbolic address resolution
  has problems on your system
*/
#define ASYNC_ADDRESS_RESOLUTION

#endif

#define PACKET_QUEUE_LENGTH     2048
#define ADDRESS_QUEUE_LENGTH    512

#ifdef WIN32
typedef DWORDLONG TrafficCounters;
#endif

#ifndef WIN32
typedef unsigned long long TrafficCounter;
#endif

#define MAX_NUM_CONTACTED_PEERS   8
#define SENT_PEERS                2
#define RCVD_PEERS                2
#define NO_PEER                  -1

#ifdef HAVE_LSOF
typedef struct processInfo {
  char marker; /* internal use only */
  char *command, *user;
  time_t firstSeen, lastSeen;
  int pid;
  TrafficCounter bytesSent, bytesReceived;
  /* peers that talked with this process */
  u_int contactedIpPeersIndexes[MAX_NUM_CONTACTED_PEERS];
  unsigned short contactedIpPeersIdx;
} ProcessInfo;

typedef struct processInfoList {
  ProcessInfo            *element;
  struct processInfoList *next;
} ProcessInfoList;

#define MAX_NUM_SHARED_PORTS     16
#define MAX_NUM_PROCESSES      1024
#define MAX_NUM_LSOF_ENTRIES    512
#endif

#define TOP_IP_PORT           65534 /* IP ports range from 0 to 65535 */
#define TOP_ASSIGNED_IP_PORTS  1024


#define ETHERNET_ADDRESS_LEN 6


typedef union {
  HEADER qb1;
  u_char qb2[PACKETSZ];
} querybuf;


#ifndef MAXALIASES
#define MAXALIASES       35
#endif

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN  256
#endif

#ifndef MAXADDRS
#define MAXADDRS         35
#endif

#ifndef NS_CMPRSFLGS
#define NS_CMPRSFLGS    0xc0
#endif

#ifndef NS_MAXCDNAME
#define NS_MAXCDNAME     255
#endif


typedef struct	{
  char	    name[MAXDNAME];		   /* official name of host */
  char	    aliases[MAXALIASES][MAXDNAME]; /* alias list */
  u_int32_t addrList[MAXADDRS];	/* list of addresses from name server */
  int	    addrType;	/* host address type */
  int	    addrLen;	/* length of address */
} DNSHostInfo;

/* ******************************************* */

/*
 * The definitions below have been copied
 * from llc.h that's part of tcpdump
 *
 */

struct llc {
  u_char dsap;
  u_char ssap;
  union {
    u_char u_ctl;
    u_short is_ctl;
    struct {
      u_char snap_ui;
      u_char snap_pi[5];
    } snap;
    struct {
      u_char snap_ui;
      u_char snap_orgcode[3];
      u_char snap_ethertype[2];
    } snap_ether;
  } ctl;
};

#define	llcui		ctl.snap.snap_ui
#define	llcpi		ctl.snap.snap_pi
#define	orgcode		ctl.snap_ether.snap_orgcode
#define	ethertype	ctl.snap_ether.snap_ethertype
#define	llcis		ctl.is_ctl
#define	llcu		ctl.u_ctl

#define	LLC_U_FMT	3
#define	LLC_GSAP	1
#define LLC_S_FMT	1

#define	LLC_U_POLL	0x10
#define	LLC_IS_POLL	0x0001
#define	LLC_XID_FI	0x81

#define	LLC_U_CMD(u)	((u) & 0xef)
#define	LLC_UI		0x03
#define	LLC_UA		0x63
#define	LLC_DISC	0x43
#define	LLC_DM		0x0f
#define	LLC_SABME	0x6f
#define	LLC_TEST	0xe3
#define	LLC_XID		0xaf
#define	LLC_FRMR	0x87

#define	LLC_S_CMD(is)	(((is) >> 10) & 0x03)
#define	LLC_RR		0x0100
#define	LLC_RNR		0x0500
#define	LLC_REJ		0x0900

#define LLC_IS_NR(is)	(((is) >> 1) & 0x7f)
#define LLC_I_NS(is)	(((is) >> 9) & 0x7f)

#ifndef LLCSAP_NULL
#define	LLCSAP_NULL		0x00
#endif

#ifndef LLCSAP_GLOBAL
#define	LLCSAP_GLOBAL		0xff
#endif

#ifndef LLCSAP_8021B
#define	LLCSAP_8021B_I		0x02
#endif

#ifndef LLCSAP_8021B
#define	LLCSAP_8021B_G		0x03
#endif

#ifndef LLCSAP_IP
#define	LLCSAP_IP		0x06
#endif

#ifndef LLCSAP_PROWAYNM
#define	LLCSAP_PROWAYNM		0x0e
#endif

#ifndef LLCSAP_8021D
#define	LLCSAP_8021D		0x42
#endif

#ifndef LLCSAP_RS511
#define	LLCSAP_RS511		0x4e
#endif

#ifndef LLCSAP_ISO8208
#define	LLCSAP_ISO8208		0x7e
#endif

#ifndef LLCSAP_PROWAY
#define	LLCSAP_PROWAY		0x8e
#endif

#ifndef LLCSAP_SNAP
#define	LLCSAP_SNAP		0xaa
#endif

#ifndef LLCSAP_ISONS
#define	LLCSAP_ISONS		0xfe
#endif

#ifndef LLCSAP_NETBIOS
#define	LLCSAP_NETBIOS		0xf0
#endif

#ifndef IPPROTO_OSPF
#define IPPROTO_OSPF              89
#endif

#ifndef IPPROTO_IGMP
#define IPPROTO_IGMP               2  /* Internet Group Management Protocol */
#endif

/* ******************************* */

#ifndef min
#define min(a,b) ((a)>(b)?(b):(a))
#endif

/* SunOS 4.x, at least, doesn't have a CLOCKS_PER_SEC.  I got this value
 * from Solaris--who knows.             
 * Paul D. Smith <psmith@baynetworks.com>
 */
#ifndef CLOCKS_PER_SEC
#define CLOCKS_PER_SEC 1000000
#endif

#ifndef NTOHL
#define NTOHL(x)    (x) = ntohl(x) 
#endif

#define DB_TIMEOUT_REFRESH_TIME      30 /* seconds */
#define DEFAULT_DB_UPDATE_TIME       60 /* seconds */
#define HASHNAMESIZE               4096

/* 75% is the threshold for the hash table: it's time to
   free up some space */
#define HASHNAMETHRESHOLDSIZE  3072 /* 75% */

#define SHORTHASHNAMESIZE  1024
#define VENDORHASHNAMESIZE (3*HASHNAMESIZE)

/* Stefano Suin <stefano@unipi.it> */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN  64
#endif

/*
 * Max number of screen switchable using
 * the space bar (interactive mode only).
*/
#define MAX_NUM_SCREENS  6

/*
 * Max number of TCP sessions that can be 
 * recorded per host 
 */
#define MAX_NUM_TCP_SESSIONS  32

/* The constant below is so large due to the
   huge service table that Doug Royer <doug@royer.com>
   has to handle. I have no clue what's inside such /etc/services
   file. However, all this is quite interesting....
*/
#define SERVICE_HASH_SIZE     50000

#define NULL_HDRLEN 4

#define SHORT_REPORT        1
#define LONG_REPORT         2


#define MAX_NUM_SESSION_PEERS 5

#define CLIENT_TO_SERVER       1
#define CLIENT_FROM_SERVER     2
#define SERVER_TO_CLIENT       3
#define SERVER_FROM_CLIENT     4


#define CLIENT_ROLE            1
#define SERVER_ROLE            2

#define LOCAL_HOST             1
#define REMOTE_HOST            2


#define REMOTE_TO_LOCAL_ACCOUNTING   1
#define LOCAL_TO_REMOTE_ACCOUNTING   2
#define LOCAL_TO_LOCAL_ACCOUNTING    3

#define MAX_NUM_HANDLED_IP_PROTOCOLS      32

#define MAX_NUM_PROTOS_SCREENS 5

/* ************* Types Definition ********************* */

typedef struct packetStats {
  TrafficCounter upTo64, upTo128, upTo256;
  TrafficCounter upTo512, upTo1024, upTo1518, above1518;
  TrafficCounter shortest, longest;
} PacketStats;

#define MAX_HOST_NAME_LEN 26

struct hnamemem {
  struct in_addr addr;
  char *name;
};

struct enamemem {
  u_short e_addr0;
  u_short e_addr1;
  u_short e_addr2;
  char   *e_name;
  u_char *e_nsap;  /* used only for nsaptable[] */
  struct enamemem *e_nxt;
};

typedef struct trafficEntry {
  TrafficCounter bytesSent, bytesReceived;
} TrafficEntry;

typedef struct serviceEntry {
  u_short port;
  char* name;
} ServiceEntry;

struct hostTraffic; /* IP Session global information */

typedef struct protoTrafficInfo {
  TrafficCounter sentLocally, sentRemotely;
  TrafficCounter receivedLocally, receivedFromRemote;
} ProtoTrafficInfo;

typedef struct simpleProtoTrafficInfo {
  TrafficCounter local, local2remote, remote, remote2local;
  TrafficCounter lastLocal, lastLocal2remote, lastRemote, lastRemote2local;
} SimpleProtoTrafficInfo;

typedef struct ipGlobalSession {
  u_short magic;
  u_short port;                    /* port (either client or server)           */
  u_char initiator;                /* CLIENT_ROLE/SERVER_ROLE                  */
  time_t firstSeen;                /* time when the session has been initiated */
  time_t lastSeen;                 /* time when the session has been closed    */
  u_short sessionCounter;          /* # of sessions we've observed             */
  TrafficCounter bytesSent;         /* # bytes received (peer -> initiator)     */
  TrafficCounter bytesReceived;     /* # bytes received (peer -> initiator)     */
  u_char lastPeer;                 /* idx of the last peer added to the list   */
  u_int peersIdx[MAX_NUM_SESSION_PEERS]; /* session peers idx          */
  struct ipGlobalSession  *next;   /* next element (linked list)               */
} IpGlobalSession;

#define MAX_NUM_FIN          4

/* **************** Plugin **************** */

typedef void(*TermFunc)();
typedef void(*PluginFunc)(const struct pcap_pkthdr *h, const u_char *p); 
typedef void(*PluginHTTPFunc)(char* url); 

typedef struct {
  /* Plugin Info */
  char *pluginName;  /* Short plugin name (e.g. arpPlugin) */
  char *pluginDescr; /* Long plugin description */
  char *pluginVersion;
  char *pluginAuthor;
  char *pluginURLname;      /* Set it to NULL if the plugin
			       doesn't speak HTTP */
  TermFunc termFunc;
  PluginFunc pluginFunc;    /* Initialize here all the plugin structs... */
  PluginHTTPFunc httpFunct; /* Set it to NULL if the plugin
			       doesn't speak HTTP */
  char* bpfFilter; /* BPF filter for selecting packets that
		      will be routed to the plugin  */
} PluginInfo;

#define PLUGIN_EXTENSION                  ".dll"
#define PLUGIN_ENTRY_FCTN_NAME "PluginEntryFctn"

/* Flow Filter List */
typedef struct flowFilterList {
  char* flowName;
  struct bpf_insn *filterCode;   /* compiled filter code       */
  struct flowFilterList *next;   /* next element (linked list) */
  TrafficCounter bytes, packets;
  PluginInfo *pluginPtr; /* 
			    This ptr != NULL is a plugin
			    has set a filter
			 */
} FlowFilterList;

#define MAGIC_NUMBER 1968

/* IP Session Information */
typedef struct ipSession {
  u_short magic;
  u_int initiatorIdx;              /* initiator address   (IP address)         */
  u_short sport;                   /* initiator address   (port)               */
  u_int remotePeerIdx;             /* remote peer address (IP address)         */
  u_short dport;                   /* remote peer address (port)               */
  time_t firstSeen;                /* time when the session has been initiated */
  time_t lastSeen;                 /* time when the session has been closed    */
  TrafficCounter bytesSent;        /* # bytes sent (initiator -> peer)         */
  TrafficCounter bytesReceived;    /* # bytes received (peer -> initiator)     */
  u_short  numFin;                 /* # FIN pkts received                      */
  u_short  numFinAcked;            /* # ACK pkts received                      */
  tcp_seq finId[MAX_NUM_FIN];      /* ACK ids we're waiting for                */
  TrafficCounter lastFlags;        /* flags of the last TCP packet             */
  u_int32_t lastCSAck, lastSCAck;  /* they store the last ACK ids C->S/S->C    */
  u_int32_t lastCSFin, lastSCFin;  /* they store the last FIN ids C->S/S->C    */
  u_short sessionState;            /* actual session state                     */
} IPSession;


#define MAX_NUM_TABLE_ROWS      384

typedef struct hostAddress {
  unsigned int numAddr;
  char* symAddr;
} HostAddress;


/* Host Traffic */
typedef struct hostTraffic {
  struct in_addr hostIpAddress;
  time_t         lastSeen; /* time when this host has sent/received some data  */
  time_t         nextDBupdate; /* next time when the DB entry for this host will be updated */
  u_char         ethAddress[ETHERNET_ADDRESS_LEN], promiscuousMode;
  char           *ethAddressString;  
  char           hostNumIpAddress[17];
  u_char         theDomainHasBeenComputed;
  char           *fullDomainName, *dotDomainName;
  char           *hostSymIpAddress;  
  char           *osName;  
  char           instanceInUse; /* If so, this instance cannot be purged */
  u_char         subnetLocalHost; /* indicates whether the host is either 
				     LOCAL_HOST or REMOTE_HOST */
  u_char         broadcastHost;   /* indicates whether this is a broadcast address */
  u_char         subnetPseudoLocalHost; /* indicates whether the host is local 
					   (with respect to the specified subnets) */
  TrafficCounter pktSent, pktReceived;
  TrafficCounter pktBroadcastSent, bytesBroadcastSent;
  TrafficCounter pktMulticastSent, bytesMulticastSent;
  TrafficCounter lastBytesSent, bytesSent, bytesSentLocally, bytesSentRemotely;
  TrafficCounter lastBytesReceived, bytesReceived, 
                 bytesReceivedLocally, bytesReceivedFromRemote;
  float          actualRcvdThpt, averageRcvdThpt, peakRcvdThpt, 
                 actualSentThpt, averageSentThpt, peakSentThpt;
  unsigned short actBandwidthUsage;
  /* IP */
  unsigned short usedClientPorts[TOP_ASSIGNED_IP_PORTS],
                 usedServerPorts[TOP_ASSIGNED_IP_PORTS]; /* list of ports used as client/server */
  TrafficCounter tcpSentLocally, tcpSentRemotely, udpSentLocally, 
                 udpSentRemotely, icmpSent, ospfSent, igmpSent;
  TrafficCounter tcpReceivedLocally, tcpReceivedFromRemote, udpReceivedLocally, 
                 udpReceivedFromRemote, icmpReceived, ospfReceived, igmpReceived;
  /* non IP */
  TrafficCounter  ipxSent, ipxReceived;
  TrafficCounter  osiSent, osiReceived;
  TrafficCounter  dlcSent, dlcReceived;
  TrafficCounter  arp_rarpSent, arp_rarpReceived;
  TrafficCounter  decnetSent, decnetReceived;
  TrafficCounter  appletalkSent, appletalkReceived;
  TrafficCounter  netbiosSent, netbiosReceived;
  TrafficCounter  otherSent, otherReceived;  
  ProtoTrafficInfo *protoIPTrafficInfos; /* info about IP traffic generated/received by this host */  
  IpGlobalSession *tcpSessionList, *udpSessionList; /* list of sessions initiated/received by this host */
  u_int contactedSentPeersIndexes[MAX_NUM_CONTACTED_PEERS]; /* peers that talked with this host */
  unsigned short contactedSentPeersIdx;
  u_int contactedRcvdPeersIndexes[MAX_NUM_CONTACTED_PEERS]; /* peers that talked with this host */
  unsigned short contactedRcvdPeersIdx;
} HostTraffic;

/* **************************** */

typedef struct domainStats {
  HostTraffic *domainHost; /* ptr to a host that belongs to the domain */
  TrafficCounter bytesSent, bytesRcvd;
  TrafficCounter tcpSent, udpSent;
  TrafficCounter icmpSent, ospfSent, igmpSent;
  TrafficCounter tcpRcvd, udpRcvd;
  TrafficCounter icmpRcvd, ospfRcvd, igmpRcvd;
} DomainStats;

/* **************************** */

typedef struct usersTraffic {
  char* userName;
  TrafficCounter bytesSent, bytesReceived;
} UsersTraffic;
 
/* **************************** */

typedef struct ipFragment {
  HostTraffic *src, *dest;
  u_int fragmentId;
  u_short sport, dport;
  time_t firstSeen;
} IpFragment;
 
/* **************************** */

/* Packet buffer */
struct pbuf {
  struct pcap_pkthdr h;
  u_char b[sizeof(unsigned int)];	/* actual size depend on snaplen */
};

/* **************************** */

#ifdef ETHER_HEADER_HAS_EA
#define ESRC(ep) ((ep)->ether_shost.ether_addr_octet)
#define EDST(ep) ((ep)->ether_dhost.ether_addr_octet)
#else
#define ESRC(ep) ((ep)->ether_shost)
#define EDST(ep) ((ep)->ether_dhost)
#endif

/* **************************** */

#define MULTICAST_MASK 0xE0000000 /* 224.X.Y.Z */

/* **************************** */

#define CRYPT_SALT "99" /* 2 char string */

/* **************************** */

#define LONG_FORMAT    1
#define SHORT_FORMAT   2

/* **************************** */

#define DELETE_FRAGMENT 1
#define KEEP_FRAGMENT   2

/* **************************** */

/* TCP Session State Transition */

#define STATE_BEGIN                  0
#define STATE_ACTIVE       STATE_BEGIN
#define STATE_FIN1_ACK0              1
#define STATE_FIN1_ACK1              2
#define STATE_FIN2_ACK0              3
#define STATE_FIN2_ACK1              4
#define STATE_FIN2_ACK2              5
#define STATE_TIMEOUT                6
#define STATE_END                    7

/* **************************** */

/* Timedout sessions are scanned each SESSION_SCAN_DELAY seconds */
#define SESSION_SCAN_DELAY        30     /* 30 secs   */

/* This is the 2MSL timeout as defined in the TCP standard (RFC 761) */
#define TWO_MSL_TIMEOUT          120     /* 2 minutes */
#define DOUBLE_TWO_MSL_TIMEOUT   (2*TWO_MSL_TIMEOUT)

#define IDLE_HOST_PURGE_TIMEOUT  3600    /*   1 hour  */

/* **************************** */

#define COLOR_1               "#CCCCFF"
#define COLOR_2               "#FFCCCC"
#define COLOR_3               "#EEEECC"
#define COLOR_4               "#FF0000"

#define BUF_SIZE              1024

#define DUMMY_IDX_VALUE       999

#define HOST_DUMMY_IDX_VALUE    99
#define HOST_DUMMY_IDX_STR      "99"

#define DOMAIN_DUMMY_IDX_VALUE  98
#define DOMAIN_DUMMY_IDX_STR    "98"

/* **************************** */

#ifndef WNOHANG
#define WNOHANG 1
#endif

/* **************************** */

/* The #ifdef below are nnede for some BSD systems
 * Courtesy of Kimmo Suominen <kim@tac.nyc.ny.us> 
 */  
#ifndef ETHERTYPE_DN
#define ETHERTYPE_DN           0x6003
#endif
#ifndef ETHERTYPE_ATALK
#define ETHERTYPE_ATALK        0x809b
#endif

/* **************************** */

#define STR_SORT_DATA_RECEIVED_PROTOS "sortDataReceivedProtos.html"
#define STR_SORT_DATA_RECEIVED_IP     "sortDataReceivedIP.html"
#define STR_SORT_DATA_RECEIVED_THPT   "sortDataReceivedThpt.html"
#define STR_SORT_DATA_SENT_PROTOS     "sortDataSentProtos.html"
#define STR_SORT_DATA_SENT_IP         "sortDataSentIP.html"
#define STR_SORT_DATA_SENT_THPT       "sortDataSentThpt.html"
#define STR_SORT_DATA_THPT_STATS      "thptStats.html"
#define STR_DOMAIN_STATS              "domainTrafficStats.html"
#define STR_MULTICAST_STATS           "multicastStats.html"
#define HOSTS_INFO_HTML               "hostsInfo.html"
#define STR_LSOF_DATA                 "lsofData.html"
#define PROCESS_INFO_HTML             "processInfo.html"
#define IP_R_2_L_HTML                 "IpR2L.html"
#define IP_L_2_R_HTML                 "IpL2R.html"
#define IP_L_2_L_HTML                 "IpL2L.html"
#define DOMAIN_INFO_HTML              "domainInfo"
#define CGI_HEADER                    "cgi/"
#define PLUGINS_HEADER                "plugins/"
#define STR_SHOW_PLUGINS              "showPlugins.html"

/* Courtesy of Daniel Savard <daniel.savard@gespro.com> */
#define RESET_STATS_HTML              "resetStats.html"

/* ******** Token Ring ************ */

#ifdef WIN32
typedef unsigned char u_int8_t;
typedef unsigned short u_int16_t;
#endif /* WIN32 */


struct tokenRing_header {
  u_int8_t  trn_ac;             /* access control field */
  u_int8_t  trn_fc;             /* field control field  */
  u_int8_t  trn_dhost[6];       /* destination host     */
  u_int8_t  trn_shost[6];       /* source host          */
  u_int16_t trn_rcf;            /* route control field  */
  u_int16_t trn_rseg[8];        /* routing registers    */
};

struct tokenRing_llc {
  u_int8_t  dsap;		/* destination SAP   */
  u_int8_t  ssap;		/* source SAP        */
  u_int8_t  llc;		/* LLC control field */
  u_int8_t  protid[3];		/* protocol id       */
  u_int16_t ethType;		/* ethertype field   */
};


#define TRMTU                      2000   /* 2000 bytes            */

#define TR_RII                     0x80
#define TR_RCF_DIR_BIT             0x80
#define TR_RCF_LEN_MASK            0x1f00
#define TR_RCF_BROADCAST           0x8000 /* all-routes broadcast   */
#define TR_RCF_LIMITED_BROADCAST   0xC000 /* single-route broadcast */
#define TR_RCF_FRAME2K             0x20
#define TR_RCF_BROADCAST_MASK      0xC000

/* ******** FDDI ************ */

#ifdef LBL_ALIGN
#define EXTRACT_16BITS(p) \
	((u_short)*((u_char *)(p) + 0) << 8 | \
	(u_short)*((u_char *)(p) + 1))
#define EXTRACT_32BITS(p) \
	((u_int32_t)*((u_char *)(p) + 0) << 24 | \
	(u_int32_t)*((u_char *)(p) + 1) << 16 | \
	(u_int32_t)*((u_char *)(p) + 2) << 8 | \
	(u_int32_t)*((u_char *)(p) + 3))
#else
#define EXTRACT_16BITS(p) \
	((u_short)ntohs(*(u_short *)(p)))
#define EXTRACT_32BITS(p) \
	((u_int32_t)ntohl(*(u_int32_t *)(p)))
#endif

#define EXTRACT_24BITS(p) \
	((u_int32_t)*((u_char *)(p) + 0) << 16 | \
	(u_int32_t)*((u_char *)(p) + 1) << 8 | \
	(u_int32_t)*((u_char *)(p) + 2))


typedef struct fddi_header {
  u_char  fc;	    /* frame control    */
  u_char  dhost[6]; /* destination host */
  u_char  shost[6]; /* source host      */
} FDDI_header;

#define FDDI_HDRLEN (sizeof(struct fddi_header))

/*
 * FDDI Frame Control bits
 */
#define	FDDIFC_C		0x80		/* Class bit */
#define	FDDIFC_L		0x40		/* Address length bit */
#define	FDDIFC_F		0x30		/* Frame format bits */
#define	FDDIFC_Z		0x0f		/* Control bits */

/*
 * FDDI Frame Control values. (48-bit addressing only).
 */
#define	FDDIFC_VOID		0x40		/* Void frame */
#define	FDDIFC_NRT		0x80		/* Nonrestricted token */
#define	FDDIFC_RT		0xc0		/* Restricted token */
#define	FDDIFC_SMT_INFO		0x41		/* SMT Info */
#define	FDDIFC_SMT_NSA		0x4F		/* SMT Next station adrs */
#define	FDDIFC_MAC_BEACON	0xc2		/* MAC Beacon frame */
#define	FDDIFC_MAC_CLAIM	0xc3		/* MAC Claim frame */
#define	FDDIFC_LLC_ASYNC	0x50		/* Async. LLC frame */
#define	FDDIFC_LLC_SYNC		0xd0		/* Sync. LLC frame */
#define	FDDIFC_IMP_ASYNC	0x60		/* Implementor Async. */
#define	FDDIFC_IMP_SYNC		0xe0		/* Implementor Synch. */
#define FDDIFC_SMT		0x40		/* SMT frame */
#define FDDIFC_MAC		0xc0		/* MAC frame */

#define	FDDIFC_CLFF		0xF0		/* Class/Length/Format bits */
#define	FDDIFC_ZZZZ		0x0F		/* Control bits */



/* ************ PPP ************* */

#define PPP_HDRLEN  4

/* ******************************** */
#ifndef DLT_RAW
#define DLT_RAW		12	/* raw IP */
#endif

#ifndef DLT_SLIP_BSDOS
#define DLT_SLIP_BSDOS	13	/* BSD/OS Serial Line IP */
#endif

#ifndef DLT_PPP_BSDOS
#define DLT_PPP_BSDOS	14	/* BSD/OS Point-to-point Protocol */
#endif


#endif /* NTOP_H */
