/*
  $Id: libomirr.h,v 1.8 1996/08/16 20:23:29 luik Exp $

  libomirr.h - utility function definitions.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef LIBOMIRR_H_INCLUDED
#define LIBOMIRR_H_INCLUDED

#ifdef	__cplusplus
extern "C" {
#endif

/* daemon.c */
extern int daemon(int nochdir, int noclose);

/* setproctitle.c */
extern void initsetproctitle(int argc, char **argv, char **envp);
#if !HAVE_SETPROCTITLE
#if STDC_HEADERS || !defined(NOVAPROTO)
extern void setproctitle(const char *fmt, ...);
#else
extern void setproctitle();
#endif
#endif /* !HAVE_SETPROCTITLE */

/* strerror.c */
extern char *strerror(int e);

/* xmalloc.c */
extern void *xmalloc(size_t n);
extern void *xrealloc(void *p, size_t n);
#define xfree(P)		if (!P) ; else free(P)

/* xstrdup.c */
extern char *xstrdup(const char *string);

/* xstrerror.c */
extern char *xstrerror(int e);

#ifdef	__cplusplus
}
#endif

#endif /* defined(LIBOMIRR_H_INCLUDED) */

