/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#include <sys/types.h>
#endif
#ifdef AIX
#include <sys/select.h>
#include <values.h>
#endif
#include <dirent.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#if defined unicos || defined SunOS
#include <fcntl.h>
#endif
#include <sys/time.h>
#include "main.h"

extern char *tabdir(char *);
extern short create_dir(char *, char *);
extern short save_dir(char *, char *);
extern short copy_file(char *, char *);
extern short save_tags(char *);
extern char **run_prog(char **, char *);
extern void mhelp(void);
extern long pftp_pager(char *, char *, char *);
extern void warranty(void);
extern long set_entry_in_files(char **, char *, long *);
extern void rm_entry_from_files(char **, char *, long *);
extern void printlistentry(char *, char *, char *);
extern long read_subdir(char **, char *);
extern void print_error_mesg(char *, char *);
extern void free_vec(char **);

extern long tlastentry;
extern long dlastentry;
extern char *tfiles[HUNAME]; /* holds the selected files */
extern char *dfiles[HUNAME]; /* holds the selected files */
extern char *pager[SONAME]; /* holds the pager program and its arguments */
extern char *headline;
extern char *lastline;
extern char *saving_str;
extern char *blankline;
extern char *curdir; /* holds the selected files */
extern short USE_PFTPPAGER;
extern char secondline[LONAME];


char browse_dir(char *pdir)
{
   char *cdir=NULL, **tmp=NULL, c='\0', *ctmp=NULL;
   char *direntries[HUNAME];
   long endnum=0, height=_WINROWS_-5;
   long num=0, cur=0, j=0, update=1;
   long firstline=0;
   struct stat buf;

   /*
    * Read directory entries.
    */
   if ((endnum = read_subdir(direntries, pdir)) < 0) return -1;
   endnum--;

   MEM_CHECK((cdir = (char *)calloc(LONAME, sizeof(char))));

   do {
      if (update > 0) {
         firstline = num;
         if (update == 1) {
            fprintf(stdout, "[H[J%s\n", headline);
            strcpy(cdir, pdir);
            *(cdir+(2*_WINCOLS_)-2) = '\0';
            fprintf(stdout, "%s:\n", cdir);
            if (strlen(cdir) < _WINCOLS_) fprintf(stdout, "\n");
         }
         else fprintf(stdout, "[H\n\n\n");
         for (j=0; j < height && *(direntries+num); j++, num++) {
            printlistentry(num==cur? "-->":"   ", pdir, *(direntries+num));
         }
         if (update == 1) fprintf(stdout, lastline);
         fprintf(stdout, "[%dH%4ld", _WINCOLS_, cur+1);
         update = 0;
      }

      while ((c = fgetc(stdin)) == '' || c == '[' || c == 'O');
      if (update < 0) {
         fprintf(stdout, "%s\b%4ld", lastline, cur+1);
         update = 0;
      }
      do {
         switch(c) {
            case 'j':
            case 'B':
               c = 0;
               if (cur < firstline + height - 1 && cur < endnum) {
                  fprintf(stdout, "[%ldH   ", cur+4-firstline);
                  cur++;
                  fprintf(stdout, "[%ldH-->[%dH%4ld", cur+4-firstline, _WINROWS_, cur+1);
                  break;
               }
               else if (cur >= endnum) {
                  cur = endnum;
                  break;
               }
               else if (cur < firstline + height - 1) break;
               else cur++;
            case ' ':
            case '6':
               if (c == '6') c = ' ';
               if (cur >= endnum + 1) break;
               if (num >= endnum) update = 2;
               if (num + height > endnum) num = endnum - height + 1;
               if (num < 0) num = 0;
               if (c == ' ') {
                  if (update == 2) cur = endnum;
                  else cur = num;
               }
               update = 2;
               break;
            case 'k':
            case 'A':
               if (cur <= 0) break;
               if (cur > firstline) {
                  fprintf(stdout, "[%ldH   ", cur+4-firstline);
                  cur--;
                  fprintf(stdout, "[%ldH-->[%dH%4ld", cur+4-firstline, _WINROWS_, cur+1);
                  break;
               }
               else if (cur > firstline) break;
            case 'b':
            case '5':
               if (c == '5') c = 'b';
               if (cur <= 0) break;
               num -= 2 * height;
               if (num < 0) num = 0;
               if (c == 'b') cur = num;
               else cur--;
               if (cur < 0) cur = 0;
               update = 2;
               break;
            case 'g':
            case '1':
               if (cur) update = 2;
               num = 0;
               cur = 0;
               break;
            case 'G':
            case '4':
               num = endnum - height + 1;
               cur = endnum;
               if (num < 0) num = 0;
               update = 2;
               break;
            case '':
               /*
                * Read directory entries.
                */
               if ((endnum = read_subdir(direntries, pdir)) < 0) {
                  if (cdir) free(cdir);
                  return -1;
               }
               endnum--;
               num -= height;
               if (num < 0) num = 0;
               update = 1;
               break;
            case 'l':
            case 'C':
            c = '0';
               sprintf(cdir, "%s/%s", pdir, *(direntries+cur));
               buf.st_mode = 0;
               if (stat(cdir, &buf) < 0) {
                  fprintf(stdout, "[%dH** %s: %s\n",
                  _WINROWS_, cdir, _PFTP_ERROR_ARRAY_);
               }
               if ((buf.st_mode & S_IFMT) == S_IFDIR) {
                  if ((c = browse_dir(cdir)) == 'q' || c == 'm') {
                     if (cdir) free(cdir);
                     free_vec(direntries);
                     return c;
                  }
                  else if ((int)c >= 0) {
                     num -= height;
                     if (num < 0) num = 0;
                     update = 1;
                  }
                  else update = -1;
               }
               else c = '\n';
               break;
            case 'm': 
               if (cdir) free(cdir);
               for (; endnum; endnum--) {
                  if (*(direntries+endnum)) free(*(direntries+endnum));
               }
               return 'm';
            case 'h':
            case 'D':
               if (cdir) free(cdir);
               for (; endnum; endnum--) {
                  if (*(direntries+endnum)) free(*(direntries+endnum));
               }
               c = 'h';
               break;
            case 't':
               sprintf(cdir, "%s/%s", pdir, *(direntries+cur));
               if ((j = set_entry_in_files(tfiles, cdir, &tlastentry)) >= 0) {
                  rm_entry_from_files(tfiles, *(tfiles+j), &tlastentry);
               }
               fprintf(stdout, "[%ldH", cur+4-firstline);
               printlistentry("-->", pdir, *(direntries+cur));
               fprintf(stdout, "[%dH", _WINROWS_);
               c = 'j';
               break;
            case 'd':
               sprintf(cdir, "%s/%s", pdir, *(direntries+cur));
               if ((j = set_entry_in_files(dfiles, cdir, &dlastentry)) >= 0) {
                  rm_entry_from_files(dfiles, *(dfiles+j), &dlastentry);
               }
               fprintf(stdout, "[%ldH", cur+4-firstline);
               printlistentry("-->", pdir, *(direntries+cur));
               fprintf(stdout, "[%dH", _WINROWS_);
               c = 'j';
               break;
            case 'q':
               fprintf(stdout, "[?25h\r[%dH%s", _WINROWS_, blankline);
               fprintf(stdout, "*** Really quit (Y|n)? ");
               c = fgetc(stdin);
               if (c == 'y' || c == 'Y' || c == '\n') {
                  if (cdir) free(cdir);
                  for (; endnum; endnum--) {
                     if (*(direntries+endnum)) free(*(direntries+endnum));
                  }
                  return 'q';
               }
               else {
                  num -= height;
                  if (num < 0) num = 0;
                  update = 1;
               }
               fprintf(stdout, "[?25l\r");
               break;
            case '\n':
               sprintf(cdir, "%s/%s", pdir, *(direntries+cur));
               if (USE_PFTPPAGER) {
                  sprintf(secondline, " File: `%s'", *(direntries+cur));
                  for (ctmp=secondline; *ctmp && ctmp - secondline < _WINCOLS_; ctmp++);
                  for (; ctmp - secondline < _WINCOLS_; ctmp++) *ctmp = ' ';
                  *ctmp = '\0';
               }
               buf.st_mode = 0;
               if (!stat(cdir, &buf) && ((buf.st_mode & S_IFMT) == S_IFREG)) {
                  if (USE_PFTPPAGER) {
                     if (!pftp_pager(cdir, secondline, blankline)) {
                        fgetc(stdin);
                     }
                  }
                  else {
                     fprintf(stderr, "[?25h\r[H[J");
                     run_prog(pager, cdir); 
                     fprintf(stderr, "[?25l\r");
                  }
                  num -= height;
                  if (num < 0) num = 0;
                  update = 1;
               }
               else if (!((buf.st_mode & S_IFMT) == S_IFREG) \
                     && !((buf.st_mode & S_IFMT) == S_IFDIR)) {
                     fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
                     fprintf(stderr, "** This is not a regular file or directory!");
                     update = -1;
               }
               else {
                  if ((buf.st_mode & S_IFMT) == S_IFDIR) {
                     c = 'l';
                     break;
                  }
                  else {
                     fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
                     fprintf(stderr, "** Can't open file `%s'.", cdir);
                     update = -1;
                  }
               }
               c = 0;
               break;
            case 's':
               j = 0; 
               for (tmp=tfiles; tmp-tfiles <= tlastentry; tmp++) {
                  buf.st_mode = 0;
                  if (*tmp && !stat(*tmp, &buf) && ((buf.st_mode & S_IFMT) == S_IFREG)) {
                     j = 1;
                     break;
                  }
               }
               sprintf(cdir, "%s/%s", pdir, *(direntries+cur));
               buf.st_mode = 0;
               stat(cdir, &buf);
               /*
                * Make cursor visible.
                */
               fprintf(stdout, "[?25h\r");
               fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
               if (j) {
                  fprintf(stdout, " Save a) taged files  b) current %s c) cancel: ",
                  ((buf.st_mode & S_IFMT) == S_IFDIR) ? "directory recursively": "file");
                  while ((c = fgetc(stdin)) != 'a' && c != 'b' && c != 'c');
               }
               if (c != 'c') {
                  char *dest=NULL;
                  if ((dest = tabdir(curdir))) {
                     if (c == 'b' || !j) {
                        /*
                         * Save current directory.
                         */
                        if ((buf.st_mode & S_IFMT) == S_IFDIR) {
                           char *ddir=NULL;
                           /*
                            * Set destination directory.
                            */
                           for (ddir=cdir; *ddir; ddir++);
                           for (ddir--; *ddir != '/' && ddir != cdir; ddir--);
                           buf.st_mode = 0;
                           if (!stat(dest, &buf)) {
                              if ((buf.st_mode & S_IFMT) == S_IFDIR) {
                                 if (create_dir(dest, ddir)) {
                                    strcat(dest, ddir);
                                    fprintf(stderr, "%s", saving_str);
                                    save_dir(cdir, dest);
                                 }
                              }
                              else {
                                 fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
                                 fprintf(stdout, "** `%s' is not a directory as needed.", dest);
                              }
                           }
                           else if (create_dir(dest, ddir)) {
                              strcat(dest, ddir);
                              fprintf(stderr, "%s", saving_str);
                              save_dir(cdir, dest);
                           }
                           c = 'd';
                        }
                        /*
                         * Save current file.
                         */
                        else {
                           if (create_dir(dest, NULL)) {
                              buf.st_mode = 0;
                              if (!stat(dest, &buf) && ((buf.st_mode & S_IFMT) == S_IFDIR)) {
                                 strcat(dest, "/");
                                 for (ctmp=cdir; *ctmp; ctmp++);
                                 for (ctmp--; *ctmp != '/' && ctmp != cdir; ctmp--);
                                 strcat(dest, ++ctmp);
                              }
                              fprintf(stderr, "%s", saving_str);
                              copy_file(cdir, dest);
                           }
                           c = 'j';
                        }
                     }
                     else if (create_dir(dest, "")) {
                        fprintf(stderr, "%s", saving_str);
                        save_tags(dest);
                     }
                  }
               }
               fprintf(stdout, "[?25l\r");
               (*statstr)->OVERWRITE = 0;
               (*statstr)->_SKIP_ = 0;
               num -= height;
               if (num < 0) num = 0;
               update = 1;
               break;
            case '?':
               mhelp();
               num -= height;
               if (num < 0) num = 0;
               update = 1;
               break;
            case 'w':
               warranty();
               num -= height;
               if (num < 0) num = 0;
               update = 1;
               break;
         }
      } while (c == 'j' || c == 'd' || c == '\n' || c == 'l');
   } while (c != 'h');
   return '\0';
}
