#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <net/if.h>
#include <netinet/in.h>

#include <config.h>
#include <support.h>

/*
#include "option.h"
#include "log.h"
*/
#include <log.h>
#include <env.h>
#include <dev/device.h>
#include <frame.h>

#define	_PATH_PROC_DEVICES	"/proc/devices"
#define	_PATH_PROC_NET_DEV	"/proc/net/dev"
#define	_PATH_PROC_OSRELEASE	"/proc/sys/kernel/osrelease"
#define	LEN_PROCLINE	256

#define	IFBUFSIZ	4096

static char ifBuf[IFBUFSIZ];
static int ifFd=-1;
int sockFd=-1;
unsigned int kernelVersion;

static struct {
    int hdrlen;
    char *hdrbody;
} ifHdr;

/*
#define DEBUG_IF
*/

#ifdef DEBUG_IF
static FILE *debugFp;

static void
dumpbuf(char *buf, int len)
{
    int i, j;

    for (i = 0; i < len;) {
	for (j = 0; j < 16 && i < len; j++, i++)
	    fprintf(debugFp, " %02x", (unsigned char)buf[i]);
	fprintf(debugFp, "\n");
    }
    fflush(debugFp);
}
#endif

static int
SearchMajor(FILE *fp, char *driver_name)
{
    char line[LEN_PROCLINE], name[IFNAMSIZ];
    int major = -1;

    fseek(fp, 0L, SEEK_SET);

    while (fgets(line, LEN_PROCLINE, fp)) {
	if (sscanf(line, "%d %s", &major, name) == 2)
	    if (strcmp(name, driver_name) == 0)
		break;
	major = -1;
    }
#ifdef DEBUG_IF
    fprintf(debugFp, "SearchMajor(%s):major=%d\n", driver_name, major);
    fflush(debugFp);
#endif
    return(major);
}

/* When driver is not loaded, call dummy ioctl
   to invoke kerneld daemon */
static void
DummyIoctl(char *if_name)
{
    struct sockaddr_in *sin;
    struct ifreq ifr;

#ifdef DEBUG_IF
    fprintf(debugFp, "DummyIoctl(%s)\n", if_name);
    fflush(debugFp);
#endif
    bzero(&ifr, sizeof(ifr));
    sin = (struct sockaddr_in *)&(ifr.ifr_addr);
    sin->sin_family = AF_INET;
    strcpy(ifr.ifr_name, if_name);
    ioctl(sockFd, SIOCGIFFLAGS, &ifr);
}

static u_int32_t
SearchUsedIf(FILE *fp, char *if_name)
{
    int n, namelen;
    char *p;
    char line[LEN_PROCLINE];
    u_int32_t bits;

    fseek(fp, 0L, SEEK_SET);

    namelen = strlen(if_name);
    bits = 0;
    n = 0;
    while(fgets(line, LEN_PROCLINE, fp)) {
	p = line;
	while (*p && *p == ' ') p ++;
	if (*p && !strncmp(p, if_name, namelen)) {
	    n = atoi(p + namelen);
	    if (n < sizeof(bits)) bits |= 1 << n;
	}
    }
#ifdef DEBUG_IF
    fprintf(debugFp, "SearchUsedIf(%s):bits=%d\n", if_name, bits);
    fflush(debugFp);
#endif
    return(bits);
}

static int
UserlinkOpen(int major, u_int32_t bits, char *ifname, int *ifnp)
{
    int n, fd = -1;
    char name[IFNAMSIZ];

    strcpy(name, "/tmp/ulXXXXXX"); /* special file name of char dev */
    if (mktemp(name) == NULL) return(-1);

    for (n = 0; n < sizeof(bits); n ++) {
	if (bits & (1 << n)) continue;
	if (mknod(name, (S_IFCHR|S_IREAD|S_IWRITE), major << 8 | n)) {
	    LogError("mknod");
	    return(-1);
	}
	errno = 0;
	fd = open(name, O_RDWR);
	unlink(name);
	if (fd >= 0)
	    break;
    }
    if  (fd >= 0) {
	sprintf(ifname, "ul%d", n);
	*ifnp = n;
	ifHdr.hdrlen = 0;
	ifHdr.hdrbody = NULL;
    }
    return(fd);
}

static int
EthertapOpen(int major, u_int32_t bits, char *ifname, int *ifnp)
{
    int n, fd;
    char tmpname[IFNAMSIZ], devname[IFNAMSIZ];
    struct stat st;

    strcpy(tmpname, "/tmp/tapXXXXXX");
    if (mktemp(tmpname) == NULL) return(-1);

    fd = -1;
    for (n = 0; n < sizeof(bits); n++) {
	if (!(bits & (1 << n))) continue;

	sprintf(devname, "/dev/tap%d", n);
	if (stat(devname, &st) == 0) {
	    fd = open(devname, O_RDWR);
	} else if (errno == ENOENT) {
	    dev_t dev = major << 8 | n + NETLINK_TAPBASE;
	    if(mknod(tmpname, S_IFCHR|S_IREAD|S_IWRITE, dev))
		LogError("mknod");
	    else {
		fd = open(tmpname, O_RDWR);
		unlink(tmpname);
	    }
	}
	if (fd >= 0)
	    break;
    }
    if (fd >= 0) {
	uid_t euid;
	struct ethhdr hdr;
	struct ifreq ifr;

	sprintf(ifname, "tap%d", n);
	*ifnp = n;

	memset(&ifr, 0, sizeof(ifr));
	strcpy(ifr.ifr_name, ifname);
	if (ioctl(sockFd, SIOCGIFHWADDR, &ifr) < 0) {
	    LogError("EthertapOpen SIOCGIFHWADDR");
	    memcpy(hdr.h_dest, "\xFE\xFD\x00\x00\x00\x00", ETH_ALEN);
	} else memcpy(hdr.h_dest, ifr.ifr_hwaddr.sa_data, ETH_ALEN);
	memcpy(hdr.h_source, hdr.h_dest, ETH_ALEN);
	hdr.h_proto = htons(ETH_P_IP);

	ifHdr.hdrlen = ETH_HLEN + 2;
	ifHdr.hdrbody = Malloc(ifHdr.hdrlen);
	memset(ifHdr.hdrbody, 0, ifHdr.hdrlen);
	memcpy(ifHdr.hdrbody + 2, &hdr, ETH_HLEN);

	/* writing to ethertap requires real uid == 0 */
	euid = geteuid();
	setuid(0);
	seteuid(euid);
    }
    return(fd);
}

int
SysIfOpen(char *ifname, int *ifnp)
{
    int major;
    u_int32_t bits=0;
    FILE *osrFp, *devsFp, *netdevFp;

#ifdef DEBUG_IF
    debugFp = fopen("/tmp/debug.if", "w");
#endif
    if ((osrFp = fopen(_PATH_PROC_OSRELEASE, "r")) != NULL) {
	int v0=0, v1=0, v2=0;

	fscanf(osrFp, "%d.%d.%d\n", &v0, &v1, &v2);
	fclose(osrFp);
	kernelVersion = (v0 << 16) + (v1 << 8) + v2;
    }
    sockFd = socket(AF_INET, SOCK_DGRAM, 0);

    if ((devsFp = fopen(_PATH_PROC_DEVICES, "r")) == NULL) return(-1);
    if ((netdevFp = fopen(_PATH_PROC_NET_DEV, "r")) == NULL) {
	fclose(devsFp);
	return(-1);
    }
    /* search userlink */
    major = SearchMajor(devsFp, "userlink");
    if (major < 0) {
	DummyIoctl("userlink");
	major = SearchMajor(devsFp, "userlink");
    }
    if (major >= 0) {
	bits = SearchUsedIf(netdevFp, "ul");
	ifFd = UserlinkOpen(major, bits, ifname, ifnp);
	if (ifFd >= 0)
	    goto End;
    }
    /* if userlink is not found, search ethertap */
    major = SearchMajor(devsFp, "netlink");
    if (major < 0) {
	DummyIoctl("ethertap");
	major = SearchMajor(devsFp, "netlink");
    }
    if (major >= 0) {
	bits = SearchUsedIf(netdevFp, "tap");
	if (!bits) {
	    DummyIoctl("ethertap");
	    bits = SearchUsedIf(netdevFp, "tap");
	}
	ifFd = EthertapOpen(major, bits, ifname, ifnp);
    }
 End:
    fclose(devsFp);
    fclose(netdevFp);
    return(ifFd);
}

void
SysIfClose()
{
    if (ifFd >= 0) close(ifFd);
    if (sockFd >= 0) close(sockFd);
    ifFd = sockFd = -1;

    if (ifHdr.hdrbody)
	free(ifHdr.hdrbody);

#ifdef DEBUG_IF
    fclose(debugFp);
#endif
}

int
SysIfWrite(u_char *buf, int len, long hbo_proto)
{
    int n;

    if (ifHdr.hdrlen > 0) {
	buf -= ifHdr.hdrlen;
	len += ifHdr.hdrlen;
	memcpy(buf, ifHdr.hdrbody, ifHdr.hdrlen);
    }
    n = write(ifFd, buf, len);
#ifdef DEBUG_IF
    fprintf(debugFp, "SysIfWrite:size=%d,return=%d\n", ifFd, len, n);
    dumpbuf(buf, n);
#endif
    return(n);
}

int
SysIfRead(int fd, char **bp, u_int16_t *proto)
{
    int n;

    if ((n = read(fd, ifBuf, IFBUFSIZ)) > 0) {
#ifdef DEBUG_IF
	fprintf(debugFp, "SysIfRead:size=%d\n", n);
	dumpbuf(ifBuf, n);
#endif
	if (ifHdr.hdrlen > 0) {
	    n -= ifHdr.hdrlen;
	    *bp = &ifBuf[ifHdr.hdrlen];
	} else {
	    *bp = ifBuf;
	}
    }
    *proto = NBO_PROTO_IP;
    return(n);
}
