#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <pwd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>

#include <config.h>
#include <support.h>
#include <account.h>

struct acclist_s {
    struct acclist_s *next;
    struct accrec_s rec;
} *accHead;

static void
PlastPrint(struct accrec_s *on, struct accrec_s *off, time_t dif)
{
    struct tm *tp;
    struct passwd *pw;
    char ct[40];

    pw = (on && on->name[0]) ? getpwuid(on->uid): NULL;
    printf("%-8.8s %-15.15s", (pw && pw->pw_name) ? pw->pw_name: "",
	   (on && on->name[0]) ? on->name: "TOTAL");
    if (on) {
	tp = localtime(&on->time.sec);
	strftime(ct, sizeof(ct), "%y/%m/%d %H:%M:%S", tp);
	printf("%s - ", ct);
    } else printf("%20s", "");
    if (off) {
	tp = localtime(&off->time.sec);
	strftime(ct, sizeof(ct), "%y/%m/%d %H:%M:%S", tp);
    } else {
	sprintf(ct, "%-*.*s", 17, 17,
		(on && on->name[0]) ?
		(dif == (time_t)-1) ? "dead":"still connected":"");
    }
    printf("%s", ct);
    if (dif == (time_t)-1) strcpy(ct, "--:--:--");
    else {
#if 0
	tp = gmtime(&dif);
	strftime(ct, sizeof(ct), "%H:%M:%S", tp);
#else
	int len;

	sprintf(ct, "%02lu:", (unsigned long)dif / 3600);
	len = strlen(ct);
	dif %= 3600;
	tp = gmtime(&dif);
	strftime(ct + len, sizeof(ct) - len, "%M:%S", tp);
#endif
    }
#if 0
    if (on && on->name[0]) printf(" (%s)\n", ct);
    else printf("  %s\n", ct);
#else
    if (on && on->name[0]) printf(" (%s)\n", ct);
    else printf("%10s\n", ct);
#endif
}

int
PlastMain(int argc, char *argv[])
{
    struct tm tb, *tp;
    struct accrec_s ar0, ar1;
    char *p, *name=NULL;
    time_t total, ssec, esec, now;
    int n, nmax=0;

    ssec = esec = 0;
    time(&now);
    tp = localtime(&now);
    memcpy(&tb, tp, sizeof(tb));
    for (n = 1; n < argc; n ++) {
	if (*argv[n] == '-') {
	    p = argv[n] + 1;
#ifdef	HAVE_STRPTIME
	    if ((nmax = atoi(p)) == 0) switch(*p) {
	    case 's':
		n ++;
		strptime(argv[n], "%y/%m/%d %H:%M:%S", &tb);
		ssec = mktime(&tb);
		break;
	    case 'e':
		n ++;
		memset(&tb, 0, sizeof(tb));
		strptime(argv[n], "%y/%m/%d %H:%M:%S", &tb);
		esec = mktime(&tb);
		break;
	    }
#endif
	} else {
	    name = argv[n];
	}
    }
    total = AccountLoad(name, ssec, esec, nmax, PlastPrint);
    memset(&ar0, 0, sizeof(ar0));
    memset(&ar1, 0, sizeof(ar1));
    ar0.time.sec = ssec;
    ar1.time.sec = esec;
    PlastPrint(ssec ? &ar0: NULL, esec ? &ar1: NULL, total);
}
