#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/xpm.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Panel.h"
#include "Parts.h"
#include "Indicator.h"
#include "xppxp.h"

XrmOptionDescRec options[] = {
{"-polling",          "*polling",    XrmoptionSepArg, NULL   },
{"-debug",            "*debug",      XrmoptionNoArg,  "True" },
{"-label",            "*labelName",  XrmoptionSepArg, NULL   },
{"-directory",        "*directory",  XrmoptionSepArg, NULL   },
};

static XtResource resources[] = {
  { XtNpolling, XtCPolling, XtRInt, sizeof(int),
            XtOffset(AppDataPtr, polling), XtRImmediate, (XtPointer) -1 },
  { XtNdebug, XtCDebug, XtRBoolean, sizeof(Boolean), 
            XtOffset(AppDataPtr, debug), XtRImmediate, (XtPointer) FALSE},
  { XtNlabelName, XtCLabelName, XtRString, sizeof(String),
            XtOffset(AppDataPtr, label), XtRString, NULL },
  { XtNdirectory, XtCDirectory, XtRString, sizeof(String),
            XtOffset(AppDataPtr, directory), XtRString, NULL },
};

XtAppContext appc;
Widget top, base, panel, indc, tdisp;
Widget led1, led2, led3, led4, led5;
Widget button1, button2, button3, button4, button5;
char sc_name[32];
AppData app_data;

XtActionsRec actions[] = {
{"autoButton",       (XtActionProc) AutoButton},
{"connectButton",    (XtActionProc) ConnectButton},
{"disconnectButton", (XtActionProc) DisconnectButton},
{"byeButton",        (XtActionProc) ByeButton},
{"quitButton",       (XtActionProc) QuitButton},
{"idling",           (XtActionProc) Idling},
{"terminal",         (XtActionProc) Terminal},
};

char autoTranslation[] = 
"<Btn1Down>:         autoButton() \n\
 <Btn1Up>:           autoButton()";

char connectTranslation[] = 
"<Btn1Down>:         connectButton() \n\
 <Btn1Up>:           connectButton()";

char disconnectTranslation[] = 
"<Btn1Down>:         disconnectButton() \n\
 <Btn1Up>:           disconnectButton()";

char byeTranslation[] = 
"<Btn1Down>:         byeButton() \n\
 <Btn1Up>:           byeButton()";

char quitTranslation[] = 
"<Btn1Down>:         quitButton() \n\
 <Btn1Up>:           quitButton()";

char idlingTranslation[] = 
"<Btn1Down>:         idling() \n\
 <Btn1Up>:           idling()";

char terminalTranslation[] = 
"<Btn1Down>:         terminal() \n\
 <Btn1Up>:           terminal()";

XtTranslations auto_trans;
XtTranslations connect_trans;
XtTranslations disconnect_trans;
XtTranslations bye_trans;
XtTranslations quit_trans;
XtTranslations idling_trans;
XtTranslations terminal_trans;

void
ppxpRetry(Widget w)
{
        /* do nothing */
}

int
main(int argc, char *argv[])
{
        XSizeHints hints;
        Dimension width, height;

        if (ppxpInit(&argc, argv)< 0) {
                exit(-1);
        }
        top = XtVaAppInitialize(&appc, NAME,
                                options, XtNumber(options),
                                &argc, argv, 
                                NULL, 
                                XtNinput, (XtArgVal)TRUE,
                                NULL);
        XtAppAddActions(appc, actions, XtNumber(actions));
        XtVaGetApplicationResources(top, &app_data,
                                    resources, XtNumber(resources),
                                    NULL);
        strncpy(sc_name, ppxpGetEnv("NAME"), sizeof(sc_name)-1);
        sc_name[sizeof(sc_name)-1]=0;
        app_data.polling = -1;
        if (app_data.debug) {
                fprintf(stderr, "%s version %s\n", NAME, VERSION);
                fprintf(stderr, "PPxP version %s\n", ppxpGetEnv("VERSION"));
                fprintf(stderr, "interface: %s\n", ppxpGetEnv("IF.DEV"));
                if (sc_name[0] != 0) {
                        fprintf(stderr, "NAME: %s\n", sc_name);
                }
        };

        icon_init();
        panel_init();

        auto_trans       = XtParseTranslationTable(autoTranslation);
        connect_trans    = XtParseTranslationTable(connectTranslation);
        disconnect_trans = XtParseTranslationTable(disconnectTranslation);
        bye_trans        = XtParseTranslationTable(byeTranslation);
        quit_trans       = XtParseTranslationTable(quitTranslation);
        idling_trans     = XtParseTranslationTable(idlingTranslation);
        terminal_trans   = XtParseTranslationTable(terminalTranslation);

        XtOverrideTranslations(button1, auto_trans);
        XtOverrideTranslations(button2, connect_trans);
        XtOverrideTranslations(button3, disconnect_trans);
        XtOverrideTranslations(button4, bye_trans);
        XtOverrideTranslations(button5, quit_trans);
        XtOverrideTranslations(led5, idling_trans);
        XtOverrideTranslations(base, terminal_trans);

        XtRealizeWidget(top);
        XtVaGetValues((Widget)base, XtNwidth,     &width,  NULL);
        XtVaGetValues((Widget)base, XtNheight,    &height, NULL);
        XtVaSetValues((Widget)top,  XtNminWidth,  width,   NULL);
        XtVaSetValues((Widget)top,  XtNmaxWidth,  width,   NULL);
        XtVaSetValues((Widget)top,  XtNminHeight, height,  NULL);
        XtVaSetValues((Widget)top,  XtNmaxHeight, height,  NULL);

        InputId = XtAppAddInput(appc, ppxpFd, (XtPointer)XtInputReadMask, 
                      (XtInputCallbackProc)ppxpCheck, NULL);
        signal_init();

        ppxpGetState();
        ppxpGetState();
        XtAppMainLoop(appc);

        FreeAll();
        exit(0);
}


void
FreeAll()
{
        ppxpFinish();
        icon_finish();
        XtUnrealizeWidget(top);
        XtDestroyWidget(top);
}

void
XpmError(int err)
{
        switch(err) {
        case XpmSuccess:
                break;
        case XpmColorError:
                fprintf(stderr, 
                        "%s: warning: can not alloc color for XPM\n", NAME);
                break;
        case XpmOpenFailed:
                fprintf(stderr, "%s: cant open XPM file\n", NAME);
                break;
        case XpmFileInvalid:
                fprintf(stderr, "%s: cant invalid XPM\n", NAME);
                break;                
        case XpmNoMemory:
                fprintf(stderr, "%s: not enough memory for XPM\n", NAME);
                break;                
        case XpmColorFailed:
                fprintf(stderr, "%s: can not alloc color for XPM\n", NAME);
                break;                
        }
        if (err <0) {
                FreeAll();
                exit(1);
        }
}
