.\" @(#)msgfmt.1 1.6 90/10/12 SMI; from Sun
.TH msgfmt 1 "25 July 1990"
.SH NAME
msgfmt \- create a message object from a message file
.SH SYNOPSIS
.B msgfmt
[
.B \-v
]
.I filename\c
.B \&.po
\&.\|.\|.
.IX "msgfmt" "" "\fLmsgfmt\fP \(em create message object file"
.IX "messages" "create message object file"
.SH DESCRIPTION
.LP
.B msgfmt
creates a
message object
.I filename
.B \&.mo
file from the portable message file
.I filename\c
.BR \&.po .
.LP
The 
.B .po 
file contains strings extracted from source code.
.B .po
files can be edited, and the
messages in them can changed to accomodate
any language supported by the system.
.LP
The
.B xgettext
command (see
.BR xgettext (1))
can be used to create the
.B default.po
file.
.LP
The
.B msgfmt
command does not modify the
portable object files.
.SS "Portable Object Files"
.IX "messages" "creating portable object files"
.IX "messages" "editing messages"
.IX "\&.po files" "portable object files"
.IX "\&.mo files" "message object files"
.LP
Each
.B .po
file contains one or more lines.
Each line
contains either a comment or a statement.
Comments start the line with a hash mark (#) and end with
the newline character and are ignored.
.LP
Each directive starts on a new line and is
separated from
.BI < value >
by white space (such as one or more space or tab characters).
.BI < value >
consists of one or more quoted strings separated by white space or <CR>.
The following are valid directives:
.IX "messages" "setting the domain"
.IX "messages" "setting the message identifier"
.IX "messages" "setting the message string"
.RS
.B domain
.I domainname
.br
.B msgid
.I message_identifier
.br
.B msgstr
.I message_string
.RE
.LP
The
.B domain
directive identifies all following directives until
another
.B domain
directive is encountered as applying to the domain
.I domainname.
The
.I domainname
is a string up to
.SM MAXDOMAIN
bytes long, and can contain any characters
allowed in legal filenames.
Until the first
.B domain
directive is encountered in the file, all target strings
belong to the default domain.
The default domain is called 
.BR default .
.LP
The
.B msgid
directive specifies the message identifier for the following
.B msgstr directive.
The
.I message_identifier
string identifies a target string at retrieval time.
Every statement containing a
.B msgid
directive must be followed by a statement containing a
.B msgstr
directive.
.LP
The
.B msgstr
directive specifies the target string associated with the
.I message_identifier
string declared in the immediately preceding
.B msgid
directive.
.SH OPTIONS
.TP 10
.B \-v
Verbose.  List duplicate message identifiers.
Message strings are not redefined.
.SH EXAMPLES
.LP
The following command creates a named
.B " .mo" 
file for each domain named in the portable message objects
.BR " filename1.po " and " filename2.po" . 
.LP
.RS
.nf
.B msgfmt filename1.po filename2.po
.RE
.fi
.LP
Running
.BR msgfmt (1)
on the following sample
.B .po
file creates two
.B .mo
files, named
.B first.mo
and
.B second.mo.
.RS
.nf
domain "first.mo"
msgid "aao"
msgstr "first sample message"
domain "second.mo"
msgid "bbo"
msgstr "second sample message"
.RE
.fi
.SH "SEE ALSO"
.BR xgettext (1) ,
.BR gettext (3) .
