/* this is the oss soundcard driver for gnometoaster */

/* compile this if oss support is enabled only */
#include "config.h"
#ifdef HAVE_OSS

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/soundcard.h>

#include "audio.h"
#include "piping.h"
#include "stdfiletrack.h"

#include "defaultentries.h"

/* FIXME: detect wether Little Endian or big Endian is supported by the
 * driver and react accordingly */
int audio_oss_open(gpointer data)
{
   audio_driver *driver=(audio_driver*)data;
   
   int speed=44100;
   int channels=2;
   int format=AFMT_S16_LE;
   
   int inp=-1;
   
   if (driver->descriptor==-1)
     {	
	driver->descriptor=open("/dev/dsp",O_WRONLY);
	if (driver->descriptor!=-1)
	  {	     
	     ioctl(driver->descriptor,SNDCTL_DSP_RESET);
	     ioctl(driver->descriptor,SNDCTL_DSP_SPEED,&speed);
	     ioctl(driver->descriptor,SNDCTL_DSP_SAMPLESIZE,&format);
	     ioctl(driver->descriptor,SNDCTL_DSP_CHANNELS,&channels);
   
/* <some constants from soundcard.h:>
 *			   IOCTLS:
 *			   SNDCTL_DSP_RESET
 *			   SNDCTL_DSP_SPEED 44100
 *			   SNDCTL_DSP_SAMPLESIZE 
 *			      AFMT_S16_LE
 *			      AFMT_S16_BE
 *			      AFMT_U16_LE
 *			      AFMT_U16_BE
 *			   SNDCTL_DSP_CHANNELS 2
 */

	     driver->data=(gpointer)piping_create_function(stdfiletrack_byteswap,
							   NULL,
							   &inp,
							   &driver->descriptor,
							   NULL);
	     driver->descriptor=inp;
	  };	
	return driver->descriptor;
     }
   else
     return -1;
   /* return -1 if sound device is in use */
};
			   
void audio_oss_close(gpointer data)
{
   int status;
   audio_driver *driver=(audio_driver*)data;

   if (driver->descriptor!=-1)
     {	
	close(driver->descriptor);
	driver->descriptor=-1;
	/* wait for byteswap to finish */
	if ((int)driver->data!=-1)
	  {
	     waitpid((int)driver->data,&status,0);
	  };	     
     };
};

void audio_oss_init()
{
   audio_driver_register(audio_driver_create(DEFAULTENTRIES_AUDIO_DEFAULT_OSS,
					     audio_oss_open,
					     audio_oss_close,
					     (gpointer)-1));
};
			 
#endif   
	  
			   
