/* this file contains definitions required for internationalization
 * the actual method is selected depending on wether gnome is installed */

#include "config.h"

#ifdef HAVE_GNOME
/* if gnome is installed,we don't have to do anything else here than just
 * including the gnome headers */
# include <gnome.h>
#else
# ifdef ENABLE_NLS
/* if gettext is enabled */
#  include <locale.h>
#  include <libintl.h>
#  define _(String) gettext (String)
#  ifdef gettext_noop
#   define N_(String) gettext_noop(String)
#  else
#   define N_(String) (String)
#  endif
# else
/* install dummy handlers if gettext is disabled */
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
# endif
#endif
