/* This is the "stream:xxx" to tracks_trackinfo convert function
 * This function has been completely rewritten sos the registration database
 * has become obsolete.
 * streams are now identified using the following convention:
 * stream:<32bit hex pidnumber>:<32bit hex mempos> which is unique 
 * throughout the system.
 * a viable extension could be the systems ip adress later on,thus letting
 * various instances of Gnometoaster exchange stream identifiers to record
 * tracks remotely. The currenty identifier should be apt to our needs though
 * at the moment */

#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "tracks.h"
#include "streams.h"
#include "main.h"


/* uncomment if you want debug messages */
/* #define DEBUG */

/* register a stream, returns a string stream identifier.
 * This identifier can be used to uniquely adress this particular
 * stream later on.
 * additionally, track gets claimed to simulate the behavior of the
 * old streams functions. */
char *streams_getstreamid(tracks_trackinfo *track)
{
	char *streamid;
	unsigned int  pid;
	
	streamid=(char*)malloc(22);
	/* <32bit hex pid>:<32bit hex mem> */
	/* strlen("0x00000000:0x00000000")=21+1[+\0]=22 */
	
	pid=getpid();
	sprintf(streamid,"%#x",pid);
	strcat(streamid,":");		
	sprintf(&streamid[strlen(streamid)],"%#x",(unsigned int)track);
#ifdef DEBUG
	printf ("calculated stream id: %s\n",streamid);
#endif
	
	/* register the track */
	tracks_claim(track);
	
#ifdef DEBUG
   printf ("streams_getstreamid: got streamid for stream %s\n",(char*)&track->name);
#endif	
	   
        return streamid;
}
;

/* get a stream by its id. returns NULL if stream is not present within this
 * instance of Gnometoaster */
tracks_trackinfo *streams_getstreambyid(char *streamid)
{
	char *localcopy;
	char *mempos;
	unsigned int pid;
	tracks_trackinfo *track;

	localcopy=(char*)malloc(strlen(streamid)+1);
	strcpy(localcopy,streamid);
	mempos=strchr(localcopy,":"[0]);
	*mempos=0;mempos++;	

	sscanf(localcopy,"%x",&pid);
#ifdef DEBUG
	printf("resolving streamid %s where pid=%s and mempos=%s\n",
	       streamid,
	       localcopy,
	       mempos);
	printf ("received stream from PID %x\n",pid);
	printf ("current instance of Gnometoaster has PID %x\n",getpid());
#endif	
	if (pid==getpid()) /* if local */
	  {
		  sscanf(mempos,"%x",(unsigned int*)&track);
	  }
	else
	  {
		  track=NULL;
	  }
	;
	free(localcopy);
#ifdef DEBUG
	printf ("streams_getstreambyid: got track address %p \n",track);
#endif
	return track;
}
;	
	

/* unclaim stream by its id. the only thing this function currently does
 * is call stream->unclaim() for the stream whose identifier is streamid */
void streams_unclaimbystreamid(char *streamid)
{
	tracks_trackinfo *track;
	
	track=streams_getstreambyid(streamid);
	if (track!=NULL)
	  {		  
		  #ifdef DEBUG 
		      printf ("unregistering track %s ...\n",(char*)&track->name);
		  #endif
		  tracks_unclaim(track);
	  }	
	else
	  {		  
		  printf ("Warning! attempts to unregister remote streams should never happen...\n");
		  printf ("Please contact A.Eckleder@bigfoot.com\n");
		  printf ("this error occurred while trying to unclaim trackid %s\n",streamid);
	  }
	;	
}
;

