#
#  $Id: Basic.py,v 1.5 1999/12/07 11:40:03 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#
"""Standard Doc format, with no extensions whatsoever.
"""

__version__ = '$Id: Basic.py,v 1.5 1999/12/07 11:40:03 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import sys, os
from formatter import NullWriter

import DTKOutput

    
class BasicDocWriter(NullWriter):
    def __init__(self, doc=sys.stdout):
	NullWriter.__init__(self)

	self.doc = doc
	self.list_depth = 0
	
    def close(self):
	self.flush()
	self.doc.close()
	self.doc = None

    def set_bookmark(self, s):
	"""Set a bookmark at the current output position.
	"""
	self.flush()
	self.doc.bookmark(s)

    def send_heading(self, text, level=1):
	self.send_literal_data(text)
	self.send_line_break()

    def set_title(self, title):
	self.doc.name = title

    # standard writer API
    def reset(self):
	self.list_depth = 0

    def send_paragraph(self, blankline=0):
	self.doc.write('\n'*blankline)

    def send_line_break(self):
	self.doc.write('\n')

    def send_hor_rule(self, *a, **kw):
	char = kw.get('char','*')[:1]
	if char == '-': count = 39
	else: count = 26
	brk = kw.get('break','none')
	if brk in ['before','both']: self.doc.write('\n')
	self.doc.write(char * count)
	if brk in ['after','both']: self.doc.write('\n')

    def send_literal_data(self, data):
	self.doc.write(data)

    def send_flowing_data(self, data):
	self.doc.write(data)

    def send_label_data(self, data):
	self.doc.write('  '*self.list_depth)
	self.doc.write(data)
	if data and data[-1] not in ' \n\r\t':
	    self.doc.write(' ')

    def new_alignment(self, align):
	pass

    def new_font(self, font):
	pass

    def new_margin(self, margin, level):
	if margin is None or level == 0:
	    self.list_depth = 0
	elif margin in ['ol', 'ul']:
	    self.list_depth = level - 1

    def new_spacing(self, spacing):
	pass

    def new_styles(self, styles):
	pass

    
class BasicDTKOutput(DTKOutput.DTKOutput):
    name = 'Basic'
    version = '1.1.0'
    author = 'Rob Tillotson <robt@debian.org>'
    url = ''
    description = 'The standard Doc format.'

    def open(self, store, base='', title='', creator='REAd', type='TEXt',
	     backup=1, category=0, version=1, writerclass=BasicDocWriter):

	p = self.context.get_plugin('Connector','Doc')
	w = p.create_stream(store, title and title or base, creator, type,
			    backup and 0x0008 or 0, version, category, 1,
			    filename=os.path.splitext(base)[0]+'.pdb')
	return writerclass(w)
