proc gStatus { coords } {
	set name [.groups get "$coords +1 chars" "$coords lineend -1 chars"]
	if { $name != ""} {
		global GR_${name}_Master
		eval "set master \$\{GR_${name}_Master\}"
		.status.lbl configure -text "Group: $name  Master: $master"
		}
	}


.groups tag configure item   -foreground blue
.groups tag configure curr   -relief sunken -borderwidth 1
.groups tag configure active -background white
.groups tag configure used   -foreground #303080

set tags ""
set g_line ""
set active ""

proc tk_menuSetFocus(.menu_group) {} {}
menu .menu_group -tearoff no
.menu_group add command -label "ReFresh" -command { new_group_request $active 1 }

.groups tag bind item <3> {
	catch { .menu_group unpost }
	tk_popup .menu_group %X %Y ""
	set coords [.groups index {@%x,%y linestart}]
	set active [.groups get "$coords +1 chars" "$coords lineend -1 chars"] 
	}

.groups tag bind item <ButtonRelease-1> {
	set coords [.groups index {@%x,%y linestart}]
	new_group_request [.groups get "$coords +1 chars" "$coords lineend -1 chars"] 0
	#.groups tag add used "$coords +1 chars" "$coords lineend -1 chars"
	}


.groups tag bind item <Enter> {
	set g_line [.groups index {@%x,%y linestart}]
	.groups tag add active "$g_line +1 chars " "$g_line lineend -1 chars"
	.groups configure -cursor hand2
	gStatus "[.groups index {@%x,%y linestart}]"
	}
.groups tag bind item <Leave> {
	set g_line [.groups index {@%x,%y linestart}]
	.groups tag remove active 1.0 end 
	.groups configure -cursor arrow
	.status.lbl configure -text ""
	}
.groups tag bind item <Motion> {
	set newLine [.groups index {@%x,%y linestart}]
	if {[string compare $newLine $g_line] != 0} {
		set g_line $newLine
		.groups tag remove active 1.0 end
		set tags [.groups tag names {@%x,%y}]
		if { $tags == "item" } { 
			.groups tag add active "$g_line +1 chars" "$g_line lineend -1 chars"
			gStatus "[.groups index {@%x,%y linestart}]"
			} else {
			.status.lbl configure -text ""
			}
		}
	}






proc hStatus { coords } {
	set name [.hosts get "$coords +1 chars" "$coords lineend -1 chars"]
	if { $name != ""} {
		global H_${name}_Descr
		eval "set master \$\{H_${name}_Descr\}"
		.status.lbl configure -text " Descr: $master"
		}
	}



.hosts tag configure curr   -relief sunken -borderwidth 1
#-foreground red
#.hosts tag configure item   -foreground blue
.hosts tag configure active -background white
.hosts tag configure used   -foreground #303080

proc tk_menuSetFocus(.menu_host) {} {}
menu .menu_host -tearoff no
.menu_host add command -label "Ping This Host" -command { host_ping_request $active }
.menu_host add command -label "Put on Term" -command { puts '$active' }
.menu_host add command -label "Update" -command { new_host_request $active 1}
.menu_host add command -label "Mount All" -command {
	new_host_request $active 0
	mount_all_request $active
	}



.hosts tag bind item <3> {
	catch { .menu_host unpost }
	tk_popup .menu_host %X %Y ""
	set coords [.hosts index {@%x,%y linestart}]
	set active [.hosts get "$coords +1 chars" "$coords lineend -1 chars"] 
	}
.hosts tag bind item <ButtonRelease-1> {
	set coords [.hosts index {@%x,%y linestart}]
	set host [.hosts get "$coords +1 chars" "$coords lineend -1 chars"] 
	new_host_request $host 0
	}

.hosts tag bind item <Enter> {
	set g_line [.hosts index {@%x,%y linestart}]
	.hosts tag add active "$g_line +1 chars " "$g_line lineend -1 chars"
	.hosts configure -cursor hand2
	hStatus "[.hosts index {@%x,%y linestart}]"
	}
.hosts tag bind item <Leave> {
	set g_line [.hosts index {@%x,%y linestart}]
	.hosts tag remove active 1.0 end 
	.hosts configure -cursor arrow
	.status.lbl configure -text ""
	}
.hosts tag bind item <Motion> {
	set newLine [.hosts index {@%x,%y linestart}]
	if {[string compare $newLine $g_line] != 0} {
		set g_line $newLine
		.hosts tag remove active 1.0 end
		set tags [.hosts tag names {@%x,%y}]
		if { $tags == "item" } { 
			.hosts tag add active "$g_line +1 chars" "$g_line lineend -1 chars"
			hStatus "[.hosts index {@%x,%y linestart}]"
			} else {
			.status.lbl configure -text ""
			}
		}
	}




proc sStatus { coords } {
	global C_HOST
	set name [.shares get "$coords +1 chars" "$coords lineend -1 chars"]
	global SH_${C_HOST}_${name}_Descr
	if { $name != ""} {
		.status.lbl configure -text " Share: [set SH_${C_HOST}_${name}_Descr]"
		}
	}



.shares tag configure curr   -relief sunken -borderwidth 1
.shares tag configure item   -foreground blue
.shares tag configure active -background white
.shares tag configure used   -foreground #303080

proc tk_menuSetFocus(.menu_share) {} {}
menu .menu_share -tearoff no
.menu_share add command -label "Mount" -command { 
	global C_HOST
	mount $C_HOST $active
	}



.shares tag bind item <3> {
	catch { .menu_share unpost }
	tk_popup .menu_share %X %Y ""
	set coords [.shares index {@%x,%y linestart}]
	set active [.shares get "$coords +1 chars" "$coords lineend -1 chars"] 
	}
.shares tag bind item <ButtonRelease-1> {
	set coords [.shares index {@%x,%y linestart}]
	set share [.shares get "$coords +1 chars" "$coords lineend -1 chars"] 
	global C_HOST
	open_share $C_HOST $share
	}

.shares tag bind item <Enter> {
	set g_line [.shares index {@%x,%y linestart}]
	.shares tag add active "$g_line +1 chars " "$g_line lineend -1 chars"
	.shares configure -cursor hand2
	sStatus "[.shares index {@%x,%y linestart}]"
	}
.shares tag bind item <Leave> {
	set g_line [.shares index {@%x,%y linestart}]
	.shares tag remove active 1.0 end 
	.shares configure -cursor arrow
	.status.lbl configure -text ""
	}
.shares tag bind item <Motion> {
	set newLine [.shares index {@%x,%y linestart}]
	if {[string compare $newLine $g_line] != 0} {
		set g_line $newLine
		.shares tag remove active 1.0 end
		set tags [.shares tag names {@%x,%y}]
		if { $tags == "item" } { 
			.shares tag add active "$g_line +1 chars" "$g_line lineend -1 chars"
			sStatus "[.shares index {@%x,%y linestart}]"
			} else {
			.status.lbl configure -text ""
			}
		}
	}



.remote tag configure active -background white
.remote tag configure curr   -relief sunken -borderwidth 1
.remote tag configure dir    -foreground blue
.remote tag configure used   -foreground black

proc tk_menuSetFocus(.menu_remote) {} {}
menu .menu_remote -tearoff no
.menu_remote add command -label "Save" -command { 
#    puts "Downloading $active........"	
#	exp_send "recurs\rprompt\rlcd $DOWNLOAD\rmget \"$active\"\rrecurs\rprompt\r"
	download_file $DOWNLOAD/tksmb_bug $active 1
	}
.menu_remote add command -label "Save to .." -command { 
        set save [ tk_getSaveFile -initialfile "<Choose Save Directory>" -initialdir $DOWNLOAD ]
	if { $save != "" } { download_file $save $active 1 }
	}
	
proc tk_menuSetFocus(.menu_file) {} {}

menu .menu_file -tearoff no
.menu_file add command -label "Download to.." -command {
        set save [ tk_getSaveFile -initialfile $active -initialdir $DOWNLOAD ]
	if { $save != "" } { download_file $save $active 0 }
        }

.remote tag bind dir <ButtonRelease-1> {
	set coords [.remote index {@%x,%y linestart}]
	set dirr [.remote get "$coords +1 chars" "$coords lineend -1 chars"]
	cd_share  \"$dirr\"
	}
.remote tag bind file <ButtonRelease-1> {
	set coords [.remote index {@%x,%y linestart}]
	set afile [.remote get "$coords +1 chars" "$coords lineend -1 chars"] 
#        puts "Downloading $afile........"	
	download_file $DOWNLOAD/$afile $afile 0
	}
.remote tag bind dir <3> {
	catch { .menu_remote unpost }
	tk_popup .menu_remote %X %Y ""
	set coords [.remote index {@%x,%y linestart}]
	set active [.remote get "$coords +1 chars" "$coords lineend -1 chars"] 
	}
.remote tag bind file <3> {
	catch { .menu_file unpost }
	tk_popup .menu_file %X %Y ""
	set coords [.remote index {@%x,%y linestart}]
	set active [.remote get "$coords +1 chars" "$coords lineend -1 chars"] 
	}


proc rStatus { coords } {
	set name [.remote get "$coords +1 chars" "$coords lineend -1 chars"]
	if { $name != ""} {
	   	if { $name != ".."} {
			.status.lbl configure -text "Enter '$name' directory?"
			} {
			.status.lbl configure -text "Go up one level?"
			}
		}
	}

.remote tag bind dir <Enter> {
	.remote tag remove active 1.0 end 
	set g_line [.remote index {@%x,%y linestart}]
	rStatus "[.remote index {@%x,%y linestart}]"
	.remote tag add active "$g_line +1 chars " "$g_line lineend -1 chars"
	.remote configure -cursor hand2
	}
.remote tag bind file <Enter> {
	.remote tag remove active 1.0 end 
	set g_line [.remote index {@%x,%y linestart}]
	fStatus "[.remote index {@%x,%y linestart}]"
	.remote tag add active "$g_line +1 chars " "$g_line lineend -1 chars"
	.remote configure -cursor hand2
	}
.remote tag bind dir <Leave> {
	.remote tag remove active 1.0 end 
	set g_line [.remote index {@%x,%y linestart}]
	.remote configure -cursor arrow
	.status.lbl configure -text ""
	}
.remote tag bind file <Leave> {
	.remote tag remove active 1.0 end 
	set g_line [.remote index {@%x,%y linestart}]
	.remote configure -cursor arrow
	.status.lbl configure -text ""
	}
.remote tag bind dir <Motion> {
	set newLine [.remote index {@%x,%y linestart}]
	if {[string compare $newLine $g_line] != 0} {
		.remote tag remove active 1.0 end 
		set g_line $newLine
		set tags [.remote tag names {@%x,%y}]
		if { $tags == "dir" } { 
			.remote tag add active "$g_line +1 chars" "$g_line lineend -1 chars"
			rStatus "[.remote index {@%x,%y linestart}]"
			} else {
			.status.lbl configure -text ""
			}
		}
	}
.remote tag bind file <Motion> {
	set newLine [.remote index {@%x,%y linestart}]
	if {[string compare $newLine $g_line] != 0} {
		.remote tag remove active 1.0 end 
		set g_line $newLine
		set tags [.remote tag names {@%x,%y}]
		if { $tags == "file" } { 
			.remote tag add active "$g_line +1 chars" "$g_line lineend -1 chars"
			fStatus "[.remote index {@%x,%y linestart}]"
			} else {
			.status.lbl configure -text ""
			}
		}
	}

proc fStatus { coords } {
	set name [.remote get "$coords +1 chars" "$coords lineend -1 chars"]
	if { $name != ""} {
		.status.lbl configure -text "Download '$name' file?"
		}
	}
