/* interface.c
 * Contains detection routines for the kernel and direct interfaces to the
 * card.
 */

/* (c) 1998 by Keith Wesolowski (wesolows@cs.unr.edu) 

 * Portions of the direct i/o routines are (c)1996 Thomas Lehmann,
 * Gideon LaGrange, and/or Franz Brinkman. 

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <fcntl.h>
#include <unistd.h>
#include "gradio.h"

extern radio_status gr_stat;

void gradio_get_interface (void)
{

    /* First determine whether we can use the kernel interface */
    int fd;
    if ((fd = open (gr_stat.dev_name, O_RDONLY)) > 0)
	gr_stat.fd = fd;
    else {
	fprintf (stderr, "No interface found!\n");
	exit (1);
    }
}
