#include "m_pd.h"

/* ------------------------ leftshift~ ----------------------------- */

static t_class *leftshift_class;

typedef struct _leftshift
{
    t_object x_obj;
} t_leftshift;

static t_int *leftshift_perform(t_int *w)
{
    t_float *in = (t_float *)(w[1]);
    t_float *out= (t_float *)(w[2]);
    int n = (int)(w[3]);

    while (--n) *out++ = *in++;
    *out = 0;
    return (w+4);
}

static void leftshift_dsp(t_leftshift *x, t_signal **sp)
{
    int n = sp[0]->s_n;
    dsp_add(leftshift_perform, 3,
    	sp[0]->s_vec + 1, sp[1]->s_vec, n);
}

static void *leftshift_new(void)
{
    t_leftshift *x = (t_leftshift *)pd_new(leftshift_class);
    outlet_new(&x->x_obj, gensym("signal"));
    return (x);
}

void leftshift_setup(void)
{
    leftshift_class = class_new(gensym("leftshift"),
    	(t_newmethod)leftshift_new, 0, sizeof(t_leftshift), 0, 0);
    class_addmethod(leftshift_class, nullfn, gensym("signal"), 0);
    class_addmethod(leftshift_class, (t_method)leftshift_dsp, gensym("dsp"), 0);
}
