/* ************************************************************************* */
/* Platform dependent routines with define switches for differrent platforms */
/* (c) iem 1998, Winfried Ritsch                                             */
/* ************************************************************************* */
#define debug 0
/* A) Systembibliotheken und C-Header */

#include <stdio.h>          /* general I/O */
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include "s_linux_mididefs.h"
#include "s_linux_midi_io.h"

/* linux, try first midi then midiX, then midi0X, which*/
char *devicename[] = {
  "/dev/midi",
  "/dev/midi00","/dev/midi01","/dev/midi02","/dev/midi03","/dev/midi04",
  "/dev/midi0","/dev/midi1","/dev/midi2","/dev/midi3","/dev/midi4",
  NULL
};

#define OPENPARAMS (O_RDWR | O_NDELAY)


fd_set midi_rfds;
struct timeval null_tv;


/* ----------------- Funktionen ---------------- */
static MIDIPort *mproot;

int midi_open(void)
{
  char **devname = devicename;
  int devhandle = -1;
  int last_devhandle = -1;
  int pn = 0;
  MIDIPort *next,*last;
  
  last = mproot = NULL;
  /* inits */
  null_tv.tv_sec = 0; /* no wait */
  null_tv.tv_usec = 0;

  
  /*    Open the Comdevhandle for RD and WR and get a handle   */
  while(*devname != NULL){ /* search for midiports */

	 /* try open one port after the other and if not fail take it */ 
	 while(*devname != NULL && (devhandle = open(*devname, OPENPARAMS)) < 0){
 		/*		fprintf(stderr,"tried %s : but got %d\n",*devname,devhandle);*/
		devname++;
	 }
	 if(*devname == NULL)	
		return last_devhandle;
	 else 
		if(debug)fprintf(stderr,"opened device %s\n",*devname);

	 if( (next = (MIDIPort *) malloc(sizeof(MIDIPort))) == NULL){
		fprintf(stderr,
				  "\n\r** ERROR ** could not alloc memory for MIDI port %d\n\r",
				  pn);
		close(devhandle);
		return(pn);
	 };	 


	 next->devhandle = devhandle;
	 next->devname = *devname;
	 next->port_no = pn++;
	 next->next = NULL;
	 last_devhandle = devhandle;
 
	 if(mproot == NULL)
		mproot = next;
	 else
		last->next = next;

	 last = next;
	 devname++;
  };

  return devhandle; /* never should arrive here, but for safety... */
}


static MIDIPort *aktport = NULL;

MIDIPort *midi_getfirstport(void)
{
  return (aktport=mproot);
}

MIDIPort *midi_getnextport(void)
{
  if(aktport != NULL)
	 return (aktport=aktport->next);
  else
	 return NULL;
}

MIDIPort *midi_getport(int pnr)
{
  int i = 0;
  aktport = mproot;

  while(aktport != NULL){
	 if(i++==pnr)
		return aktport;
	 aktport=aktport->next;
  }
  return NULL;
}

void midi_close(void)
{
  MIDIPort * next = mproot;

  if (!next) return;
  while(next->next != NULL){
	 if(next->devhandle > 0)
		close(next->devhandle);    /* close the handle */
	 next = next->next;
  }
  return;
}
 

/* MIDI stat */
int midi_instat(MIDIPort *mp)
{
  /* no wait */
  /*  
		null_tv.tv_sec = 0;
		null_tv.tv_usec = 0;
  */

  FD_ZERO(&midi_rfds);
  FD_SET(mproot->devhandle,&midi_rfds);

  return select(mproot->devhandle+1,&midi_rfds,NULL,NULL,&null_tv);
}

byte midi_in(MIDIPort *mp)
{
  byte chr;

  read(mp->devhandle,(char *) &chr,1);

  return chr;
}


int midi_flush(MIDIPort *mp)
{
  while(midi_instat(mp) > 0)
	 midi_in(mp);

  return TRUE;
}

int midi_out(MIDIPort *mp,unsigned char b)
{
  if ((write(mp->devhandle,(char *) &b,1)) == 1)
    {

		return 1;
	 };
  return 0;
}


/* Keyboard stat */
fd_set key_rfds;

int key_instat(void)
{
  null_tv.tv_sec = 0; /* no wait */
  null_tv.tv_usec = 0;

  FD_ZERO(&key_rfds);
  FD_SET(STDIN_FILENO,&key_rfds);

  return select(1,&key_rfds,NULL,NULL,&null_tv);
}

byte key_in(void)
{
  byte chr;

  read(STDIN_FILENO,(char *) &chr,1);
  return chr;
}

