#ifndef MUS_H
#define MUS_H

#define MUS_VERSION 1
#define MUS_REVISION 4
#define MUS_DATE "5-Nov-99"

/* 
 * 1. rev 1: (25-Sep-99): added width arg to make_src -- forgot this somehow in first pass.
 *                        decided to make mus_inspect return char* like mus_describe.
 *    rev 2: (29-Sep-99): implemented mus-increment and mus-frequency for granulate (as in mus.lisp).
 *                        clm's fft renamed mus-fft to avoid collision with snd's version.
 *                        added max_size arg to make_granulate (to reflect mus.lisp).
 *    rev 3: (4-Oct-99):  (scm) make-env arg order changed to reflect mus.lisp.
 *    rev 4: (5-Nov-99):  mus_sin exported.
 */

/* compile time switches:
 *
 * WITH_SINE_TABLE (default 1)
 *   if 1, use table lookup for sine, else math library's sin
 *
 * HAVE_SNDLIB (default 0)
 *   if 1, sndlib.h is included, and various of its function are used
 *
 * WITH_MUS_MODULE (default 0)
 *   defined if we're being loaded into Snd
 */

/* taken from libtool's demo/foo.h to try to protect us from C++ and ancient C's */
#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

#undef __P
#if defined (__STDC__) || defined (_AIX) || (defined (__mips) && defined (_SYSTYPE_SVR4)) || defined(WIN32) || defined(__cplusplus)
# define __P(protos) protos
#else
# define __P(protos) ()
#endif

#ifndef TRUE
  #define TRUE 1
#endif
#ifndef FALSE
  #define FALSE 0
#endif

#if HAVE_SNDLIB
  #include "sndlib.h"
#else
  #ifdef MACOS
    #define CALLOC(a,b)  NewPtrClear((a) * (b))
    #define MALLOC(a)    NewPtr((a))
    #define FREE(a)      DisposePtr((Ptr)(a))
  #else
    #define CALLOC(a,b)  calloc(a,b)
    #define MALLOC(a,b)  malloc(a,b)
    #define FREE(a)      free(a)
    #define REALLOC(a,b) realloc(a,b)
  #endif 
#endif

typedef struct {
  int type;
  char *name;
  int   (*release)(void *ptr);
  char  *(*describe)(void *ptr);
  char  *(*inspect)(void *ptr);
  int   (*equalp)(void *gen1,void *gen2);
  float *(*data)(void *ptr);
  float *(*set_data)(void *ptr, float *new_data);
  int   (*length)(void *ptr);
  int   (*set_length)(void *ptr, int new_length);
  float (*frequency)(void *ptr);
  float (*set_frequency)(void *ptr, float new_freq);
  float (*phase)(void *ptr); 
  float (*set_phase)(void *ptr, float new_phase);
  float (*scaler)(void *ptr);
  float (*set_scaler)(void *ptr, float val);
} mus_any_class;

typedef struct {
  mus_any_class *core;
} mus_any;

typedef struct {
  mus_any_class *core;
  int chans;
  float *vals;
} mus_frame;

typedef struct {
  mus_any_class *core;
  int chans;
  float **vals;
} mus_mixer;

typedef struct {
  int type;
  float (*sample)(void *ptr, int samp, int chan);
  int (*location)(void *ptr);
  int (*set_location)(void *ptr, int loc);
  int (*channel)(void *ptr);
  int (*begin)(void *ptr);
  int (*end)(void *ptr);
} mus_input_class;

typedef struct {
  mus_any_class *core;
  mus_input_class *base;
} mus_input;

typedef struct {
  int type;
  float (*sample)(void *ptr, int samp, int chan, float data);
  int (*begin)(void *ptr);
  int (*end)(void *ptr);
} mus_output_class;

typedef struct {
  mus_any_class *core;
  mus_output_class *base;
} mus_output;

#if (!HAVE_SNDLIB)
enum {MUS_NO_ERROR,MUS_NO_FREQUENCY,MUS_NO_PHASE,MUS_NO_GEN,MUS_NO_LENGTH,
      MUS_NO_FREE,MUS_NO_DESCRIBE,MUS_NO_EQUALP,MUS_NO_DATA,MUS_NO_SCALER,
      MUS_MEMORY_ALLOCATION_FAILED,MUS_UNSTABLE_TWO_POLE_ERROR,
      MUS_INVALID_CHANNEL_FOR_FRAME,MUS_CANT_OPEN_FILE,MUS_NO_SAMPLE_INPUT,
      MUS_NO_SAMPLE_OUTPUT,MUS_NO_FRAME_INPUT,MUS_NO_FRAME_OUTPUT,
      MUS_NO_SUCH_CHANNEL,MUS_NO_FILE_NAME_PROVIDED,MUS_NO_LOCATION,MUS_NO_CHANNEL,
      MUS_NO_SUCH_FFT_WINDOW,
      MUS_INITIAL_ERROR_TAG};
#endif

enum {MUS_OSCIL,MUS_SUM_OF_COSINES,MUS_DELAY,MUS_COMB,MUS_NOTCH,MUS_ALL_PASS,
      MUS_TABLE_LOOKUP,MUS_SQUARE_WAVE,MUS_SAWTOOTH_WAVE,MUS_TRIANGLE_WAVE,MUS_PULSE_TRAIN,
      MUS_RAND,MUS_RAND_INTERP,MUS_ASYMMETRIC_FM,MUS_ONE_ZERO,MUS_ONE_POLE,MUS_TWO_ZERO,MUS_TWO_POLE,MUS_FORMANT,
      MUS_WAVESHAPE,MUS_SRC,MUS_GRANULATE,MUS_SINE_SUMMATION,MUS_WAVE_TRAIN,MUS_BUFFER,
      MUS_FILTER,MUS_FIR_FILTER,MUS_IIR_FILTER,MUS_CONVOLVE,MUS_ENV,MUS_LOCSIG,
      MUS_FRAME,MUS_READIN,MUS_OUTPUT,MUS_INPUT,MUS_FILE2SAMPLE,MUS_FILE2FRAME,
      MUS_SAMPLE2FILE,MUS_FRAME2FILE,MUS_MIXER,
      MUS_INITIAL_GEN_TAG};

enum {MUS_RECTANGULAR_WINDOW,MUS_HANNING_WINDOW,MUS_WELCH_WINDOW,MUS_PARZEN_WINDOW,MUS_BARTLETT_WINDOW,
      MUS_HAMMING_WINDOW,MUS_BLACKMAN2_WINDOW,MUS_BLACKMAN3_WINDOW,MUS_BLACKMAN4_WINDOW,
      MUS_EXPONENTIAL_WINDOW,MUS_RIEMANN_WINDOW,MUS_KAISER_WINDOW,MUS_CAUCHY_WINDOW,MUS_POISSON_WINDOW,
      MUS_GAUSSIAN_WINDOW,MUS_TUKEY_WINDOW};


__BEGIN_DECLS

void init_mus_module __P((void));

#if (!HAVE_SNDLIB)
#ifdef __GNUC__
void mus_error(int error, char *format, ...) __attribute__ ((format (printf, 2, 3)));
#else
void mus_error __P((int error, char *format, ...));
#endif
void mus_set_error_handler(void (*new_error_handler)(int err_type, char *err_msg));
int mus_make_error_tag __P((void));
#endif

int mus_make_class_tag __P((void));
float mus_radians2hz __P((float rads));
float mus_hz2radians __P((float hz));
float mus_degrees2radians __P((float degree));
float mus_radians2degrees __P((float rads));
float mus_db2linear __P((float x));
float mus_linear2db __P((float x));
float mus_srate __P((void));
float mus_set_srate __P((float val));
int mus_array_print_length __P((void));
int mus_set_array_print_length __P((int val));
float mus_sin __P((float phase));

float mus_ring_modulate __P((float s1,float s2));
float mus_amplitude_modulate __P((float s1,float s2, float s3));
float mus_contrast_enhancement __P((float sig, float index));
float mus_dot_product __P((float *data1, float *data2, int size));
void mus_clear_array __P((float *arr, int size));
float mus_polynomial __P((float *coeffs, float x, int ncoeffs));
void mus_multiply_arrays __P((float *data, float *window, int len));
void mus_rectangular2polar __P((float *rl, float *im, int size));
float mus_array_interp __P((float *wave, float phase, int size));

int mus_free __P((mus_any *ptr));
char *mus_describe __P((mus_any *gen));
char *mus_inspect __P((mus_any *gen));
int mus_equalp __P((mus_any *g1, mus_any *g2));
float mus_phase __P((mus_any *gen));
float mus_set_phase __P((mus_any *gen, float val));
float mus_set_frequency __P((mus_any *gen, float val));
float mus_frequency __P((mus_any *gen));
int mus_length __P((mus_any *gen));
int mus_set_length __P((mus_any *gen, int len));
float *mus_data __P((mus_any *gen));
float *mus_set_data __P((mus_any *gen, float *data));
char *mus_name __P((mus_any *ptr));
int mus_type __P((mus_any *ptr));
float mus_scaler __P((mus_any *gen));
float mus_set_scaler __P((mus_any *gen, float val));

float mus_oscil __P((mus_any *o, float fm, float pm));
int mus_oscil_p __P((mus_any *ptr));
mus_any *mus_make_oscil __P((float freq, float phase));

float mus_sum_of_cosines __P((mus_any *gen, float fm));
int mus_sum_of_cosines_p __P((mus_any *ptr));
mus_any *mus_make_sum_of_cosines __P((int cosines, float freq, float phase));
int mus_cosines __P((mus_any *ptr));

float mus_delay __P((mus_any *gen, float input, float pm));
float mus_tap __P((mus_any *gen, float loc));
mus_any *mus_make_delay __P((int size, float *line, int line_size));
int mus_delay_p __P((mus_any *ptr));

float mus_comb __P((mus_any *gen, float input, float pm));
mus_any *mus_make_comb __P((float scaler, int size, float *line, int line_size));
int mus_comb_p __P((mus_any *ptr));

float mus_notch __P((mus_any *gen, float input, float pm));
mus_any *mus_make_notch __P((float scaler, int size, float *line, int line_size));
int mus_notch_p __P((mus_any *ptr));

float mus_all_pass __P((mus_any *gen, float input, float pm));
mus_any *mus_make_all_pass __P((float backward, float forward, int size, float *line, int line_size));
int mus_all_pass_p __P((mus_any *ptr));
float mus_feedback __P((mus_any *ptr));
float mus_set_feedback __P((mus_any *ptr, float val));
float mus_feedforward __P((mus_any *ptr));
float mus_set_feedforward __P((mus_any *ptr, float val));

float mus_table_lookup __P((mus_any *gen, float fm));
mus_any *mus_make_table_lookup  __P((float freq, float phase, float *wave, int wave_size));
int mus_table_lookup_p __P((mus_any *ptr));
float *mus_partials2wave __P((float *partial_data, int partials, float *table, int table_size, int normalize));
float *mus_phasepartials2wave __P((float *partial_data, int partials, float *table, int table_size, int normalize));

float mus_sawtooth_wave __P((mus_any *gen, float fm));
mus_any *mus_make_sawtooth_wave __P((float freq, float amp, float phase));
int mus_sawtooth_wave_p __P((mus_any *gen));

float mus_square_wave __P((mus_any *gen, float fm));
mus_any *mus_make_square_wave __P((float freq, float amp, float phase));
int mus_square_wave_p __P((mus_any *gen));

float mus_triangle_wave __P((mus_any *gen, float fm));
mus_any *mus_make_triangle_wave __P((float freq, float amp, float phase));
int mus_triangle_wave_p __P((mus_any *gen));

float mus_pulse_train __P((mus_any *gen, float fm));
mus_any *mus_make_pulse_train __P((float freq, float amp, float phase));
int mus_pulse_train_p __P((mus_any *gen));

void mus_set_rand_seed __P((int seed));
float mus_random __P((float amp));

float mus_rand __P((mus_any *gen, float fm));
mus_any *mus_make_rand __P((float freq, float base));
int mus_rand_p __P((mus_any *ptr));

float mus_rand_interp __P((mus_any *gen, float fm));
mus_any *mus_make_rand_interp __P((float freq, float base));
int mus_rand_interp_p __P((mus_any *ptr));

float mus_asymmetric_fm __P((mus_any *gen, float index, float fm));
mus_any *mus_make_asymmetric_fm __P((float freq, float phase, float r, float ratio));
int mus_asymmetric_fm_p __P((mus_any *ptr));

float mus_one_zero __P((mus_any *gen, float input));
mus_any *mus_make_one_zero __P((float a0, float a1));
int mus_one_zero_p __P((mus_any *gen));

float mus_one_pole __P((mus_any *gen, float input));
mus_any *mus_make_one_pole __P((float a0, float b1));
int mus_one_pole_p __P((mus_any *gen));

float mus_two_zero __P((mus_any *gen, float input));
mus_any *mus_make_two_zero __P((float a0, float a1, float a2));
int mus_two_zero_p __P((mus_any *gen));
mus_any *mus_make_zpolar __P((float radius, float frequency));

float mus_two_pole __P((mus_any *gen, float input));
mus_any *mus_make_two_pole __P((float a0, float b1, float b2));
int mus_two_pole_p __P((mus_any *gen));
mus_any *mus_make_ppolar __P((float radius, float frequency));

float mus_a0 __P((mus_any *ptr));
float mus_set_a0 __P((mus_any *ptr, float val));
float mus_a1 __P((mus_any *ptr));
float mus_set_a1 __P((mus_any *ptr, float val));
float mus_a2 __P((mus_any *ptr));
float mus_set_a2 __P((mus_any *ptr, float val));
float mus_b1 __P((mus_any *ptr));
float mus_set_b1 __P((mus_any *ptr, float val));
float mus_b2 __P((mus_any *ptr));
float mus_set_b2 __P((mus_any *ptr, float val));

float mus_formant __P((mus_any *ptr, float input)); 
mus_any *mus_make_formant __P((float radius, float frequency, float gain));
int mus_formant_p __P((mus_any *ptr));
float mus_formant_radius __P((mus_any *ptr));
float mus_set_formant_radius __P((mus_any *ptr, float val));

float mus_sine_summation __P((mus_any *ptr, float fm));
mus_any *mus_make_sine_summation __P((float frequency, float phase, int n, float a, float b_ratio));
int mus_sine_summation_p __P((mus_any *ptr));

float mus_filter __P((mus_any *ptr, float input));
mus_any *mus_make_filter __P((int order, float *xcoeffs, float *ycoeffs, float *state));
int mus_filter_p __P((mus_any *ptr));

float mus_fir_filter __P((mus_any *ptr, float input));
mus_any *mus_make_fir_filter __P((int order, float *xcoeffs, float *state));
int mus_fir_filter_p __P((mus_any *ptr));

float mus_iir_filter __P((mus_any *ptr, float input));
mus_any *mus_make_iir_filter __P((int order, float *ycoeffs, float *state));
int mus_iir_filter_p __P((mus_any *ptr));

float *mus_xcoeffs __P((mus_any *ptr));
float *mus_ycoeffs __P((mus_any *ptr));
int mus_order __P((mus_any *ptr));

float mus_wave_train __P((mus_any *gen, float fm));
mus_any *mus_make_wave_train __P((float freq, float phase, float *wave, int wsize));
int mus_wave_train_p __P((mus_any *gen));

float mus_buffer2sample __P((mus_any *ptr));
float mus_sample2buffer __P((mus_any *ptr, float val));
mus_any *mus_make_buffer __P((float *preloaded_buffer, int size, float current_file_time));
int mus_buffer_p __P((mus_any *ptr));
int mus_buffer_empty_p __P((mus_any *ptr));
mus_any *mus_buffer2frame __P((mus_any *rb, mus_any *fr));
mus_any *mus_frame2buffer __P((mus_any *rb, mus_any *fr));

mus_any *mus_make_waveshape __P((float frequency, float phase, float *table, int size));
float mus_waveshape __P((mus_any *ptr, float index, float fm));
int mus_waveshape_p __P((mus_any *ptr));
float *mus_partials2waveshape __P((int npartials, float *partials, int size, float *table));
void mus_phasepartials2waveshape __P((int n, float *partials, float *phases, int size, float *Fx, float *Fy));
float *mus_partials2polynomial __P((int npartials, float *partials, int kind));

float mus_env __P((mus_any *ptr));
mus_any *mus_make_env __P((float *brkpts, int pts, float scaler, float offset, float base, float duration, int start, int end, float *odata));
int mus_env_p __P((mus_any *ptr));
void mus_restart_env __P((mus_any *ptr));
float mus_env_interp __P((float x, mus_any *env));

int mus_frame_p __P((mus_any *ptr));
mus_frame *mus_make_empty_frame __P((int chans));
mus_frame *mus_make_frame __P((int chans,...));
mus_frame *mus_frame_add __P((mus_frame *f1, mus_frame *f2, mus_frame *res));
mus_frame *mus_frame_multiply __P((mus_frame *f1, mus_frame *f2, mus_frame *res));
float mus_frame_ref __P((mus_frame *f, int chan));
float mus_frame_set __P((mus_frame *f, int chan, float val));
float *mus_frame_data __P((mus_frame *f));

int mus_mixer_p __P((mus_any *ptr));
mus_mixer *mus_make_empty_mixer __P((int chans));
mus_mixer *mus_make_identity_mixer __P((int chans));
mus_mixer *mus_make_mixer __P((int chans,...));
float **mus_mixer_data __P((mus_mixer *f));
float mus_mixer_ref __P((mus_mixer *f, int in, int out));
float mus_mixer_set __P((mus_mixer *f, int in, int out, float val));
mus_frame *mus_frame2frame __P((mus_mixer *f, mus_frame *in, mus_frame *out));
mus_frame *mus_sample2frame __P((mus_any *f, float in, mus_frame *out));
float mus_frame2sample __P((mus_any *f, mus_frame *in));
mus_mixer *mus_mixer_multiply __P((mus_mixer *f1, mus_mixer *f2, mus_mixer *res));

int mus_file2sample_p __P((mus_any *ptr));
mus_any *mus_make_file2sample __P((char *filename));
float mus_file2sample __P((mus_any *ptr, int samp, int chan));

float mus_readin __P((mus_any *rd));
mus_any *mus_make_readin __P((char *filename, int chan, int start, int direction));
int mus_readin_p __P((mus_any *ptr));
float mus_increment __P((mus_any *rd));
float mus_set_increment __P((mus_any *rd, float dir));
int mus_location __P((mus_input *rd));
int mus_set_location __P((mus_input *rd, int loc));
int mus_channel __P((mus_input *rd));
mus_any *mus_make_file_input __P((char *filename, int start, int chan));
float mus_file_input __P((void *ptr, int direction));

int mus_output_p __P((void *ptr));
int mus_input_p __P((void *ptr));
float mus_in_any __P((int frame, int chan, mus_input *IO));
float mus_ina __P((int frame, mus_input *inp));
float mus_inb __P((int frame, mus_input *inp));

mus_any *mus_make_file2frame __P((char *filename));
int mus_file2frame_p __P((mus_any *ptr));
mus_frame *mus_file2frame __P((mus_any *ptr, int samp, mus_frame *f));

int mus_sample2file_p __P((mus_any *ptr));
mus_any *mus_make_sample2file __P((char *filename, int chans));
float mus_sample2file __P((mus_any *ptr, int samp, int chan, float val));
mus_any *mus_make_file_output __P((char *name, int srate, int chans, int format, int type, char *comment));

float mus_out_any __P((int frame, int chan, float val, mus_output *IO));
float mus_outa __P((int frame, float val));
float mus_outb __P((int frame, float val));
float mus_outc __P((int frame, float val));
float mus_outd __P((int frame, float val));

mus_any *mus_make_frame2file __P((char *filename, int chans));
int mus_frame2file_p __P((mus_any *ptr));
mus_frame *mus_frame2file __P((mus_any *ptr, int samp, mus_frame *data));

mus_frame *mus_locsig __P((mus_any *ptr, int loc, float val));
mus_any *mus_make_locsig __P((float degree, float distance, float reverb, int chans, mus_output *output, mus_output *revput));
int mus_locsig_p __P((mus_any *ptr));
int mus_channels __P((mus_any *ptr));
float mus_locsig_ref __P((mus_any *ptr, int chan));
float mus_locsig_set __P((mus_any *ptr, int chan, float val));
float mus_locsig_reverb_ref __P((mus_any *ptr, int chan));
float mus_locsig_reverb_set __P((mus_any *ptr, int chan, float val));

mus_any *mus_make_src __P((float (*input)(void *arg, int direction), float srate, int width, void *environ));
float mus_src __P((mus_any *srptr, float sr_change, float (*input)(void *arg, int direction)));
int mus_src_p __P((mus_any *ptr));

int mus_convolve_p __P((mus_any *ptr));
float mus_convolve __P((mus_any *ptr, float (*input)(void *arg, int direction)));
mus_any *mus_make_convolve __P((float (*input)(void *arg, int direction), float *filter, int fftsize, int filtersize, void *environ));
void mus_spectrum __P((float *rdat, float *idat, float *window, int n, int type));
void mus_fft __P((float *rl, float *im, int n, int isign));
float *mus_make_fft_window __P((int size, int type, float beta));
void mus_convolution __P((float* rl1, float* rl2, int n));

int mus_granulate_p __P((mus_any *ptr));
float mus_granulate __P((mus_any *ptr, float (*input)(void *arg, int direction)));
mus_any *mus_make_granulate __P((float (*input)(void *arg,int direction), 
				 float expansion, float length, float scaler, 
				 float hop, float ramp, float jitter, int max_size, void *environ));
float mus_ramp __P((mus_any *ptr));
float mus_set_ramp __P((mus_any *ptr, float val));
int mus_hop __P((mus_any *ptr));
int mus_set_hop __P((mus_any *ptr, int val));

#if HAVE_SNDLIB
int mus_set_file_buffer_size __P((int size));
#endif

void mus_mix __P((char *outfile, char *infile, int out_start, int out_samps, int in_start, mus_mixer *mx, mus_any ***envs));
int mus_file2fltarray __P((char *filename, int chan, int start, int samples, float *array));
int mus_fltarray2file __P((char *filename, float *ddata, int len, int srate, int channels));

__END_DECLS

#endif
