#ifndef OLD_SNDLIB_H
#define OLD_SNDLIB_H

/* these are for backwards compatibility -- names changed 19-June-99 to use "mus" prefix */

#define clm_printf(str) mus_printf(str)
#define set_clm_datum_type(tfd,type) mus_set_datum_type(tfd,type)
#define open_clm_file_descriptors(tfd,df,ds,dl) mus_open_file_descriptors(tfd,df,ds,dl);
#define close_clm_file_descriptors(tfd) mus_close_file_descriptors(tfd)
#define cleanup_clm_file_descriptors() mus_cleanup_file_descriptors()
#define clm_open_read(arg) mus_open_read(arg)
#define clm_open_write(arg) mus_open_write(arg)
#define clm_create(arg) mus_create(arg)
#define clm_reopen_write(arg) mus_reopen_write(arg)
#define clm_close(fd) mus_close(fd)
#define clm_seek(tfd,offset,origin) mus_seek(tfd,offset,origin)
#define clm_read(fd,beg,end,chans,bufs) mus_read(fd,beg,end,chans,bufs)
#define clm_read_chans(fd,beg,end,chans,bufs,cm) mus_read_chans(fd,beg,end,chans,bufs,cm)
#define clm_write_zeros(fd,num) mus_write_zeros(fd,num)
#define clm_write(tfd,beg,end,chans,bufs) mus_write(tfd,beg,end,chans,bufs)
#define float_sound(cbuf,samps,form,buf) mus_float_sound(cbuf,samps,form,buf)
#define create_descriptors() mus_create_descriptors()
#define clm_read_any(tfd,beg,chans,nints,bufs,cm) mus_read_any(tfd,beg,chans,nints,bufs,cm)
#define unshort_sound(ibuf,samps,form,obuf) mus_unshort_sound(ibuf,samps,form,obuf)
#define complete_filename(tok) mus_complete_filename(tok)

#define c_snd_header_data_size() mus_header_samples()
#define mus_header_data_size() mus_header_samples()
#define c_snd_header_data_location() mus_header_data_location()
#define c_snd_header_chans() mus_header_chans()
#define c_snd_header_srate() mus_header_srate()
#define c_snd_header_type() mus_header_type()
#define c_snd_header_format() mus_header_format()
#define c_snd_header_distributed() mus_header_distributed()
#define c_snd_header_comment_start() mus_header_comment_start()
#define c_snd_header_comment_end() mus_header_comment_end()
#define c_snd_header_type_specifier() mus_header_type_specifier()
#define c_snd_header_bits_per_sample() mus_header_bits_per_sample()
#define c_snd_header_fact_samples() mus_header_fact_samples()
#define c_snd_header_block_align() mus_header_block_align()
#define c_snd_header_loop_mode(w) mus_header_loop_mode(w)
#define c_snd_header_loop_start(w) mus_header_loop_start(w)
#define c_snd_header_loop_end(w) mus_header_loop_end(w)
#define c_snd_header_mark_position(w) mus_header_mark_position(w)
#define c_snd_header_base_note() mus_header_base_note()
#define c_snd_header_base_detune() mus_header_base_detune()
#define c_snd_header_original_format() mus_header_original_format()
#define c_snd_header_datum_size() mus_header_format2bytes()
#define c_snd_header_aux_comment_start(w) mus_header_aux_comment_start(w)
#define c_snd_header_aux_comment_end(w) mus_header_aux_comment_end(w)
#define c_true_file_length() mus_true_file_length()

#define c_snd_datum_size(f) mus_format2bytes(f)
#define mus_datum_size(f) mus_format2bytes(f)
#define c_snd_bytes(f,s) mus_samples2bytes(f,s)
#define mus_bytes(f,s) mus_samples2bytes(f,s)
#define c_snd_samples(f,s) mus_bytes2samples(f,s)
#define mus_samples(f,s) mus_bytes2samples(f,s)

#define c_read_header_with_fd(chan) mus_read_header_with_fd(chan)
#define c_read_header(arg) mus_read_header(arg)
#define c_write_header(name,type,srate,chans,loc,size,format,comment,len) mus_write_header(name,type,srate,chans,loc,size,format,comment,len)
#define c_write_header_with_fd(chan,type,srate,chans,loc,size,format,comment,len) mus_write_header_with_fd(chan,type,srate,chans,loc,size,format,comment,len)
#define c_update_header_with_fd(chan,type,siz) mus_update_header_with_fd(chan,type,siz)
#define c_update_header(name,type,siz,srate,format,chans,loc) mus_update_header(name,type,siz,srate,format,chans,loc)
#define c_update_header_comment(name,loc,comment,len,typ) mus_update_header_comment(name,loc,comment,len,typ)
#define bytes_per_sample(frm) sound_bytes_per_sample(frm)
#define write_next_header(chan,srate,chans,loc,siz,format,comment,len) mus_write_next_header(chan,srate,chans,loc,siz,format,comment,len) 
#define set_aifc_header(val) mus_set_aifc_header(val)
#define create_header_buffer() mus_create_header_buffer()
#define c_set_snd_header(srate,chans,format) mus_set_snd_header(srate,chans,format)

#define DEFAULT_DEVICE 0
#define READ_WRITE_DEVICE 1
#define ADAT_IN_DEVICE 2
#define AES_IN_DEVICE 3
#define LINE_OUT_DEVICE 4
#define LINE_IN_DEVICE 5
#define MICROPHONE_DEVICE 6
#define SPEAKERS_DEVICE 7
#define DIGITAL_IN_DEVICE 8
#define DIGITAL_OUT_DEVICE 9
#define DAC_OUT_DEVICE 10
#define ADAT_OUT_DEVICE 11
#define AES_OUT_DEVICE 12
#define DAC_FILTER_DEVICE 13
#define MIXER_DEVICE 14
#define LINE1_DEVICE 15
#define LINE2_DEVICE 16
#define LINE3_DEVICE 17
#define AUX_INPUT_DEVICE 18
#define CD_IN_DEVICE 19
#define AUX_OUTPUT_DEVICE 20
#define SPDIF_IN_DEVICE 21
#define SPDIF_OUT_DEVICE 22

#define NIST_shortpack 2
#define AIFF_IMA_ADPCM 99
#define AUDIO_SYSTEM(n) ((n)<<16)

#ifdef SNDLIB_LITTLE_ENDIAN
  #define COMPATIBLE_FORMAT snd_16_linear_little_endian
#else
  #define COMPATIBLE_FORMAT snd_16_linear
#endif

#ifndef WINDOZE
  #define NO_ERROR 0
#else
  #define NO_ERROR 0L
#endif
#define CHANNELS_NOT_AVAILABLE 1
#define SRATE_NOT_AVAILABLE 2
#define FORMAT_NOT_AVAILABLE 3
#define NO_INPUT_AVAILABLE 4
#define NO_OUTPUT_AVAILABLE 5
#define INPUT_BUSY 6
#define OUTPUT_BUSY 7
#define CONFIGURATION_NOT_AVAILABLE 8
#define INPUT_CLOSED 9
#define OUTPUT_CLOSED 10
#define IO_INTERRUPTED 11
#define NO_LINES_AVAILABLE 12
#define WRITE_ERROR 13
#define SIZE_NOT_AVAILABLE 14
#define DEVICE_NOT_AVAILABLE 15
#define CANT_CLOSE 16
#define CANT_OPEN 17
#define READ_ERROR 18
#define AMP_NOT_AVAILABLE 19
#define AUDIO_NO_OP 20
#define CANT_WRITE 21
#define CANT_READ 22
#define NO_READ_PERMISSION 23

#define AMP_FIELD 0
#define SRATE_FIELD 1
#define CHANNEL_FIELD 2
#define FORMAT_FIELD 3
#define DEVICE_FIELD 4
#define IMIX_FIELD 5
#define IGAIN_FIELD 6
#define RECLEV_FIELD 7
#define PCM_FIELD 8
#define PCM2_FIELD 9
#define OGAIN_FIELD 10
#define LINE_FIELD 11
#define MIC_FIELD 12
#define LINE1_FIELD 13
#define LINE2_FIELD 14
#define LINE3_FIELD 15
#define SYNTH_FIELD 16
#define BASS_FIELD 17
#define TREBLE_FIELD 18
#define CD_FIELD 19

#define MAX_FILE_NAME 128

#define snd_unsupported -1
#define snd_no_snd 0
#define snd_16_linear 1
#define snd_8_mulaw 2
#define snd_8_linear 3
#define snd_32_float 4
#define snd_32_linear 5
#define snd_8_alaw 6
#define snd_8_unsigned 7
#define snd_24_linear 8
#define snd_64_double 9
#define snd_16_linear_little_endian 10
#define snd_32_linear_little_endian 11
#define snd_32_float_little_endian 12
#define snd_64_double_little_endian 13
#define snd_16_unsigned 14
#define snd_16_unsigned_little_endian 15
#define snd_24_linear_little_endian 16
#define snd_32_vax_float 17
#define snd_12_linear 18
#define snd_12_linear_little_endian 19
#define snd_12_unsigned 20
#define snd_12_unsigned_little_endian 21

#define set_big_endian_int(j,x) mus_set_big_endian_int(j,x)
#define get_big_endian_int(in) mus_big_endian_int(in)
#define set_little_endian_int(j,x) mus_set_little_endian_int(j,x)
#define get_little_endian_int(in) mus_little_endian_int(in)
#define get_uninterpreted_int(in) mus_uninterpreted_int(in)
#define set_big_endian_float(j,x) mus_set_big_endian_float(j,x)
#define get_big_endian_float(in) mus_big_endian_float(in)
#define set_little_endian_float(j,x) mus_set_little_endian_float(j,x)
#define get_little_endian_float(in) mus_little_endian_float(in)
#define set_big_endian_short(j,x) mus_set_big_endian_short(j,x)
#define get_big_endian_short(in) mus_big_endian_short(in)
#define set_little_endian_short(j,x) mus_set_little_endian_short(j,x)
#define get_little_endian_short(in) mus_little_endian_short(in)
#define set_big_endian_unsigned_short(j,x) mus_set_big_endian_unsigned_short(j,x)
#define get_big_endian_unsigned_short(in) mus_big_endian_unsigned_short(in)
#define set_little_endian_unsigned_short(j,x) mus_set_little_endian_unsigned_short(j,x)
#define get_little_endian_unsigned_short(in) mus_little_endian_unsigned_short(in)
#define get_little_endian_double(in) mus_little_endian_double(in)
#define get_big_endian_double(in) mus_big_endian_double(in)
#define set_big_endian_double(j,x) mus_set_big_endian_double(j,x)
#define set_little_endian_double(j,x) mus_set_little_endian_double(j,x)
#define get_big_endian_unsigned_int(in) mus_big_endian_unsigned_int(in)
#define get_little_endian_unsigned_int(in) mus_little_endian_unsigned_int(in)

#define mus_set_datum_type(a,b) mus_set_header_type(a,b)
#define mus_set_datum_chans(a,b) mus_set_chans(a,b)

#endif


