(define segment
  (lambda (marks-not-files)
    ;; run through currently selected file looking for sound segments
    ;; and write each to a separate (aiff) file named segN.snd, or
    ;; mark the segment boundaries if marks-not-files
    (let* ((snd (selected-sound))
	   (soundname (file-name snd))
	   (chans (sound-chans soundname))
	   (frames (snd-length snd))
	   (output-counter 0)
	   (hop-size 32)
	   (silent-max (* hop-size .001))
	   (seg-start -1))
      (do ((frame 0 (+ frame hop-size)) )
	  ((>= frame frames))
	;; check each channel 
	(let ((chan-max 0.0))
	  (do ((chan 0 (1+ chan))) 
	      ((= chan chans))
	    (let ((data (samples frame (+ frame hop-size) snd chan))
		  (sum 0.0))
	      (do ((i 0 (1+ i)))
		  ((= i hop-size))
		(set! sum (+ sum (abs (vector-ref data i)))))
	      (if (> sum chan-max) (set! chan-max sum))))

	  (if (> chan-max silent-max)
	      (if (< seg-start 0) 
		  (set! seg-start frame))
	      (if (and (>= seg-start 0) (> frame seg-start))
		  (begin
		    (set! output-counter (1+ output-counter))
		    (if marks-not-files
			(begin
			  (report-in-minibuffer (string-append "segment " 
							       (number->string output-counter) 
							       ": " 
							       (number->string seg-start) 
							       " " 
							       (number->string frame)))
			  (add-mark seg-start snd 0)
			  (add-mark frame snd 0))
			(begin
			  (let* ((old-sync (syncing? snd)))
			    (set-syncing #t snd)
			    (make-region seg-start frame snd)
			    (save-region 0 (string-append "seg" (number->string output-counter) ".snd"))
			    (set-syncing old-sync snd))))
		    (set! seg-start -1))))))
      "done")))

		    
	      