#include "snd.h"
#include "vct.h"
#include "sndlib-strings.h"

#define CLM_BUFFER_SIZE 16384
static char *clm_buffer = NULL;
static int clm_buffer_size = 0;

int *clm_snd_data(snd_state *ss, int *length)
{
  int *arr;
  int i,j,beg,ints,blen,len;
  if (!clm_buffer) 
    {
      clm_buffer = (char *)CALLOC(CLM_BUFFER_SIZE,sizeof(char));
      clm_buffer_size = CLM_BUFFER_SIZE;
    }
  write(ss->to_clm,"nil",4);
  read(ss->from_clm,clm_buffer,4);
  len = mus_big_endian_int((unsigned char *)clm_buffer);
  (*length) = len;
  blen = (clm_buffer_size/4);
  arr = (int *)CALLOC(len,sizeof(int));
  for (beg=0;beg<len;beg+=blen)
    {
      read(ss->from_clm,clm_buffer,clm_buffer_size);
      ints = len-beg;
      if (ints > blen) ints=blen;
      for (i=0,j=0;i<ints;i++,j+=4) arr[i+beg] = mus_big_endian_int((unsigned char *)(clm_buffer+j));
    }
  return(arr);
}

void snd_clm_data (snd_state *ss, int len, int *data)
{
  int beg,ints,blen,val;
#ifdef SNDLIB_LITTLE_ENDIAN
  unsigned char *d1;
#endif
  val = mus_big_endian_int((unsigned char *)(&len));
  write(ss->to_clm,(char *)(&val),4);
  blen = (clm_buffer_size/4);
#ifdef SNDLIB_LITTLE_ENDIAN
  d1 = (unsigned char *)data;
  for (beg=0;beg<len;beg++,d1+=4)
    data[beg] = mus_big_endian_int(d1);
#endif
  for (beg=0;beg<len;beg+=blen)
    {
      ints = len-beg;
      if (ints > blen) ints=blen;
      write(ss->to_clm,(char *)(data+beg),ints*4);
    }
}

int get_clm_string(snd_state *ss, int fd, int from_clm)
{
  /* communication is via lisp expressions except for the find exprs -- these are in the C subset used by find */
  int bytes,i,j,k,m,n,start,commenting,len,parens,quoting,loop_start;
  char *tmp;
  if (!clm_buffer)
    {
      clm_buffer = (char *)CALLOC(CLM_BUFFER_SIZE,sizeof(char));
      clm_buffer_size = CLM_BUFFER_SIZE;
    }
  bytes=read(fd,clm_buffer,clm_buffer_size);
  if (bytes == 0) return(0);
  clm_buffer[bytes] = '\0';
  commenting = 0;
  parens = 0;
  quoting = FALSE;
  start = 0;
  loop_start = 0;
READ_CLM:
  for (i=loop_start;i<bytes;i++)
    {
      if (!quoting)
	{
	  if ((commenting == 0) && (clm_buffer[i] == ';')) commenting = 1;
	  else if ((commenting == 1) && (clm_buffer[i] == '\n')) commenting = 0;
	  else if ((commenting == 0) && (clm_buffer[i] == '#') && (clm_buffer[i+1] == '|')) commenting = 2;
	  else if ((commenting == 2) && (clm_buffer[i] == '|') && (clm_buffer[i+1] == '#')) commenting = 0;
	}
      if (clm_buffer[i] == '\"') quoting = (!quoting);
      if (commenting == 0)
	{
	  if (clm_buffer[i] == '(') {if (parens == 0) start = i; parens++;}
	  else if (clm_buffer[i] == ')') 
	    {
	      parens--; 
	      if (parens == 0) 
		{
		  tmp = (char *)CALLOC(i-start+2,sizeof(char));
		  for (m=0,n=start;n<=i;m++,n++) tmp[m] = clm_buffer[n];
		  tmp[m]='\0';
		  clm_doit(ss,tmp,from_clm);
		  FREE(tmp);
		}
	    }
	}
    }
  if (parens)
    {
      if (start != 0)
	for (i=start,j=0;i<bytes;i++,j++) clm_buffer[j] = clm_buffer[i];
      len = bytes - start;
      if (len == clm_buffer_size)
	{
	  clm_buffer_size *= 2;
	  clm_buffer = (char *)REALLOC(clm_buffer,clm_buffer_size*sizeof(char));
	}
      clm_buffer[len] = '\0';
      loop_start = len;
      k = read(fd,(char *)(clm_buffer+len),clm_buffer_size - len);
      if (k <= 0) 
	{
	  snd_error(STR_error_reading_file_extra_open_paren);
	  snd_error("\ncurrent expression started at byte %d\n",start);
	  return(0); /* this ends the read loops below */
	}
      bytes = len + k;
      goto READ_CLM;
    }
  return(bytes);
}

void clm_snd_replace_samples(snd_state *ss, char *tempf, snd_info *sp)
{
  int err,i;
  char *ofile = NULL;
  /* sequester tempf so repeated clm with-sounds don't walk on previous edits */
  ofile = snd_tempnam(ss); 
  err = snd_copy_file(ss,tempf,ofile);
  if (err == 0)
    {
      for (i=0;i<sp->nchans;i++)
	{
	  /* samples as -1 means use current tempfile read_header result in this case */
	  file_override_samples(-1,ofile,sp->chans[i],i,(i == 0) ? DELETE_ME : DONT_DELETE_ME,LOCK_MIXES,S_clm_snd_replace_samples);
	}
    }
  FREE(ofile);
}

#if (!HAVE_GUILE)

static char clm_white_space[4]={' ','\t','\n',')'};
/* static char clm_open_paren[1] = {'('}; */
static char clm_null_string[1] = {'\0'};
static int no_guile_errors = 0;

#define RES_SIZE 512
static char res_buf[RES_SIZE];

static void display_results(snd_state *ss, char *msg)
{
  if (ss->respond_to_clm)
    write(ss->to_clm,msg,strlen(msg)+1);
  else
    {
      if (ss->mx_sp) 
	report_in_minibuffer(ss->mx_sp,msg);
      if (ss->listening != LISTENER_CLOSED)
	{
	  ss->result_printout = MESSAGE_WITH_CARET;
	  snd_append_command(ss,msg);
	}
    }
}

static void fsym(snd_state *ss, float val)
{
  sprintf(res_buf,"%f",val);
  display_results(ss,res_buf);
}

static void isym(snd_state *ss, int val)
{
  sprintf(res_buf,"%d",val);
  display_results(ss,res_buf);
}

static void ssym(snd_state *ss, char *val)
{
  sprintf(res_buf,"\"%s\"",val);
  display_results(ss,res_buf);
}

static float fstr(char *str)
{
  float val = 0.0;
  if ((str) && (*str)) sscanf(str,"%f",&val);
  return(val);
}

static int istr(char *str)
{
  int val = 0;
  if ((str) && (*str)) sscanf(str,"%d",&val);
  return(val);
}

static char *sstr(char *val)
{
  /* strip off double quotes, if any */
  int len;
  if ((val) && (*val))
    {
      if (val[0] == '\"') val++;
      len = strlen(val);
      if (val[len-1] == '\"') val[len-1] = 0;
    }
  return(val);
}

static void lsym(snd_state *ss, env *e)
{
  char *news;
  if (e)
    {
      news = env_to_string(e);
      if (news)
	{
	  if (ss->mx_sp)
	    report_in_minibuffer(ss->mx_sp,news);
	  else write(ss->to_clm,news,strlen(news)+1);
	  FREE(news);
	}
    }
}

typedef struct {
  char *name;
  env *val;
} lv;

static int env_table_size = 0;
static int env_table_top = 0;
static lv **env_table = NULL;

static void add_symbol(char *name, env *val)
{
  lv *v;
  if (env_table_top == env_table_size)
    {
      env_table_size += 16;
      if (env_table_top == 0) 
	env_table = (lv **)CALLOC(env_table_size,sizeof(lv));
      else env_table = (lv **)REALLOC(env_table,env_table_size * sizeof(lv));
    }
  v = (lv *)CALLOC(1,sizeof(lv));
  v->name = copy_string(name);
  v->val = copy_env(val);
  env_table[env_table_top] = v;
  env_table_top++;
}

static lv *find_symbol(char *name) 
{
  int i;
  for (i=0;i<env_table_top;i++) 
    if (strcmp(name,env_table[i]->name) == 0) return(env_table[i]);
  return(NULL);
}

static snd_info *get_sp(snd_state *state, char *str)
{
  int snd_n;
  if ((str) && (*str))
    sscanf(str,"%d",&snd_n);
  else 
    if ((state->selected_sound != NO_SELECTION) && (snd_ok(state->sounds[state->selected_sound])))
      snd_n = state->selected_sound;
    else snd_n = 0;
  if ((snd_n >= 0) && (snd_n < state->max_sounds) && (snd_ok(state->sounds[snd_n])))
    return(state->sounds[snd_n]);
  else return(any_selected_sound(state));
}

static chan_info *get_cp(snd_state *state, char *sstr, char *cstr)
{
  snd_info *sp;
  int chn_n;
  sp = get_sp(state,sstr);
  if (sp) 
    {
      if ((cstr) && (*cstr))
	sscanf(cstr,"%d",&chn_n);
      else
	if (sp->selected_channel != NO_SELECTION) 
	  chn_n = sp->selected_channel;
	else chn_n = 0;
      if ((chn_n >= 0) && (chn_n < sp->nchans)) return(sp->chans[chn_n]);
    }
  state->eval_error = SND_NO_SUCH_CHANNEL;
  return(NULL);
}

static mark *get_m(snd_state *state, char *sstr, char *cstr, char *mstr)
{
  chan_info *cp;
  int mn;
  cp = get_cp(state,sstr,cstr);
  if (mstr) 
    sscanf(mstr,"%d",&mn);
  else mn = 0;
  return(find_mark_id(cp,mn));
}

static void g_save_envelopes(snd_state *state, char *name)
{
  FILE *fd;
  if (name == NULL) name = "envs.save";
  fd = fopen(name,"w");
  if (fd)
    {
      save_envelope_editor_state(state,fd);
      fclose(fd);
    }
}


void g_snd_callback(snd_state *ss, int callb) {}

env *name_to_env(char *str) 
{
  lv *e;
  e = find_symbol(str);
  if (e) return(copy_env(e->val));
  return(NULL);
}

static void pass_name_to_envelope_editor(snd_state *ss, char *fullstr) 
{
  /* fullstr is the incoming "defvar ...)" */
  char *name,*val,*defv;
  env *e;
  defv = strtok(fullstr,clm_white_space);
  name = strtok(NULL,clm_white_space);
  val = strtok(NULL,clm_null_string);
  e = scan_envelope(val);
  if (e)
    {
      alert_envelope_editor(ss,copy_string(name),e);
      add_symbol(name,e);
    }
}

void add_or_edit_symbol(char *name, env *val)
{
  lv *v;
  v = find_symbol(name);
  if (v)
    v->val = copy_env(val);
  else add_symbol(name,val);
}

static int prefix_fix(char *str)
{
  int val = 1;
  if ((str) && (*str)) sscanf(str,"%d",&val);
  return(val);
}

static int symit(snd_state *ss,char **str);

int clm_just_doit(snd_state *ss, char *buf) 
{
  int val;
  /* this is called from the lisp listener when the user has typed in a form (so don't echo it) */
  ss->result_printout = MESSAGE_WITH_CARET;
  val = clm_doit(ss,buf,FALSE);
  ss->result_printout = PLAIN_MESSAGE;
  return(val);
}

static int handle_set(snd_state *ss, char *tok, char **str)
{
  snd_info *sp;
  chan_info *cp;
  mark *m;
  float f0,f1;
  int ivals[2];
  int ival;
  if (strcmp(tok,S_set_ask_before_overwrite) == 0) {set_ask_before_overwrite(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_audio_output_device) == 0) {set_audio_output_device(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_auto_resize) == 0) {set_auto_resize(ss,istr(str[1])); reflect_resize(ss); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_auto_update) == 0) {set_auto_update(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_channel_style) == 0) {set_channel_style(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_color_cutoff) == 0) {set_color_cutoff(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_color_inverted) == 0) {set_color_inverted(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_color_scale) == 0) {set_color_scale(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_colormap) == 0) {set_color_map(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_corruption_time) == 0) {set_corruption_time(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_cursor) == 0) 
    {
      cp = get_cp(ss,str[2],str[3]); 
      if (cp) 
	{
	  cp->cursor_on = 1;
	  handle_cursor(cp,cursor_moveto(cp,istr(str[1]))); 
	}
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_cursor_follows_play) == 0) 
    {sp = get_sp(ss,str[2]); if (sp) sp->cursor_follows_play = istr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_dac_size) == 0) {set_dac_size(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_amp) == 0) {set_default_amp(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_contrast) == 0) {set_default_contrast(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_contrast_amp) == 0) {set_default_contrast_amp(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_contrasting) == 0) {set_default_contrasting(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_expand) == 0) {set_default_expand(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_expand_hop) == 0) {set_default_expand_hop(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_expand_length) == 0) {set_default_expand_length(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_expand_ramp) == 0) {set_default_expand_ramp(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_expanding) == 0) {set_default_expanding(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_filter_dBing) == 0) {set_default_filter_dBing(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_filter_order) == 0) {set_default_filter_order(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_filtering) == 0) {set_default_filtering(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_output_type) == 0) {set_default_output_type(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_reverb_feedback) == 0) {set_default_reverb_feedback(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_reverb_length) == 0) {set_default_reverb_length(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_reverb_lowpass) == 0) {set_default_reverb_lowpass(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_reverb_scale) == 0) {set_default_reverb_scale(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_reverbing) == 0) {set_default_reverbing(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_default_speed) == 0) {set_default_speed(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_dot_size) == 0) {set_dot_size(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_edit_history_width) == 0) {set_edit_history_width(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_env_base) == 0) {isym(ss,set_env_base(sstr(str[1]),fstr(str[2]))); return(0);}
  if (strcmp(tok,S_set_enved_base) == 0) {in_set_enved_base(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_enved_clipping) == 0) {in_set_enved_clipping(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_enved_exping) == 0) {in_set_enved_exping(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_enved_target) == 0) {in_set_enved_target(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_enved_waving) == 0) {in_set_enved_waving(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_enved_dBing) == 0) {in_set_enved_dBing(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_eps_file) == 0) {set_eps_file(ss,sstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_expand) == 0) 
    {
      sp = get_sp(ss,str[2]); 
      if (sp) snd_expand_changed(sp,set_raw_value(w_snd_expand(sp),snd_expand_to_int(fstr(str[1])))); 
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_expand_hop) == 0) {sp = get_sp(ss,str[2]); if (sp) sp->local_exphop = fstr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_expand_length) == 0) {sp = get_sp(ss,str[2]); if (sp) sp->local_explen = fstr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_expand_ramp) == 0) {sp = get_sp(ss,str[2]); if (sp) sp->local_exprmp = fstr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_expanding) == 0) {sp = get_sp(ss,str[2]); if (sp) toggle_expand_button(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_fft_beta) == 0) {set_fft_beta(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_fft_log_frequency) == 0) {set_fft_log_frequency(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_fft_log_magnitude) == 0) {set_fft_log_magnitude(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_fft_size) == 0) {set_fft_size(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_fft_style) == 0) {set_fft_style(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_fft_window) == 0) {set_fft_window(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_ffting) == 0) {cp = get_cp(ss,str[2],str[3]); if (cp) fftb(cp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_filter_dBing) == 0) {sp = get_sp(ss,str[2]); if (sp) set_filter_dBing(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_filter_env_order) == 0) {set_filter_env_order(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_filter_order) == 0) {sp = get_sp(ss,str[2]); if (sp) filter_order_changed(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_filter_env) == 0) 
    {sp = get_sp(ss,str[2]); if (sp) {sp->filter_env = scan_envelope(str[1]); filter_env_changed(sp,sp->filter_env); isym(ss,0); return(0);}}
  if (strcmp(tok,S_set_filtering) == 0) {sp = get_sp(ss,str[2]); if (sp) toggle_filter_button(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_fit_data_on_open) == 0) {set_fit_data_on_open(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_graph_style) == 0) {in_set_graph_style(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_graph_style) == 0) {set_graph_style(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_graphing) == 0) {cp = get_cp(ss,str[2],str[3]); if (cp) cp->lisp_graphing = istr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_group_amp) == 0) {mx_set_group_amp(ss,istr(str[1]),istr(str[2]),fstr(str[3])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_group_beg) == 0) {mx_set_group_beg(ss,istr(str[1]),fstr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_group_end) == 0) {mx_set_group_end(ss,istr(str[1]),fstr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_group_speed) == 0) {mx_set_group_speed(ss,istr(str[1]),fstr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_group_tempo) == 0) {mx_set_group_tempo(ss,istr(str[1]),fstr(str[2])); isym(ss,0); return(0);}
#if HAVE_XmHTML
  if (strcmp(tok,S_set_html_dir) == 0) {set_html_dir(ss,sstr(str[1])); isym(ss,0); return(0);}
#endif
  if (strcmp(tok,S_set_initial_x0) == 0) {set_initial_x0(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_initial_x1) == 0) {set_initial_x1(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_initial_y0) == 0) {set_initial_y0(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_initial_y1) == 0) {set_initial_y1(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_just_sounds) == 0) {toggle_just_sounds(istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_left_sample) == 0) {clm_left_axis(get_cp(ss,str[2],str[3]),istr(str[1])); isym(ss,0);return(0);}
  if (strcmp(tok,S_set_line_size) == 0) {set_line_size(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mark_name) == 0) {m = get_m(ss,str[3],str[4],str[1]); if (m) m->name = copy_string(sstr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_min_dB) == 0) {set_min_dB(ss,fstr(str[1])); fsym(ss,ss->min_dB); return(0);}
  if (strcmp(tok,S_set_max_fft_peaks) == 0) {set_max_fft_peaks(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_max_fft_size) == 0) {set_max_fft_size(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_max_regions) == 0) {set_max_regions(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_amp) == 0) {in_set_mix_amp(ss,istr(str[1]),istr(str[2]),fstr(str[3])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_amp_scaler) == 0) {set_mix_amp_scaler(fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_anchor) == 0) {set_mix_anchor(ss,istr(str[1]),istr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_groups) == 0) {set_mix_groups(ss,istr(str[1]),istr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_length) == 0) {set_mix_length(ss,istr(str[1]),istr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_position) == 0) {set_mix_position(ss,istr(str[1]),istr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_speed) == 0) {in_set_mix_speed(ss,istr(str[1]),fstr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_speed_scaler) == 0) {set_mix_speed_scaler(fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_state) == 0) {in_set_mix_state(ss,istr(str[1]),istr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_tempo_scaler) == 0) {set_mix_tempo_scaler(fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mix_waveform_height) == 0) {set_mix_waveform_height(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mixer_group_max_out_chans) == 0) {set_mixer_group_max_out_chans(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mixer_groups) == 0) {set_mixer_groups(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_mixer_save_state_file) == 0) {set_mixer_save_state_file(ss,sstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_movies) == 0) {set_movies(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_normalize_fft) == 0) {set_normalize_fft(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_normalize_on_open) == 0) {set_normalize_on_open(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_oss_buffers) == 0)
    {
#if (HAVE_OSS || HAVE_ALSA)
      set_oss_buffers(istr(str[1]),istr(str[2]));
#endif
      isym(ss,0);
      return(0);
    }
  if (strcmp(tok,S_set_previous_files_sort) == 0) {set_previous_files_sort(ss,istr(str[1])); update_prevfiles(ss); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_print_length) == 0) {set_print_length(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_raw_chans) == 0) {set_raw_chans(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_raw_format) == 0) {set_raw_format(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_raw_srate) == 0) {set_raw_srate(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_raw_type) == 0) {set_raw_type(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_read_only) == 0) 
    {sp = get_sp(ss,str[2]); if (sp) {ival = istr(str[1]); sp->read_only = ival; snd_file_lock_icon(sp,ival);} isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_autoload) == 0) {set_autoload(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_buffer_size) == 0) {in_set_recorder_buffer_size(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_file) == 0) {in_set_recorder_file(ss,sstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_gain) == 0) {write_record_state(AUDIO_GAINS,istr(str[1]),0,fstr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_in_amp) == 0) {write_record_state(REC_IN_AMPS,istr(str[1]),istr(str[2]),fstr(str[3])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_in_format) == 0) {in_set_recorder_in_format(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_out_amp) == 0) {write_record_state(REC_OUT_AMPS,istr(str[1]),0,fstr(str[2])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_out_chans) == 0) {in_set_recorder_out_chans(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_out_format) == 0) {in_set_recorder_out_format(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_srate) == 0) {set_recorder_srate(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_trigger) == 0) {set_recorder_trigger(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_recorder_max_duration) == 0) {set_recorder_max_duration(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_reverb_decay) == 0) {set_reverb_decay(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_reverb_feedback) == 0) {sp = get_sp(ss,str[2]); if (sp) sp->local_revfb = fstr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_reverb_length) == 0) 
    {
      sp = get_sp(ss,str[2]); 
      if (sp) snd_revlen_changed(sp,set_raw_value(w_snd_revlen(sp),snd_revlen_to_int(fstr(str[1])))); 
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_reverb_lowpass) == 0) {sp = get_sp(ss,str[2]); if (sp) sp->local_revlp = fstr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_reverb_scale) == 0) 
    {
      sp = get_sp(ss,str[2]); 
      if (sp) snd_revscl_changed(sp,set_raw_value(w_snd_revscl(sp),snd_revscl_to_int(fstr(str[1])))); 
      isym(ss,0); return(0);
    }
  if (strcmp(tok,S_set_reverbing) == 0) {sp = get_sp(ss,str[2]); if (sp) toggle_reverb_button(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_right_sample) == 0) {clm_right_axis(get_cp(ss,str[2],str[3]),istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_save_state_on_exit) == 0) {set_save_state_on_exit(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_save_state_file) == 0) {set_save_state_file(ss,sstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_show_axes) == 0) {set_show_axes(ss,istr(str[1])); isym(ss,0); return(0);}
#if (XmVERSION == 1)
  if (strcmp(tok,S_set_show_edit_history) == 0) {edit_history(ss,istr(str[1])); isym(ss,0); return(0);}
#endif
  if (strcmp(tok,S_set_show_fft_peaks) == 0) {set_show_fft_peaks(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_show_marks) == 0) {set_show_marks(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_show_mix_consoles) == 0) {set_show_mix_consoles(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_show_mix_waveforms) == 0) {set_show_mix_waveforms(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_show_selection_transform) == 0) {set_show_selection_transform(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_show_usage_stats) == 0) {set_show_usage_stats(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_show_y_zero) == 0) {set_show_y_zero(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_showing_controls) == 0) 
    {sp = get_sp(ss,str[2]); if (sp) {if (istr(str[1])) sound_show_ctrls(sp); else sound_hide_ctrls(sp);} isym(ss,0); return(0);}
  if (strcmp(tok,S_set_sinc_width) == 0) {set_sinc_width(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_cutoff) == 0) {set_spectro_cutoff_and_redisplay(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_hop) == 0) {set_spectro_hop(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_x_angle) == 0) {set_spectro_x_angle(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_x_scale) == 0) {set_spectro_x_scale(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_y_angle) == 0) {set_spectro_y_angle(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_y_scale) == 0) {set_spectro_y_scale(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_z_angle) == 0) {set_spectro_z_angle(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_spectro_z_scale) == 0) {set_spectro_z_scale(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_speed) == 0) 
    {
      sp = get_sp(ss,str[2]); 
      if (sp) snd_srate_changed(sp,set_raw_value(w_snd_srate(sp),snd_srate_to_int(fstr(str[1])))); 
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_speed_style) == 0) {activate_speed_in_menu(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_speed_tones) == 0) {set_speed_tones(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_squelch_update) == 0) {cp = get_cp(ss,str[2],str[3]); if (cp) cp->squelch_update = istr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_syncing) == 0) {sp = get_sp(ss,str[2]); if (sp) syncb(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_temp_dir) == 0) {set_temp_dir(ss,sstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_transform_type) == 0) {set_transform_type(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_trap_segfault) == 0) {set_trap_segfault(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_uniting) == 0) {sp = get_sp(ss,str[2]); if (sp) combineb(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_use_raw_defaults) == 0) {set_use_raw_defaults(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_verbose_cursor) == 0) {set_verbose_cursor(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_vu_font) == 0) {set_vu_font(ss,copy_string(sstr(str[1]))); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_vu_font_size) == 0) {set_vu_font_size(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_vu_size) == 0) {set_vu_size(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_wavelet_type) == 0) {set_wavelet_type(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_waving) == 0) {cp = get_cp(ss,str[2],str[3]); if (cp) waveb(cp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_wavo) == 0) {set_wavo(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_wavo_hop) == 0) {set_wavo_hop(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_wavo_trace) == 0) {set_wavo_trace(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_window_height) == 0) {set_snd_window_height(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_window_width) == 0) {set_snd_window_width(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_window_x) == 0) {set_snd_window_x(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_window_y) == 0) {set_snd_window_y(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_x_axis_style) == 0) {in_set_x_axis_style(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_x_bounds) == 0) 
    {
      cp = get_cp(ss,str[3],str[4]); 
      if (cp) 
	{
	  f0 = fstr(str[1]);
	  f1 = fstr(str[2]);
	  if (f1 > f0)
	    clm_x_axis(cp,f0,f1);
	  else make_eval_error(ss," (impossible bounds)","");
	}
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_xmax) == 0) {set_xmax(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_xmin) == 0) {set_xmin(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_y_bounds) == 0) 
    {
      cp = get_cp(ss,str[3],str[4]); 
      if (cp) 
	{
	  if (snd_strlen(str[1]) > 0)
	    {
	      f0 = fstr(str[1]);
	      if (snd_strlen(str[2]) > 0)
		f1 = fstr(str[2]);
	      if (f0 < 0.0)
		f1 = -f0;
	      else
		{
		  f1 = f0;
		  f0 = -f0;
		}
	    }
	  else
	    {
	      /* if no bounds given, use maxamp */
	      f1 = get_maxamp(cp->state,cp->sound,cp);
	      if (f1 < 0.0) f1 = -f1;
	      if (f1 == 0.0) f1 = .001;
	      f0 = -f1;
	    }
	  if (f1 > f0)
	    clm_y_axis(cp,f0,f1);
	  else make_eval_error(ss," (impossible bounds)","");
	}
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_ymax) == 0) {set_ymax(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_ymin) == 0) {set_ymin(ss,fstr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_zero_pad) == 0) {set_zero_pad(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_zoom_focus_style) == 0) {activate_focus_menu(ss,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_amp) == 0) 
    {
      sp = get_sp(ss,str[2]); 
      if (sp) snd_amp_changed(sp,set_raw_value(w_snd_amp(sp),snd_amp_to_int(fstr(str[1])))); 
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_contrast) == 0) 
    {
      sp = get_sp(ss,str[2]); 
      if (sp) snd_contrast_changed(sp,set_raw_value(w_snd_contrast(sp),snd_contrast_to_int(fstr(str[1])))); 
      isym(ss,0); 
      return(0);
    }
  if (strcmp(tok,S_set_contrast_amp) == 0) {sp = get_sp(ss,str[2]); if (sp) sp->contrast_amp = fstr(str[1]); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_contrasting) == 0) {sp = get_sp(ss,str[2]); if (sp) toggle_contrast_button(sp,istr(str[1])); isym(ss,0); return(0);}
  if (strcmp(tok,S_set_sample) == 0) 
    {
      cp = get_cp(ss,str[3],str[4]); 
      if (cp) 
	{
	  ivals[0] = (int)(SNDLIB_SNDFIX * fstr(str[2])); 
	  change_samples(istr(str[1]),1,ivals,cp,LOCK_MIXES,S_set_sample);
	  check_for_first_edit(cp); 
	  update_graph(cp,NULL); 
	} 
      isym(ss,0);
      return(0);
    }
  if (strcmp(tok,S_set_mark_sample) == 0) 
    {
      cp = get_cp(ss,str[3],str[4]); 
      m = get_m(ss,str[3],str[4],str[1]); 
      if (m) 
	{
	  m->samp = istr(str[2]); 
	  finish_moving_mark(cp,m);
	}
      isym(ss,0);
      return(0);
    }
  isym(ss,-1); /* don't hang clm on mistyped input! */
  return(-1);
}

int clm_doit(snd_state *ss, char *buf, int from_clm)
{
  int i,err = 0;
  char *tmp;
  char *tok[10];
  snd_info *sp;
  chan_info *cp;
  if (buf == NULL) return(0);
  if ((!(from_clm)) && (ss->result_printout == PLAIN_MESSAGE)) snd_append_command(ss,buf);
  cp = NULL;
  sp = any_selected_sound(ss);
  if (sp) cp = any_selected_channel(sp);
  for (i=0;i<10;i++) tok[i] = NULL;
  /* tmp = strtok(buf,clm_open_paren); */ /* someday I'll understand why this doesn't work... */
  tmp = buf;
  if (tmp[0] == '(') tmp++;
  ss->respond_to_clm = from_clm;
  /* now a kludge to handle the special defvar case */
  if ((snd_strlen(tmp) > 7) && (tmp[0]=='d') && (tmp[1]=='e') && (tmp[2]=='f') && (tmp[3]=='v') && (tmp[4]=='a') && (tmp[5]=='r'))
    {
      pass_name_to_envelope_editor(ss,tmp);
      isym(ss,0);
    }
  else
    {
      tok[0] = strtok(tmp,clm_white_space);
      for (i=1;i<10;i++) 
	{
	  tok[i] = strtok(NULL,clm_white_space);
	  if (tok[i] == NULL) break;
	}
      if (tok[0] == NULL) return(-1); /* probably white space with a <cr> */
      err = symit(ss,tok);
      if ((err == -1) && (cp)) err = execute_macro(cp,buf,1);
    }
  ss->respond_to_clm = 0;
  if (!from_clm) check_snd_eval_error(ss);
  return(err);
}

static int symit(snd_state *ss,char **str)
{
  char *tok,*filename,*tempfile;
  int ival,i,num,len,beg;
  chan_info *cp;
  snd_info *sp;
  mark **mps;
  mark *m;
  float scls[1];
  int *clmvals;
  int ivals[2];
  tok = str[0];
  switch (*tok)
    {
    case 'a':
      if (strcmp(tok,S_activate_listener) == 0)
	{
	  handle_listener(ss,LISTENER_LISTENING); 
	  ss->listening = LISTENER_LISTENING; 
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_active_sounds) == 0) 
	{
	  num = 0;
	  for (i=0;i<ss->max_sounds;i++) if (snd_ok(ss->sounds[i])) num++;
	  isym(ss,num);
	  return(0);
	}
      if (strcmp(tok,S_abort) == 0) abort();
      if (strcmp(tok,S_add_mark) == 0) {cp = get_cp(ss,str[2],str[3]); if (cp) isym(ss,mark_id(add_mark(istr(str[1]),NULL,cp))); return(0);}
      if (strcmp(tok,S_add_sound_file_extension) == 0) {add_sound_file_extension(sstr(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_aiff_sound_file) == 0) {isym(ss,AIFF_sound_file); return(0);}
      if (strcmp(tok,S_amp) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->amp); else isym(ss,0); return(0);}
      if (strcmp(tok,S_append_to_minibuffer) == 0) {sp = get_sp(ss,str[2]); if (sp) append_to_minibuffer(sp,sstr(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_ask_before_overwrite) == 0) {isym(ss,ask_before_overwrite(ss)); return(0);}
      if (strcmp(tok,S_audio_output_device) == 0) {isym(ss,audio_output_device(ss)); return(0);}
      if (strcmp(tok,S_audio_error) == 0) {isym(ss,audio_error()); return(0);}
      if (strcmp(tok,S_audio_error_name) == 0) {ssym(ss,audio_error_name(istr(str[1]))); return(0);}
      if (strcmp(tok,S_audio_outputs) == 0) 
	{
#ifdef SUN
	  sun_outputs(istr(str[1]),istr(str[2]),istr(str[3]));
#endif
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_auto_resize) == 0) {isym(ss,auto_resize(ss)); return(0);}
      if (strcmp(tok,S_auto_update) == 0) {isym(ss,auto_update(ss)); return(0);}
      break;
    case 'b':
      if (strcmp(tok,S_backward_graph) == 0) {goto_previous_graph(current_channel(ss),prefix_fix(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_backward_mark) == 0) {goto_mark(current_channel(ss),-prefix_fix(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_backward_mix) == 0) {goto_mix(current_channel(ss),-prefix_fix(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_backward_sample) == 0) 
	{cp = current_channel(ss); if (cp) handle_cursor(cp,cursor_move(cp,-prefix_fix(str[1]))); isym(ss,0); return(0);}
      if (strcmp(tok,S_sound_bytes_per_sample) == 0) {isym(ss,sound_bytes_per_sample(istr(str[1]))); return(0);}
      if (strcmp(tok,S_bind_key) == 0) {set_keymap_entry(istr(str[1]),istr(str[2]),sstr(str[3]),istr(str[4])); isym(ss,0); return(0);}
      break;
    case 'c':
      if (strcmp(tok,S_call_apply) == 0) {sp = get_sp(ss,str[1]); if (sp) run_apply_to_completion(sp); isym(ss,0); return(0);}
#if (HAVE_OSS || HAVE_ALSA)
      if (strcmp(tok,S_clear_audio_inputs) == 0) {clear_soundcard_inputs(); isym(ss,0); return(0);}
#endif
      if (strcmp(tok,S_channel_style) == 0) {isym(ss,channel_style(ss)); return(0);}
      if (strcmp(tok,S_channels) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->nchans); else isym(ss,0); return(0);}
      if (strcmp(tok,S_chans) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->nchans); else isym(ss,0); return(0);}
      if (strcmp(tok,S_clm_dialog) == 0) {start_clm_dialog(ss,sstr(str[1]),NULL); isym(ss,0); return(0);}
      if (strcmp(tok,S_clm_snd_replace_samples) == 0) 
	{
	  tempfile = sstr(str[1]);
	  if ((str[2]) && (*(str[2]))) 
	    sp = find_sound(ss,sstr(str[2]));
	  else sp = any_selected_sound(ss);
	  clm_snd_replace_samples(ss,tempfile,sp);
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_clm_snd_samples) == 0) 
	{
	  cp = current_channel(ss);
	  if (cp)
	    {
	      beg = istr(str[1]);
	      len = istr(str[2]);
	      clmvals = load_samples(beg,len,cp);
	      snd_clm_data(ss,len,clmvals);
	      FREE(clmvals);
	    }
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_clm_snd_set_samples) == 0) 
	{
	  cp = current_channel(ss);
	  if (cp)
	    {
	      beg = istr(str[1]);
	      clmvals = clm_snd_data(ss,&len);
	      change_samples(beg,len,clmvals,cp,LOCK_MIXES,S_clm_snd_set_samples);
	      check_for_first_edit(cp);
	      update_graph(cp,NULL);
	      FREE(clmvals);
	    }
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_clm_snd_update) == 0) 
	{
	  filename = sstr(str[1]);
	  sp = find_sound(ss,filename);
	  if (sp)
	    snd_update(ss,sp);
	  else snd_open_file(filename,ss);
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_clm_snd_close) == 0) 
	{
	  filename = sstr(str[1]);
	  sp = find_sound(ss,filename);
	  if (sp) snd_close_file(sp,ss);
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_clmQ) == 0) {isym(ss,0); return(0);}
      if (strcmp(tok,S_close_sound) == 0) {sp = get_sp(ss,str[1]); if (sp) snd_close_file(sp,ss); isym(ss,0); return(0);}
      if (strcmp(tok,S_color_cutoff) == 0) {fsym(ss,color_cutoff(ss)); return(0);}
      if (strcmp(tok,S_color_dialog) == 0) {start_color_dialog(ss,0,0); isym(ss,0); return(0);}
      if (strcmp(tok,S_color_inverted) == 0) {isym(ss,color_inverted(ss)); return(0);}
      if (strcmp(tok,S_color_scale) == 0) {fsym(ss,color_scale(ss)); return(0);}
      if (strcmp(tok,S_colormap) == 0) {isym(ss,color_map(ss)); return(0);}
      if (strcmp(tok,S_comment) == 0) {sp = get_sp(ss,str[1]); if (sp) ssym(ss,sound_comment(sp->fullname)); else isym(ss,0); return(0);}
      if (strcmp(tok,S_contrast) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->contrast); else isym(ss,0); return(0);}
      if (strcmp(tok,S_contrast_amp) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->contrast_amp); else isym(ss,0); return(0);}
      if (strcmp(tok,S_contrasting) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->contrasting); else isym(ss,0); return(0);}
      if (strcmp(tok,S_convolve_with) == 0) 
	{
	  cp = get_cp(ss,str[3],str[4]); 
	  if (cp) 
	    {
	      filename = mus_complete_filename(sstr(str[1]));
	      if (snd_probe_file(ss,filename) == FILE_EXISTS)
		convolve_with(filename,fstr(str[2]),cp); 
	    }
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_convolve_selection_with) == 0) 
	{
	  finish_keyboard_selection();
	  filename = mus_complete_filename(sstr(str[1]));
	  if (snd_probe_file(ss,filename) == FILE_EXISTS)
	    convolve_with(filename,fstr(str[2]),NULL); 
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_count_matches) == 0) {isym(ss,snd_find_1(get_cp(ss,str[3],str[4]),copy_string(str[1]),istr(str[2]),TRUE)); return(0);}
      if (strcmp(tok,S_corruption_time) == 0) {isym(ss,(int)(corruption_time(ss))); return(0);}
      if (strcmp(tok,S_cursor) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) isym(ss,cp->cursor); else isym(ss,0); return(0);}
      if (strcmp(tok,S_cursor_follows_play) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->cursor_follows_play); else isym(ss,0); return(0);}
      if (strcmp(tok,S_cut) == 0) 
	{
	  finish_keyboard_selection();
	  if (region_ok(0))
	    {
	      delete_selection(S_cut,UPDATE_DISPLAY);
	    }
	  else ss->eval_error = SND_NO_ACTIVE_SELECTION;
	  isym(ss,0);
	  return(0);
	}
      break;
    case 'd':
      if (strcmp(tok,S_dac_size) == 0) {isym(ss,dac_size(ss)); return(0);}
      if (strcmp(tok,S_data_format) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,(sp->hdr)->format); else isym(ss,0); return(0);}
      if (strcmp(tok,S_data_location) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,(sp->hdr)->data_location); else isym(ss,0); return(0);}
      if (strcmp(tok,S_default_amp) == 0) {fsym(ss,default_amp(ss)); return(0);}
      if (strcmp(tok,S_default_contrast) == 0) {fsym(ss,default_contrast(ss)); return(0);}
      if (strcmp(tok,S_default_contrast_amp) == 0) {fsym(ss,default_contrast_amp(ss)); return(0);}
      if (strcmp(tok,S_default_contrasting) == 0) {isym(ss,default_contrasting(ss)); return(0);}
      if (strcmp(tok,S_default_expand) == 0) {fsym(ss,default_expand(ss)); return(0);}
      if (strcmp(tok,S_default_expand_hop) == 0) {fsym(ss,default_expand_hop(ss)); return(0);}
      if (strcmp(tok,S_default_expand_length) == 0) {fsym(ss,default_expand_length(ss)); return(0);}
      if (strcmp(tok,S_default_expand_ramp) == 0) {fsym(ss,default_expand_ramp(ss)); return(0);}
      if (strcmp(tok,S_default_expanding) == 0) {isym(ss,default_expanding(ss)); return(0);}
      if (strcmp(tok,S_default_filter_dBing) == 0) {isym(ss,default_filter_dBing(ss)); return(0);}
      if (strcmp(tok,S_default_filter_order) == 0) {isym(ss,default_filter_order(ss)); return(0);}
      if (strcmp(tok,S_default_filtering) == 0) {isym(ss,default_filtering(ss)); return(0);}
      if (strcmp(tok,S_default_output_type) == 0) {isym(ss,default_output_type(ss)); return(0);}
      if (strcmp(tok,S_default_reverb_feedback) == 0) {fsym(ss,default_reverb_feedback(ss)); return(0);}
      if (strcmp(tok,S_default_reverb_length) == 0) {fsym(ss,default_reverb_length(ss)); return(0);}
      if (strcmp(tok,S_default_reverb_lowpass) == 0) {fsym(ss,default_reverb_lowpass(ss)); return(0);}
      if (strcmp(tok,S_default_reverb_scale) == 0) {fsym(ss,default_reverb_scale(ss)); return(0);}
      if (strcmp(tok,S_default_reverbing) == 0) {isym(ss,default_reverbing(ss)); return(0);}
      if (strcmp(tok,S_default_speed) == 0) {fsym(ss,default_speed(ss)); return(0);}
      if (strcmp(tok,S_delete_mark) == 0) 
	{
	  cp = get_cp(ss,str[2],str[3]); 
	  m = get_m(ss,str[1],str[2],str[3]); 
	  if (m) delete_mark_id(m->id,cp); 
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_delete_marks) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) delete_marks(cp); isym(ss,0); return(0);}
      if (strcmp(tok,S_delete_region) == 0) 
	{
	  ival = istr(str[1]);
	  if (region_ok(ival))
	    delete_region_and_update_browser(ss,ival);
	  else ss->eval_error = SND_NO_SUCH_REGION;
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_dot_size) == 0) {isym(ss,dot_size(ss)); return(0);}
      if (strcmp(tok,S_delete_sample) == 0) 
	{
	  cp = get_cp(ss,str[2],str[3]); 
	  if (cp) 
	    {
	      ival = istr(str[1]);
	      if ((ival <= current_ed_samples(cp)) && (ival >= 0))
		{
		  delete_samples(istr(str[1]),1,cp,S_delete_sample); 
		  check_for_first_edit(cp); 
		  update_graph(cp,NULL);
		}
	      else ss->eval_error = SND_NO_SUCH_SAMPLE;
	    } 
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_delete_samples) == 0) 
	{
	  cp = get_cp(ss,str[3],str[4]);
	  if (cp) 
	    {
	      delete_samples(istr(str[1]),istr(str[2]),cp,S_delete_samples); 
	      check_for_first_edit(cp); 
	      update_graph(cp,NULL);
	    } 
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_describe_audio) == 0) {snd_help(ss,"Audio State",report_audio_state()); isym(ss,0); return(0);}
      if (strcmp(tok,S_dismiss_all_dialogs) == 0) {dismiss_all(ss); isym(ss,0); return(0);}
      break;
    case 'e':
      if (strcmp(tok,S_edit_header_dialog) == 0) {edit_header(get_sp(ss,str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_edit_history_width) == 0) {isym(ss,edit_history_width(ss)); return(0);}
      if (strcmp(tok,S_enved_base) == 0) {fsym(ss,enved_base(ss)); return(0);}
      if (strcmp(tok,S_enved_power) == 0) {fsym(ss,enved_power(ss)); return(0);}
      if (strcmp(tok,S_enved_clipping) == 0) {isym(ss,enved_clipping(ss)); return(0);}
      if (strcmp(tok,S_enved_dialog) == 0) {create_envelope_editor(ss); isym(ss,0); return(0);}
      if (strcmp(tok,S_enved_exping) == 0) {isym(ss,enved_exping(ss)); return(0);}
      if (strcmp(tok,S_enved_target) == 0) {isym(ss,enved_target(ss)); return(0);}
      if (strcmp(tok,S_enved_waving) == 0) {isym(ss,enved_waving(ss)); return(0);}
      if (strcmp(tok,S_enved_dBing) == 0) {isym(ss,enved_dBing(ss)); return(0);}
      if (strcmp(tok,S_eps_file) == 0) {ssym(ss,eps_file(ss)); return(0);}
      if (strcmp(tok,S_exit) == 0) {snd_exit_cleanly(ss); snd_exit(1);}
      if (strcmp(tok,S_expand) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->expand); else isym(ss,0); return(0);}
      if (strcmp(tok,S_expand_hop) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->local_exphop); else isym(ss,0); return(0);}
      if (strcmp(tok,S_expand_length) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->local_explen); else isym(ss,0); return(0);}
      if (strcmp(tok,S_expand_ramp) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->local_exprmp); else isym(ss,0); return(0);}
      if (strcmp(tok,S_expanding) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->expanding); else isym(ss,0); return(0);}
      if (strcmp(tok,S_env_selection) == 0)
	{
	  cp = get_cp(ss,str[3],str[4]);
	  if ((cp) && (active_selection(cp))) apply_env(cp,scan_envelope(str[1]),0,0,1.0,TRUE,FALSE,S_env_selection);
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_env_sound) == 0) 
	{
	  int dur,samp;
	  cp = get_cp(ss,str[5],str[6]);
	  if (cp)
	    {
	      if ((str[2]) && (*(str[2]))) samp = istr(str[2]); else samp = 0;
	      if ((str[3]) && (*(str[3]))) dur = istr(str[3]); else dur = current_ed_samples(cp);
	      apply_env(cp,scan_envelope(str[1]),samp,dur,1.0,FALSE,FALSE,S_env_sound);
	    }
	  isym(ss,0);
	  return(0);
	}
      break;
    case 'f':
      if (strcmp(tok,S_fft_beta) == 0) {fsym(ss,fft_beta(ss)); return(0);}
      if (strcmp(tok,S_fft_log_frequency) == 0) {isym(ss,fft_log_frequency(ss)); return(0);}
      if (strcmp(tok,S_fft_log_magnitude) == 0) {isym(ss,fft_log_magnitude(ss)); return(0);}
      if (strcmp(tok,S_fft_size) == 0) {isym(ss,fft_size(ss)); return(0);}
      if (strcmp(tok,S_fft_style) == 0) {isym(ss,fft_style(ss)); return(0);}
      if (strcmp(tok,S_fft_window) == 0) {isym(ss,fft_window(ss)); return(0);}
      if (strcmp(tok,S_ffting) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) isym(ss,cp->ffting); else isym(ss,0); return(0);}
      if (strcmp(tok,S_file_dialog) == 0) {start_file_dialog(ss,0,0); isym(ss,0); return(0);}
      if (strcmp(tok,S_file_name) == 0) {sp = get_sp(ss,str[1]); if (sp) ssym(ss,sp->fullname); else isym(ss,0); return(0);}
      if (strcmp(tok,S_filter_sound) == 0) 
	{cp = get_cp(ss,str[3],str[4]); if (cp) apply_filter(cp,istr(str[2]),scan_envelope(str[1]),FALSE,S_filter_sound,FALSE); isym(ss,0); return(0);}
      if (strcmp(tok,S_filter_dBing) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->filter_dBing); else isym(ss,0); return(0);}
      if (strcmp(tok,S_filter_env) == 0) {sp = get_sp(ss,str[1]); if (sp) ssym(ss,env_to_string(sp->filter_env)); else isym(ss,0); return(0);}
      if (strcmp(tok,S_filter_env_order) == 0) {isym(ss,filter_env_order(ss)); return(0);}
      if (strcmp(tok,S_filter_order) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->filter_order); else isym(ss,0); return(0);}
      if (strcmp(tok,S_filtering) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->filtering); else isym(ss,0); return(0);}
      if (strcmp(tok,S_filter_selection) == 0) 
	{
	  cp = get_cp(ss,str[3],str[4]); 
	  if (cp) apply_filter(cp,istr(str[2]),scan_envelope(str[1]),FALSE,S_filter_selection,TRUE); 
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_find) == 0) {isym(ss,snd_find_1(get_cp(ss,str[3],str[4]),copy_string(str[1]),istr(str[2]),FALSE)); return(0);}
      if (strcmp(tok,S_find_sound) == 0) 
	{
	  filename = sstr(str[1]);
	  for (i=0;i<ss->max_sounds;i++)
	    {
	      sp = ss->sounds[i];
	      if ((snd_ok(sp)) && ((strcmp(filename,sp->fullname) == 0) || (strcmp(filename,sp->shortname) == 0)))
		{
		  isym(ss,i);
		  return(0);
		}
	    }
	  isym(ss,-1); 
	  return(0);
	}
      if (strcmp(tok,S_fit_data_on_open) == 0) {isym(ss,fit_data_on_open(ss)); return(0);}
      if (strcmp(tok,S_forward_graph) == 0) {goto_next_graph(current_channel(ss),prefix_fix(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_forward_mark) == 0) {goto_mark(current_channel(ss),prefix_fix(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_forward_mix) == 0) {goto_mix(current_channel(ss),prefix_fix(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_forward_sample) == 0) 
	{cp = current_channel(ss); if (cp) handle_cursor(cp,cursor_move(cp,prefix_fix(str[1]))); isym(ss,0); return(0);}
      if (strcmp(tok,S_find_mark) == 0) 
	{
	  if (str[1]) 
	    {
	      cp = get_cp(ss,str[2],str[3]); 
	      if ((cp) && (cp->marks)) 
		{
		  mps = cp->marks[cp->edit_ctr]; 
		  if (mps) 
		    {
		      if (isdigit((int)(str[1][0])))
			{
			  num = istr(str[1]);
			  for (i=0;i<=cp->mark_ctr[cp->edit_ctr];i++) 
			    if (mps[i]->samp == num) {isym(ss,i); return(0);}
			}
		      else
			{
			  filename = sstr(str[1]);
			  for (i=0;i<=cp->mark_ctr[cp->edit_ctr];i++) 
			    if ((mps[i]->name) && (strcmp(filename,mps[i]->name) == 0)) {isym(ss,i); return(0);}
			}
		    }
		}
	    } 
	  isym(ss,-1);
	  return(-0);
	} 
      if (strcmp(tok,S_frames) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) isym(ss,current_ed_samples(cp)); else isym(ss,0); return(0);}
      break;
    case 'g':
      if (strcmp(tok,"global-set-key") == 0) {set_keymap_entry(istr(str[1]),istr(str[2]),sstr(str[3]),istr(str[4])); isym(ss,0); return(0);}
      if (strcmp(tok,"global-unset-key") == 0) {set_keymap_entry(istr(str[1]),istr(str[2]),"5",0); isym(ss,0); return(0);} /* 5=cursor_no_action */
      if (strcmp(tok,S_graph_style) == 0) {isym(ss,graph_style(ss)); return(0);}
      if (strcmp(tok,S_graphing) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) isym(ss,cp->lisp_graphing); else isym(ss,0); return(0);}
      if (strcmp(tok,S_graph_ps) == 0) {snd_print(ss,eps_file(ss),1); isym(ss,0); return(0);}
      if (strcmp(tok,S_group_amp) == 0) {fsym(ss,mx_get_group_amp(ss,istr(str[1]),istr(str[2]))); return(0);}
      if (strcmp(tok,S_group_beg) == 0) {fsym(ss,mx_get_group_beg(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_group_dialog) == 0) {fire_up_group_browser(ss); isym(ss,0); return(0);}
      if (strcmp(tok,S_group_end) == 0) {fsym(ss,mx_get_group_end(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_group_okQ) == 0) {isym(ss,group_ok(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_group_speed) == 0) {fsym(ss,mx_get_group_speed(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_group_tempo) == 0) {fsym(ss,mx_get_group_tempo(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_groups) == 0) {isym(ss,active_groups(ss)); return(0);}
      if (strcmp(tok,S_guileQ) == 0) {isym(ss,0); return(0);}
      break;
    case 'h':
      if (strcmp(tok,S_header_type) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,(sp->hdr)->type); else isym(ss,0); return(0);}
      if (strcmp(tok,S_help_dialog) == 0) {snd_help(ss,sstr(str[1]),sstr(str[2])); isym(ss,0); return(0);}
      if (strcmp(tok,S_hide_listener) == 0) {if (ss->listening == LISTENER_OPEN) handle_listener(ss,LISTENER_LISTENING); isym(ss,0); return(0);}
#if HAVE_XmHTML
      if (strcmp(tok,S_html_dir) == 0) {ssym(ss,html_dir(ss)); return(0);}
#endif
      break;
    case 'i':
      if (strcmp(tok,S_initial_x0) == 0) {fsym(ss,initial_x0(ss)); return(0);}
      if (strcmp(tok,S_initial_x1) == 0) {fsym(ss,initial_x1(ss)); return(0);}
      if (strcmp(tok,S_initial_y0) == 0) {fsym(ss,initial_y0(ss)); return(0);}
      if (strcmp(tok,S_initial_y1) == 0) {fsym(ss,initial_y1(ss)); return(0);}
      if (strcmp(tok,S_insert_sample) == 0) 
	{
	  cp = get_cp(ss,str[3],str[4]); 
	  if (cp) 
	    {
	      ival = istr(str[1]);
	      if (ival >= 0) 
		{
		  ivals[0] = (int)(SNDLIB_SNDFIX * fstr(str[2])); 
		  insert_samples(ival,1,ivals,cp,S_insert_sample); 
		  check_for_first_edit(cp); 
		  update_graph(cp,NULL);
		}
	      else ss->eval_error = SND_NO_SUCH_SAMPLE; /* should we insert and move begin back? */
	    } 
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_insert_region) == 0) 
	{
	  ival = istr(str[2]); 
	  if (region_ok(ival))
	    {
	      cp = get_cp(ss,str[3],str[4]); 
	      if (cp) 
		{
		  finish_keyboard_selection(); 
		  insert_region(ival,istr(str[1]),cp,S_insert_region); 
		  update_graph(cp,NULL);
		} 
	    }
	  else ss->eval_error = SND_NO_SUCH_REGION;
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_insert_sound) == 0) 
	{
	  cp = get_cp(ss,str[3],str[4]);
	  if (cp)
	    {
	      filename = mus_complete_filename(sstr(str[1]));
	      ival = sound_chans(filename);
	      if (ival > 0)
		{
		  file_insert_samples(0,sound_samples(filename)/ival,filename,cp,istr(str[2]),DONT_DELETE_ME,S_insert_sound);
		  check_for_first_edit(cp);
		  update_graph(cp,NULL);
		}
	      else ss->eval_error = SND_NO_SUCH_FILE;
	    }
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_ircam_sound_file) == 0) {isym(ss,IRCAM_sound_file); return(0);}
      break;
    case 'j':
      break;
    case 'k':
      if (strcmp(tok,S_key) == 0) {keyboard_command(current_channel(ss),istr(str[1]),istr(str[2])); isym(ss,0); return(0);}
      break;
    case 'l':
      if (strcmp(tok,S_left_sample) == 0) 
	{cp = get_cp(ss,str[1],str[2]); if ((cp) && (cp->axis)) isym(ss,(cp->axis)->losamp); else isym(ss,0); return(0);}
      if (strcmp(tok,S_line_size) == 0) {isym(ss,line_size(ss)); return(0);}
      if (strcmp(tok,S_load) == 0) {isym(ss,snd_load_file(ss,mus_complete_filename(sstr(str[1])))); return(0);}
      break;
    case 'm':
      if (strcmp(tok,S_make_region) == 0) {cp = get_cp(ss,str[3],str[4]); if (cp) define_region(cp,istr(str[1]),istr(str[2]),FALSE); isym(ss,0); return(0);}
      if (strcmp(tok,S_mark_name) == 0) {m = get_m(ss,str[2],str[3],str[1]); if (m) ssym(ss,m->name); else isym(ss,0); return(0);}
      if (strcmp(tok,S_mark_sample) == 0) {m = get_m(ss,str[2],str[3],str[1]); if (m) isym(ss,m->samp); else isym(ss,0); return(0);}
      if (strcmp(tok,S_marks) == 0) 
	{cp = get_cp(ss,str[1],str[2]); if ((cp) && (cp->marks)) isym(ss,1+cp->mark_ctr[cp->edit_ctr]); else isym(ss,0); return(0);}
      if (strcmp(tok,S_max_fft_peaks) == 0) {isym(ss,max_fft_peaks(ss)); return(0);}
      if (strcmp(tok,S_max_fft_size) == 0) {isym(ss,max_fft_size(ss)); return(0);}
      if (strcmp(tok,S_max_regions) == 0) {isym(ss,max_regions(ss)); return(0);}
      if (strcmp(tok,S_max_sounds) == 0) {isym(ss,ss->max_sounds); return(0);}
      if (strcmp(tok,S_memo_sound) == 0) {isym(ss,0); return(0);}
      if (strcmp(tok,S_mix) == 0) /* file samp chan snd chn */
	{
	  cp = get_cp(ss,str[4],str[5]);
	  if (cp)
	    {
	      filename = mus_complete_filename(sstr(str[1]));
	      ival = sound_chans(filename);
	      if (ival > 0)
		file_mix_samples(istr(str[2]),sound_samples(filename)/ival,filename,cp,istr(str[3]),DONT_DELETE_ME,FALSE,1,S_mix);
	      else ss->eval_error = SND_NO_SUCH_FILE;
	    }
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_maxamp) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) fsym(ss,get_maxamp(ss,cp->sound,cp)); else isym(ss,0); return(0);}
      if (strcmp(tok,S_min_dB) == 0) {fsym(ss,ss->min_dB); return(0);}
      if (strcmp(tok,S_mix_amp) == 0) {fsym(ss,in_mix_amp(ss,istr(str[1]),istr(str[2]))); return(0);}
      if (strcmp(tok,S_mix_amp_scaler) == 0) {fsym(ss,get_mix_amp_scaler()); return(0);}
      if (strcmp(tok,S_mix_anchor) == 0) {isym(ss,mix_anchor(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_mix_groups) == 0) {isym(ss,mix_groups(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_mix_length) == 0) {isym(ss,mix_length(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_mix_position) == 0) {isym(ss,mix_position(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_mix_region) == 0) 
	{
	  ival = istr(str[3]);
	  if (region_ok(ival))
	    {
	      cp = get_cp(ss,str[4],str[5]); 
	      if (cp) mix_region(ival,cp,istr(str[1]),fstr(str[2])); 
	    }
	  else ss->eval_error = SND_NO_SUCH_REGION;
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_mix_speed) == 0) {fsym(ss,in_mix_speed(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_mix_speed_scaler) == 0) {fsym(ss,get_mix_speed_scaler()); return(0);}
      if (strcmp(tok,S_mix_state) == 0) {isym(ss,in_mix_state(ss,istr(str[1]))); return(0);}
      if (strcmp(tok,S_mix_tempo_scaler) == 0) {fsym(ss,get_mix_tempo_scaler()); return(0);}
      if (strcmp(tok,S_mix_waveform_height) == 0) {isym(ss,mix_waveform_height(ss)); return(0);}
      if (strcmp(tok,S_mixer_group_max_out_chans) == 0) {isym(ss,mixer_group_max_out_chans(ss)); return(0);}
      if (strcmp(tok,S_mixer_groups) == 0) {isym(ss,mixer_groups(ss)); return(0);}
      if (strcmp(tok,S_mixer_save_state_file) == 0) {ssym(ss,mixer_save_state_file(ss)); return(0);}
      if (strcmp(tok,S_movies) == 0) {isym(ss,movies(ss)); return(0);}
      break;
    case 'n':
      if (strcmp(tok,S_new_sound) == 0) 
	{
	  if (str[2] == NULL)
	    snd_new_file(ss,mus_complete_filename(sstr(str[1])),unsupported_sound_file,SNDLIB_UNSUPPORTED,0,0);
	  else snd_new_file(ss,mus_complete_filename(sstr(str[1])),istr(str[2]),istr(str[3]),istr(str[4]),istr(str[5]));
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_next_sound_file) == 0) {isym(ss,NeXT_sound_file); return(0);}
      if (strcmp(tok,S_nist_sound_file) == 0) {isym(ss,NIST_sound_file); return(0);}
      if (strcmp(tok,S_normalize_fft) == 0) {isym(ss,normalize_fft(ss)); return(0);}
      if (strcmp(tok,S_normalize_on_open) == 0) {isym(ss,normalize_on_open(ss)); return(0);}
      if (strcmp(tok,S_normalize_view) == 0) {normalize_all_sounds(ss); isym(ss,0); return(0);}
      break;
    case 'o': 
      if (strcmp(tok,S_okQ) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,snd_ok(sp)); else isym(ss,0); return(0);}
      if (strcmp(tok,S_open_sound) == 0) {sp = snd_open_file(sstr(str[1]),ss); if (sp) isym(ss,sp->index); else isym(ss,0); return(0);}
      if (strcmp(tok,S_open_alternate_sound) == 0) 
	{
	  sp = any_selected_sound(ss);
	  if (sp) snd_close_file(sp,ss);
	  sp = snd_open_file(sstr(str[1]),ss);
	  if (sp) isym(ss,sp->index); else isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_or) == 0) {lsym(ss,name_to_env(str[1])); return(0);}
      /* this is for clm-snd envelope communication -- a necessary kludge! */
      if (strcmp(tok,S_orientation_dialog) == 0) {start_orientation_dialog(ss,0,0); isym(ss,0); return(0);}
      if (strcmp(tok,S_override_data_location) == 0) 
	{
	  sp = get_sp(ss,str[2]);
	  if (sp)
	    {
	      override_sound_header(sp->fullname,-1,-1,-1,-1,istr(str[1]),-1);
	      snd_update(ss,sp);
	    }
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_override_data_format) == 0) 
	{
	  sp = get_sp(ss,str[2]);
	  if (sp)
	    {
	      override_sound_header(sp->fullname,-1,-1,istr(str[1]),-1,-1,-1);
	      snd_update(ss,sp);
	    }
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_override_data_size) == 0) 
	{
	  sp = get_sp(ss,str[2]);
	  if (sp)
	    {
	      override_sound_header(sp->fullname,-1,-1,-1,-1,-1,istr(str[1]));
	      snd_update(ss,sp);
	    }
	  isym(ss,0); 
	  return(0);
	}
      break;
    case 'p':
      if (strcmp(tok,S_peaks) == 0) {cp = get_cp(ss,str[2],str[3]); if (cp) display_fft_peaks(cp,sstr(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_play_region) == 0) 
	{
	  ival = istr(str[1]);
	  if (region_ok(ival))
	    play_region(ss,istr(str[1]),NULL); 
	  else ss->eval_error = SND_NO_SUCH_REGION;
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_preload_directory) == 0) {add_directory_to_prevlist(ss,sstr(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_preload_file) == 0) {remember_me(ss,filename_without_home_directory(sstr(str[1])),sstr(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_previous_files_sort) == 0) {isym(ss,previous_files_sort(ss)); return(0);}
      if (strcmp(tok,S_print_length) == 0) {isym(ss,print_length(ss)); return(0);}
      if (strcmp(tok,S_protect_region) == 0) 
	{if (str[2]) ival = istr(str[2]); else ival = 1; set_region_protect(istr(str[1]),ival); isym(ss,0); return(0);}
      if (strcmp(tok,S_play) == 0) 
	{
	  if (str[3]) 
	    {
	      cp = get_cp(ss,str[2],str[3]);
	      if (cp) start_playing(cp,istr(str[1])); 
	    }
	  else 
	    {
	      sp = get_sp(ss,str[2]); 
	      if (sp) start_playing(sp,istr(str[1]));
	    }
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_play_and_wait) == 0) 
	{
	  if (str[3]) 
	    {
	      cp = get_cp(ss,str[2],str[3]);
	      if (cp) play_to_end(cp,istr(str[1])); 
	    }
	  else 
	    {
	      sp = get_sp(ss,str[2]); 
	      if (sp) play_to_end(sp,istr(str[1]));
	    }
	  isym(ss,0);
	  return(0);
	}
      break;
    case 'r':
      if (strcmp(tok,S_raw_chans) == 0) {isym(ss,raw_chans(ss)); return(0);}
      if (strcmp(tok,S_raw_format) == 0) {isym(ss,raw_format(ss)); return(0);}
      if (strcmp(tok,S_raw_sound_file) == 0) {isym(ss,raw_sound_file); return(0);}
      if (strcmp(tok,S_raw_srate) == 0) {isym(ss,raw_srate(ss)); return(0);}
      if (strcmp(tok,S_raw_type) == 0) {isym(ss,raw_type(ss)); return(0);}
      if (strcmp(tok,S_read_only) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->read_only); else isym(ss,0); return(0);}
      if (strcmp(tok,S_recorder_dialog) == 0) {snd_record_file(ss); isym(ss,0); return(0);}
      if (strcmp(tok,S_recorder_autoload) == 0) {isym(ss,recorder_autoload(ss)); return(0);}
      if (strcmp(tok,S_recorder_buffer_size) == 0) {isym(ss,recorder_buffer_size(ss)); return(0);}
      if (strcmp(tok,S_recorder_file) == 0) {ssym(ss,recorder_file(ss)); return(0);}
      if (strcmp(tok,S_recorder_gain) == 0) {fsym(ss,read_record_state(AUDIO_GAINS,istr(str[1]),0)); return(0);}
      if (strcmp(tok,S_recorder_in_amp) == 0) {fsym(ss,read_record_state(REC_IN_AMPS,istr(str[1]),istr(str[2]))); return(0);}
      if (strcmp(tok,S_recorder_in_format) == 0) {isym(ss,recorder_in_format(ss)); return(0);}
      if (strcmp(tok,S_recorder_max_duration) == 0) {fsym(ss,recorder_max_duration(ss)); return(0);}
      if (strcmp(tok,S_recorder_out_amp) == 0) {fsym(ss,read_record_state(REC_OUT_AMPS,istr(str[1]),0)); return(0);}
      if (strcmp(tok,S_recorder_out_chans) == 0) {isym(ss,recorder_out_chans(ss)); return(0);}
      if (strcmp(tok,S_recorder_out_format) == 0) {isym(ss,recorder_out_format(ss)); return(0);}
      if (strcmp(tok,S_recorder_srate) == 0) {isym(ss,recorder_srate(ss)); return(0);}
      if (strcmp(tok,S_recorder_trigger) == 0) {fsym(ss,recorder_trigger(ss)); return(0);}
      if (strcmp(tok,S_region_chans) == 0) 
	{ival = istr(str[1]); if (region_ok(ival)) isym(ss,region_chans(ival)); else ss->eval_error = SND_NO_SUCH_REGION; return(0);}
      if (strcmp(tok,S_region_dialog) == 0) {if (snd_regions() > 0) View_Region_Callback(main_PANE(ss),(XtPointer)ss,NULL); isym(ss,0); return(0);}
      if (strcmp(tok,S_region_length) == 0) 
	{ival = istr(str[1]); if (region_ok(ival)) isym(ss,region_len(ival)); else ss->eval_error = SND_NO_SUCH_REGION; return(0);}
      if (strcmp(tok,S_region_maxamp) == 0) 
	{ival = istr(str[1]); if (region_ok(ival)) fsym(ss,region_maxamp(ival)); else ss->eval_error = SND_NO_SUCH_REGION; return(0);}
      if (strcmp(tok,S_region_sample) == 0) {finish_keyboard_selection(); fsym(ss,region_sample(istr(str[2]),istr(str[3]),istr(str[1]))); return(0);}
      if (strcmp(tok,S_region_srate) == 0) 
	{ival = istr(str[1]); if (region_ok(ival)) isym(ss,region_srate(ival)); else ss->eval_error = SND_NO_SUCH_REGION; return(0);}
      if (strcmp(tok,S_regions) == 0) {isym(ss,snd_regions()); return(0);}
      if (strcmp(tok,S_report_in_minibuffer) == 0) {sp = get_sp(ss,str[2]); if (sp) report_in_minibuffer(sp,str[1]); isym(ss,0); return(0);}
      if (strcmp(tok,S_restore_control_panel) == 0) {sp = get_sp(ss,str[1]); if (sp) restore_control_state(sp); isym(ss,0); return(0);}
      if (strcmp(tok,S_reverb_decay) == 0) {fsym(ss,reverb_decay(ss)); return(0);}
      if (strcmp(tok,S_reverb_feedback) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->local_revfb); else isym(ss,0); return(0);}
      if (strcmp(tok,S_reverb_length) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->revlen); else isym(ss,0); return(0);}
      if (strcmp(tok,S_reverb_lowpass) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->local_revlp); else isym(ss,0); return(0);}
      if (strcmp(tok,S_reverb_scale) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->revscl); else isym(ss,0); return(0);}
      if (strcmp(tok,S_reverbing) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->reverbing); else isym(ss,0); return(0);}
      if (strcmp(tok,S_reverse_sound) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) reverse_sound(cp,FALSE); isym(ss,0); return(0);}
      if (strcmp(tok,S_reverse_selection) == 0) {cp = get_cp(ss,NULL,NULL); if (cp) reverse_sound(cp,TRUE); isym(ss,0); return(0);}
      if (strcmp(tok,S_riff_sound_file) == 0) {isym(ss,RIFF_sound_file); return(0);}
      if (strcmp(tok,S_right_sample) == 0) 
	{cp = get_cp(ss,str[1],str[2]); if ((cp) && (cp->axis)) isym(ss,(cp->axis)->hisamp); else isym(ss,0); return(0);}
      if (strcmp(tok,S_redo) == 0) 
	{
	  ival = istr(str[1]); 
	  if (ival == 0) ival = 1; 
	  cp = get_cp(ss,str[2],str[3]); 
	  if (cp) 
	    {
	      redo_EDIT(cp,ival); 
	      update_graph(cp,NULL);
	    }
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_revert_sound) == 0) 
	{
	  sp = get_sp(ss,str[1]);
	  if (sp)
	    {
	      for (i=0;i<sp->nchans;i++) 
		{
		  revert_edits(sp->chans[i],NULL); 
		  update_graph(sp->chans[i],NULL);
		}
	      reflect_file_revert_in_label(sp);
	      reflect_file_revert_in_menu(ss);
	    }
	  isym(ss,0);
	  return(0);
	}
      break;
    case 's':
      if ((tok[1] == 'e') && (tok[2] == 't') && (tok[3] == '-'))
	{
	  return(handle_set(ss,tok,str));
	}
      if (strcmp(tok,S_sample) == 0) {cp = get_cp(ss,str[2],str[3]); if (cp) fsym(ss,sample(istr(str[1]),cp)); return(0);}
      if (strcmp(tok,S_save_control_panel) == 0) {sp = get_sp(ss,str[1]); if (sp) save_control_state(sp); isym(ss,0); return(0);}
      if (strcmp(tok,S_save_envelopes) == 0) {g_save_envelopes(ss,str[1]); isym(ss,0); return(0);}
      if (strcmp(tok,S_save_macros) == 0) {save_macros(ss); isym(ss,0); return(0);}
      if (strcmp(tok,S_save_marks) == 0) {sp = get_sp(ss,str[1]); if (sp) save_marks(sp); isym(ss,0); return(0);}
      if (strcmp(tok,S_save_options) == 0) 
	{
	  FILE *fd;
	  fd = fopen(mus_complete_filename(sstr(str[1])),"w");
	  if (fd)
	    {
	      save_snd_state_options(ss,fd); 
	      fclose(fd);
	    }
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_save_region) == 0) 
	{
	  ival = istr(str[1]);
	  if (region_ok(ival))
	    save_region(ss,ival,mus_complete_filename(sstr(str[2])),istr(str[3])); 
	  else ss->eval_error = SND_NO_SUCH_REGION;
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_save_selection) == 0)
	{
	  save_selection(ss,mus_complete_filename(sstr(str[1])),istr(str[2]),istr(str[3]),istr(str[4]),sstr(str[5]));
	  isym(ss,0); return(0);
	}
      if (strcmp(tok,S_save_state_on_exit) == 0) {isym(ss,save_state_on_exit(ss)); return(0);}
      if (strcmp(tok,S_save_state) == 0) {save_state(ss,sstr(str[1])); isym(ss,0); return(0);}
      if (strcmp(tok,S_save_state_file) == 0) {ssym(ss,save_state_file(ss)); return(0);}
      if (strcmp(tok,S_scale_selection_to) == 0) 
	{
	  if (region_ok(0))
	    {
	      scls[0] = fstr(str[1]);
	      scale_to(ss,NULL,NULL,scls,1,TRUE);
	      fsym(ss,scls[0]);
	    }
	  else 
	    {
	      ss->eval_error = SND_NO_ACTIVE_SELECTION;
	      isym(ss,-1);
	    }
	  return(0);
	}
      if (strcmp(tok,S_scale_selection_by) == 0) 
	{
	  if (region_ok(0))
	    {
	      scls[0] = fstr(str[1]);
	      scale_by(ss,NULL,NULL,scls,1,TRUE);
	      fsym(ss,scls[0]);
	    }
	  else 
	    {
	      ss->eval_error = SND_NO_ACTIVE_SELECTION;
	      isym(ss,-1);
	    }
	  return(0);
	}
      if (strcmp(tok,S_scale_to) == 0) 
	{
	  cp = get_cp(ss,str[2],str[3]);
	  if (cp)
	    {
	      scls[0] = fstr(str[1]);
	      scale_to(ss,cp->sound,cp,scls,1,FALSE); 
	    }
	  fsym(ss,scls[0]);
	  return(0);
	}
      if (strcmp(tok,S_scale_by) == 0) 
	{
	  cp = get_cp(ss,str[2],str[3]);
	  if (cp)
	    {
	      scls[0] = fstr(str[1]);
	      scale_by(ss,cp->sound,cp,scls,1,FALSE); 
	    }
	  fsym(ss,scls[0]);
	  return(0);
	}
      if (strcmp(tok,S_select_all) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) define_region(cp,0,current_ed_samples(cp),FALSE); isym(ss,0); return(0);}
      if (strcmp(tok,S_select_channel) == 0) 
	{
	  sp = any_selected_sound(ss);
	  ival = istr(str[1]);
	  if ((sp) && (ival >= 0) && (ival < sp->nchans))
	    select_channel(sp,ival); 
	  else ss->eval_error = SND_NO_SUCH_CHANNEL;
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_select_region) == 0) 
	{
	  ival = istr(str[1]);
	  if (region_ok(ival))
	    select_region_and_update_browser(ss,ival); 
	  else ss->eval_error = SND_NO_SUCH_REGION;
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_select_sound) == 0) 
	{
	  ival = istr(str[1]); 
	  if ((ival >= 0) && (ival < ss->max_sounds) && (snd_ok(ss->sounds[ival])))
	    select_channel(ss->sounds[ival],0);
	  else ss->eval_error = SND_NO_SUCH_SOUND;
	  isym(ss,0); 
	  return(0);
	}
      if (strcmp(tok,S_selected_channel) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->selected_channel); else isym(ss,0); return(0);}
      if (strcmp(tok,S_selection_beg) == 0) {if (selection_is_current()) isym(ss,selection_beg(NULL)); else isym(ss,0); return(0);}
      if (strcmp(tok,S_selection_length) == 0) {if (selection_is_current()) isym(ss,region_len(0)); else isym(ss,0); return(0);}
      if (strcmp(tok,S_short_file_name) == 0) {sp = get_sp(ss,str[1]); if (sp) ssym(ss,sp->shortname); else isym(ss,0); return(0);}
      if (strcmp(tok,S_show_axes) == 0) {isym(ss,show_axes(ss)); return(0);}
#if (XmVERSION == 1)
      if (strcmp(tok,S_show_edit_history) == 0) {isym(ss,show_edit_history(ss)); return(0);}
#endif
      if (strcmp(tok,S_show_fft_peaks) == 0) {isym(ss,show_fft_peaks(ss)); return(0);}
      if (strcmp(tok,S_show_listener) == 0) {if (ss->listening != LISTENER_OPEN) handle_listener(ss,LISTENER_OPEN); isym(ss,0); return(0);}
      if (strcmp(tok,S_show_marks) == 0) {isym(ss,show_marks(ss)); return(0);}
      if (strcmp(tok,S_show_mix_consoles) == 0) {isym(ss,show_mix_consoles(ss)); return(0);}
      if (strcmp(tok,S_show_mix_waveforms) == 0) {isym(ss,show_mix_waveforms(ss)); return(0);}
      if (strcmp(tok,S_show_selection_transform) == 0) {isym(ss,show_selection_transform(ss)); return(0);}
      if (strcmp(tok,S_show_usage_stats) == 0) {isym(ss,show_usage_stats(ss)); return(0);}
      if (strcmp(tok,S_show_y_zero) == 0) {isym(ss,show_y_zero(ss)); return(0);}
      if (strcmp(tok,S_showing_controls) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,control_panel_open(sp)); else isym(ss,0); return(0);}
      if (strcmp(tok,S_sinc_width) == 0) {isym(ss,sinc_width(ss)); return(0);}
      if (strcmp(tok,S_smooth) == 0)
	{
	  cp = get_cp(ss,str[3],str[4]);
	  if (cp) cos_smooth(cp,istr(str[1]),istr(str[2]),FALSE,S_smooth);
	  isym(ss,0); return(0);
	}
      if (strcmp(tok,S_smooth_selection) == 0)
	{
	  cp = get_cp(ss,NULL,NULL);
	  if (cp) cos_smooth(cp,0,0,TRUE,S_smooth_selection);
	  isym(ss,0); return(0);
	}
      if (strcmp(tok,S_snd_clm_samples) == 0)
	  {
	    file_info *hdr;
	    sp = NULL;
	    if ((str[1]) &&(*(str[1])))
	      {
		filename = sstr(str[1]);
		sp = find_sound(ss,filename);
	      }
	    if (!sp) sp = any_selected_sound(ss);
	    if (sp)
	      {
		filename = snd_tempnam(ss);
		hdr = sp->hdr;
		save_edits_2(sp,filename,hdr->type,hdr->format,hdr->srate,NULL);
		ssym(ss,filename);
	      }
	    else isym(ss,0);
	    return(0);
	  }
      if (strcmp(tok,S_snd_16_linear) == 0) {isym(ss,SNDLIB_16_LINEAR); return(0);}
      if (strcmp(tok,S_snd_16_linear_little_endian) == 0) {isym(ss,SNDLIB_16_LINEAR_LITTLE_ENDIAN); return(0);}
      if (strcmp(tok,S_snd_24_linear) == 0) {isym(ss,SNDLIB_24_LINEAR); return(0);}
      if (strcmp(tok,S_snd_32_float) == 0) {isym(ss,SNDLIB_32_FLOAT); return(0);}
      if (strcmp(tok,S_snd_32_float_little_endian) == 0) {isym(ss,SNDLIB_32_FLOAT_LITTLE_ENDIAN); return(0);}
      if (strcmp(tok,S_snd_32_linear) == 0) {isym(ss,SNDLIB_32_LINEAR); return(0);}
      if (strcmp(tok,S_snd_32_linear_little_endian) == 0) {isym(ss,SNDLIB_32_LINEAR_LITTLE_ENDIAN); return(0);}
      if (strcmp(tok,S_snd_64_double) == 0) {isym(ss,SNDLIB_64_DOUBLE); return(0);}
      if (strcmp(tok,S_snd_8_alaw) == 0) {isym(ss,SNDLIB_8_ALAW); return(0);}
      if (strcmp(tok,S_snd_8_linear) == 0) {isym(ss,SNDLIB_8_LINEAR); return(0);}
      if (strcmp(tok,S_snd_8_mulaw) == 0) {isym(ss,SNDLIB_8_MULAW); return(0);}
      if (strcmp(tok,S_snd_8_unsigned) == 0) {isym(ss,SNDLIB_8_UNSIGNED); return(0);}
      if (strcmp(tok,S_snd_print) == 0) 
	{
	  ss->result_printout = MESSAGE_WITHOUT_CARET;
	  snd_append_command(ss,sstr(str[1]));
	  return(0);
	}
      if (strcmp(tok,S_sound_chans) == 0) {isym(ss,sound_chans(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_comment) == 0) {ssym(ss,sound_comment(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_data_format) == 0) {isym(ss,sound_data_format(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_data_location) == 0) {isym(ss,sound_data_location(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_datum_size) == 0) {isym(ss,sound_datum_size(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_format_name) == 0) {ssym(ss,sound_format_name(istr(str[1]))); return(0);}
      if (strcmp(tok,S_sound_header_type) == 0) {isym(ss,sound_header_type(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_length) == 0) {isym(ss,sound_length(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_samples) == 0) {isym(ss,sound_samples(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_srate) == 0) {isym(ss,sound_srate(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_sound_type_name) == 0) {ssym(ss,sound_type_name(istr(str[1]))); return(0);}
      if (strcmp(tok,S_sound_type_specifier) == 0) {isym(ss,sound_type_specifier(mus_complete_filename(sstr(str[1])))); return(0);}
      if (strcmp(tok,S_spectro_cutoff) == 0) {fsym(ss,spectro_cutoff(ss)); return(0);}
      if (strcmp(tok,S_spectro_hop) == 0) {isym(ss,spectro_hop(ss));  return(0);}
      if (strcmp(tok,S_spectro_x_angle) == 0) {fsym(ss,spectro_x_angle(ss)); return(0);}
      if (strcmp(tok,S_spectro_x_scale) == 0) {fsym(ss,spectro_x_scale(ss)); return(0);}
      if (strcmp(tok,S_spectro_y_angle) == 0) {fsym(ss,spectro_y_angle(ss)); return(0);}
      if (strcmp(tok,S_spectro_y_scale) == 0) {fsym(ss,spectro_y_scale(ss)); return(0);}
      if (strcmp(tok,S_spectro_z_angle) == 0) {fsym(ss,spectro_z_angle(ss)); return(0);}
      if (strcmp(tok,S_spectro_z_scale) == 0) {fsym(ss,spectro_z_scale(ss)); return(0);}
      if (strcmp(tok,S_speed) == 0) {sp = get_sp(ss,str[1]); if (sp) fsym(ss,sp->srate); else isym(ss,0); return(0);}
      if (strcmp(tok,S_speed_style) == 0) {isym(ss,speed_style(ss)); return(0);}
      if (strcmp(tok,S_speed_tones) == 0) {isym(ss,speed_tones(ss)); return(0);}
      if (strcmp(tok,S_squelch_update) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) isym(ss,cp->squelch_update); else isym(ss,0); return(0);}
      if (strcmp(tok,S_srate) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,(sp->hdr)->srate); else isym(ss,0); return(0);}
      if (strcmp(tok,S_src_sound) == 0) {src_env_or_num(ss,NULL,fstr(str[1]),TRUE,FALSE,S_src_sound,FALSE); isym(ss,0); return(0);} /* no env case */
      if (strcmp(tok,S_src_selection) == 0) {src_env_or_num(ss,NULL,fstr(str[1]),TRUE,FALSE,S_src_selection,TRUE); isym(ss,0); return(0);} /* no env case */
      if (strcmp(tok,S_stop_playing) == 0) {sp = get_sp(ss,str[1]); if (sp) stop_playing_sound(sp); isym(ss,0); return(0);}
      if (strcmp(tok,S_syncing) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->syncing); return(0);}
      if (strcmp(tok,S_selected_sound) == 0) {isym(ss,ss->selected_sound); return(0);}
      if (strcmp(tok,S_save_sound) == 0) {sp = get_sp(ss,str[1]); if (sp) save_edits(sp,NULL); isym(ss,0); return(0);}
      if (strcmp(tok,S_save_sound_as) == 0) 
	{
	  sp = get_sp(ss,str[2]);
	  if (str[3] == NULL)
	    save_edits_2(sp,mus_complete_filename(sstr(str[1])),(sp->hdr)->type,(sp->hdr)->format,(sp->hdr)->srate,NULL);
	  else save_edits_2(sp,mus_complete_filename(sstr(str[1])),istr(str[3]),istr(str[4]),istr(str[5]),NULL);
	  isym(ss,0);
	  return(0);
	}
      break;
    case 't':
      if (strcmp(tok,S_temp_dir) == 0) {ssym(ss,temp_dir(ss)); return(0);}
      if (strcmp(tok,S_transform_dialog) == 0) {fire_up_transform_dialog(ss); isym(ss,0); return(0);}
      if (strcmp(tok,S_transform_type) == 0) {isym(ss,transform_type(ss)); return(0);}
      if (strcmp(tok,S_trap_segfault) == 0) {isym(ss,trap_segfault(ss)); return(0);}
      break;
    case 'u':
      if (strcmp(tok,S_uniting) == 0) {sp = get_sp(ss,str[1]); if (sp) isym(ss,sp->combining); return(0);}
      if (strcmp(tok,S_update_fft) == 0) {cp = get_cp(ss,str[1],str[2]); calculate_fft(cp,NULL); isym(ss,0); return(0);}
      if (strcmp(tok,S_update_graph) == 0) {cp = get_cp(ss,str[1],str[2]); update_graph(cp,NULL); isym(ss,0); return(0);}
      if (strcmp(tok,S_update_sound) == 0) {sp = get_sp(ss,str[1]); if (sp) snd_update(ss,sp); isym(ss,0); return(0);}
      if (strcmp(tok,S_use_raw_defaults) == 0) {isym(ss,use_raw_defaults(ss)); return(0);}
      if (strcmp(tok,S_undo) == 0) 
	{
	  ival = istr(str[1]); 
	  if (ival == 0) ival = 1; 
	  cp = get_cp(ss,str[2],str[3]); 
	  if (cp) 
	    {
	      undo_EDIT(cp,ival); 
	      update_graph(cp,NULL);
	    }
	  isym(ss,0);
	  return(0);
	}
      if (strcmp(tok,S_unbind_key) == 0) {set_keymap_entry(istr(str[1]),istr(str[2]),"5",0); isym(ss,0); return(0);} /* 5=cursor_no_action */
      break;
    case 'v':
      if (strcmp(tok,S_verbose_cursor) == 0) {isym(ss,verbose_cursor(ss)); return(0);}
      if (strcmp(tok,S_version) == 0) {ssym(ss,SND_VERSION); return(0);}
      if (strcmp(tok,S_vu_font) == 0) {ssym(ss,vu_font(ss)); return(0);}
      if (strcmp(tok,S_vu_font_size) == 0) {fsym(ss,vu_font_size(ss)); return(0);}
      if (strcmp(tok,S_vu_size) == 0) {fsym(ss,vu_size(ss)); return(0);}
      if (strcmp(tok,S_view_sound) == 0) 
	{
	  ss->viewing = 1;
	  sp = snd_open_file(sstr(str[1]),ss);
	  ss->viewing = 0;
	  if (sp) isym(ss,sp->index); else isym(ss,0);
	  return(0);
	}
      break;
    case 'w':
      if (strcmp(tok,S_wavelet_type) == 0) {isym(ss,wavelet_type(ss)); return(0);}
      if (strcmp(tok,S_waving) == 0) {cp = get_cp(ss,str[1],str[2]); if (cp) isym(ss,cp->waving); else isym(ss,0); return(0);}
      if (strcmp(tok,S_wavo) == 0) {isym(ss,wavo(ss)); return(0);}
      if (strcmp(tok,S_wavo_hop) == 0) {isym(ss,wavo_hop(ss)); return(0);}
      if (strcmp(tok,S_wavo_trace) == 0) {isym(ss,wavo_trace(ss)); return(0);}
      if (strcmp(tok,S_window_height) == 0) {isym(ss,snd_window_height(ss)); return(0);}
      if (strcmp(tok,S_window_width) == 0) {isym(ss,snd_window_width(ss)); return(0);}
      if (strcmp(tok,S_window_x) == 0) {isym(ss,snd_window_x(ss)); return(0);}
      if (strcmp(tok,S_window_y) == 0) {isym(ss,snd_window_y(ss)); return(0);}
      break;
    case 'x':
      if (strcmp(tok,S_x_axis_style) == 0) {isym(ss,x_axis_style(ss)); return(0);}
      if (strcmp(tok,S_x_bounds) == 0) {cp = get_cp(ss,str[3],str[4]); if (cp) fsym(ss,(cp->axis)->x0); else isym(ss,0); return(0);}
      if (strcmp(tok,S_xmax) == 0) {fsym(ss,xmax(ss)); return(0);}
      if (strcmp(tok,S_xmin) == 0) {fsym(ss,xmin(ss)); return(0);}
      break;
    case 'X':
#if HAVE_XmHTML
      if (strcmp(tok,S_XmHTML) == 0) {isym(ss,1); return(0);}
#else
      if (strcmp(tok,S_XmHTML) == 0) {isym(ss,0); return(0);}
#endif
      break;
    case 'y':
      if (strcmp(tok,S_y_bounds) == 0) {cp = get_cp(ss,str[3],str[4]); if (cp) fsym(ss,(cp->axis)->y0); else isym(ss,0); return(0);}
      if (strcmp(tok,S_ymax) == 0) {fsym(ss,ymax(ss)); return(0);}
      if (strcmp(tok,S_ymin) == 0) {fsym(ss,ymin(ss)); return(0);}
      break;
    case 'z':
      if (strcmp(tok,S_zero_pad) == 0) {isym(ss,zero_pad(ss)); return(0);}
      if (strcmp(tok,S_zoom_focus_style) == 0) {isym(ss,zoom_focus_style(ss)); return(0);}
      break;
    default: break;
    }
  isym(ss,-1); /* don't hang clm on mistyped input! */
  return(-1);
}

static int clm_buffer_in_progress = 0;
static char init_file_buffer[128];

void snd_load_init_file(snd_state *ss, int nog, int noi)
{
  /* look for ".snd" on the home directory, and load it using the lisp-like CLM syntax given above */
  int fd;
  char *str;
  no_guile_errors = 1;
#ifdef SND_CONF
  if (nog == 0)
    {
      fd = open(SND_CONF,O_RDONLY,0);
      if (fd != -1)
	{
	  if (!clm_buffer) 
	    {
	      clm_buffer = (char *)CALLOC(CLM_BUFFER_SIZE,sizeof(char));
	      clm_buffer_size = CLM_BUFFER_SIZE;
	    }
	  clm_buffer_in_progress = 1;
	  while (get_clm_string(ss,fd,FALSE));
	  clm_buffer_in_progress = 0;
	  close(fd);
	}
    }
#endif
  if ((ss->init_file) && (noi == 0))
    {
      str = ss->init_file;
      if ((*str) == '~')
	{
	  strcpy(init_file_buffer,getenv("HOME"));
	  strcat(init_file_buffer,++str);
	  fd = open(init_file_buffer,O_RDONLY,0);
	}
      else fd = open(ss->init_file,O_RDONLY,0);
      if (fd == -1) return;
      if (!clm_buffer) 
	{
	  clm_buffer = (char *)CALLOC(CLM_BUFFER_SIZE,sizeof(char));
	  clm_buffer_size = CLM_BUFFER_SIZE;
	}
      clm_buffer_in_progress = 1;
      while (get_clm_string(ss,fd,FALSE));
      clm_buffer_in_progress = 0;
      close(fd);
    }
  no_guile_errors = 0;
}

int snd_load_file(snd_state *ss,char *filename)
{
  int fd,old_progress;
  char *str,*saved_buf;
  str=filename;
  saved_buf = NULL;
  if ((*str) == '~')
    {
      strcpy(init_file_buffer,getenv("HOME"));
      strcat(init_file_buffer,++str);
      fd = open(init_file_buffer,O_RDONLY,0);
    }
  else fd = open(str,O_RDONLY,0);
  if (fd == -1) return(-1);
  if (!clm_buffer) 
    {
      clm_buffer = (char *)CALLOC(CLM_BUFFER_SIZE,sizeof(char));
      clm_buffer_size = CLM_BUFFER_SIZE;
    }
  old_progress = clm_buffer_in_progress;
  if (clm_buffer_in_progress)
    {
      saved_buf = (char *)CALLOC(clm_buffer_size,sizeof(char));
      strcpy(saved_buf,clm_buffer);
    }
  clm_buffer_in_progress = 1;
  while (get_clm_string(ss,fd,FALSE));
  close(fd);
  clm_buffer_in_progress = old_progress;
  if (saved_buf)
    {
      strcpy(clm_buffer,saved_buf);
      FREE(saved_buf);
    }
  return(0);
}

#endif /* (not) HAVE_GUILE */

#define NUM_COMMANDS 703

static char *snd_commands[NUM_COMMANDS]={
  S_XmHTML,
  S_abort,S_abortQ,S_activate_listener,S_active_sounds,S_add_mark,S_add_sound_file_extension,S_add_to_main_menu,S_add_to_menu,S_amp,
  S_amplitude_env,S_append_to_minibuffer,S_ask_before_overwrite,
  S_audio_output_device,S_auto_resize,S_auto_update,S_autocorrelate,S_autocorrelation,

  S_backward_graph,S_backward_mark,S_backward_mix,S_backward_sample,S_bartlett_window,S_basic_color,S_bind_key,
  S_blackman2_window,S_blackman3_window,S_blackman4_window,S_bomb,

  S_call_apply,S_call_plug,S_call_plug_selection,S_cauchy_window,S_change_menu_label,S_channel_style,S_channels,S_channels_combined,S_channels_separate,
  S_channels_superimposed,S_chans,S_chebyshev_transform,S_clear_audio_inputs,S_clm_dialog,S_clm_snd_close,S_clm_snd_region,
  S_clm_snd_replace_samples,S_clm_snd_samples,S_clm_snd_set_samples,S_clm_snd_update,S_clmQ,S_close_hook,
  S_close_sound,S_close_sound_file,S_color_cutoff,S_color_dialog,S_color_inverted,S_color_scale,S_colorQ,S_colormap,
  S_comment,S_contrast,S_contrast_amp,S_contrasting,
  S_convolve_arrays,S_convolve_selection_with,S_convolve_with,S_corruption_time,S_count_matches,
  S_cursor,S_cursor_claim_selection,S_cursor_color,
  S_cursor_follows_play,S_cursor_in_middle,S_cursor_in_view,S_cursor_no_action,
  S_cursor_on_left,S_cursor_on_right,S_cursor_update_display,S_cut,

  S_dac_size,S_data_color,S_data_format,S_data_location,S_default_amp,S_default_contrast,S_default_contrast_amp,S_default_contrasting,
  S_default_expand,S_default_expand_hop,S_default_expand_length,S_default_expand_ramp,S_default_expanding,S_default_filter_dBing,
  S_default_filter_order,S_default_filtering,S_default_output_type,S_default_reverb_feedback,S_default_reverb_length,
  S_default_reverb_lowpass,S_default_reverb_scale,S_default_reverbing,S_default_speed,S_delete_int_samples,
  S_delete_mark,S_delete_marks,S_delete_region,S_delete_sample,S_delete_samples,S_describe_audio,S_describe_plug,
  S_dismiss_all_dialogs,S_dot_size,

  S_edit_header_dialog,S_edit_history_width,S_edits,
  S_env_selection,S_env_sound,S_enved_base,S_enved_clipping,S_enved_dBing,
  S_enved_dialog,S_enved_exping,S_enved_power,S_enved_target,
  S_enved_waveform_color,S_enved_waving,S_eps_file,S_exit,S_exit_hook,S_expand,S_expand_hop,
  S_expand_length,S_expand_ramp,S_expanding,S_exponential_window,

  S_fft,S_fft_beta,S_fft_hook,S_fft_log_frequency,S_fft_log_magnitude,
  S_fft_size,S_fft_style,S_fft_window,S_ffting,S_file_dialog,S_file_name,
  S_filter_dBing,S_filter_env,S_filter_env_order,
  S_filter_order,S_filter_selection,S_filter_sound,S_filter_waveform_color,S_filtering,
  S_find,S_find_mark,S_find_sound,S_finish_progress_report,
  S_fit_data_on_open,S_focus_active,S_focus_left,S_focus_middle,
  S_focus_right,S_forward_graph,S_forward_mark,S_forward_mix,S_forward_sample,S_fourier_transform,S_frames,

  S_gaussian_window,S_graph,S_graph_ps,S_graph_color,S_graph_cursor,
  S_graph_dots,S_graph_dots_and_lines,S_graph_filled,S_graph_hook,
  S_graph_lines,S_graph_lollipops,S_graph_style,S_graphing,S_group_amp,S_group_beg,S_group_dialog,S_group_end,S_group_okQ,
  S_group_speed,S_group_tempo,S_groups,S_guileQ,

  S_hadamard_transform,S_hamming_window,S_hankel_transform,S_hanning_window,S_header_type,S_help_dialog,
  S_hide_listener,S_highlight_color,S_html_dir,

  S_in,S_initial_x0,S_initial_x1,S_initial_y0,S_initial_y1,S_insert_int_samples,S_insert_region,S_insert_sample,
  S_insert_samples,S_insert_sound,

  S_kaiser_window,S_key,S_key_press_hook,S_keyboard_no_action,

  S_left_sample,S_legendre_transform,S_line_size,S_listener_color,S_listener_prompt,S_load_colormap,

  S_make_color,S_make_region,S_make_vct,
  S_map_across_all_chans,S_map_across_chans,S_map_across_sound_chans,S_map_all_chans,S_map_chan,S_map_chans,S_map_sound_chans,
  S_mark_color,S_mark_name,S_mark_sample,S_marks,S_max_fft_peaks,
  S_max_fft_size, S_max_regions,S_max_sounds,S_maxamp,S_memo_sound,S_min_dB,S_mix,
  S_mix_amp,S_mix_amp_scaler,S_mix_anchor,S_mix_color,S_mix_focus_color,S_mix_groups,S_mix_length,S_mix_overlay,S_mix_position,
  S_mix_region,S_mix_speed,S_mix_speed_scaler,S_mix_state,S_mix_tempo_scaler,
  S_mix_waveform_color,S_mix_waveform_height,S_mixer_group_max_out_chans,
  S_mixer_groups,S_mixer_save_state_file,S_mouse_drag_hook,S_mouse_press_hook,S_mouse_release_hook,S_movies,

  S_new_sound,S_normal_fft,S_normalize_fft,S_normalize_on_open,S_normalize_view,

  S_okQ,S_open_alternate_sound,S_open_hook,S_open_raw_sound,S_open_sound,S_open_sound_file,S_orientation_dialog,
  S_override_data_format,S_override_data_location,S_override_data_size,

  S_parzen_window,S_peaks,S_play,S_play_and_wait,S_play_region,S_poisson_window,S_position_color,S_prefix_arg,S_preload_directory,S_preload_file,
  S_previous_files_sort,S_print_length,
  S_progress_report,S_protect_region,S_pushed_button_color,

  S_raw_chans,S_raw_format,S_raw_srate,S_raw_type,S_read_only,
  S_recorder_autoload,S_recorder_buffer_size,S_recorder_dialog,
  S_recorder_file,S_recorder_gain,S_recorder_in_amp,S_recorder_in_format,S_recorder_max_duration,S_recorder_out_amp,S_recorder_out_chans,
  S_recorder_out_format,S_recorder_srate,S_recorder_trigger,S_rectangular_window,S_redo,S_region_chans,S_region_dialog,S_region_length,
  S_region_maxamp,S_region_sample,S_region_samples,S_region_samples_vct,
  S_region_srate,S_regions,S_remove_from_menu,S_report_in_minibuffer,S_restore_control_panel,
  S_restore_marks,S_restore_region,S_reverb_decay,S_reverb_feedback,S_reverb_length,S_reverb_lowpass,S_reverb_scale,
  S_reverbing,S_reverse_selection,S_reverse_sound,S_revert_sound,S_riemann_window,S_right_sample,

  S_sample,S_samples,S_samples_vct,S_save_control_panel,S_save_edit_history,S_save_envelopes,S_save_macros,S_save_marks,S_save_options,
  S_save_region,S_save_selection,S_save_sound,S_save_sound_as,S_save_state,S_save_state_file,
  S_save_state_on_exit,S_scale_by,S_scale_selection_by, S_scale_selection_to,S_scale_to,
  S_scan_across_all_chans,S_scan_across_chans,S_scan_across_sound_chans,S_scan_all_chans,S_scan_chan,S_scan_chans,S_scan_sound_chans,
  S_select_all,S_select_channel,
  S_select_region,S_select_sound,S_selected_channel,S_selected_data_color,S_selected_graph_color,S_selected_sound,
  S_selection_beg,S_selection_color,S_selection_length,S_selection_member,S_selection_to_temp,S_selection_to_temps,

  S_set_amp,S_set_ask_before_overwrite,S_set_audio_output_device,S_set_auto_resize,S_set_auto_update,S_set_basic_color,
  S_set_channel_style,S_set_color_cutoff,S_set_color_inverted,
  S_set_color_scale,S_set_colormap,S_set_contrast,S_set_contrast_amp,S_set_contrasting,S_set_corruption_time,S_set_cursor,
  S_set_cursor_color,S_set_cursor_follows_play,
  S_set_dac_size,S_set_data_color,
  S_set_default_amp,S_set_default_contrast,S_set_default_contrast_amp,S_set_default_contrasting,
  S_set_default_expand,S_set_default_expand_hop,S_set_default_expand_length,S_set_default_expand_ramp,S_set_default_expanding,
  S_set_default_filter_dBing,S_set_default_filter_order,S_set_default_filtering,S_set_default_output_type,S_set_default_reverb_feedback,
  S_set_default_reverb_length,S_set_default_reverb_lowpass,S_set_default_reverb_scale,S_set_default_reverbing,S_set_default_speed,
  S_set_dot_size,S_set_edit_history_width,S_set_env_base,S_set_enved_base,S_set_enved_clipping,S_set_enved_dBing,
  S_set_enved_exping,S_set_enved_power,S_set_enved_target,S_set_enved_waveform_color,
  S_set_enved_waving,S_set_eps_file,S_set_expand,S_set_expand_hop,S_set_expand_length,
  S_set_expand_ramp,S_set_expanding,S_set_fft_beta,S_set_fft_log_frequency,S_set_fft_log_magnitude,S_set_fft_size,
  S_set_fft_style,S_set_fft_window,S_set_ffting,S_set_filter_dBing,S_set_filter_env,S_set_filter_env_order,S_set_filter_order,
  S_set_filter_waveform_color,S_set_filtering,S_set_fit_data_on_open,S_set_graph_color,S_set_graph_cursor,
  S_set_graph_style,S_set_graphing,S_set_group_amp,S_set_group_beg,S_set_group_end,
  S_set_group_speed,S_set_group_tempo,S_set_highlight_color,
  S_set_html_dir,S_set_initial_x0,S_set_initial_x1,S_set_initial_y0,S_set_initial_y1,
  S_set_int_samples,S_set_just_sounds,S_set_left_sample,S_set_line_size,S_set_listener_color,S_set_listener_prompt,
  S_set_mark_color,S_set_mark_name,S_set_mark_sample,
  S_set_max_fft_peaks,S_set_max_fft_size, S_set_max_regions,S_set_menu_sensitive,
  S_set_min_dB,S_set_mix_amp,S_set_mix_amp_scaler,S_set_mix_anchor,S_set_mix_color,S_set_mix_focus_color,
  S_set_mix_groups,S_set_mix_length,S_set_mix_position,S_set_mix_speed,S_set_mix_speed_scaler,S_set_mix_state,S_set_mix_tempo_scaler,
  S_set_mix_waveform_color,S_set_mix_waveform_height,
  S_set_mixer_group_max_out_chans,S_set_mixer_groups,S_set_mixer_save_state_file,S_set_movies,S_set_normalize_fft,S_set_normalize_on_open,
  S_set_oss_buffers,S_set_position_color,
  S_set_prefix_arg,S_set_previous_files_sort,S_set_print_length,S_set_pushed_button_color,
  S_set_raw_chans,S_set_raw_format,S_set_raw_srate,S_set_raw_type,
  S_set_read_only,S_set_recorder_autoload,S_set_recorder_buffer_size,S_set_recorder_file,S_set_recorder_gain,S_set_recorder_in_amp,
  S_set_recorder_in_format,S_set_recorder_max_duration,S_set_recorder_out_amp,S_set_recorder_out_chans,
  S_set_recorder_out_format,S_set_recorder_srate,S_set_recorder_trigger,
  S_set_reverb_decay,S_set_reverb_feedback,S_set_reverb_length,S_set_reverb_lowpass,S_set_reverb_scale,S_set_reverbing,
  S_set_right_sample,S_set_sample,S_set_samples,
  S_set_save_state_file,S_set_save_state_on_exit,
  S_set_selected_data_color,S_set_selected_graph_color,S_set_selection_color,S_set_show_axes,
  S_set_show_fft_peaks,S_set_show_marks,S_set_show_mix_consoles,S_set_show_mix_waveforms,
  S_set_show_selection_transform,S_set_show_usage_stats,S_set_show_y_zero,S_set_showing_controls,S_set_sinc_width,
  S_set_spectro_cutoff,S_set_spectro_hop,S_set_spectro_x_angle,S_set_spectro_x_scale,S_set_spectro_y_angle,
  S_set_spectro_y_scale,S_set_spectro_z_angle,S_set_spectro_z_scale,S_set_speed,S_set_speed_style,S_set_speed_tones,S_set_squelch_update,
  S_set_syncing,S_set_temp_dir,S_set_text_focus_color,S_set_transform_type,S_set_trap_segfault,
  S_set_uniting,S_set_use_raw_defaults,S_set_verbose_cursor,S_set_vu_font,
  S_set_vu_font_size,S_set_vu_size,S_set_wavelet_type,S_set_waving,S_set_wavo,S_set_wavo_hop,S_set_wavo_trace,S_set_window_height,
  S_set_window_width,S_set_window_x,S_set_window_y,S_set_x_axis_style,S_set_x_bounds,S_set_xmax,S_set_xmin,S_set_y_bounds,
  S_set_y_limits,S_set_ymax,S_set_ymin,S_set_zero_pad,S_set_zoom_color,S_set_zoom_focus_style,

  S_short_file_name,S_show_axes,S_show_fft_peaks,S_show_listener,S_show_marks,
  S_show_mix_consoles,S_show_mix_waveforms,S_show_selection_transform,S_show_usage_stats,S_show_y_zero,
  S_showing_controls,S_sinc_width,S_smooth,S_smooth_selection,
  S_snd_clm_samples,S_snd_spectrum,
  S_sonogram,
  S_sound_to_temp,S_sound_to_temps,
  S_spectro_cutoff,S_spectro_hop,S_spectro_x_angle,S_spectro_x_scale,S_spectro_y_angle,S_spectro_y_scale,
  S_spectro_z_angle,S_spectro_z_scale,S_spectrogram,S_spectrum_env,S_speed,S_speed_as_float,S_speed_as_ratio,S_speed_as_semitone,
  S_speed_style,S_speed_tones,S_squelch_update,S_srate,S_srate_env,
  S_src_selection,S_src_sound,S_start_hook,S_start_playing_hook,S_start_progress_report,
  S_stop_playing,S_stop_playing_hook,S_string_length,S_syncing,

  S_temp_dir,S_temp_filenames,S_temp_to_selection,S_temp_to_sound,S_temps_to_selection,S_temps_to_sound,S_text_focus_color,
  S_transform_dialog,S_transform_sample,S_transform_samples,S_transform_samples_vct,S_transform_type,S_trap_segfault,S_tukey_window,

  S_unbind_key,S_undo,S_uniting,S_update_fft,S_update_graph,S_update_sound,S_update_var,S_use_raw_defaults,

  S_vct_samples,S_vct_sound_file,S_vct_addB,S_vct_copy,S_vct_fillB,S_vct_length,S_vct_multiplyB,S_vct_offsetB,S_vct_ref,S_vct_scaleB,S_vct_setB,S_vct_p,
  S_verbose_cursor,S_version,S_view_sound,S_vu_font,S_vu_font_size,S_vu_size,

  S_walsh_transform,S_wavelet_transform,S_wavelet_type,S_waving,S_wavo,S_wavo_hop,S_wavo_trace,S_welch_window,
  S_window_height,S_window_width,S_window_x,S_window_y,

  S_x_axis_style,S_x_bounds,S_x_in_samples,S_x_in_seconds,S_x_to_one,S_xmax,S_xmin,

  S_y_bounds,S_yes_or_no_p,S_ymax,S_ymin,

  S_zero_pad,S_zoom_color,S_zoom_focus_style
};

static char *current_match = NULL;

static int complete_one_set(char *text, int num_commands, char **commands)
{
  int i,j,len,curlen,matches = 0;
  len = strlen(text);
  for (i=0;i<num_commands;i++)
    {
      if (text[0] < commands[i][0]) break;
      if (text[0] == commands[i][0])
	{
	  if (strncmp(text,commands[i],len) == 0)
	    {
	      matches++;
	      add_possible_completion(commands[i]);
	      if (current_match == NULL)
		current_match = copy_string(commands[i]);
	      else 
		{
		  curlen = snd_strlen(current_match);
		  for (j=0;j<curlen;j++)
		    if (current_match[j] != commands[i][j])
		      {
			current_match[j] = '\0';
			break;
		      }
		}
	    }
	}
    }
  return(matches);
}

#if WITH_MUS_MODULE
  int mus_num_commands(void);
  char **mus_commands(void);
#endif
int sndlib_num_commands(void);
char **sndlib_commands(void);

#if DEBUGGING
void check_snd_commands(void);
void check_snd_commands(void)
{
  int i;
  char **names;
  for (i=1;i<NUM_COMMANDS;i++)
    if (strcmp(snd_commands[i-1],snd_commands[i]) >= 0)
      snd_error("%s >= %s\n",snd_commands[i-1],snd_commands[i]);
  names = sndlib_commands();
  for (i=1;i<sndlib_num_commands();i++)
    if (strcmp(names[i-1],names[i]) >= 0)
      snd_error("%s >= %s\n",names[i-1],names[i]);
#if WITH_MUS_MODULE
  names = mus_commands();
  for (i=1;i<mus_num_commands();i++)
    if (strcmp(names[i-1],names[i]) >= 0)
      snd_error("%s >= %s\n",names[i-1],names[i]);
#endif
}
#endif


char *command_completer(char *original_text)
{
  int i,len,beg,matches = 0;
  char *text;
  /* first back up to some delimiter to get the current command */
  current_match = NULL;
  set_completion_matches(0);
  if ((original_text) && (*original_text))
    {
      len = strlen(original_text);
      for (i=len-1;i>=0;i--)
	if ((!(isalpha((int)(original_text[i])))) &&
	    (!(isdigit((int)(original_text[i])))) &&
	    (original_text[i] != '-'))
	  break;
      beg = i+1;
      if (beg == len) return(copy_string(original_text));
      if (beg > 0) 
	text = (char *)(original_text+beg);
      else text = original_text;
      matches = complete_one_set(text,NUM_COMMANDS,snd_commands);
      matches += complete_one_set(text,sndlib_num_commands(),sndlib_commands());
#if WITH_MUS_MODULE
      matches += complete_one_set(text,mus_num_commands(),mus_commands());
#endif
    }
  else return(copy_string(original_text));
  set_completion_matches(matches);
  if ((current_match) && (*current_match))
    {
      if (beg == 0)
	return(current_match);
      else
	{
	  len = snd_strlen(current_match) + beg + 2;
	  text = (char *)CALLOC(len,sizeof(char));
	  strncpy(text,original_text,beg);
	  strcat(text,current_match);
	  FREE(current_match);
	  return(text);
	}
    }
  return(copy_string(original_text));
}

void check_snd_eval_error(snd_state *ss)
{
  char *err = NULL;

  if (ss->eval_error != SND_NO_EVAL_ERROR)
    {
      switch (ss->eval_error)
	{
	case SND_NO_SUCH_MIX:         err = " (no such mix)"; break;
	case SND_NO_SUCH_CHANNEL:     err = " (no such channel)"; break;
	case SND_NO_SUCH_SOUND:       err = " (no such sound)"; break;
	case SND_NO_SUCH_MARK:        err = " (no such mark)"; break;
	case SND_NO_SUCH_GROUP:       err = " (no such group)"; break;
	case SND_NO_SUCH_REGION:      err = " (no such region)"; break;
	case SND_NO_ACTIVE_SELECTION: err = " (no active selection)"; break;
	case SND_NO_SUCH_FILE:        err = " (no such file)"; break;
	case SND_NO_SUCH_MENU:        err = " (no such menu)"; break;
	case SND_NO_SUCH_SAMPLE:      err = " (no such sample)"; break;
	case SND_MISCELLANEOUS_ERROR: err = ss->eval_error_info; break;
	default: err = " (unknown error)"; break;
	}
      ss->eval_error = SND_NO_EVAL_ERROR;
      if (ss->mx_sp) append_to_minibuffer(ss->mx_sp,err);
      if (ss->listening != LISTENER_CLOSED) snd_append_command(ss,err);
    }
}

void make_eval_error(snd_state *ss, char *str, char *data)
{
  if (ss->eval_error_info) {FREE(ss->eval_error_info); ss->eval_error_info = NULL;}
  ss->eval_error_info = (char *)CALLOC(256,sizeof(char));
  sprintf(ss->eval_error_info,str,data);
  ss->eval_error = SND_MISCELLANEOUS_ERROR;
}
