#include "snd.h"
#include <locale.h>

static int remove_temp_files(chan_info *cp, void *ptr)
{
  free_sound_list(cp);
  free_mix_list(cp);
  return(0);
}

#ifdef DEBUG_MEMORY
  void mem_report(void);
#endif

void snd_exit_cleanly(snd_state *ss)
{  
  if ((save_state_on_exit(ss)) && (save_state_file(ss)))
    save_state(ss,save_state_file(ss));

  CLM_disconnect(ss);
  cleanup_clm_dialog(ss);
  cleanup_dac();
  if (ss->to_clm)
    {
      close(ss->from_clm);
      ss->from_clm = 0;
    }
  if (ss->to_clm)
    {
      close(ss->to_clm);
      ss->to_clm = 0;
    }
  map_over_chans(ss,remove_temp_files,NULL);
  cleanup_region_temp_files();
  cleanup_group_temp_files(ss);
  cleanup_recording();
#ifdef DEBUG_MEMORY
  mem_report();
#endif
}

/* ---------------- save sound state (options, or entire state) ---------------- */

static int fneq(float a, float b)
{
  /* floating point != replacement */
  return(fabs(a - b) > .00001);
}

#if HAVE_GUILE
static char *zoom_focus_style_name(snd_state *ss)
{
  switch (zoom_focus_style(ss))
    {
    case FOCUS_LEFT: return(S_focus_left); break;
    case FOCUS_RIGHT: return(S_focus_right); break;
    case FOCUS_MIDDLE: return(S_focus_middle); break;
    default: return(S_focus_active); break;
    }
}
#endif

void save_snd_state_options (snd_state *ss, FILE *fd)
{ /* for save options menu choice (.snd) -- mostly saving snd_state info */
  time_t ts;
  char time_buf[64];
  char *locale = NULL;
  locale = copy_string(setlocale(LC_NUMERIC,"C")); /* must use decimal point in floats since Scheme assumes that format */

#if (!defined(HAVE_CONFIG_H)) || defined(HAVE_STRFTIME)
  time(&ts);
  strftime(time_buf,64,STRFTIME_FORMAT,localtime(&ts));
  fprintf(fd,"\n;;; Snd %s (%s) options saved %s\n",SND_RPM_VERSION,SND_VERSION,time_buf);
#else
  fprintf(fd,"\n;;; Snd %s (%s)\n",SND_RPM_VERSION,SND_VERSION);
#endif

  if (fft_size(ss) != 256) fprintf(fd,"(%s %d)\n",S_set_fft_size,fft_size(ss));
#if HAVE_GUILE
  if (fft_window(ss) != default_fft_window(NULL)) 
    fprintf(fd,"(%s %s)\n",S_set_fft_window,fft_window_name(ss));
  if (fft_style(ss) != NORMAL_FFT) 
    fprintf(fd,"(%s %s)\n",S_set_fft_style,(fft_style(ss) == SONOGRAM) ? S_sonogram : S_spectrogram);
  if (x_axis_style(ss) != X_IN_SECONDS) 
    fprintf(fd,"(%s %s)\n",S_set_x_axis_style,(x_axis_style(ss) == X_IN_SAMPLES) ? S_x_in_samples : S_x_to_one);
  if (graph_style(ss) != GRAPH_LINES) 
    {
      switch (graph_style(ss))
	{
	case GRAPH_DOTS:           fprintf(fd,"(%s %s)\n",S_set_graph_style,S_graph_dots); break;
	case GRAPH_DOTS_AND_LINES: fprintf(fd,"(%s %s)\n",S_set_graph_style,S_graph_dots_and_lines); break;
	case GRAPH_LOLLIPOPS:      fprintf(fd,"(%s %s)\n",S_set_graph_style,S_graph_lollipops); break;
    	case GRAPH_FILLED:         fprintf(fd,"(%s %s)\n",S_set_graph_style,S_graph_filled); break;
	}
    }
  if (speed_style(ss) != SPEED_AS_FLOAT) 
    fprintf(fd,"(%s %s)\n",S_set_speed_style,(speed_style(ss) == SPEED_AS_RATIO) ? S_speed_as_ratio : S_speed_as_semitone);
  if (channel_style(ss) != CHANNELS_SEPARATE) 
    fprintf(fd,"(%s %s)\n",S_set_channel_style,(channel_style(ss) == CHANNELS_SUPERIMPOSED) ? S_channels_superimposed : S_channels_combined);
  if (enved_target(ss) != AMPLITUDE_ENV) 
    fprintf(fd,"(%s %s)\n",S_set_enved_target,(enved_target(ss) == SPECTRUM_ENV) ? S_spectrum_env : S_srate_env);
  if (transform_type(ss) != FOURIER) 
    fprintf(fd,"(%s %s)\n",S_set_transform_type,transform_type_name(ss));
  if (zoom_focus_style(ss) != FOCUS_ACTIVE) 
    fprintf(fd,"(%s %s)\n",S_set_zoom_focus_style,zoom_focus_style_name(ss));
#else
  if (fft_window(ss) != default_fft_window(NULL)) fprintf(fd,"(%s %d)\n",S_set_fft_window,fft_window(ss));
  if (fft_style(ss) != NORMAL_FFT) fprintf(fd,"(%s %d)\n",S_set_fft_style,fft_style(ss));
  if (x_axis_style(ss) != X_IN_SECONDS) fprintf(fd,"(%s %d)\n",S_set_x_axis_style,x_axis_style(ss));
  if (graph_style(ss) != GRAPH_LINES) fprintf(fd,"(%s %d)\n",S_set_graph_style,graph_style(ss));
  if (speed_style(ss) != SPEED_AS_FLOAT) fprintf(fd,"(%s %d)\n",S_set_speed_style,speed_style(ss));
  if (channel_style(ss) != CHANNELS_SEPARATE) fprintf(fd,"(%s %d)\n",S_set_channel_style,channel_style(ss));
  if (enved_target(ss) != AMPLITUDE_ENV) fprintf(fd,"(%s %d)\n",S_set_enved_target,enved_target(ss));
  if (transform_type(ss) != FOURIER) fprintf(fd,"(%s %d)\n",S_set_transform_type,transform_type(ss));
  if (zoom_focus_style(ss) != FOCUS_ACTIVE) fprintf(fd,"(%s %d)\n",S_set_zoom_focus_style,zoom_focus_style(ss));
#endif
  if (trap_segfault(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_trap_segfault,trap_segfault(ss));
  if (show_selection_transform(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_show_selection_transform,show_selection_transform(ss));
  if (sinc_width(ss) != 10) fprintf(fd,"(%s %d)\n",S_set_sinc_width,sinc_width(ss));
  if (speed_tones(ss) != 12) fprintf(fd,"(%s %d)\n",S_set_speed_tones,speed_tones(ss));
  if (ss->init_window_width != -1) fprintf(fd,"(%s %d)\n",S_set_window_width,snd_window_width(ss));
  if (ss->init_window_height != -1) fprintf(fd,"(%s %d)\n",S_set_window_height,snd_window_height(ss));
  if (ss->init_window_x != -1) fprintf(fd,"(%s %d)\n",S_set_window_x,snd_window_x(ss));
  if (ss->init_window_y != -1) fprintf(fd,"(%s %d)\n",S_set_window_y,snd_window_y(ss));
  if (default_contrasting(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_default_contrasting,default_contrasting(ss));
  if (default_expanding(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_default_expanding,default_expanding(ss));
  if (default_reverbing(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_default_reverbing,default_reverbing(ss));
  if (default_filtering(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_default_filtering,default_filtering(ss));
  if (default_filter_order(ss) != 20) fprintf(fd,"(%s %d)\n",S_set_default_filter_order,default_filter_order(ss));
  if (default_filter_dBing(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_default_filter_dBing,default_filter_dBing(ss));
  if (default_output_type(ss) != DEFAULT_OUTPUT_TYPE) fprintf(fd,"(%s %d)\n",S_set_default_output_type,default_output_type(ss));
  if (normalize_on_open(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_normalize_on_open,normalize_on_open(ss));
  if (auto_resize(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_auto_resize,auto_resize(ss));
  if (auto_update(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_auto_update,auto_update(ss));
  if (color_inverted(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_color_inverted,color_inverted(ss));
  if (zero_pad(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_zero_pad,zero_pad(ss));
  if (line_size(ss) != 128) fprintf(fd,"(%s %d)\n",S_set_line_size,line_size(ss));
  if (ask_before_overwrite(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_ask_before_overwrite,ask_before_overwrite(ss));
  if (wavo(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_wavo,wavo(ss));
  if (wavo_hop(ss) != 3) fprintf(fd,"(%s %d)\n",S_set_wavo_hop,wavo_hop(ss));
  if (wavo_trace(ss) != 64) fprintf(fd,"(%s %d)\n",S_set_wavo_trace,wavo_trace(ss));
  if (spectro_hop(ss) != 4) fprintf(fd,"(%s %d)\n",S_set_spectro_hop,spectro_hop(ss));
  if (color_map(ss) != -1) fprintf(fd,"(%s %d)\n",S_set_colormap,color_map(ss));
  if (wavelet_type(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_wavelet_type,wavelet_type(ss));
  if (dot_size(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_dot_size,dot_size(ss));
  if (movies(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_movies,movies(ss));
  if (normalize_fft(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_normalize_fft,normalize_fft(ss));
  if (fit_data_on_open(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_fit_data_on_open,fit_data_on_open(ss));
  if (save_state_on_exit(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_save_state_on_exit,save_state_on_exit(ss));
  if (filter_env_order(ss) != 40) fprintf(fd,"(%s %d)\n",S_set_filter_env_order,filter_env_order(ss));
  if (mixer_groups(ss) != 6) fprintf(fd,"(%s %d)\n",S_set_mixer_groups,mixer_groups(ss));
  if (mixer_group_max_out_chans(ss) != 4) fprintf(fd,"(%s %d)\n",S_set_mixer_group_max_out_chans,mixer_group_max_out_chans(ss));
  if (max_fft_peaks(ss) != 100) fprintf(fd,"(%s %d)\n",S_set_max_fft_peaks,max_fft_peaks(ss));
  if (max_fft_size(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_max_fft_size,max_fft_size(ss));
  if (max_regions(ss) != 16) fprintf(fd,"(%s %d)\n",S_set_max_regions,max_regions(ss));
  if (corruption_time(ss) != 60.0) fprintf(fd,"(%s %.2f)\n",S_set_corruption_time,corruption_time(ss));
  if (verbose_cursor(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_verbose_cursor,verbose_cursor(ss));
  if (show_fft_peaks(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_show_fft_peaks,show_fft_peaks(ss));
  if (show_y_zero(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_show_y_zero,show_y_zero(ss));
  if (show_axes(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_show_axes,show_axes(ss));
  if (show_marks(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_show_marks,show_marks(ss));
#if (XmVERSION == 1)
  if (show_edit_history(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_show_edit_history,show_edit_history(ss));
  if (edit_history_width(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_edit_history_width,edit_history_width(ss));
#else
  if (edit_history_width(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_edit_history_width,edit_history_width(ss));
#endif
  if (fft_log_magnitude(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_fft_log_magnitude,fft_log_magnitude(ss));
  if (fft_log_frequency(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_fft_log_frequency,fft_log_frequency(ss));
  if (raw_srate(ss) != 44100) fprintf(fd,"(%s %d)\n",S_set_raw_srate,raw_srate(ss));
  if (raw_chans(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_raw_chans,raw_chans(ss));
  if (raw_format(ss) != SNDLIB_16_LINEAR) fprintf(fd,"(%s %d)\n",S_set_raw_format,raw_format(ss));
  if (raw_type(ss) != NeXT_sound_file) fprintf(fd,"(%s %d)\n",S_set_raw_type,raw_type(ss));
  if (use_raw_defaults(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_use_raw_defaults,use_raw_defaults(ss));
  if (print_length(ss) != 12) fprintf(fd,"(%s %d)\n",S_set_print_length,print_length(ss));
  if (show_usage_stats(ss) != FALSE) fprintf(fd,"(%s %d)\n",S_set_show_usage_stats,show_usage_stats(ss));
  if (show_mix_consoles(ss) != 1) fprintf(fd,"(%s %d)\n",S_set_show_mix_consoles,show_mix_consoles(ss));
  if (show_mix_waveforms(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_show_mix_waveforms,show_mix_waveforms(ss));
  if (mix_waveform_height(ss) != 20) fprintf(fd,"(%s %d)\n",S_set_mix_waveform_height,mix_waveform_height(ss));
  if (recorder_autoload(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_recorder_autoload,recorder_autoload(ss));
  if (recorder_buffer_size(ss) != 4096) fprintf(fd,"(%s %d)\n",S_set_recorder_buffer_size,recorder_buffer_size(ss));
  if (recorder_out_chans(ss) != 2) fprintf(fd,"(%s %d)\n",S_set_recorder_out_chans,recorder_out_chans(ss));
  if (recorder_out_format(ss) != SNDLIB_COMPATIBLE_FORMAT) fprintf(fd,"(%s %d)\n",S_set_recorder_out_format,recorder_out_format(ss));
  if (recorder_in_format(ss) != SNDLIB_COMPATIBLE_FORMAT) fprintf(fd,"(%s %d)\n",S_set_recorder_in_format,recorder_in_format(ss));
  if (recorder_srate(ss) != 22050) fprintf(fd,"(%s %d)\n",S_set_recorder_srate,recorder_srate(ss));
  if (enved_waving(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_enved_waving,enved_waving(ss));
  if (enved_dBing(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_enved_dBing,enved_dBing(ss));
  if (enved_clipping(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_enved_clipping,enved_clipping(ss));
  if (enved_exping(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_enved_exping,enved_exping(ss));
  if (prefix_arg(ss) != 0) fprintf(fd,"(%s %d)\n",S_set_prefix_arg,prefix_arg(ss));

  if (vu_font(ss) != NULL) fprintf(fd,"(%s \"%s\")\n",S_set_vu_font,vu_font(ss));
  if (recorder_file(ss) != NULL) fprintf(fd,"(%s \"%s\")\n",S_set_recorder_file,recorder_file(ss));
  if (save_state_file(ss) != NULL) fprintf(fd,"(%s \"%s\")\n",S_set_save_state_file,save_state_file(ss));
  if (temp_dir(ss) != NULL) fprintf(fd,"(%s \"%s\")\n",S_set_temp_dir,temp_dir(ss));
  if ((eps_file(ss) != NULL) && (strcmp(eps_file(ss),"snd.eps") != 0)) fprintf(fd,"(%s \"%s\")\n",S_set_eps_file,eps_file(ss));
  if (strcmp(listener_prompt(ss),">") != 0) fprintf(fd,"(%s \"%s\")\n",S_set_listener_prompt,listener_prompt(ss));
  if ((mixer_save_state_file(ss) != NULL) && (strcmp(mixer_save_state_file(ss),MIXER_SAVE_STATE_FILE) != 0)) 
    fprintf(fd,"(%s \"%s\")\n",S_set_mixer_save_state_file,mixer_save_state_file(ss));
  if (audio_output_device(ss) != SNDLIB_DEFAULT_DEVICE) fprintf(fd,"(%s %d)\n",S_set_audio_output_device,audio_output_device(ss));

  if (fneq(default_contrast_amp(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_default_contrast_amp,default_contrast_amp(ss));
  if (fneq(fft_beta(ss),0.0)) fprintf(fd,"(%s %.4f)\n",S_set_fft_beta,fft_beta(ss));
  if (fneq(default_amp(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_default_amp,default_amp(ss));
  if (fneq(default_contrast(ss),0.0)) fprintf(fd,"(%s %.4f)\n",S_set_default_contrast,default_contrast(ss));
  if (fneq(default_expand_length(ss),.15)) fprintf(fd,"(%s %.4f)\n",S_set_default_expand_length,default_expand_length(ss));
  if (fneq(default_expand_ramp(ss),.4)) fprintf(fd,"(%s %.4f)\n",S_set_default_expand_ramp,default_expand_ramp(ss));
  if (fneq(default_expand_hop(ss),.05)) fprintf(fd,"(%s %.4f)\n",S_set_default_expand_hop,default_expand_hop(ss));
  if (fneq(default_reverb_feedback(ss),1.09)) fprintf(fd,"(%s %.4f)\n",S_set_default_reverb_feedback,default_reverb_feedback(ss));
  if (fneq(default_reverb_lowpass(ss),0.7)) fprintf(fd,"(%s %.4f)\n",S_set_default_reverb_lowpass,default_reverb_lowpass(ss));
  if (fneq(default_expand(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_default_expand,default_expand(ss));
  if (fneq(default_speed(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_default_speed,default_speed(ss));
  if (fneq(default_reverb_scale(ss),0.0)) fprintf(fd,"(%s %.4f)\n",S_set_default_reverb_scale,default_reverb_scale(ss));
  if (fneq(default_reverb_length(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_default_reverb_length,default_reverb_length(ss));
  if (fneq(reverb_decay(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_reverb_decay,reverb_decay(ss));
  if (fneq(initial_x0(ss),0.0)) fprintf(fd,"(%s %.4f)\n",S_set_initial_x0,initial_x0(ss));
  if (fneq(initial_x1(ss),0.1)) fprintf(fd,"(%s %.4f)\n",S_set_initial_x1,initial_x1(ss));
  if (fneq(initial_y0(ss),-1.0)) fprintf(fd,"(%s %.4f)\n",S_set_initial_y0,initial_y0(ss));
  if (fneq(initial_y1(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_initial_y1,initial_y1(ss));
  if (fneq(xmax(ss),0.0)) fprintf(fd,"(%s %.4f)\n",S_set_xmax,xmax(ss));
  if (fneq(xmin(ss),0.0)) fprintf(fd,"(%s %.4f)\n",S_set_xmin,xmin(ss));
  if (fneq(ymax(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_ymax,ymax(ss));
  if (fneq(ymin(ss),-1.0)) fprintf(fd,"(%s %.4f)\n",S_set_ymin,ymin(ss));
  if (fneq(ss->min_dB,-60.0)) fprintf(fd,"(%s %.4f)\n",S_set_min_dB,ss->min_dB);
  if (fneq(color_cutoff(ss),.003)) fprintf(fd,"(%s %.4f)\n",S_set_color_cutoff,color_cutoff(ss));
  if (fneq(color_scale(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_color_scale,color_scale(ss));
  if (fneq(spectro_x_scale(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_spectro_x_scale,spectro_x_scale(ss));
  if (fneq(spectro_y_scale(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_spectro_y_scale,spectro_y_scale(ss));
  if (fneq(spectro_z_scale(ss),0.1)) fprintf(fd,"(%s %.4f)\n",S_set_spectro_z_scale,spectro_z_scale(ss));
  if (fneq(spectro_z_angle(ss),-2.0)) fprintf(fd,"(%s %.4f)\n",S_set_spectro_z_angle,spectro_z_angle(ss));
  if (fneq(spectro_x_angle(ss),90.0)) fprintf(fd,"(%s %.4f)\n",S_set_spectro_x_angle,spectro_x_angle(ss));
  if (fneq(spectro_y_angle(ss),0.0)) fprintf(fd,"(%s %.4f)\n",S_set_spectro_y_angle,spectro_y_angle(ss));
  if (fneq(spectro_cutoff(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_spectro_cutoff,spectro_cutoff(ss));
  if (fneq(vu_size(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_vu_size,vu_size(ss));
  if (fneq(vu_font_size(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_vu_font_size,vu_font_size(ss));
  if (fneq(enved_base(ss),1.0)) fprintf(fd,"(%s %.4f)\n",S_set_enved_base,enved_base(ss));
  if (fneq(enved_power(ss),3.0)) fprintf(fd,"(%s %.4f)\n",S_set_enved_power,enved_power(ss));

  fprintf(fd,";;; end of snd options\n");
  if (locale)
    {
      setlocale(LC_NUMERIC,locale);
      FREE(locale);
    }
}

static FILE *open_restart_file(char *name, int append)
{
  FILE *fd;
  char *str;
  char *buf = NULL;
  if (!name) return(NULL);
  buf = (char *)CALLOC(256,sizeof(char));
  str = name;
  if ((*str) == '~')
    {
      strcpy(buf,getenv("HOME"));
      strcat(buf,++str);
      str=buf;
    }
  if (append)
    fd = fopen(str,"a");
  else fd = fopen(str,"w");
  FREE(buf);
  return(fd);
}

FILE *open_snd_init_file (snd_state *ss)
{ /* needed also by keyboard macro saver */
  return(open_restart_file(ss->init_file,TRUE));
}

int save_options (snd_state *ss) /* snd-xmenu */
{
  FILE *fd;
  fd = open_snd_init_file(ss);
  if (fd)
    {
      save_snd_state_options(ss,fd);
      fclose(fd);
      return(0);
    }
  else return(-1);
}

#define white_space "      "

static int save_sound_state (snd_info *sp, void *ptr) 
{
  int chan;
  FILE *fd;
  chan_info *cp;
  axis_info *ap;
  char *tmpstr=NULL;
  fd = (FILE *)ptr;
  fprintf(fd,"(let ((sfile (or (%s \"%s\") (%s \"%s\"))))\n  (if sfile\n    (begin\n",
	  S_find_sound,
	  sp->shortname,
	  (sp->read_only) ? S_view_sound : S_open_sound,
	  sp->fullname);
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_syncing,sp->syncing);
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_contrasting,sp->contrasting);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_contrast,sp->contrast);
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_expanding,sp->expanding);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_expand,sp->expand);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_expand_ramp,sp->local_exprmp);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_expand_hop,sp->local_exphop);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_expand_length,sp->local_explen);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_speed,sp->srate);
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_reverbing,sp->reverbing);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_reverb_scale,sp->revscl);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_reverb_length,sp->revlen);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_reverb_feedback,sp->local_revfb);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_reverb_lowpass,sp->local_revlp);
  fprintf(fd,"%s(%s %.4f sfile)\n",white_space,S_set_amp,sp->amp);
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_filtering,sp->filtering);
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_filter_order,sp->filter_order);
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_filter_dBing,sp->filter_dBing);
  if (sp->filter_env) 
    {
      fprintf(fd,"%s(%s %s sfile)\n",white_space,S_set_filter_env,tmpstr=env_to_string(sp->filter_env));
      if (tmpstr) FREE(tmpstr);
    }
  fprintf(fd,"%s(%s %d sfile)\n",white_space,S_set_cursor_follows_play,sp->cursor_follows_play);
  for (chan=0;chan<sp->nchans;chan++)
    {
      cp = sp->chans[chan];
      ap = cp->axis;
      fprintf(fd,"%s(%s %d sfile %d)\n",white_space,S_set_waving,cp->waving,chan);
      fprintf(fd,"%s(%s %d sfile %d)\n",white_space,S_set_ffting,cp->ffting,chan);
      fprintf(fd,"%s(%s %d sfile %d)\n",white_space,S_set_graphing,cp->lisp_graphing,chan);
      fprintf(fd,"%s(%s %.4f %.4f sfile %d)\n",white_space,S_set_x_bounds,ap->x0,ap->x1,chan);
      fprintf(fd,"%s(%s %.4f %.4f sfile %d)\n",white_space,S_set_y_bounds,ap->y0,ap->y1,chan);
      fprintf(fd,"%s(%s %d sfile %d)\n",white_space,S_set_cursor,cp->cursor,chan);
      edit_history_to_file(fd,cp);
    }
  fprintf(fd,"      )))\n");
  return(0);
}

int save_state (snd_state *ss, char *save_state_name)
{
  FILE *save_fd;
  char *locale = NULL;
  save_fd = open_restart_file(save_state_name,FALSE);
  if (save_fd == NULL) 
    {
      snd_error(STR_cant_write_p,save_state_name,strerror(errno));
      return(-1);
    }
  else
    {
      locale = copy_string(setlocale(LC_NUMERIC,"C")); /* must use decimal point in floats since Scheme assumes that format */
      save_prevlist(save_fd);                                /* list of previous files (View: Files option) */
      map_over_sounds(ss,save_sound_state,(void *)save_fd);  /* current sound state -- will traverse chans */
      save_macro_state(ss,save_fd);                          /* current unsaved keyboard macros (snd-chn.c) */
      save_envelope_editor_state(ss,save_fd);                /* current envelope editor window state */
      save_regions(save_fd);                                 /* regions */
      save_snd_state_options(ss,save_fd);                    /* options = user-settable global state variables */
      if (transform_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_transform_dialog);
      if (enved_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_enved_dialog);
      if (color_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_color_dialog);
      if (orientation_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_orientation_dialog);
      if (file_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_file_dialog); /* View: Files dialog, not Open: File */
      if (region_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_region_dialog);
      if (record_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_recorder_dialog);
      if (group_dialog_is_active()) fprintf(save_fd,"(%s)\n",S_group_dialog);
      fclose(save_fd);
      /* cp->mixes is mix_state struct -- has mix_pool->mixdata array */
      /* each mixdata struct has states -> arrays of console_state structs */
      /* each console_state has beg end etc */
      /* groups? */
      if (locale)
	{
	  setlocale(LC_NUMERIC,locale);
	  FREE(locale);
	}
    }
  return(0);
}

