#include "snd.h"

#if HAVE_GUILE

#define ERRN1(a,b) SCM_ASSERT((gh_number_p(a)),a,SCM_ARG1,b)
#define ERRN2(a,b) SCM_ASSERT((gh_number_p(a)),a,SCM_ARG2,b)
#define ERRN3(a,b) SCM_ASSERT((gh_number_p(a)),a,SCM_ARG3,b)
#define ERRCOL1(a,b) SCM_ASSERT((snd_color_p(a)),a,SCM_ARG1,b)
#define ERRS1(a,b) SCM_ASSERT((gh_string_p(a)),a,SCM_ARG1,b)
#define RTNSTR(a) return(gh_str02scm(a))
#define RTNBOOL(a) return((a) ? SCM_BOOL_T : SCM_BOOL_F)
#define GH_COLOR_SET(name,obj) SCM_SETCDR(name,obj)
#define GH_TYPE_OF(a) (SCM_TYP16(a))

static snd_state *state;

#if HAVE_XmHTML
  static SCM g_html_dir(void) {RTNSTR(html_dir(state));}
  static SCM g_set_html_dir(SCM val) {ERRS1(val,S_set_html_dir); set_html_dir(state,gh_scm2newstr(val,0)); return(val);}
#endif

static void timed_eval(XtPointer in_code, XtIntervalId *id)
{
  char *scode = NULL;
  SCM code;
  code = (SCM)in_code;
  if (code)
    {
      if (gh_string_p(code))
	{
	  scode = gh_scm2newstr(code,NULL);
	  gh_eval_str(scode);
	  FREE(scode);
	}
      else
	{
	  if (gh_procedure_p(code))
	    gh_call0(code);
	}
    }
}

static SCM g_in(SCM ms, SCM code)
{
  XtAppAddTimeOut((state->sgx)->mainapp,gh_scm2ulong(ms),(XtTimerCallbackProc)timed_eval,(XtPointer)code);
  return(ms);
}

/* color support */

static int snd_color_tag = 0;

typedef struct {
  Pixel color;
} snd_color;

static SCM mark_snd_color(SCM obj)
{
  SCM_SETGC8MARK(obj);
  return(SCM_BOOL_F);
}

static int snd_color_p(SCM obj)
{
  return((SCM_NIMP(obj)) && (GH_TYPE_OF(obj) == (SCM)snd_color_tag));
}

static SCM g_color_p(SCM obj) {RTNBOOL(snd_color_p(obj));}

static snd_color *get_snd_color(SCM arg)
{
  if (snd_color_p(arg))
    return((snd_color *)gh_cdr(arg));
  return(NULL);
}

static scm_sizet free_snd_color(SCM obj)
{
  Colormap cmap;
  Display *dpy;
  snd_color *v = (snd_color *)gh_cdr(obj);
  dpy=XtDisplay(main_SHELL(state));
  cmap=DefaultColormap(dpy,DefaultScreen(dpy));
  XFreeColors(dpy,cmap,&(v->color),1,0);
  FREE(v);
  return(0);
}

static int print_snd_color(SCM obj, SCM port, scm_print_state *pstate)
{
  char *buf = NULL;
  snd_color *v = (snd_color *)gh_cdr(obj);
  Colormap cmap;
  XColor tmp_color;
  Display *dpy;
  buf = (char *)CALLOC(128,sizeof(char));
  dpy=XtDisplay(main_SHELL(state));
  cmap=DefaultColormap(dpy,DefaultScreen(dpy));
  tmp_color.flags = DoRed | DoGreen | DoBlue;
  tmp_color.pixel = v->color;
  XQueryColor(dpy,cmap,&tmp_color);
  sprintf(buf,"#<color: (%.2f %.2f %.2f)>",
	  (float)tmp_color.red / 65535.0,(float)tmp_color.green / 65535.0,(float)tmp_color.blue / 65535.0);
  scm_puts(buf,port);
  FREE(buf);
  return(1);
}

static SCM equalp_snd_color(SCM obj1, SCM obj2)
{
  snd_color *v1,*v2;
  v1 = (snd_color *)gh_cdr(obj1);
  v2 = (snd_color *)gh_cdr(obj2);
  RTNBOOL(v1->color == v2->color);
}

static SCM g_make_snd_color(SCM r, SCM g, SCM b)
{
  SCM ans;
  Colormap cmap;
  XColor tmp_color;
  Display *dpy;
  snd_color *new_color;
  ERRN1(r,S_make_color);
  /* someday accept a list as r */
  ERRN2(g,S_make_color);
  ERRN3(b,S_make_color);
  new_color = (snd_color *)CALLOC(1,sizeof(snd_color));
  dpy=XtDisplay(main_SHELL(state));
  cmap=DefaultColormap(dpy,DefaultScreen(dpy));
  tmp_color.flags = DoRed | DoGreen | DoBlue;
  tmp_color.red = (int)(65535 * gh_scm2double(r));
  tmp_color.green = (int)(65535 * gh_scm2double(g));
  tmp_color.blue = (int)(65535 * gh_scm2double(b));
  if ((XAllocColor(dpy,cmap,&tmp_color)) == 0)
    new_color->color = BlackPixel(dpy,DefaultScreen(dpy)); 
  else new_color->color = tmp_color.pixel;
  SCM_NEWCELL(ans);
  SCM_SETCAR(ans,snd_color_tag);
  SCM_SETCDR(ans,(SCM)new_color);
  return(ans);
}

static SCM pixel2color(Pixel pix)
{
  Colormap cmap;
  XColor tmp_color;
  Display *dpy;
  dpy=XtDisplay(main_SHELL(state));
  cmap=DefaultColormap(dpy,DefaultScreen(dpy));
  tmp_color.flags = DoRed | DoGreen | DoBlue;
  tmp_color.pixel = pix;
  XQueryColor(dpy,cmap,&tmp_color);
  return(g_make_snd_color(gh_double2scm((float)tmp_color.red / 65535.0),
			  gh_double2scm((float)tmp_color.green / 65535.0),
			  gh_double2scm((float)tmp_color.blue / 65535.0)));
}

#if (!HAVE_MAKE_SMOB_TYPE)
static scm_smobfuns snd_color_smobfuns = {
  &mark_snd_color,
  &free_snd_color,
  &print_snd_color,
  &equalp_snd_color};
#endif

static SCM basic_color,zoom_color,position_color,mark_color,listener_color,mix_color,mix_focus_color;
static SCM mix_waveform_color,enved_waveform_color,filter_waveform_color,sg_highlight_color,graph_color;
static SCM selected_graph_color,data_color,selected_data_color,cursor_color,selection_color,pushed_button_color,text_focus_color;

static int recolor_everything(Widget w, void *ptr)
{
  Pixel curcol;
  if (XtIsWidget(w))
    {
      XtVaGetValues(w,XmNbackground,&curcol,NULL);
      if (curcol == (Pixel)ptr)
	XtVaSetValues(w,XmNbackground,(state->sgx)->basic_color,NULL);
    }
  return(0);
}

static SCM g_set_basic_color (SCM color) 
{
  snd_color *v; 
  Pixel old_color;
  ERRCOL1(color,S_set_basic_color); 
  GH_COLOR_SET(basic_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      old_color = (state->sgx)->basic_color;
      (state->sgx)->basic_color = v->color; 
      map_over_children(main_SHELL(state),recolor_everything,(void *)old_color);
    }
  return(color);
}

static SCM g_basic_color(void) {return(pixel2color((state->sgx)->basic_color));}

static void color_unselected_graphs(Pixel color)
{
  int i,j;
  chan_info *cp;
  snd_info *sp;
  for (i=0;i<state->max_sounds;i++)
    {
      sp = (snd_info *)state->sounds[i];
      if (sp)
	{
	  for (j=0;j<sp->allocated_chans;j++)
	    {
	      cp = sp->chans[j];
	      if ((cp) && ((i != state->selected_sound) || (j != sp->selected_channel)))
		{
		  XtVaSetValues(channel_graph(cp),XmNbackground,color,NULL);
		}
	    }
	}
    }
}

#define COLOR_POSITION 0
#define COLOR_ZOOM 1

static void color_chan_components(Pixel color, int which_component)
{
  int i,j;
  chan_info *cp;
  snd_info *sp;
  for (i=0;i<state->max_sounds;i++)
    {
      sp = (snd_info *)state->sounds[i];
      if (sp)
	{
	  for (j=0;j<sp->allocated_chans;j++)
	    {
	      cp = sp->chans[j];
	      if (cp)
		{
		  if (which_component == COLOR_POSITION)
		    {
		      XtVaSetValues(channel_sx(cp),XmNbackground,color,NULL);
		      XtVaSetValues(channel_zy(cp),XmNbackground,color,NULL);
		    }
		  else
		    {
		      XtVaSetValues(channel_zx(cp),XmNbackground,color,NULL);
		      XtVaSetValues(channel_sy(cp),XmNbackground,color,NULL);
		    }
		}
	    }
	}
    }
}

static SCM g_set_data_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_data_color); 
  GH_COLOR_SET(data_color,color);
  /* this hidden scheme variable needed to handle Xalloc/XFree correctly (otherwise XFreeColors can't safely be called at all) */
  v = get_snd_color(color); 
  if (v) 
    {
      color_data(state,v->color);
      map_over_chans(state,update_graph,NULL);
    }
  return(color);
}

static SCM g_data_color(void) {return(pixel2color((state->sgx)->data_color));}

static SCM g_set_selected_data_color (SCM color)
{
  snd_color *v; 
  chan_info *cp;
  ERRCOL1(color,S_set_selected_data_color); 
  GH_COLOR_SET(selected_data_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      color_selected_data(state,v->color);
      cp = selected_channel(state);
      if (cp) 
	{
	  color_selected_data(state,v->color);
	  update_graph(cp,NULL);
	}
    }
  return(color);
}

static SCM g_selected_data_color(void) {return(pixel2color((state->sgx)->selected_data_color));}

static SCM g_set_graph_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_graph_color);
  GH_COLOR_SET(graph_color,color);
  v = get_snd_color(color);
  if (v) 
    {
      color_graph(state,v->color);
      color_unselected_graphs(v->color);
    }
  return(color);
}

static SCM g_graph_color(void) {return(pixel2color((state->sgx)->graph_color));}

static SCM g_set_selected_graph_color (SCM color) 
{
  snd_color *v; 
  chan_info *cp;
  ERRCOL1(color,S_set_selected_graph_color);
  GH_COLOR_SET(selected_graph_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      color_selected_graph(state,v->color);
      cp = selected_channel(state);
      if (cp) 
	{
	  XtVaSetValues(channel_graph(cp),XmNbackground,v->color,NULL);
	}
    }
  return(color);
}

static SCM g_selected_graph_color(void) {return(pixel2color((state->sgx)->selected_graph_color));}

static SCM g_set_cursor_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_cursor_color); 
  GH_COLOR_SET(cursor_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      color_cursor(state,v->color);
      map_over_chans(state,update_graph,NULL);
    }
  return(color);
}

static SCM g_cursor_color(void) {return(pixel2color((state->sgx)->cursor_color));}

static SCM g_set_selection_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_selection_color); 
  GH_COLOR_SET(selection_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      color_selection(state,v->color);
      map_over_chans(state,update_graph,NULL);
    }
  return(color);
}

static SCM g_selection_color(void) {return(pixel2color((state->sgx)->selection_color));}

static SCM g_set_highlight_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_highlight_color); 
  GH_COLOR_SET(sg_highlight_color,color);
  v = get_snd_color(color); 
  if (v) (state->sgx)->highlight_color = v->color; 
  return(color);
}

static SCM g_highlight_color(void) {return(pixel2color((state->sgx)->highlight_color));}

static SCM g_set_mark_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_mark_color); 
  GH_COLOR_SET(mark_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      color_marks(state,v->color);
      map_over_chans(state,update_graph,NULL);
    }
  return(color);
}

static SCM g_mark_color(void) {return(pixel2color((state->sgx)->mark_color));}

static SCM g_set_zoom_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_zoom_color); 
  GH_COLOR_SET(zoom_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      (state->sgx)->zoom_color = v->color; 
      color_chan_components(v->color,COLOR_ZOOM);
    }
  return(color);
}

static SCM g_zoom_color(void) {return(pixel2color((state->sgx)->zoom_color));}

static SCM g_set_position_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_position_color); 
  GH_COLOR_SET(position_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      (state->sgx)->position_color = v->color; 
      color_chan_components(v->color,COLOR_POSITION);
    }
  return(color);
}

static SCM g_position_color(void) {return(pixel2color((state->sgx)->position_color));}

static SCM g_set_listener_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_listener_color); 
  GH_COLOR_SET(listener_color,color);
  v = get_snd_color(color);
  if (v) color_listener(v->color);
  return(color);
}

static SCM g_listener_color(void) {return(pixel2color((state->sgx)->listener_color));}

static SCM g_set_enved_waveform_color (SCM color) 
{
  snd_color *v;
  ERRCOL1(color,S_set_enved_waveform_color); 
  GH_COLOR_SET(enved_waveform_color,color);
  v = get_snd_color(color); 
  if (v) color_enved_waveform(v->color);
  return(color);
}

static SCM g_enved_waveform_color(void) {return(pixel2color((state->sgx)->enved_waveform_color));}

static SCM g_set_mix_waveform_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_mix_waveform_color);
  GH_COLOR_SET(mix_waveform_color,color);
  v = get_snd_color(color);
  if (v) 
    {
      color_mix_waveform(state,v->color);
      map_over_chans(state,update_graph,NULL);
    }
  return(color);
}

static SCM g_mix_waveform_color(void) {return(pixel2color((state->sgx)->mix_waveform_color));}

static SCM g_set_filter_waveform_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_filter_waveform_color);
  GH_COLOR_SET(filter_waveform_color,color);
  v = get_snd_color(color);
  if (v) color_filter_waveform(state,v->color);
  return(color);
}

static SCM g_filter_waveform_color(void) {return(pixel2color((state->sgx)->filter_waveform_color));}

static SCM g_set_mix_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_mix_color); 
  GH_COLOR_SET(mix_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      (state->sgx)->mix_color = v->color;
      map_over_chans(state,color_mixes,NULL);
    }
  return(color);
}

static SCM g_mix_color(void) {return(pixel2color((state->sgx)->mix_color));}

static SCM g_set_mix_focus_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_mix_focus_color); 
  GH_COLOR_SET(mix_focus_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      (state->sgx)->mix_focus_color = v->color;
      color_focused_mixes(state);
    }
  return(color);
}

static SCM g_mix_focus_color(void) {return(pixel2color((state->sgx)->mix_focus_color));}


static int recolor_button(Widget w, void *ptr)
{
  if (XtIsWidget(w))
    {
      if (XmIsPushButton(w))
	XtVaSetValues(w,XmNarmColor,(state->sgx)->pushed_button_color,NULL);
      else
	{
	  if (XmIsToggleButton(w))
	    XtVaSetValues(w,XmNselectColor,(state->sgx)->pushed_button_color,NULL);
	}
    }
  return(0);
}

static SCM g_set_pushed_button_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_pushed_button_color); 
  GH_COLOR_SET(pushed_button_color,color);
  v = get_snd_color(color); 
  if (v) 
    {
      (state->sgx)->pushed_button_color = v->color;
      map_over_children(main_SHELL(state),recolor_button,NULL);
    }
  return(color);
}

static SCM g_pushed_button_color(void) {return(pixel2color((state->sgx)->pushed_button_color));}

static SCM g_set_text_focus_color (SCM color) 
{
  snd_color *v; 
  ERRCOL1(color,S_set_text_focus_color); 
  GH_COLOR_SET(text_focus_color,color);
  v = get_snd_color(color); 
  if (v) (state->sgx)->text_focus_color = v->color;
  return(color);
}

static SCM g_text_focus_color(void) {return(pixel2color((state->sgx)->text_focus_color));}

static SCM g_load_colormap(SCM colors)
{
  int i,len;
  Pixel *xcs;
  snd_color *v;
  SCM_ASSERT((gh_vector_p(colors)),colors,SCM_ARG1,S_load_colormap);
  len = gh_vector_length(colors);
  xcs = (Pixel *)CALLOC(len,sizeof(Pixel));
  for (i=0;i<len;i++)
    {
      v = get_snd_color(gh_vector_ref(colors,gh_int2scm(i)));
      xcs[i] = v->color;
    }
  x_load_colormap(xcs);
  return(gh_int2scm(len));
}

static SCM g_graph_cursor(void)
{
  return(gh_int2scm(in_graph_cursor(state)));
}

static SCM g_set_graph_cursor(SCM curs)
{
  ERRN1(curs,S_set_graph_cursor);
  state->Graph_Cursor = gh_scm2int(curs);
  make_graph_cursor(state);
  return(curs);
}

void g_initialize_xgh(snd_state *ss)
{
  state = ss;
#if HAVE_MAKE_SMOB_TYPE
  snd_color_tag = scm_make_smob_type_mfpe("color",sizeof(snd_color),mark_snd_color,free_snd_color,print_snd_color,equalp_snd_color);
#else
  snd_color_tag = scm_newsmob(&snd_color_smobfuns);
#endif
#if HAVE_XmHTML
  gh_eval_str("(define XmHTML? (lambda nil 1))");
#else
  gh_eval_str("(define XmHTML? (lambda nil 0))");
#endif
  gh_new_procedure2_0(S_in,g_in);
#if HAVE_XmHTML
  gh_new_procedure0_0(S_html_dir,g_html_dir);
  gh_new_procedure1_0(S_set_html_dir,g_set_html_dir);
#endif
  gh_new_procedure3_0(S_make_color,g_make_snd_color);
  gh_new_procedure1_0(S_colorQ,g_color_p);
  gh_new_procedure1_0(S_set_basic_color,g_set_basic_color);
  gh_new_procedure0_0(S_basic_color,g_basic_color);
  gh_new_procedure1_0(S_set_zoom_color,g_set_zoom_color);
  gh_new_procedure0_0(S_zoom_color,g_zoom_color);
  gh_new_procedure1_0(S_set_position_color,g_set_position_color);
  gh_new_procedure0_0(S_position_color,g_position_color);
  gh_new_procedure1_0(S_set_mark_color,g_set_mark_color);
  gh_new_procedure0_0(S_mark_color,g_mark_color);
  gh_new_procedure1_0(S_set_listener_color,g_set_listener_color);
  gh_new_procedure0_0(S_listener_color,g_listener_color);
  gh_new_procedure1_0(S_set_mix_color,g_set_mix_color);
  gh_new_procedure0_0(S_mix_color,g_mix_color);
  gh_new_procedure1_0(S_set_mix_focus_color,g_set_mix_focus_color);
  gh_new_procedure0_0(S_mix_focus_color,g_mix_focus_color);
  gh_new_procedure1_0(S_set_mix_waveform_color,g_set_mix_waveform_color);
  gh_new_procedure0_0(S_mix_waveform_color,g_mix_waveform_color);
  gh_new_procedure1_0(S_set_enved_waveform_color,g_set_enved_waveform_color);
  gh_new_procedure0_0(S_enved_waveform_color,g_enved_waveform_color);
  gh_new_procedure1_0(S_set_filter_waveform_color,g_set_filter_waveform_color);
  gh_new_procedure0_0(S_filter_waveform_color,g_filter_waveform_color);
  gh_new_procedure1_0(S_set_highlight_color,g_set_highlight_color);
  gh_new_procedure0_0(S_highlight_color,g_highlight_color);
  gh_new_procedure1_0(S_set_graph_color,g_set_graph_color);
  gh_new_procedure0_0(S_graph_color,g_graph_color);
  gh_new_procedure1_0(S_set_selected_graph_color,g_set_selected_graph_color);
  gh_new_procedure0_0(S_selected_graph_color,g_selected_graph_color);
  gh_new_procedure1_0(S_set_data_color,g_set_data_color);
  gh_new_procedure0_0(S_data_color,g_data_color);
  gh_new_procedure1_0(S_set_selected_data_color,g_set_selected_data_color);
  gh_new_procedure0_0(S_selected_data_color,g_selected_data_color);
  gh_new_procedure1_0(S_set_cursor_color,g_set_cursor_color);
  gh_new_procedure0_0(S_cursor_color,g_cursor_color);
  gh_new_procedure1_0(S_set_selection_color,g_set_selection_color);
  gh_new_procedure0_0(S_selection_color,g_selection_color);
  gh_new_procedure1_0(S_set_pushed_button_color,g_set_pushed_button_color);
  gh_new_procedure0_0(S_pushed_button_color,g_pushed_button_color);
  gh_new_procedure1_0(S_set_text_focus_color,g_set_text_focus_color);
  gh_new_procedure0_0(S_text_focus_color,g_text_focus_color);

  gh_new_procedure0_0(S_graph_cursor,g_graph_cursor);
  gh_new_procedure1_0(S_set_graph_cursor,g_set_graph_cursor);
  gh_new_procedure1_0(S_load_colormap,g_load_colormap);

  /* these are not documented (intended to be hidden) -- needed for correct GC */
  basic_color = gh_define("basic_color",SCM_UNDEFINED);
  zoom_color = gh_define("zoom_color",SCM_UNDEFINED);
  position_color = gh_define("position_color",SCM_UNDEFINED);
  mark_color = gh_define("mark_color",SCM_UNDEFINED);
  listener_color = gh_define("listener_color",SCM_UNDEFINED);
  mix_color = gh_define("mix_color",SCM_UNDEFINED);
  mix_focus_color = gh_define("mix_focus_color",SCM_UNDEFINED);
  mix_waveform_color = gh_define("mix_waveform_color",SCM_UNDEFINED);
  enved_waveform_color = gh_define("enved_waveform_color",SCM_UNDEFINED);
  filter_waveform_color = gh_define("filter_waveform_color",SCM_UNDEFINED);
  sg_highlight_color = gh_define("highlight_color",SCM_UNDEFINED);
  graph_color = gh_define("graph_color",SCM_UNDEFINED);
  selected_graph_color = gh_define("selected_graph_color",SCM_UNDEFINED);
  data_color = gh_define("data_color",SCM_UNDEFINED);
  selected_data_color = gh_define("selected_data_color",SCM_UNDEFINED);
  cursor_color = gh_define("cursor_color",SCM_UNDEFINED);
  selection_color = gh_define("selection_color",SCM_UNDEFINED);
  pushed_button_color = gh_define("pushed_button_color",SCM_UNDEFINED);
  text_focus_color = gh_define("text_focus_color",SCM_UNDEFINED);
}
#endif
