#!/bin/sh
#  -*-tcl-*-\
exec wish8.0 "$0" ${1:+"$@"}

# Copyright (C) 1998, DGA - part of the Transcriber program
# distributed under the GNU General Public License (see COPYING file)

###############################################################

# Syntax: BgShape.tcl $signal_name $shape_name
# returns $shape_name if it succeeds, else the error message

# This script is launched as a background sub-process and computes a
# min/max shape at a centi-second scale of the whole signal in order
# to make signal display at low resolutions go faster within Transcriber.

# load sound (snack's tcl-only version) and trans packages.
set base [file dir [file dir [info script]]]
lappend auto_path $base [file dir $base]
package require sound
catch {
   package require snackSphere
}
# libtrans contains Tk widgets, so loading under tclsh could be a problem
# (but it doesn't raise any error under Linux...)
package require trans

proc Main {signame shpname {rate 16000} {channels 1} {header 0}} {
   set sound [sound]
   $sound config -file $signame -guessproperties 1 -frequency $rate -channels $channels -skiphead $header
   set tmpshp [file dir $shpname]/tmp[pid].shp
   $sound centi $tmpshp
   file rename -force -- $tmpshp $shpname
   puts $shpname
   exit
}

eval Main $argv