/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id#

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/param.h>

#include "wsound.h"


int             checkForFile (char *instrpath);

int
SFindSoundServer(void)
{
	Window         *lstChildren;
	Window          retRoot;
	Window          retParent;
	int             indexCount;
	u_int           numChildren;
	XClassHint     *retHint;
	
	dpy = XOpenDisplay("");
	
	if (!dpy) {
		sfatal(SMessageForError(SERR_NODISPLAY));
		wAbort();
	}
	
	_XA_WINDOWMAKER_WM_FUNCTION = XInternAtom(dpy, "_WINDOWMAKER_WM_FUNCTION", False);
	if (XQueryTree(dpy, DefaultRootWindow(dpy), &retRoot, &retParent, &lstChildren, &numChildren)) {
		for (indexCount = 1; indexCount < numChildren; indexCount++) {
			retHint = XAllocClassHint();
			if (!retHint) {
				XFree(lstChildren);
				SErrorCode = SERR_NOMEMORY;
				return -1;
			}
			XGetClassHint(dpy, lstChildren[indexCount], retHint);
			if (retHint->res_class) {
				if (strcmp("WMSoundServer", retHint->res_class) == 0) {
					wsoundserver = lstChildren[indexCount];
					XFree(lstChildren);
					if (retHint) {
						XFree(retHint);
					}
					return 0;
				}
			}
			XFree(retHint);
			retHint = 0;
		}
		XFree(lstChildren);
	}
	XCloseDisplay(dpy);

	return -1;
}



int
checkForFile(char *instrpath)
{
	return (access(instrpath, F_OK));
}


char*
SMapEventID(int wsEventID)
{
	switch (wsEventID) {
		case 1000:
				  return (S_STARTUP);
		case 1001:
				  return (S_SHADE);
		case 1002:
				  return (S_UNSHADE);
		case 1003:
				  return (S_MAXIMIZE);
		case 1004:
				  return (S_UNMAXIMIZE);
		case 1005:
				  return (S_ICONIFY);
		case 1006:
				  return (S_DEICONIFY);
		case 1007:
				  return (S_HIDE);
		case 1008:
				  return (S_UNHIDE);
		case 1009:
				  return (S_APPSTART);
		case 1010:
				  return (S_APPEXIT);
		case 1011:
				  return (S_USERDEF);
		default:
				  return (NULL);
	}
}


char*
SGetSoundFile(char *plKey)
{
	proplist_t      array, val;
	int             nr_elem = 0, i = 0;
	char		*strsndfile = NULL;
	char		*strpath = NULL;
	char		*strbuffer = NULL;
	
	strbuffer = SGetStringForKey(plKey);
	if (!strbuffer) {
		SErrorCode = SERR_NOKEY;
		return NULL;
	}

	strsndfile = strdup(strbuffer);
	strbuffer = NULL;
	if (!strsndfile) {
		SErrorCode = SERR_NOMEMORY;
		return NULL;
	}

	if (strcmp(strsndfile, "None") == 0) { /* SoundFile says None ... No need to search any further ... just don't play sound */
		strbuffer = strdup(strsndfile);
		if (!strbuffer) {
			SErrorCode = SERR_NOMEMORY;
			return NULL;
		}
		return strbuffer;
	}
	
	strbuffer = sexpandpath(strsndfile);
	if (strncmp(strbuffer, "/", 1) == 0) {
		return strbuffer;
	}
	free(strbuffer);
	strbuffer = NULL;
	
	array = SGetObjectForKey("SoundPath"); /* Do NOT Free */
	nr_elem = PLGetNumberOfElements(array);
	
	while (i < nr_elem) {
		val = PLGetArrayElement(array, i); /* Do NOT Free */
		strpath = sexpandpath(PLGetString(val));
		if (!strpath) {
			SErrorCode = SERR_NOFILE;
			return NULL;
		}
		strbuffer = (char *) malloc(MAXPATHLEN*sizeof(char));
		if (!strbuffer) {
			free(strpath);
			free(strsndfile);
			SErrorCode = SERR_NOMEMORY;
			return NULL;
		}
		strcpy(strbuffer, strpath);
		strcat(strbuffer, "/");
		strcat(strbuffer, strsndfile);
		if (checkForFile(strbuffer) == 0) {
			free(strpath);
			free(strsndfile);
			return strbuffer;
		}
		free(strpath);
		strpath = NULL;
		free(strbuffer);
		strbuffer = NULL;
		i++;
	}
	
	free(strsndfile);
	SErrorCode = SERR_NOFILE;
	
	return NULL;
}

char*
SGetSoundSetFile(char *sndsetfile)
{
	proplist_t	array, val;
	int		nr_elem = 0, i = 0;
	char		*strpath, *strbuffer;

	if (strncmp(sndsetfile, "/", 1) == 0) {
		strbuffer = strdup(sndsetfile);
		if (!strbuffer) {
			SErrorCode = SERR_NOMEMORY;
			return NULL;
		}
		return strbuffer;
	}
	
	array = SGetObjectForKey("SoundSetPath"); /* Do NOT Free */
	nr_elem = PLGetNumberOfElements(array);
	
	while (i < nr_elem) {
		val = PLGetArrayElement(array, i); /* Do NOT Free */
		strpath = sexpandpath(PLGetString(val));
		if (!strpath)
			return NULL;
		strbuffer = (char *) malloc(MAXPATHLEN*sizeof(char));
		if (!strbuffer) {
			free(strpath);
			return NULL;
		}
		strcpy(strbuffer, strpath);
		strcat(strbuffer, "/");
		strcat(strbuffer, sndsetfile);
		if (checkForFile(strbuffer) == 0) {
			free(strpath);
			return strbuffer;
		}
		free(strpath);
		strpath = NULL;
		free(strbuffer);
		strbuffer = NULL;
		i++;
	}
	
	return NULL;
}
