
#include <hash_map>

#include "repl.hh"
#include "map_repl.hh"
#include "refcount.hh"

namespace afilter {

  template <typename T>
  class SingleRepl : public CharReplTypes<T>, 
		     public MapReplBase<typename T::InValue, typename T::Value> 
  {
    typedef hash_map<InValue,String> Lookup;
    RefCount<Lookup> lookup;
  
  public:

    SingleRepl(const ConfigData *, const ReplOpts *) {}

    Base * clone() const {return new SingleRepl(*this);}
    void assign(const Base * other) {*this = *(const SingleRepl *)(other);}
  
    bool fill(InValue c, Itr *, Buffer * buffer) {
      Lookup::iterator i = lookup->find(c);
      if (i == lookup->end()) return false;
      add_to_buffer(*buffer, i->second, SingleMulti());
      return true;
    }
    void add (const InValue * k, const Value * v) {
      pair<InValue,String> temp;
      temp.first = *k;
      for (; *v != '\0'; ++v)        
	temp.second.push_back(*v);
      lookup->insert(temp);
    }
  };
}
