
#include <stdlib.h>

typedef struct aspell aspell;
typedef struct SC_Error aspellError;

typedef enum aspellProblem {
  as_none, as_nonexistent, as_bad_format, 
  as_cant_write, as_duplicates, 
  as_unknown_lang, as_mismatched_lang
} aspellProblem;

typedef const char * aspellString;

typedef struct aspellSuggestions {
  size_t size;
  aspellString * data;  /* an array of size elements */
  void *internal_obj;
} aspellSuggestions;

typedef struct aspellWordList {
  size_t size;
  aspellString * data;  /* an array of size elements */
  void *internal_obj;
} aspellWordList;


#ifdef __cplusplus
extern "C" {
#endif

  aspell * aspell_new(const char *master, const char *personal);
  void aspell_free(aspell *sc);
  const aspellError * aspell_error(aspell *sc);
  const char * aspell_lang_name(aspell *sc);
  aspellSuggestions * aspell_suggest(aspell *sc, const char *word);
  int aspell_check(aspell *sc, const char *word);
  int aspell_check_raw(aspell *sc, const char *word);
  void aspell_add_personal(aspell *sc, const char *word);
  void aspell_add_session(aspell *sc, const char *word);
  void aspell_save_dicts(aspell *sc);
  void aspell_clear_session(aspell *sc);
  void aspell_change_personal(aspell *sc, const char *base);
  aspellWordList * get_personal(aspell *sc); /* not implemented yet */
  aspellWordList * get_session(aspell *sc);  /* not implemented yet */
  
  void aspell_free_suggestions(aspellSuggestions *wl);
  void aspell_free_word_list(aspellWordList *wl);
  
  const char *  aspell_error_file(const aspellError *error);
  const char *  aspell_error_addinfo(const aspellError *error);
  aspellProblem aspell_error_problem(const aspellError *error);
  const char *  aspell_error_message(const aspellError *error);

#ifdef __cplusplus
};
#endif
