#ifndef __autil_clone_ptr_t__
#define __autil_clone_ptr_t__

#include <typeinfo>
#include "clone_ptr.hh"

namespace autil {

  template <typename Class> 
  ClonePtr<Class>::ClonePtr(const ClonePtr<Class> &other) {
    if (other.ptr) ptr = other.ptr->clone();
    else           ptr = 0;
  }

  template <typename Class>
  inline void clone_ptr_assign_same_id(ClonePtr<Class> & ths, 
				       const Class * other_ptr) 
  {
    ths.ptr->assign(other_ptr);
  }

  template <typename Class>
  inline void clone_ptr_assign_same_id(ClonePtr<const Class> & ths, 
				       const Class * other_ptr) 
  {
    delete ths.ptr;
    ths.ptr = other_ptr->clone();
  }

  template <typename Class>
  void ClonePtr<Class>::assign(const Class * other_ptr) 
  {
    if (ptr) {
      if (other_ptr) {
	if (typeid(*ptr) == typeid(*other_ptr)) {
	  clone_ptr_assign_same_id(*this, other_ptr);
	} else {
	  delete ptr;
	  ptr = other_ptr->clone();
	}
      } else {
	delete ptr;
	ptr = 0;
      }
    } else {
      if (other_ptr) ptr = other_ptr->clone();
      else           ptr = 0;
    }
  }
  
  template <typename Class>
  ClonePtr<Class> & 
  ClonePtr<Class>::operator= (Class * other) {
    delete ptr;
    ptr = other;
    return *this;
  }

  template <typename Class>
  void ClonePtr<Class>::del() {
    delete ptr;
    ptr = 0;
  }
  
  template <typename Class>
  ClonePtr<Class>::~ClonePtr() {
    delete ptr;
  }
  
}

#endif
