/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * tclcost.h,v 1.18 1999/06/26 01:32:47 joe Exp
 *
 * Author:	Joe English
 * Created:	Feb 1995
 * Description:	Bag of declarations, misc. macros.
 * Requires:	tcl.h
 */

#ifndef TCLCOST_H
#define TCLCOST_H 1

typedef struct	/* Cost global data */
{
    ESISNode		current_node;
    ESISDocument 	current_document;
    Tcl_HashTable	document_table;		/* map docname->ESISDocument */
    int			number_documents;	/* #documents in table */
} CostData;

/*+++
 * Convenience macros:
 */

#define CMDPROC(name) \
int name(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])

#define CHECKNARGS(nargs,argusage) \
    if (argc != nargs+1) { \
	Tcl_AppendResult(interp, "wrong #args\n", NULL); \
	Tcl_AppendResult(interp, "Usage: ", argv[0], " ", argusage, NULL); \
	return TCL_ERROR; \
    }

#define CHECKCURNODE(cd) \
    if (!cd->current_node) { \
	Tcl_AppendResult(interp, argv[0], ": no current node", NULL); \
	return TCL_ERROR; }

/*+++
 * Utility routines:
 */
extern char *skip_comments(char *); 

/*+++
 * Cost routines:
 */

extern int CostEval(Tcl_Interp *interp, CostData *cd, ESISNode nd, char *expr);
extern void CostRegisterDocument(Tcl_Interp *, CostData *, ESISDocument);

typedef struct CQAssoc *CQAssoc, CQAssocRec;

extern CQAssoc assocConstructor(Tcl_Interp *interp, CostData *cd, char *str);
extern void assocDestructor(ClientData);
extern CMDPROC(assocProc);

/*+++ External commands:
*/
extern CMDPROC(DefineSubstProc);
extern CMDPROC(DefineEnvironmentProc);
extern CMDPROC(CostLoadXMLProc);

/*+++ Initialization:
*/
#ifdef __WIN32__
#	define EXPORT __declspec(dllexport)
#else
#	define EXPORT
#endif
extern int EXPORT Cost_Init(Tcl_Interp *interp);

#endif /*TCLCOST_H*/
