## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Format/Texinfo: SGML conversion specification for Texinfo output format
## ----------------------------------------------------------------------
## Copyright (C) 1998,1999,2000 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
package DebianDoc_SGML::Format::Texinfo;
use strict;
use vars qw( @ISA @EXPORT );
use Exporter;
@ISA = ( 'Exporter' );
@EXPORT = qw ();

## ----------------------------------------------------------------------
## import packages
use SGMLS::Output;
use Text::Format;

## ----------------------------------------------------------------------
## layout definitions
$DebianDoc_SGML::Format::Driver::indent_level = 0;
my $text = new Text::Format;
$text->columns( 79 );
$text->firstIndent( 0 );
$text->extraSpace( 1 );

## ----------------------------------------------------------------------
## global variables
use vars qw( %nodes @main_menu %detailed_menu %sub_menus %current $node );

## ----------------------------------------------------------------------
## book output subroutines
## ----------------------------------------------------------------------
sub _output_start_book
{
    output( "\\input texinfo \@c -*- texinfo -*-\n" );
}
sub _output_end_book
{
    output( "\n" );
    output( "\@shortcontents\n" );
    output( "\n" );
    output( "\@contents\n" );
    output( "\n" );
    output( "\@bye\n");
    output( "\n" );
}

## ----------------------------------------------------------------------
## title page output subroutines
## ----------------------------------------------------------------------
sub _output_titlepag
{
    output( "\n" );
    output( "\@c %**start of header\n" );
    output( "\@c \@setfilename \n" );
    output( "\@settitle $DebianDoc_SGML::Format::Driver::title\n" );
    output( "\@setchapternewpage on\n" );
    output( "\@paragraphindent 0\n" );
    output( "\@c %**end of header\n" );
    output( "\n" );
    output( "\@ifinfo\n" );
    if ( length( $DebianDoc_SGML::Format::Driver::abstract ) )
    {
	output( $DebianDoc_SGML::Format::Driver::abstract );
    }
    if ( length( $DebianDoc_SGML::Format::Driver::copyright ) )
    {
	output( "\n" );
	output( $DebianDoc_SGML::Format::Driver::copyright );
    }
    output( "\n" );
    output( "\@end ifinfo\n" );
    output( "\n" );
    output( "\@titlepage\n" );
    output( "\n" );
    output( "\@title $DebianDoc_SGML::Format::Driver::title\n" );
    if ( length( $DebianDoc_SGML::Format::Driver::version ) )
    {
	output( "\n" );
	output( "\@subtitle $DebianDoc_SGML::Format::Driver::version\n" );
    }
    output( "\n" );
    grep( output( "\@author $_\n" ), @DebianDoc_SGML::Format::Driver::authors );
    output( "\n" );
    output( "\@page\n" );
    if ( length ( $DebianDoc_SGML::Format::Driver::copyright ) )
    {
	output( "\n" );
	output( "\@vskip 0pt plus 1filll\n" );
	output( $DebianDoc_SGML::Format::Driver::copyright );
    }
    output( "\n" );
    output( "\@end titlepage\n" );
}
sub _output_copyrightsummaries
{
    output( join( " \@*\n", @_ ), "\n" );
}

## ----------------------------------------------------------------------
## table of contents output subroutines
## ----------------------------------------------------------------------
my %section_name = (
		    '-2' => 'appendix',
		    '-1' => 'chapter',
		    '0' => 'section',
		    '1' => 'subsection',
		    '2' => 'subsubsection',
		    '3' => 'paragraph',
		    '4' => 'subparagraph',
		    );
sub _output_toc
{
    output( "\n" );
    output( "\@ifinfo\n" );
    output( "\n" );
    output( "\@node Top\n" );
    output( "\@top $DebianDoc_SGML::Format::Driver::title\n" );
    if ( length( $DebianDoc_SGML::Format::Driver::abstract ) )
    {
	output( $DebianDoc_SGML::Format::Driver::abstract );
    }
    output( "\@end ifinfo\n" );
    output( "\n" );
    output( "\@menu\n" );
    foreach ( @main_menu)
    {
	my ( $name, $number ) = split( / /, $_, 2 );
	output( "* $DebianDoc_SGML::Format::Driver::i18n{$name} $number\:\:\t\t$nodes{$_}\n" );
    }
    if ( keys %detailed_menu > 0 )
    {
	output( "\@detailmenu\n" );
	output( "\n" );
	output( " --- $DebianDoc_SGML::Format::Driver::i18n{'detailed'} ---\n" );
	foreach my $main ( @main_menu)
	{
	    next if $#{$detailed_menu{ $main }} < 0;
	    output( "\n" );
	    output( "$nodes{ $main }\n" );
	    output( "\n" );
	    foreach ( @{$detailed_menu{ $main }} )
	    {
		my $space = "";
		$space .= "\t" if m/section/;
		$space = " " . $space if m/^section/;
		my ( $name, $number ) = split( / /, $_, 2 );
		output( "* $DebianDoc_SGML::Format::Driver::i18n{$name} $number\:\:$space$nodes{$_}\n" );
	    }
	}
	output( "\@end detailmenu\n" );
    }
    output( "\@end menu\n" );
}
sub _output_tocentry
{
    if ( $_[1] == -1 )
    {
	$current{$_[1]} = ( $_[2] =~ m/^[A-Z]/ ? "appendix" : "chapter" )
	    . " $_[2]";
	push( @main_menu, $current{$_[1]} );
    }
    else
    {
	$current{$_[1]} = "$section_name{$_[1]} $_[2]";
	push( @{$detailed_menu{ $current{'-1'} }}, $current{$_[1]} );
	push( @{$sub_menus{ $current{$_[1]-1}}}, $current{$_[1]} ) if $_[1] < 3;
    }
    $nodes{ $current{$_[1]} } = $_[0];
}

## ----------------------------------------------------------------------
## section output subroutines
## ----------------------------------------------------------------------
my %section_markup = (
		      '-2' => "\@appendix",
		      '-1' => "\@chapter",
		      '0' => "\@section",
		      '1' => "\@subsection",
		      '2' => "\@subsubsection",
		      '3' => "\@unnumberedsubsubsec",
		      '4' => "\@subheading",
		      );
sub _output_chapter
{
    output( $_[0] );
}
sub _output_appendix
{
    output( $_[0] );
}
sub _output_heading
{
    if ( $#{$sub_menus{$node}} > -1 )
    {
	output( "\n" );
	output( "\@menu\n" );
	foreach ( @{$sub_menus{$node}} )
	{
	    my ( $name, $number ) = split( / /, $_, 2 );
	    output( "* $DebianDoc_SGML::Format::Driver::i18n{$name} $number\:\: $nodes{$_}\n" );
	}
	output( "\@end menu\n" );
    }
    if ( $section_name{$_[1]} !~ m/graph/ )
    {
	$node = "$section_name{$_[1]} $_[2]";
	output( "\n" );
	output( "\@node $DebianDoc_SGML::Format::Driver::i18n{$section_name{$_[1]}} $_[2]\n" );
    }
    output( "$section_markup{$_[1]} $_[0]\n" );
}

## ----------------------------------------------------------------------
## paragraph output subroutines
## ----------------------------------------------------------------------
sub _output_p
{
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact
	&& ( length( $_[0] )
	     || ( $DebianDoc_SGML::Format::Driver::is_special
		  && $DebianDoc_SGML::Format::Driver::will_be_compact ) );
    output( $text->format( "$_[0]\n" ) ) if length( $_[0] );
}

## ----------------------------------------------------------------------
## example output subroutines
## ----------------------------------------------------------------------
sub _output_example
{
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@example\n" );
    output( $_[0] );
    output( "\@end example\n" );
}

## ----------------------------------------------------------------------
## footnote output subroutines
## ----------------------------------------------------------------------
sub _output_footnote
{
    output( "\@footnote{$_[0]}" );
}

## ----------------------------------------------------------------------
## comment output subroutines
## ----------------------------------------------------------------------
sub _output_comment
{
}

## ----------------------------------------------------------------------
## list output subroutines
## ----------------------------------------------------------------------
sub _output_list
{
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@itemize \@bullet\n" );
    output( $_[0] );
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@end itemize\n" );
}
sub _output_enumlist
{
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@enumerate\n" );
    output( $_[0] );
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@end enumerate\n" );
}
sub _output_taglist
{
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@table \@asis\n" );
    output( $_[0] );
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@end table\n" );
}
sub _output_list_tag
{
}
sub _output_enumlist_tag
{
}
sub _output_taglist_tag
{
}
sub _output_list_item
{
    $_[0] =~ s/^\n//;
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@item\n" );
    output( $_[0] );
}
sub _output_enumlist_item
{
    $_[0] =~ s/^\n//;
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@item\n" );
    output( $_[0] );
}
sub _output_taglist_item
{
    $_[0] =~ s/^\n//;
    output( "\n" ) if ! $DebianDoc_SGML::Format::Driver::is_compact;
    output( "\@item " . shift( @{$_[1]} ) . "\n" );
    foreach ( @{$_[1]} )
    {
        output( "\@itemx $_\n" );
    }
    output( $_[0] );
}

## ----------------------------------------------------------------------
## emph output subroutines
## ----------------------------------------------------------------------
sub _output_em
{
    output( "\@emph{$_[0]}" );
}
sub _output_strong
{
    output( "\@strong{$_[0]}" );
}
sub _output_var
{
    output( "\@var{$_[0]}" );
}
sub _output_package
{
    output( "\@code{$_[0]}" );
}
sub _output_prgn
{
    output( "\@code{$_[0]}" );
}
sub _output_file
{
    output( "\@file{$_[0]}" );
}
sub _output_tt
{
    output( "\@samp{$_[0]}" );
}
sub _output_qref
{
    output( $_[0] );
}

## ----------------------------------------------------------------------
## xref output subroutines
## ----------------------------------------------------------------------
sub _output_ref
{
    my ( $name, $number ) = split( / /, $_[1], 2 );
    output( "\@ref{$DebianDoc_SGML::Format::Driver::i18n{$name} $number}, `$_[0]'" );
}
sub _output_manref
{
    output( "\@code{$_[0]($_[1])}" );
}
sub _output_email
{
    output( " " ) if ( $DebianDoc_SGML::Format::Driver::in_author );
    output( "\@email{$_[0]}" );
}
sub _output_ftpsite
{
    output( "\@url{$_[0]}" );
}
sub _output_ftppath
{
    output( "\@file{$_[1]}" );
}
sub _output_httpsite
{
    output( "\@url{$_[0]}" );
}
sub _output_httppath
{
    output( "\@file{$_[1]}" );
}
sub _output_url
{
    output( _sani( $_[1] ) ) if $_[1] ne "";
    output( " (" ) if $_[1] ne "";
    output( "\@url{" );
    output( _sani( $_[0] ) );
    output( "}" );
    output( ")" ) if $_[1] ne "";
}

## ----------------------------------------------------------------------
## data output subroutines
## ----------------------------------------------------------------------
sub _cdata
{
    output( _sani( $_[0] ) );
}
sub _sdata
{
    output( $DebianDoc_SGML::Format::Driver::sdata_mapping{ $_[0] } )
	if defined( $DebianDoc_SGML::Format::Driver::sdata_mapping{ $_[0] } );
}
sub _sani
{
    ( $_ ) = @_;

    # escape command characters
    s/\@/\@\@/g;
    s/{/\@{/g;
    s/}/\@}/g;

    # in examples no further replacement
    return $_ if $DebianDoc_SGML::Format::Driver::is_example;

    # hyphens
    s/--/---/g;

    # special symbols
    s/\.\.\./\@dots{} /g;

    return $_;
}

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
