/* 
 * DSSSL keyword type.
 */

#include "scheme.h"

int T_Keyword;

struct S_Keyword {
    Object unused;
    Object symbol;
};

#define KEYWORD(obj) ((struct S_Keyword *)POINTER(obj))

static Object keyword_property;

/* 
 * Keywords identity is implemented by attaching keyword objects to the
 * symbols of the same name, as a property.
 */

Object P_String_To_Keyword(Object str)
{
    Object s, k;

    Check_Type(str, T_String);

    s = P_String_To_Symbol(str);
    k = P_Get(s, keyword_property);
    if(!Truep(k))
    {
	Object argv[3];
	GC_Node;
	
	GC_Link(str);
	k = Alloc_Object(sizeof(struct S_Keyword), T_Keyword, 1);
	GC_Unlink;

	KEYWORD(k)->symbol = s;
	argv[0] = s;
	argv[1] = keyword_property;
	argv[2] = k;
	P_Put(3, argv);
    }

    return k;
}

Object P_Keyword_To_String(Object k)
{
    Check_Type(k, T_Keyword);

    return P_Symbol_To_String(KEYWORD(k)->symbol);
}

Object P_Keywordp(Object k)
{
    return TYPE(k) == T_Keyword ? True : False;
}

/* We never create two keywords with the same name, so we can use ==
 * to compare them.
 */

int keyword_equal(Object a, Object b)
{
    return KEYWORD(a) == KEYWORD(b);
}

/* 
 * Keywords are printed as the corresponding symbol followed by a colon.
 */

int keyword_print(Object k, Object port, int raw, int length, int depth)
{
    Print_Object(KEYWORD(k)->symbol, port, raw, length, depth);
    Printf(port, ":");
    return 0;
}

/* 
 * I'm not sure if this is needed (are symbols garbage collected?), nor
 * am I sure what it should return.
 */

int keyword_visit(Object *k, int (*visit)(Object *))
{
    return visit(&KEYWORD(*k)->symbol);
}

void elk_init_keyword(void)
{
    T_Keyword = Define_Type(0, "keyword", 0, sizeof(struct S_Keyword), 
			    keyword_equal, keyword_equal,
			    keyword_print, keyword_visit);

    Define_Primitive(P_String_To_Keyword, "string->keyword", 1, 1, EVAL);
    Define_Primitive(P_Keyword_To_String, "keyword->string", 1, 1, EVAL);
    Define_Primitive(P_Keywordp, "keyword?", 1, 1, EVAL);
    
    keyword_property = Intern("d!keyword");
}

