/* 
 * DSSSL quantity type.
 */

#include "scheme.h"

int T_Quantity;

struct S_Quantity {
    Object unused;
    Object number;
    Object dimension;
};

#define QUANTITY(obj) ((struct S_Quantity *)POINTER(obj))

/* 
 * A quantity is a number times a dimension (= power of metre).  The
 * implementation of defined units and quantity arithmetic is handled
 * in scheme.
 */

Object P_Make_Quantity(Object number, Object dimension)
{
    Object q;
    GC_Node2;

    Check_Number(number);
    Check_Type(dimension, T_Fixnum);

    /* Canonicalise dimensionless quantities to numbers */
    /* (XXX is this allowed?  don't want to make nth etc handle quantities) */

    if(Truep(P_Zerop(dimension)))
	return number;

    GC_Link2(number, dimension);
    q = Alloc_Object(sizeof(struct S_Quantity), T_Quantity, 1);
    GC_Unlink;

    QUANTITY(q)->number = number;
    QUANTITY(q)->dimension = dimension;

    return q;
}

Object P_Quantity_To_Number(Object q)
{
    if(Truep(P_Numberp(q)))
	return q;

    Check_Type(q, T_Quantity);

    return QUANTITY(q)->number;
}

static Object zero;
Object P_Quantity_Dimension(Object q)
{
    if(Truep(P_Numberp(q)))
	return zero;

    Check_Type(q, T_Quantity);

    return QUANTITY(q)->dimension;
}

Object P_Quantityp(Object q)
{
    return TYPE(q) == T_Quantity ? True : False;
}

int quantity_equal(Object a, Object b)
{
    Object argv[2];

    argv[0] = QUANTITY(a)->number;
    argv[1] = QUANTITY(b)->number;

    if(!Truep(P_Generic_Equal(2, argv)))
	return 0;
	
    argv[0] = QUANTITY(a)->dimension;
    argv[1] = QUANTITY(b)->dimension;

    return Truep(P_Generic_Equal(2, argv)) ? 1 : 0;
}

/* 
 * Quantities are printed as the number, followed by "m", followed
 * by the dimension.
 */

int quantity_print(Object q, Object port, int raw, int length, int depth)
{
    /* XXX What are the length and depth args? */
    GC_Node2;
    GC_Link2(q, port);
 
    Print_Object(QUANTITY(q)->number, port, raw, length, depth);
    Printf(port, "m");
    if(FIXNUM(QUANTITY(q)->dimension) != 1)
	Print_Object(QUANTITY(q)->dimension, port, raw, length, depth);
    GC_Unlink;
    return 0;
}

/* 
 * I am not sure what this should return.
 */

static quantity_visit(register Object *q, register (*visit)(Object *))
{
    (*visit)(&QUANTITY(*q)->number);
    (*visit)(&QUANTITY(*q)->dimension);
}

void elk_init_quantity(void)
{
    T_Quantity = Define_Type(0, "quantity", 0, sizeof(struct S_Quantity), 
			    quantity_equal, quantity_equal,
			    quantity_print, quantity_visit);

    Define_Primitive(P_Make_Quantity, "make-quantity", 2, 2, EVAL);
    Define_Primitive(P_Quantity_To_Number, "quantity->number", 1, 1, EVAL);
    Define_Primitive(P_Quantity_Dimension, "quantity-dimension", 1, 1, EVAL);
    Define_Primitive(P_Quantityp, "quantity?", 1, 1, EVAL);

    zero = Make_Integer(0);
}

