/*
 * Module for the routines to decide whether file will be hidden on directory view.
 *
 * See hide.h about the details.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#if defined(HAVE_STRING_H)
#include <string.h>
#elif defined(HAVE_STRINGS_H)
#include <strings.h>
#endif
#include <glib.h>


/**
 * hide_emacs_backup:
 **/
gboolean
hide_emacs_backup(const char *fname)
{
	int lenb;

	lenb = strlen(fname);
	if (fname[lenb-1] == '~')
		return TRUE;
	return FALSE;
}

/**
 * hide_obj_file:
 **/
gboolean
hide_obj_file(const char *fname)
{
	int lenb;

	lenb = strlen(fname);
	if (strcmp(&fname[lenb-2], ".o") == 0)
		return TRUE;
	return FALSE;
}
