/*
 * Copyright (c) 1997  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef LINEBUF_H
#define LINEBUF_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>


typedef struct {
    char *buffer;		/* buffer */
    char *current;		/* end of data in `buffer' */
    size_t bufsize;		/* size of `buffer' */
    size_t restsize;		/* size of unprocessed data in `buffer' */
} Line_Buffer;
 

/*
 * Function declarations.
 */
#ifdef __STDC__
int initialize_line_buffer(Line_Buffer *, size_t);
void clear_line_buffer(Line_Buffer *);
int have_rest_in_line_buffer(Line_Buffer *);
void reset_line_buffer(Line_Buffer *);
size_t line_buffer_size(Line_Buffer *);
ssize_t read_line_buffer(Line_Buffer *, char *, int);
int skip_line_buffer(Line_Buffer *, int);
#else
int initialize_line_buffer();
void clear_line_buffer();
int have_rest_in_line_buffer();
void reset_line_buffer();
size_t line_buffer_size();
ssize_t read_line_buffer();
int skip_line_buffer();
#endif

#endif /* not LINEBUF_H */
