
#include "lib.h"


char **
strarr_add (char **table, int *ntable, char const *str)
{
  table = (char **) xrealloc (table, (*ntable + 1) * sizeof (char *));
  table[*ntable] = xstrdup (str);
  (*ntable)++;

  return (table);
}


#if HAVE_HSEARCH_R

#include <search.h>
#include <errno.h>

char **
strtab_add (char **table, int *ntable, char const *str)
{
  int i;
  ENTRY e, *e_p;
  struct hsearch_data* hash_table_p = (struct hsearch_data*)table;

  if (!hash_table_p)
    {
      hash_table_p = (struct hsearch_data*) xrealloc (0, sizeof (struct hsearch_data));
      hash_table_p->table = 0;
      hcreate_r (HSEARCH_MAX, hash_table_p);
    }

  if (strtab_find (table, *ntable, str) != -1)
    {
      (*ntable)++;
      return (char**)hash_table_p;
    }
    
  e.key = xstrdup (str);
  e.data = (char*)*ntable;
  hsearch_r (e, ENTER, &e_p, hash_table_p);
  if(!e_p)
    error ("can't add to hashtable:" "%s", strerror (errno));
  
  (*ntable)++;

  return (char**)hash_table_p;
}

#endif /* HAVE_HSEARCH_R */
