
#include "yodl.h"

void
gram_RENAMEMACRO ()
{
  char
   *macname, *newname;
  int
    index;

  macname = gram_parlist (builtin_get (idx_RENAMEMACRO), 0);
  gram_onename (builtin_get (idx_RENAMEMACRO), macname);

  while (lextok == tok_space ||	/* skip spaces, newlines */
	 lextok == tok_newline
    )
    lexer ();

  newname = gram_parlist (builtin_get (idx_RENAMEMACRO), 0);
  gram_onename (builtin_get (idx_RENAMEMACRO), newname);

  message (3, "%s %s %s\n", builtin_get (idx_RENAMEMACRO), macname, newname);

  if ((index = strarr_find (builtin, nbuiltin, macname)) >= 0)
    {
      free (builtin[index]);
      builtin[index] = newname;
    }
  else if ((index = strtab_find (userdef, nuserdef, macname)) >= 0)
    {
      free (userdef[index]);
      userdef[index] = newname;
    }
  else
    error_gram (builtin_get (idx_RENAMEMACRO),
		"cannot find macro named %s", macname);

  free (macname);
}
