
/* required standard includes */
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "config.h"
#include "../lib/lib.h"

/* the passes that we have to make */
#define FIRSTPASS   0
#define LASTPASS    1

/* the action flags for this program */
typedef struct
  {
    int labels:1;		/* fix labels, refs, links request */
    int tableofcontents:1;	/* make table of contents request */
    int removeblank:1;		/* remove blank lines request */
    int killblanks:1;		/* actually in remove-blank state? */
    int onepass:1;		/* single pass mode request */
    int roff:1;			/* handle roff cmds request */
    int protectdot:1;		/* protect .XX lines request */
  }
FLAGS;

/* functions */
extern void dumptable (char **table, int start, int ntable);
extern void handleline (char *buf, int pass);
extern void handlenotag (char *buf, int pass);
extern void handletag (char *buf, int pass);
extern void label (char **table, int ntable, int pass);
extern void lastnumber (char **table, int ntable, int pass);
extern void parseflags (int *ac, char ***av);
extern void ref (char **table, int ntable, int pass);
extern void roffcmd (char **table, int ntable, int pass);
extern void tableofcontents (int pass);
extern void tocentry (char **table, int ntable, int pass);
extern void runpass (int pass);
extern void usage (void);

/* global data */
#ifndef EXTERN
#define EXTERN extern
#endif
EXTERN FLAGS
  act;				/* action flags */
EXTERN FILE
* inf,				/* input file */
 *outf;				/* output file */
EXTERN char
 *lastnum;			/* last used numbering command */
EXTERN char
**lab,				/* labels */
**num;				/* and the numbers they refer to */
EXTERN int
  nlab,				/* table sizes */
  nnum;
EXTERN int
  lineno;			/* line number */
EXTERN char
***toc;				/* lines of table of contents */
EXTERN int
 *tocsize;
EXTERN int
  ntoc;				/* # of lines in toc */
