/*
AutoConvert, a Chinese HZ/GB/Big5 encodings auto-converter
Copyright (C) 1999  ڹ  Yu Guanghui <ygh@dlut.edu.cn>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*/
/* 
* author: Yu Guanghui <ygh@rose.dlut.edu.cn>
*	  Network Center
* 	  Dalian Univ. of Tech.	
*	  $Header: /home/ygh/.cvsroot/autoconvert/lib.c,v 1.6 1999/12/28 04:52:00 ygh Exp $
*/

#include <stdio.h>

#include "config.h"

int j_code(char * buff,int count)
{
	unsigned char * phz;
	int c_gb=0;
	int c_big5=0;

	char HZ_START[]="~{";
	char HZ_END[]="~}";



	for(phz=buff;phz<(buff+count);phz++){
		if(*phz & 0x80){
			if((*phz==0xB5&&*(phz+1)==0xC4) || ((*phz==0xCE)&&*(phz+1)==0xD2)){
				c_gb++;
				phz++;
				continue;
			}else if((*phz==0xAA&&*(phz+1)==0xBA)|| ((*phz==0xA7)&&*(phz+1)==0xDA)){
				c_big5++;
				phz++;
				continue;
			}
			phz++;
		}
	}


	if(c_gb > c_big5){
		return GB_CODE;
	}else if (c_gb ==  c_big5){ //c_gb == 0,c_big5==0
		if(strstr(buff,HZ_START)!=NULL && strstr(buff,HZ_END)!=NULL){
			return HZ_CODE;
		}
		return j_code2(buff,count);		
	}else{
		return BIG5_CODE;
	}
}

int j_code2(char * buff,int count)
{
	unsigned char * phz;
	int c_gb=0;
	
	for(phz=buff;phz<(buff+count);phz++){
		if(*phz & 0x80){
			if ((*phz >= 0xF8 && *phz <= 0xF9) && ( (*(phz+1) >= 0x40 && *(phz+1) <= 0x7E) || (*(phz+1) >= 0xA1 && *(phz+1) <= 0xFE ))){
				return BIG5_CODE;
			}
			if ((*phz >= 0xA1 && *phz <= 0xF7) && (* (phz+1) >= 0x40 && *(phz+1) <= 0x7E)){
				return BIG5_CODE;
			}
			if ((*phz >= 0xA1 && *phz <= 0xF7) && (* (phz+1) >= 0xA1 && *(phz+1) <= 0xFE)){
				c_gb++;
			}
			phz++;
			continue;
		}
	}

	if( c_gb ==0 ){
		return OTHER_CODE;
	}else {
		return GB_CODE;
	}

}

