#! /bin/sh
#
# apcupsd       This shell script takes care of starting and stopping
#               the apcupsd UPS monitoring daemon.
#
# chkconfig: 2345 10 99
# description: apcupsd monitors power and takes action if necessary
#
# Source function libarary
. /etc/rc.d/init.d/functions


case "$1" in
    start)
	if [ -x /sbin/powersc ]; then
		action "Starting UPS monitoring:" /sbin/powersc INIT nomsgs
		touch /var/lock/subsys/apcups
	fi
    ;;
    stop)
	action "Shutting down UPS monitoring:" /sbin/powersc STOP nomsgs
	rm -f /var/lock/subsys/apcups
    ;;
    restart)
	action "Restarting UPS monitoring:" /sbin/powersc RESTARTME nomsgs
    ;;
    status)
    ;;
    *)
    echo "Usage: $0 {start|stop}"
    exit 1
esac

exit 0
