cat <<EOF
%define name apcupsd
%define version ${1}
%define release 1
%define builddir \$RPM_BUILD_DIR/%{name}-%{version}
Name:		%{name}
Version:	%{version}
Release:	%{release}
Vendor:		APC UPS Daemon Team
Packager:	Andre Hedrick <hedrick@astro.dyer.vanderbilt.edu>
URL:		http://www.dyer.vanderbilt.edu/server/apcupsd/
Source:         %{name}-%{version}.tar.gz
Group:		Applications/Daemon
Copyright:	GPL
Icon:		apcupsd.gif
Requires:	
BuildRoot:	/var/tmp/%{name}-%{version}
Summary:	UPS power management under Linux for APCC Products.

%description
		BackUPS, BackUPS Pro, SmartUPS V/S, and SmartUPS(NET/RM)
		success. MatrixUPS and ShareUPS testing stage.
		SmartUPS V/S is untested, but should be okay.
		It allows your computer/server to run during power problems
		for a specified length of time or the life of the batteries
		in your BackUPS, BackUPS Pro, SmartUPS v/s, or SmartUPS, and
		then properly executes a controlled shutdown during an
		extended power failure.
		The following APC cables are supported fully:
		940-0020B, 940-0024B, 940-0024C, 940-0095A, 940-0095C(maybe),
		940-0023A(Last resort, please pick another.)
		Successful tests on BackUPS 400/600, BackUPS Pro 420/650/1400,
		SmartUPS v/s, and SmartUPS SU700RM/SU1250/SU1400RM w/ SMNP
		PowerNET card. Current testing with ShareUPS/SU3000 Matrix.
		EtherUPS or NetUPS is clean and works but needs slave
		disconnect/reconnect polish.
		APCaccess is the IPC management tool for "apcupsd".
		APCaccess is used to manage slaves locally.

%prep
%setup

%build
CFLAGS="\$RPM_OPT_FLAGS" ./configure --prefix=/usr --sbindir=/sbin --enable-powerflute --enable-nls
make

%install
if [ -d \$RPM_BUILD_ROOT ]; then rm -rf \$RPM_BUILD_ROOT; fi
mkdir -p \$RPM_BUILD_ROOT/{etc/X11/wmconfig,usr/lib/rhs/control-panel}
make install prefix=\$RPM_BUILD_ROOT/usr
cp %{builddir}/redhat/*.{xpm,init} \$RPM_BUILD_ROOT/usr/lib/rhs/control-panel
cp %{builddir}/fetchmail.man \$RPM_BUILD_ROOT/usr/man/man1/fetchmail.1
gzip -9f \$RPM_BUILD_ROOT/usr/man/man1/fetchmail.1
cd \$RPM_BUILD_ROOT/usr/man/man1
ln -sf fetchmail.1.gz fetchmailconf.1.gz
rm -rf %{builddir}/contrib/RCS
chmod 644 %{builddir}/contrib/*
cp %{builddir}/redhat/fetchmailconf.wmconfig \$RPM_BUILD_ROOT/etc/X11/wmconfig/fetchmailconf

%clean
rm -rf \$RPM_BUILD_ROOT

%files
%defattr (644, root, root, 755)
%doc README NEWS NOTES FAQ COPYING FEATURES sample.rcfile contrib
%doc fetchmail-features.html fetchmail-FAQ.html design-notes.html
/usr/lib/rhs/control-panel/fetchmailconf.xpm
/usr/lib/rhs/control-panel/fetchmailconf.init
/etc/X11/wmconfig/fetchmailconf
%defattr (644, root, man)
/usr/man/man1/*.1.gz
%defattr (755, root, root)
/usr/bin/fetchmail
/usr/bin/fetchmailconf
EOF
