#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include "gnap.h"
#include "callbacks.h"
#include "interface.h"

extern main_window *the_window;
extern GtkWidget *properties_window;

static GnomeUIInfo file_menu_uiinfo[] = {
  GNOMEUIINFO_MENU_EXIT_ITEM (exit_cb, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu_uiinfo[] = {
  GNOMEUIINFO_MENU_SELECT_ALL_ITEM (menu_select_all_cb, NULL),
  GNOMEUIINFO_MENU_NEW_ITEM(N_("Select _None"), N_("Unselect everything"),menu_unselect_all_cb, NULL), 
  GNOMEUIINFO_MENU_CLEAR_ITEM (menu_clear_all_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_NEW_ITEM(N_("_Crop"), N_("Delete all unselected items"),menu_crop_cb, NULL), 
  GNOMEUIINFO_MENU_NEW_ITEM(N_("_Delete"), N_("Delete all selected items"),menu_delete_cb, NULL), 
  GNOMEUIINFO_END
};

static GnomeUIInfo windows_menu_uiinfo[] = {
  GNOMEUIINFO_MENU_NEW_ITEM(N_("Downloads..."), N_("Window of all current downloads"),download_window_cb,NULL), 
  GNOMEUIINFO_MENU_NEW_ITEM(N_("Queue..."),N_("Queue of downloads"),queue_window_cb, NULL), 
  GNOMEUIINFO_MENU_NEW_ITEM(N_("MOTD..."), N_("Message of the day"),motd_window_cb, NULL), 
  GNOMEUIINFO_END
};

static GnomeUIInfo settings_menu_uiinfo[] = {
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (preferences_cb, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo help_menu_uiinfo[] = {
  GNOMEUIINFO_MENU_ABOUT_ITEM (about_cb, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo menubar_uiinfo[] = {
  GNOMEUIINFO_MENU_FILE_TREE (file_menu_uiinfo),
  GNOMEUIINFO_MENU_EDIT_TREE (edit_menu_uiinfo),
  GNOMEUIINFO_MENU_WINDOWS_TREE(windows_menu_uiinfo),
  GNOMEUIINFO_MENU_SETTINGS_TREE (settings_menu_uiinfo),
  GNOMEUIINFO_MENU_HELP_TREE (help_menu_uiinfo),
  GNOMEUIINFO_END
};

GtkWidget *create_download_window(void) 
{
 GtkWidget *dialog;
 GtkWidget *scrolled_window;
 GtkWidget *clist;
 gchar *labels[4] = {_("File"), _("From"), _("%"), _("KB/sec")};

 dialog = gnome_dialog_new("Download Window",_("Abort Download"),NULL);
 gnome_dialog_close_hides(GNOME_DIALOG(dialog),TRUE);

 scrolled_window = gtk_scrolled_window_new(NULL,NULL);
 gtk_widget_set_usize(scrolled_window,400,200);
 gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox),scrolled_window,TRUE,TRUE,5); 

 clist = gtk_clist_new_with_titles(4,labels);
 gtk_container_add(GTK_CONTAINER(scrolled_window),clist);
 gtk_clist_set_column_width(GTK_CLIST(clist),0,200);
 gtk_clist_set_column_width(GTK_CLIST(clist),1,70);
 gtk_clist_set_column_width(GTK_CLIST(clist),2,30);
 gtk_object_set_data (GTK_OBJECT(dialog),"clist",clist);

 gtk_signal_connect (GTK_OBJECT(dialog),"clicked",download_button_cb,clist);

 return dialog;
}

GtkWidget *create_queue_window(void) 
{
  //GtkWidget *scrolled_window;
  //scrolled_window = gtk_scrolled_window_new(NULL,NULL);
}

void create_main_window ()
{
  GtkWidget *hbox;
  GtkWidget *gtk_search_entry;
  GtkWidget *label;
  GtkWidget *dock;
  GtkWidget *scrolled_window;
  gchar *titles[6] = {
    N_("Song"),
    N_("Computer"),
    N_("Speed"),
    N_("Size (MB)"),
    N_("Bitrate"),
    N_("Length")
  };


  the_window->app = gnome_app_new ("gnap", "gnap");

  // setup appbar
  the_window->appbar = gnome_appbar_new (FALSE , TRUE, GNOME_PREFERENCES_NEVER);

  // "toolbar" .. actualy a dock.. we'll use this until we can expand inside toolbar
  dock = gnome_dock_item_new("gnap-search_bar",(GNOME_DOCK_ITEM_BEH_EXCLUSIVE | GNOME_DOCK_ITEM_BEH_NEVER_VERTICAL));
  gtk_container_set_border_width(GTK_CONTAINER(dock),4); 
  gnome_dock_add_item(GNOME_DOCK(GNOME_APP(the_window->app)->dock), GNOME_DOCK_ITEM (dock), GNOME_DOCK_TOP, 1, 0, 0, FALSE);
  gtk_widget_show(dock);

  hbox = gtk_hbox_new (0,3);
  gtk_container_add(GTK_CONTAINER(dock),hbox);
  gtk_widget_show(hbox);
  
  label = gtk_label_new(_("Search: "));
  gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(label),0,0,2);
  gtk_widget_show(label); 

  the_window->search_entry = gnome_entry_new("gnap-history");
  gtk_widget_grab_focus(the_window->search_entry);
  gtk_search_entry = gnome_entry_gtk_entry(GNOME_ENTRY(the_window->search_entry));
  gtk_signal_connect (GTK_OBJECT (gtk_search_entry), "activate",search_cb, NULL);
  gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(the_window->search_entry),1,1,2);
  gtk_widget_show(the_window->search_entry);

  // animator
//  the_window->animator = gnome_animator_new_with_size(30,40);
//  pixmap = gnome_pixmap_new_from_rgb_d((gchar*)flowerimage.pixel_data,flowerimage.bytes_per_pixel,flowerimage.width,flowerimage.height); 
//  gnome_animator_append_frame_from_gnome_pixmap(the_window->animator, pixmap,0,0,200);
//  gnome_animator_append_frame_from_gnome_pixmap(the_window->animator, pixmap,2,0,200);
//  gnome_animator_append_frame_from_gnome_pixmap(the_window->animator, pixmap,4,0,200);
//  gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(the_window->animator),0,0,1);
//  gtk_widget_show(the_window->animator);

  // clist and scrolled window..
  scrolled_window = gtk_scrolled_window_new(NULL,NULL);
  gtk_widget_set_usize(scrolled_window,500,200);
  gtk_widget_show(scrolled_window);

  the_window->clist = gtk_clist_new_with_titles (6, titles);
  // FIXME: make its so column 0 resizes when the window resizes, not column 5
  //gtk_clist_set_column_auto_resize(GTK_CLIST(the_window->clist),0,1);
  //gtk_clist_set_column_auto_resize(GTK_CLIST(the_window->clist),5,0);
  gtk_clist_set_selection_mode(GTK_CLIST(the_window->clist),GTK_SELECTION_EXTENDED );
  gtk_clist_set_column_min_width(GTK_CLIST(the_window->clist),0,170);
  gtk_clist_set_column_min_width(GTK_CLIST(the_window->clist),1,60);
  gtk_clist_set_column_min_width(GTK_CLIST(the_window->clist),2,60);
  gtk_clist_set_column_min_width(GTK_CLIST(the_window->clist),3,60);
  gtk_clist_set_column_min_width(GTK_CLIST(the_window->clist),4,40);
  gtk_clist_set_column_min_width(GTK_CLIST(the_window->clist),5,40);

  gtk_clist_set_column_max_width(GTK_CLIST(the_window->clist),1,80);
  gtk_clist_set_column_max_width(GTK_CLIST(the_window->clist),2,60);
  gtk_clist_set_column_max_width(GTK_CLIST(the_window->clist),3,60);
  gtk_clist_set_column_max_width(GTK_CLIST(the_window->clist),4,40);
  gtk_clist_set_column_max_width(GTK_CLIST(the_window->clist),5,40);

  gtk_clist_set_column_width(GTK_CLIST(the_window->clist),0,170);
  gtk_clist_set_column_width(GTK_CLIST(the_window->clist),1,60);
  gtk_clist_set_column_width(GTK_CLIST(the_window->clist),2,60);
  gtk_clist_set_column_width(GTK_CLIST(the_window->clist),3,60);
  gtk_clist_set_column_width(GTK_CLIST(the_window->clist),4,40);
  gtk_clist_set_column_width(GTK_CLIST(the_window->clist),5,50);


  gtk_signal_connect (GTK_OBJECT (the_window->clist), "select-row", GTK_SIGNAL_FUNC (select_row_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (the_window->clist), "unselect-row", GTK_SIGNAL_FUNC (unselect_row_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (the_window->clist), "select-all", GTK_SIGNAL_FUNC (select_all_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (the_window->clist), "unselect-all", GTK_SIGNAL_FUNC (unselect_all_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (the_window->clist), "button_press_event", GTK_SIGNAL_FUNC (main_popup_cb), NULL);

  gtk_container_add(GTK_CONTAINER(scrolled_window),the_window->clist);
  gtk_widget_show (the_window->clist);

  // fill in all the parts of the gnome app
  gnome_app_set_statusbar (GNOME_APP (the_window->app), the_window->appbar);
  gnome_app_create_menus (GNOME_APP (the_window->app), menubar_uiinfo);
  gnome_app_set_contents (GNOME_APP (the_window->app), scrolled_window);

  gtk_signal_connect (GTK_OBJECT (the_window->app), "destroy",GTK_SIGNAL_FUNC (exit_cb), NULL);
}

void missing_fields_dialog()
{
  GtkWidget *dialog;
  dialog = gnome_message_box_new(_("You have not entered all the required fields!"),GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
  gtk_widget_show(dialog);
  gnome_dialog_run(GNOME_DIALOG(dialog));
}

gint create_undefined_user_window(void)
{
 GtkWidget *dialog;

 dialog = gnome_message_box_new(_("Do you already have an existing napster account?"),GNOME_MESSAGE_BOX_GENERIC,GNOME_STOCK_BUTTON_NO, GNOME_STOCK_BUTTON_YES,  NULL);

 return gnome_dialog_run (GNOME_DIALOG (dialog));
}

// -1 = fail.. closed box. 
// 0 = did well, saved user config
// 1 = didn't fill in all fields
gint create_new_user_window(void) 
{
 GtkWidget *dialog;
 GtkWidget *vbox_main;
 GtkWidget *frame_top;
 GtkWidget *table_top;
 GtkWidget *label_username;
 GtkWidget *label_password;
 GtkWidget *label_connection;
 GtkWidget *label_email;
 GtkWidget *frame_bottom;
 GtkWidget *table_bottom;
 GtkWidget *label_upload;
 GtkWidget *label_download;
 GtkWidget *entry_username;
 GtkWidget *entry_password;
 GtkWidget *entry_email;
 GtkWidget *combo;
 GtkWidget *fileentry_upload;
 GtkWidget *fileentry_download;
 gint i;
 GList *connect_options = NULL;

 struct entrys{
  GtkWidget *username;
  GtkWidget *password;
  GtkWidget *email;
  GtkWidget *connection;
  GtkWidget *upload;
  GtkWidget *download;
 } input;

 //struct entrys input;

 dialog = gnome_dialog_new (_("New User"),_("Configure gnap!"),NULL);

 vbox_main = gtk_vbox_new (FALSE, 0);
 gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox),vbox_main,TRUE,TRUE,0);

 // first frame
 frame_top = gtk_frame_new (_("User:"));
 gtk_box_pack_start (GTK_BOX (vbox_main), frame_top, TRUE, TRUE, 0);
 gtk_container_set_border_width (GTK_CONTAINER (frame_top), 4);
 gtk_frame_set_shadow_type (GTK_FRAME (frame_top),GTK_SHADOW_ETCHED_OUT);

 table_top = gtk_table_new (4, 2, FALSE);
 gtk_container_add (GTK_CONTAINER (frame_top), table_top);
 gtk_table_set_col_spacings (GTK_TABLE (table_top), 12);

 // labels 
 label_username = gtk_label_new (_("Username:"));
 gtk_table_attach (GTK_TABLE (table_top), label_username, 0, 1, 0, 1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
 label_password = gtk_label_new (_("Password:"));
 gtk_table_attach (GTK_TABLE (table_top), label_password, 0, 1, 1, 2, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
 label_connection = gtk_label_new (_("Connection Type:"));
 gtk_table_attach (GTK_TABLE (table_top), label_connection, 0, 1, 2, 3, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
 label_email = gtk_label_new (_("Email Address:"));
 gtk_table_attach (GTK_TABLE (table_top), label_email, 0, 1, 3, 4, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

 //  entrys
 entry_username = gtk_entry_new();
 input.username = entry_username;
 gtk_table_attach (GTK_TABLE (table_top), entry_username, 1, 2, 0, 1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
 entry_password = gtk_entry_new ();
 input.password = entry_password;
 gtk_entry_set_visibility(GTK_ENTRY(entry_password),0);
 gtk_table_attach (GTK_TABLE (table_top), entry_password, 1, 2, 1, 2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

 // combo box for connection type
 combo = gtk_combo_new();
 gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),0);
 for(i=0;i<=10;i++) {
  connect_options = g_list_append(connect_options, gnap_int_to_connection(i));
 }
 gtk_combo_set_popdown_strings (GTK_COMBO (combo), connect_options);
 gtk_table_attach (GTK_TABLE (table_top), combo, 1, 2, 2, 3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
 input.connection = GTK_COMBO(combo)->entry;

 // email entry
 entry_email = gtk_entry_new ();
 input.email = entry_email;
 gtk_table_attach (GTK_TABLE (table_top), entry_email, 1, 2, 3, 4, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

 // second frame
 frame_bottom = gtk_frame_new (_("Directories:"));
 gtk_box_pack_start (GTK_BOX (vbox_main), frame_bottom, TRUE, TRUE, 0);
 gtk_container_set_border_width (GTK_CONTAINER (frame_bottom), 4);
 gtk_frame_set_shadow_type (GTK_FRAME (frame_bottom), GTK_SHADOW_ETCHED_OUT);

 table_bottom = gtk_table_new (2, 2, FALSE);
 gtk_container_add (GTK_CONTAINER (frame_bottom), table_bottom);
 gtk_container_set_border_width (GTK_CONTAINER (table_bottom), 4);
 gtk_table_set_col_spacings (GTK_TABLE (table_bottom), 12);

 label_upload = gtk_label_new (_("Upload Dir"));
 gtk_table_attach (GTK_TABLE (table_bottom), label_upload, 0, 1, 0, 1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0); 
 label_download = gtk_label_new (_("Download Dir"));
 gtk_table_attach (GTK_TABLE (table_bottom), label_download, 0, 1, 1, 2, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

 // upload file entry
 fileentry_upload = gnome_file_entry_new (NULL, _("Upload Directory"));
 gnome_file_entry_set_directory (GNOME_FILE_ENTRY (fileentry_upload), 1);
 gtk_table_attach (GTK_TABLE (table_bottom), fileentry_upload, 1, 2, 0, 1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
 input.upload = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_upload)); 

 // download file entry
 fileentry_download = gnome_file_entry_new (NULL, _("Download Directory"));
 gnome_file_entry_set_directory (GNOME_FILE_ENTRY (fileentry_download),1);
 gtk_table_attach (GTK_TABLE (table_bottom), fileentry_download, 1, 2, 1, 2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
 input.download = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_download)); 

 gtk_widget_show_all(dialog);

 do {
  if(gnome_dialog_run(GNOME_DIALOG(dialog)))
   return 0;
 } while(!check_input(GNOME_DIALOG(dialog),&input));
 gtk_widget_destroy(dialog);
 return 1;
}

GtkWidget* create_pref_window ()
{
  gchar *username,*password,*email,*upload_dir,*download_dir;
  gint connection,i;
  GList *connect_options = NULL;
  GtkWidget *entry;
  GtkWidget *property_box;
  GtkWidget *vbox_main;
  GtkWidget *frame_top;
  GtkWidget *table_top;
  GtkWidget *label_username;
  GtkWidget *label_password;
  GtkWidget *label_connection;
  GtkWidget *label_email;
  GtkWidget *entry_username;
  GtkWidget *entry_password;
  GtkWidget *entry_email;
  GtkWidget *combo;
  GtkWidget *frame_bottom;
  GtkWidget *table_bottom;
  GtkWidget *label_upload;
  GtkWidget *label_download;
  GtkWidget *fileentry_upload;
  GtkWidget *fileentry_download;

  username =     gnome_config_get_string("/gnap/General/username");
  password =     gnome_config_get_string("/gnap/General/password");
  email =        gnome_config_get_string("/gnap/General/email");
  upload_dir =   gnome_config_get_string("/gnap/General/upload_dir");
  download_dir = gnome_config_get_string("/gnap/General/download_dir");
  connection =   gnome_config_get_int("/gnap/General/connection");

  property_box = gnome_property_box_new();
  gnome_dialog_close_hides(GNOME_DIALOG(property_box),TRUE);
  gtk_signal_connect (GTK_OBJECT (property_box), "apply", GTK_SIGNAL_FUNC (properties_apply_cb), property_box);

  vbox_main = gtk_vbox_new (FALSE, 0);
  gnome_property_box_append_page (GNOME_PROPERTY_BOX(property_box),vbox_main, gtk_label_new(_("General")));

  // first frame
  frame_top = gtk_frame_new (_("User:"));
  gtk_box_pack_start (GTK_BOX (vbox_main), frame_top, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame_top), 4);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_top),GTK_SHADOW_ETCHED_OUT);

  table_top = gtk_table_new (4, 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame_top), table_top);
  gtk_table_set_col_spacings (GTK_TABLE (table_top), 12);

  label_username = gtk_label_new (_("Username:"));
  gtk_table_attach (GTK_TABLE (table_top), label_username, 0, 1, 0, 1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  label_password = gtk_label_new (_("Password:"));
  gtk_table_attach (GTK_TABLE (table_top), label_password, 0, 1, 1, 2, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  label_connection = gtk_label_new (_("Connection Type:"));
  gtk_table_attach (GTK_TABLE (table_top), label_connection, 0, 1, 2, 3, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  label_email = gtk_label_new (_("Email Address:"));
  gtk_table_attach (GTK_TABLE (table_top), label_email, 0, 1, 3, 4, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  // username entry
  entry_username = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(entry_username),username);
  gtk_signal_connect (GTK_OBJECT (entry_username), "changed", GTK_SIGNAL_FUNC (properties_changed_cb), property_box);
  gtk_table_attach (GTK_TABLE (table_top), entry_username, 1, 2, 0, 1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_object_set_data(GTK_OBJECT(property_box),"entry_username",entry_username);

  // password entry
  entry_password = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY(entry_password),password);
  gtk_entry_set_visibility(GTK_ENTRY(entry_password),0);
  gtk_signal_connect (GTK_OBJECT (entry_password), "changed", GTK_SIGNAL_FUNC (properties_changed_cb), property_box);
  gtk_table_attach (GTK_TABLE (table_top), entry_password, 1, 2, 1, 2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_object_set_data(GTK_OBJECT(property_box),"entry_password",entry_password);

  // combo box for connection type
  combo = gtk_combo_new();
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),0);
  connect_options = g_list_append(connect_options, gnap_int_to_connection(connection));
  for(i=0;i<=10;i++) {
   if(i!=connection) 
    connect_options = g_list_append(connect_options, gnap_int_to_connection(i));
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), connect_options);
  gtk_combo_set_value_in_list(GTK_COMBO (combo),connection,1);
  gtk_signal_connect (GTK_OBJECT(GTK_ENTRY(GTK_COMBO(combo)->entry)), "changed", GTK_SIGNAL_FUNC (properties_changed_cb), property_box);
  gtk_table_attach (GTK_TABLE (table_top), combo, 1, 2, 2, 3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_object_set_data(GTK_OBJECT(property_box),"combo",combo);

  // email entry
  entry_email = gtk_entry_new ();
  gtk_entry_set_text(GTK_ENTRY(entry_email),email);
  gtk_signal_connect (GTK_OBJECT (entry_email), "changed", GTK_SIGNAL_FUNC (properties_changed_cb), property_box);
  gtk_table_attach (GTK_TABLE (table_top), entry_email, 1, 2, 3, 4, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_object_set_data(GTK_OBJECT(property_box),"entry_email",entry_email);

  // second frame
  frame_bottom = gtk_frame_new (_("Directories:"));
  gtk_box_pack_start (GTK_BOX (vbox_main), frame_bottom, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame_bottom), 4);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_bottom), GTK_SHADOW_ETCHED_OUT);

  table_bottom = gtk_table_new (2, 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame_bottom), table_bottom);
  gtk_container_set_border_width (GTK_CONTAINER (table_bottom), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table_bottom), 12);

  label_upload = gtk_label_new (_("Upload Dir"));
  gtk_table_attach (GTK_TABLE (table_bottom), label_upload, 0, 1, 0, 1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0); 

  label_download = gtk_label_new (_("Download Dir"));
  gtk_table_attach (GTK_TABLE (table_bottom), label_download, 0, 1, 1, 2, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  // upload file entry
  fileentry_upload = gnome_file_entry_new (NULL, _("Upload Directory"));
  gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_upload))),upload_dir); 
  gtk_signal_connect (GTK_OBJECT (gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_upload))), "changed", GTK_SIGNAL_FUNC (properties_changed_cb), property_box);
  gnome_file_entry_set_directory (GNOME_FILE_ENTRY (fileentry_upload), 1);
  gtk_table_attach (GTK_TABLE (table_bottom), fileentry_upload, 1, 2, 0, 1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  entry = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_upload));
  gtk_object_set_data(GTK_OBJECT(property_box),"entry_upload",entry);

  // download file entry
  fileentry_download = gnome_file_entry_new (NULL, _("Download Directory"));
  gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_download))),download_dir); 
  gtk_signal_connect (GTK_OBJECT (gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_download))), "changed", GTK_SIGNAL_FUNC (properties_changed_cb), property_box);
  gnome_file_entry_set_directory (GNOME_FILE_ENTRY (fileentry_download),1);
  gtk_table_attach (GTK_TABLE (table_bottom), fileentry_download, 1, 2, 1, 2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  entry = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileentry_download));
  gtk_object_set_data(GTK_OBJECT(property_box),"entry_download",entry);

  return property_box;
}

GtkWidget *create_about_window ()
{
  const gchar *authors[] = { "Ryan Dahl <four@shrub.net>", NULL };
  GtkWidget *about;

  about =
    gnome_about_new ("gnap", VERSION, _("Copyright Ryan Dahl 1999"), authors,
		     _("major thanks to youngoat for helping me out.\ninsidious too.\numm.. hire me to do some c programming or something."),
		     NULL);
  gtk_window_set_modal (GTK_WINDOW (about), TRUE);

  return about;
}
