/******************************************************************************\
 gnofin/exp-html.c   $Revision: 1.2 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "gnofin.h"
#include "account.h"
#include "record.h"
#include "exp-html.h"

static FinRecordField fields[] = 
{
  FIN_RECORD_FIELD_DATE,
  FIN_RECORD_FIELD_TYPE_FULL,
  FIN_RECORD_FIELD_INFO,
  FIN_RECORD_FIELD_STATUS,
  FIN_RECORD_FIELD_AMOUNT,
  FIN_RECORD_FIELD_BALANCE,
};

static void
write_info (FILE * file, gchar * info_text)
{
  gchar * c;

  fin_trace("");

  /* html filter.. necessary to translate, for example, "<" to "&lt;" */

  for (c = info_text; *c; ++c)
  {
    /* process special characters
     * FIXME: are there other characters we should worry about? */

    switch (*c)
    {
    case '<':
      fprintf(file, "&lt;");
      break;
    case '>':
      fprintf(file, "&gt;");
      break;
    default:
      fprintf(file, "%c", *c);
      break;
    }
  }
}

static gboolean 
html_export (FILE * file, const gchar * filename, FinAccountSet * set)
{
  GList * ac, *rc;

  fin_trace("");

  fprintf(file, "<html>\n"
  		"<title>%s</title>\n"
                "<body bgcolor=white>\n", g_basename(filename));

  for (ac=set->accounts; ac; ac=ac->next)
  {
    FinAccount * account = LIST_GET(FinAccount, ac);
    fprintf(file, "<b>%s</b> : <i>%s</i><p>\n" 
    		  "<table border=1>\n", account->name, account->info);
    for (rc=account->records; rc; rc=rc->next)
    {
      gchar ** text = fin_stringized_record_new(LIST_GET(FinRecord, rc),
      						fields, 
						sizeof_array(fields));
      fprintf(file, "<tr>"
      		    "<td>%s</td>"  // date
      		    "<td>%s</td>"  // type
		    "<td>",
		    text[0], text[1]);

      write_info(file, text[2]);   // info

      fprintf(file, "</td>"
		    "<td>%s</td>"  // stat
		    "<td>%s</td>"  // amount
		    "<td>%s</td>"  // balance
		    "</tr>\n",
		    text[3], text[4], text[5]);
    }
    fprintf(file, "</table><p>\n");
  }
 
  fprintf(file, "</body>\n"
                "</html>\n");

  return TRUE;
}

FinExportFilter FinExport_HTML =
{
  "HTML",
  "Created by Darin Fisher <dfisher@jagger.me.berkeley.edu>",
  html_export,
};
