/******************************************************************************\
 gnofin/exp-text.c   $Revision: 1.1 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "gnofin.h"
#include "account.h"
#include "record.h"
#include "exp-text.h"

static FinRecordField fields[] = 
{
  FIN_RECORD_FIELD_DATE,
  FIN_RECORD_FIELD_TYPE_FULL,
  FIN_RECORD_FIELD_INFO,
  FIN_RECORD_FIELD_STATUS,
  FIN_RECORD_FIELD_AMOUNT,
  FIN_RECORD_FIELD_BALANCE,
};

static gboolean 
text_export (FILE * file, const gchar * filename, FinAccountSet * set)
{
  GList * ac, *rc;

  fin_trace("");

  for (ac=set->accounts; ac; ac=ac->next)
  {
    FinAccount * account = LIST_GET(FinAccount, ac);
    fprintf(file, "%s\t%s\n", account->name, account->info);
    for (rc=account->records; rc; rc=rc->next)
    {
      gchar ** text = fin_stringized_record_new(LIST_GET(FinRecord, rc),
      						fields, 
						sizeof_array(fields));
      fprintf(file, "%s\t"  // date
      		    "%s\t"  // type
		    "%s\t"  // info
		    "%s\t"  // stat
		    "%s\t"  // amount
		    "%s\n", // balance
		    text[0], text[1], text[2], 
		    text[3], text[4], text[5]);
    }
    if (ac->next)
      fprintf(file,"\n");
  }
 
  return TRUE;
}

FinExportFilter FinExport_TEXT =
{
  "Tab-delimited Text",
  "Created by Darin Fisher <dfisher@jagger.me.berkeley.edu>",
  text_export,
};
